/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public class TimeSeriesStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private String start;
    private String end;
    private String gap;
    private String field;
    private String format;
    private DateTimeFormatter formatter;
    private Metric[] metrics;
    private List<Tuple> tuples = new ArrayList<Tuple>();
    private int index;
    private String zkHost;
    private SolrParams params;
    private String collection;
    protected transient SolrClientCache cache;
    protected transient CloudSolrClient cloudSolrClient;

    public TimeSeriesStream(String zkHost, String collection, SolrParams params, Metric[] metrics, String field, String start, String end, String gap, String format) throws IOException {
        this.init(collection, params, field, metrics, start, end, gap, format, zkHost);
    }

    public TimeSeriesStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter startExpression = factory.getNamedOperand(expression, "start");
        StreamExpressionNamedParameter endExpression = factory.getNamedOperand(expression, "end");
        StreamExpressionNamedParameter fieldExpression = factory.getNamedOperand(expression, "field");
        StreamExpressionNamedParameter gapExpression = factory.getNamedOperand(expression, "gap");
        StreamExpressionNamedParameter formatExpression = factory.getNamedOperand(expression, "format");
        StreamExpressionNamedParameter qExpression = factory.getNamedOperand(expression, "q");
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        List<StreamExpression> metricExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, Metric.class);
        if (qExpression == null) {
            throw new IOException("The timeseries expression requires the q parameter");
        }
        String start = null;
        if (startExpression != null) {
            start = ((StreamExpressionValue)startExpression.getParameter()).getValue();
        }
        String end = null;
        if (endExpression != null) {
            end = ((StreamExpressionValue)endExpression.getParameter()).getValue();
        }
        String gap = null;
        if (gapExpression != null) {
            gap = ((StreamExpressionValue)gapExpression.getParameter()).getValue();
        }
        String field = null;
        if (fieldExpression != null) {
            field = ((StreamExpressionValue)fieldExpression.getParameter()).getValue();
        }
        String format = null;
        if (formatExpression != null) {
            format = ((StreamExpressionValue)formatExpression.getParameter()).getValue();
        }
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (0 == namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        Metric[] metrics = new Metric[metricExpressions.size()];
        for (int idx = 0; idx < metricExpressions.size(); ++idx) {
            metrics[idx] = factory.constructMetric(metricExpressions.get(idx));
        }
        if (0 == metrics.length) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one metric expected.", expression, collectionName));
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("start") || namedParam.getName().equals("end") || namedParam.getName().equals("gap")) continue;
            params.add(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(collectionName, params, field, metrics, start, end, gap, format, zkHost);
    }

    public String getCollection() {
        return this.collection;
    }

    private void init(String collection, SolrParams params, String field, Metric[] metrics, String start, String end, String gap, String format, String zkHost) throws IOException {
        this.zkHost = zkHost;
        this.collection = collection;
        this.start = start;
        this.gap = gap;
        if (!gap.startsWith("+")) {
            this.gap = "+" + gap;
        }
        this.metrics = metrics;
        this.field = field;
        this.params = params;
        this.end = end;
        if (format != null) {
            this.format = format;
            this.formatter = DateTimeFormatter.ofPattern(format, Locale.ROOT);
        }
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        ModifiableSolrParams tmpParams = new ModifiableSolrParams(this.params);
        for (Map.Entry<String, String[]> param : tmpParams.getMap().entrySet()) {
            expression.addParameter(new StreamExpressionNamedParameter(param.getKey(), String.join((CharSequence)",", param.getValue())));
        }
        for (Metric metric : this.metrics) {
            expression.addParameter(metric.toExpression(factory));
        }
        expression.addParameter(new StreamExpressionNamedParameter("start", this.start));
        expression.addParameter(new StreamExpressionNamedParameter("end", this.end));
        expression.addParameter(new StreamExpressionNamedParameter("gap", this.gap));
        expression.addParameter(new StreamExpressionNamedParameter("field", this.gap));
        expression.addParameter(new StreamExpressionNamedParameter("format", this.format));
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        child.setExpression(this.params.stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), Arrays.toString((Object[])e.getValue()))).collect(Collectors.joining(",")));
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.cache = context.getSolrClientCache();
    }

    @Override
    public List<TupleStream> children() {
        return new ArrayList<TupleStream>();
    }

    @Override
    public void open() throws IOException {
        if (this.cache != null) {
            this.cloudSolrClient = this.cache.getCloudSolrClient(this.zkHost);
        } else {
            ArrayList<String> hosts = new ArrayList<String>();
            hosts.add(this.zkHost);
            this.cloudSolrClient = new CloudSolrClient.Builder(hosts, Optional.empty()).build();
        }
        String json = this.getJsonFacetString(this.field, this.metrics, this.start, this.end, this.gap);
        ModifiableSolrParams paramsLoc = new ModifiableSolrParams(this.params);
        paramsLoc.set("json.facet", json);
        paramsLoc.set("rows", "0");
        QueryRequest request = new QueryRequest(paramsLoc);
        try {
            NamedList<Object> response = this.cloudSolrClient.request(request, this.collection);
            this.getTuples(response, this.field, this.metrics);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.cache == null) {
            this.cloudSolrClient.close();
        }
    }

    @Override
    public Tuple read() throws IOException {
        if (this.index < this.tuples.size()) {
            Tuple tuple = this.tuples.get(this.index);
            ++this.index;
            return tuple;
        }
        HashMap<String, Boolean> fields = new HashMap<String, Boolean>();
        fields.put("EOF", true);
        Tuple tuple = new Tuple(fields);
        return tuple;
    }

    private String getJsonFacetString(String field, Metric[] _metrics, String start, String end, String gap) {
        StringBuilder buf = new StringBuilder();
        this.appendJson(buf, _metrics, field, start, end, gap);
        return "{" + buf.toString() + "}";
    }

    private void appendJson(StringBuilder buf, Metric[] _metrics, String field, String start, String end, String gap) {
        buf.append('\"');
        buf.append("timeseries");
        buf.append('\"');
        buf.append(":{");
        buf.append("\"type\":\"range\"");
        buf.append(",\"field\":\"" + field + "\"");
        buf.append(",\"start\":\"" + start + "\"");
        buf.append(",\"end\":\"" + end + "\"");
        buf.append(",\"gap\":\"" + gap + "\"");
        buf.append(",\"facet\":{");
        int metricCount = 0;
        for (Metric metric : _metrics) {
            String identifier = metric.getIdentifier();
            if (identifier.startsWith("count(")) continue;
            if (metricCount > 0) {
                buf.append(",");
            }
            buf.append("\"facet_" + metricCount + "\":\"" + identifier + "\"");
            ++metricCount;
        }
        buf.append("}}");
    }

    private void getTuples(NamedList response, String field, Metric[] metrics) {
        Tuple tuple = new Tuple(new HashMap());
        NamedList facets = (NamedList)response.get("facets");
        this.fillTuples(this.tuples, tuple, facets, field, metrics);
    }

    private void fillTuples(List<Tuple> tuples, Tuple currentTuple, NamedList facets, String field, Metric[] _metrics) {
        NamedList nl = (NamedList)facets.get("timeseries");
        if (nl == null) {
            return;
        }
        List allBuckets = (List)nl.get("buckets");
        for (int b = 0; b < allBuckets.size(); ++b) {
            NamedList bucket = (NamedList)allBuckets.get(b);
            Object val = bucket.get("val");
            if (this.formatter != null) {
                LocalDateTime localDateTime = LocalDateTime.ofInstant(((Date)val).toInstant(), ZoneOffset.UTC);
                val = localDateTime.format(this.formatter);
            }
            Tuple t = currentTuple.clone();
            t.put(field, val);
            int m = 0;
            for (Metric metric : _metrics) {
                String identifier = metric.getIdentifier();
                if (!identifier.startsWith("count(")) {
                    if (bucket.get("facet_" + m) != null) {
                        Number d = (Number)bucket.get("facet_" + m);
                        if (metric.outputLong) {
                            t.put(identifier, Math.round(d.doubleValue()));
                        } else {
                            t.put(identifier, d.doubleValue());
                        }
                    }
                    ++m;
                    continue;
                }
                long l = ((Number)bucket.get("count")).longValue();
                t.put("count(*)", l);
            }
            tuples.add(t);
        }
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }
}

