/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.DataInputInputStream;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaBinUpdateRequestCodec {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final AtomicBoolean WARNED_ABOUT_INDEX_TIME_BOOSTS = new AtomicBoolean();

    public void marshal(UpdateRequest updateRequest, OutputStream os) throws IOException {
        NamedList<Object> nl = new NamedList<Object>();
        NamedList params = this.solrParamsToNamedList(updateRequest.getParams());
        if (updateRequest.getCommitWithin() != -1) {
            params.add("commitWithin", updateRequest.getCommitWithin());
        }
        Iterator<SolrInputDocument> docIter = null;
        if (updateRequest.getDocIterator() != null) {
            docIter = updateRequest.getDocIterator();
        }
        Map<SolrInputDocument, Map<String, Object>> docMap = updateRequest.getDocumentsMap();
        nl.add("params", params);
        if (updateRequest.getDeleteByIdMap() != null) {
            nl.add("delByIdMap", updateRequest.getDeleteByIdMap());
        }
        nl.add("delByQ", updateRequest.getDeleteQuery());
        if (docMap != null) {
            nl.add("docsMap", docMap.entrySet().iterator());
        } else {
            if (updateRequest.getDocuments() != null) {
                docIter = updateRequest.getDocuments().iterator();
            }
            nl.add("docs", docIter);
        }
        try (JavaBinCodec codec = new JavaBinCodec();){
            codec.marshal(nl, os);
        }
    }

    public UpdateRequest unmarshal(InputStream is, final StreamingUpdateHandler handler) throws IOException {
        NamedList params;
        final UpdateRequest updateRequest = new UpdateRequest();
        final NamedList[] namedList = new NamedList[1];
        JavaBinCodec codec = new JavaBinCodec(){
            private boolean seenOuterMostDocIterator = false;

            public NamedList readNamedList(DataInputInputStream dis) throws IOException {
                int sz = this.readSize(dis);
                NamedList<Object> nl = new NamedList<Object>();
                if (namedList[0] == null) {
                    namedList[0] = nl;
                }
                for (int i = 0; i < sz; ++i) {
                    String name = (String)this.readVal(dis);
                    Object val = this.readVal(dis);
                    nl.add(name, val);
                }
                return nl;
            }

            public List readIterator(DataInputInputStream fis) throws IOException {
                if (this.seenOuterMostDocIterator) {
                    return super.readIterator(fis);
                }
                this.seenOuterMostDocIterator = true;
                return this.readOuterMostDocIterator(fis);
            }

            private List readOuterMostDocIterator(DataInputInputStream fis) throws IOException {
                NamedList params = (NamedList)namedList[0].get("params");
                updateRequest.setParams(new ModifiableSolrParams(params.toSolrParams()));
                if (handler == null) {
                    return super.readIterator(fis);
                }
                Integer commitWithin = null;
                Boolean overwrite = null;
                Object o = null;
                while (true) {
                    if (o == null) {
                        o = this.readVal(fis);
                    }
                    if (o == END_OBJ) break;
                    SolrInputDocument sdoc = null;
                    if (o instanceof List) {
                        sdoc = JavaBinUpdateRequestCodec.this.listToSolrInputDocument((List)o);
                    } else if (o instanceof NamedList) {
                        UpdateRequest req = new UpdateRequest();
                        req.setParams(new ModifiableSolrParams(((NamedList)o).toSolrParams()));
                        handler.update(null, req, null, null);
                    } else if (o instanceof Map.Entry) {
                        sdoc = (SolrInputDocument)((Map.Entry)o).getKey();
                        Map p = (Map)((Map.Entry)o).getValue();
                        if (p != null) {
                            commitWithin = (Integer)p.get("cw");
                            overwrite = (Boolean)p.get("ow");
                        }
                    } else {
                        sdoc = (SolrInputDocument)o;
                    }
                    o = this.readVal(fis);
                    if (o == END_OBJ) {
                        updateRequest.lastDocInBatch();
                    }
                    handler.update(sdoc, updateRequest, commitWithin, overwrite);
                }
                return Collections.EMPTY_LIST;
            }
        };
        Iterator iterator = null;
        try {
            codec.unmarshal(is);
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (codec != null) {
                if (iterator != null) {
                    try {
                        codec.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    codec.close();
                }
            }
        }
        if (updateRequest.getParams() == null && (params = (NamedList)namedList[0].get("params")) != null) {
            updateRequest.setParams(new ModifiableSolrParams(params.toSolrParams()));
        }
        List delById = (List)namedList[0].get("delById");
        Map delByIdMap = (Map)namedList[0].get("delByIdMap");
        List delByQ = (List)namedList[0].get("delByQ");
        List doclist = (List)namedList[0].get("docs");
        Object docsMapObj = namedList[0].get("docsMap");
        ArrayList docMap = docsMapObj instanceof Map ? new ArrayList(((Map)docsMapObj).entrySet()) : (ArrayList)docsMapObj;
        if (delById != null) {
            for (String s : delById) {
                updateRequest.deleteById(s);
            }
        }
        if (delByIdMap != null) {
            for (Map.Entry entry : delByIdMap.entrySet()) {
                Map params2 = (Map)entry.getValue();
                if (params2 != null) {
                    Long version = (Long)params2.get("ver");
                    if (params2.containsKey("_route_")) {
                        updateRequest.deleteById((String)entry.getKey(), (String)params2.get("_route_"));
                        continue;
                    }
                    updateRequest.deleteById((String)entry.getKey(), version);
                    continue;
                }
                updateRequest.deleteById((String)entry.getKey());
            }
        }
        if (delByQ != null) {
            for (String s : delByQ) {
                updateRequest.deleteByQuery(s);
            }
        }
        return updateRequest;
    }

    private SolrInputDocument listToSolrInputDocument(List<NamedList> namedList) {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        for (int i = 0; i < namedList.size(); ++i) {
            String message;
            Float boost;
            NamedList nl = namedList.get(i);
            if (i == 0) {
                boost = (Float)nl.getVal(0);
                if (boost == null || boost.floatValue() == 1.0f) continue;
                message = "Ignoring document boost: " + boost + " as index-time boosts are not supported anymore";
                if (WARNED_ABOUT_INDEX_TIME_BOOSTS.compareAndSet(false, true)) {
                    log.warn(message);
                    continue;
                }
                log.debug(message);
                continue;
            }
            boost = (Float)nl.getVal(2);
            if (boost != null && boost.floatValue() != 1.0f) {
                message = "Ignoring field boost: " + boost + " as index-time boosts are not supported anymore";
                if (WARNED_ABOUT_INDEX_TIME_BOOSTS.compareAndSet(false, true)) {
                    log.warn(message);
                } else {
                    log.debug(message);
                }
            }
            doc.addField((String)nl.getVal(0), nl.getVal(1));
        }
        return doc;
    }

    private NamedList solrParamsToNamedList(SolrParams params) {
        if (params == null) {
            return new NamedList();
        }
        return params.toNamedList();
    }

    public static interface StreamingUpdateHandler {
        public void update(SolrInputDocument var1, UpdateRequest var2, Integer var3, Boolean var4);
    }
}

