/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request.json;

import org.apache.solr.client.solrj.request.json.JsonFacetMap;

public class TermsFacetMap
extends JsonFacetMap<TermsFacetMap> {
    public TermsFacetMap(String fieldName) {
        super("terms");
        this.put("field", fieldName);
    }

    @Override
    public TermsFacetMap getThis() {
        return this;
    }

    public TermsFacetMap setBucketOffset(int numToSkip) {
        if (numToSkip < 0) {
            throw new IllegalArgumentException("Parameter 'numToSkip' must be non-negative");
        }
        this.put("offset", numToSkip);
        return this;
    }

    public TermsFacetMap setLimit(int maximumBuckets) {
        if (maximumBuckets < 0) {
            throw new IllegalArgumentException("Parameter 'maximumBuckets' must be non-negative");
        }
        this.put("limit", maximumBuckets);
        return this;
    }

    public TermsFacetMap setSort(String sortString) {
        if (sortString == null) {
            throw new IllegalArgumentException("Parameter 'sortString' must be non-null");
        }
        this.put("sort", sortString);
        return this;
    }

    public TermsFacetMap setPreliminarySort(String preliminarySort) {
        if (preliminarySort == null) {
            throw new IllegalArgumentException("Parameter 'preliminarySort' must be non-null");
        }
        this.put("prelim_sort", preliminarySort);
        return this;
    }

    public TermsFacetMap setOverRequest(int numExtraBuckets) {
        if (numExtraBuckets < -1) {
            throw new IllegalArgumentException("Parameter 'numExtraBuckets' must be >= -1");
        }
        this.put("overrequest", numExtraBuckets);
        return this;
    }

    public TermsFacetMap useDistributedFacetRefining(boolean useRefining) {
        this.put("refine", useRefining);
        return this;
    }

    public TermsFacetMap setOverRefine(int numExtraBuckets) {
        if (numExtraBuckets < -1) {
            throw new IllegalArgumentException("Parameter 'numExtraBuckets' must be >= -1");
        }
        this.put("overrefine", numExtraBuckets);
        return this;
    }

    public TermsFacetMap setMinCount(int minCount) {
        if (minCount < 1) {
            throw new IllegalArgumentException("Parameter 'minCount' must be a positive integer");
        }
        this.put("mincount", minCount);
        return this;
    }

    public TermsFacetMap includeMissingBucket(boolean missingBucket) {
        this.put("missing", missingBucket);
        return this;
    }

    public TermsFacetMap includeTotalNumBuckets(boolean numBuckets) {
        this.put("numBuckets", numBuckets);
        return this;
    }

    public TermsFacetMap includeAllBucketsUnionBucket(boolean shouldInclude) {
        this.put("allBuckets", shouldInclude);
        return this;
    }

    public TermsFacetMap setTermPrefix(String termPrefix) {
        if (termPrefix == null) {
            throw new IllegalArgumentException("Parameter 'termPrefix' must be non-null");
        }
        this.put("prefix", termPrefix);
        return this;
    }

    public TermsFacetMap setFacetMethod(FacetMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Parameter 'method' must be non-null");
        }
        this.put("method", method.toString());
        return this;
    }

    public static enum FacetMethod {
        DV("dv"),
        UIF("uif"),
        DVHASH("dvhash"),
        ENUM("enum"),
        STREAM("stream"),
        SMART("smart");

        private final String value;

        private FacetMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

