/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.extras.complete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.compat.definition.digester.CompatibilityDigesterDefinitionsReader;
import org.apache.tiles.context.TilesRequestContextHolder;
import org.apache.tiles.definition.DefinitionsReader;
import org.apache.tiles.definition.pattern.DefinitionPatternMatcherFactory;
import org.apache.tiles.definition.pattern.PatternDefinitionResolver;
import org.apache.tiles.definition.pattern.PrefixedPatternDefinitionResolver;
import org.apache.tiles.definition.pattern.regexp.RegexpDefinitionPatternMatcherFactory;
import org.apache.tiles.definition.pattern.wildcard.WildcardDefinitionPatternMatcherFactory;
import org.apache.tiles.el.ELAttributeEvaluator;
import org.apache.tiles.el.JspExpressionFactoryFactory;
import org.apache.tiles.el.ScopeELResolver;
import org.apache.tiles.el.TilesContextBeanELResolver;
import org.apache.tiles.el.TilesContextELResolver;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.evaluator.BasicAttributeEvaluatorFactory;
import org.apache.tiles.factory.BasicTilesContainerFactory;
import org.apache.tiles.factory.TilesContainerFactoryException;
import org.apache.tiles.freemarker.TilesSharedVariableFactory;
import org.apache.tiles.impl.mgmt.CachingTilesContainer;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.mvel.MVELAttributeEvaluator;
import org.apache.tiles.mvel.ScopeVariableResolverFactory;
import org.apache.tiles.mvel.TilesContextBeanVariableResolverFactory;
import org.apache.tiles.mvel.TilesContextVariableResolverFactory;
import org.apache.tiles.ognl.AnyScopePropertyAccessor;
import org.apache.tiles.ognl.DelegatePropertyAccessor;
import org.apache.tiles.ognl.NestedObjectDelegatePropertyAccessor;
import org.apache.tiles.ognl.NestedObjectExtractor;
import org.apache.tiles.ognl.OGNLAttributeEvaluator;
import org.apache.tiles.ognl.PropertyAccessorDelegateFactory;
import org.apache.tiles.ognl.ScopePropertyAccessor;
import org.apache.tiles.ognl.TilesApplicationContextNestedObjectExtractor;
import org.apache.tiles.ognl.TilesContextPropertyAccessorDelegateFactory;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.freemarker.render.FreemarkerRenderer;
import org.apache.tiles.request.freemarker.render.FreemarkerRendererBuilder;
import org.apache.tiles.request.mustache.MustacheRenderer;
import org.apache.tiles.request.render.BasicRendererFactory;
import org.apache.tiles.request.render.ChainedDelegateRenderer;
import org.apache.tiles.request.render.Renderer;
import org.apache.tiles.request.velocity.render.VelocityRenderer;
import org.apache.tiles.request.velocity.render.VelocityRendererBuilder;
import org.mvel2.integration.VariableResolverFactory;

public class CompleteAutoloadTilesContainerFactory
extends BasicTilesContainerFactory {
    private static final String FREEMARKER_RENDERER_NAME = "freemarker";
    private static final String VELOCITY_RENDERER_NAME = "velocity";
    private static final String MUSTACHE_RENDERER_NAME = "mustache";

    public TilesContainer createDecoratedContainer(TilesContainer originalContainer, ApplicationContext applicationContext) {
        return new CachingTilesContainer(originalContainer);
    }

    protected void registerAttributeRenderers(BasicRendererFactory rendererFactory, ApplicationContext applicationContext, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        super.registerAttributeRenderers(rendererFactory, applicationContext, container, attributeEvaluatorFactory);
        FreemarkerRenderer freemarkerRenderer = FreemarkerRendererBuilder.createInstance().setApplicationContext(applicationContext).setParameter("TemplatePath", "/").setParameter("NoCache", "true").setParameter("ContentType", "text/html").setParameter("template_update_delay", "0").setParameter("default_encoding", "ISO-8859-1").setParameter("number_format", "0.##########").setParameter("org.apache.tiles.request.freemarker.CUSTOM_SHARED_VARIABLE_FACTORIES", "tiles," + TilesSharedVariableFactory.class.getName()).build();
        rendererFactory.registerRenderer(FREEMARKER_RENDERER_NAME, (Renderer)freemarkerRenderer);
        VelocityRenderer velocityRenderer = VelocityRendererBuilder.createInstance().setApplicationContext(applicationContext).build();
        rendererFactory.registerRenderer(VELOCITY_RENDERER_NAME, (Renderer)velocityRenderer);
        MustacheRenderer mustacheRenderer = new MustacheRenderer();
        mustacheRenderer.setAcceptPattern(Pattern.compile(".+\\.mustache"));
        rendererFactory.registerRenderer(MUSTACHE_RENDERER_NAME, (Renderer)mustacheRenderer);
    }

    protected Renderer createDefaultAttributeRenderer(BasicRendererFactory rendererFactory, ApplicationContext applicationContext, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        ChainedDelegateRenderer retValue = new ChainedDelegateRenderer();
        retValue.addAttributeRenderer(rendererFactory.getRenderer("definition"));
        retValue.addAttributeRenderer(rendererFactory.getRenderer(VELOCITY_RENDERER_NAME));
        retValue.addAttributeRenderer(rendererFactory.getRenderer(FREEMARKER_RENDERER_NAME));
        retValue.addAttributeRenderer(rendererFactory.getRenderer(MUSTACHE_RENDERER_NAME));
        retValue.addAttributeRenderer(rendererFactory.getRenderer("template"));
        retValue.addAttributeRenderer(rendererFactory.getRenderer("string"));
        return retValue;
    }

    protected AttributeEvaluatorFactory createAttributeEvaluatorFactory(ApplicationContext applicationContext, LocaleResolver resolver) {
        BasicAttributeEvaluatorFactory attributeEvaluatorFactory = new BasicAttributeEvaluatorFactory((AttributeEvaluator)this.createELEvaluator(applicationContext));
        attributeEvaluatorFactory.registerAttributeEvaluator("MVEL", (AttributeEvaluator)this.createMVELEvaluator());
        attributeEvaluatorFactory.registerAttributeEvaluator("OGNL", (AttributeEvaluator)this.createOGNLEvaluator());
        return attributeEvaluatorFactory;
    }

    protected <T> PatternDefinitionResolver<T> createPatternDefinitionResolver(Class<T> customizationKeyClass) {
        WildcardDefinitionPatternMatcherFactory wildcardFactory = new WildcardDefinitionPatternMatcherFactory();
        RegexpDefinitionPatternMatcherFactory regexpFactory = new RegexpDefinitionPatternMatcherFactory();
        PrefixedPatternDefinitionResolver resolver = new PrefixedPatternDefinitionResolver();
        resolver.registerDefinitionPatternMatcherFactory("WILDCARD", (DefinitionPatternMatcherFactory)wildcardFactory);
        resolver.registerDefinitionPatternMatcherFactory("REGEXP", (DefinitionPatternMatcherFactory)regexpFactory);
        return resolver;
    }

    protected List<ApplicationResource> getSources(ApplicationContext applicationContext) {
        Collection webINFSet = applicationContext.getResources("/WEB-INF/**/tiles*.xml");
        Collection metaINFSet = applicationContext.getResources("classpath*:META-INF/**/tiles*.xml");
        ArrayList<ApplicationResource> filteredResources = new ArrayList<ApplicationResource>();
        if (webINFSet != null) {
            for (ApplicationResource resource : webINFSet) {
                if (!Locale.ROOT.equals(resource.getLocale())) continue;
                filteredResources.add(resource);
            }
        }
        if (metaINFSet != null) {
            for (ApplicationResource resource : metaINFSet) {
                if (!Locale.ROOT.equals(resource.getLocale())) continue;
                filteredResources.add(resource);
            }
        }
        return filteredResources;
    }

    protected DefinitionsReader createDefinitionsReader(ApplicationContext applicationContext) {
        return new CompatibilityDigesterDefinitionsReader();
    }

    private ELAttributeEvaluator createELEvaluator(ApplicationContext applicationContext) {
        ELAttributeEvaluator evaluator = new ELAttributeEvaluator();
        JspExpressionFactoryFactory efFactory = new JspExpressionFactoryFactory();
        efFactory.setApplicationContext(applicationContext);
        evaluator.setExpressionFactory(efFactory.getExpressionFactory());
        CompositeELResolver elResolver = new CompositeELResolver(){
            {
                BeanELResolver beanElResolver = new BeanELResolver(false);
                this.add((ELResolver)new ScopeELResolver());
                this.add((ELResolver)new TilesContextELResolver((ELResolver)beanElResolver));
                this.add((ELResolver)new TilesContextBeanELResolver());
                this.add((ELResolver)new ArrayELResolver(false));
                this.add((ELResolver)new ListELResolver(false));
                this.add((ELResolver)new MapELResolver(false));
                this.add((ELResolver)new ResourceBundleELResolver());
                this.add((ELResolver)beanElResolver);
            }
        };
        evaluator.setResolver((ELResolver)elResolver);
        return evaluator;
    }

    private MVELAttributeEvaluator createMVELEvaluator() {
        TilesRequestContextHolder requestHolder = new TilesRequestContextHolder();
        ScopeVariableResolverFactory variableResolverFactory = new ScopeVariableResolverFactory(requestHolder);
        variableResolverFactory.setNextFactory((VariableResolverFactory)new TilesContextVariableResolverFactory(requestHolder));
        variableResolverFactory.setNextFactory((VariableResolverFactory)new TilesContextBeanVariableResolverFactory(requestHolder));
        MVELAttributeEvaluator mvelEvaluator = new MVELAttributeEvaluator(requestHolder, (VariableResolverFactory)variableResolverFactory);
        return mvelEvaluator;
    }

    private OGNLAttributeEvaluator createOGNLEvaluator() {
        try {
            PropertyAccessor objectPropertyAccessor = OgnlRuntime.getPropertyAccessor(Object.class);
            NestedObjectDelegatePropertyAccessor applicationContextPropertyAccessor = new NestedObjectDelegatePropertyAccessor((NestedObjectExtractor)new TilesApplicationContextNestedObjectExtractor(), objectPropertyAccessor);
            AnyScopePropertyAccessor anyScopePropertyAccessor = new AnyScopePropertyAccessor();
            ScopePropertyAccessor scopePropertyAccessor = new ScopePropertyAccessor();
            TilesContextPropertyAccessorDelegateFactory factory = new TilesContextPropertyAccessorDelegateFactory(objectPropertyAccessor, (PropertyAccessor)applicationContextPropertyAccessor, (PropertyAccessor)anyScopePropertyAccessor, (PropertyAccessor)scopePropertyAccessor);
            DelegatePropertyAccessor tilesRequestAccessor = new DelegatePropertyAccessor((PropertyAccessorDelegateFactory)factory);
            OgnlRuntime.setPropertyAccessor(Request.class, (PropertyAccessor)tilesRequestAccessor);
            return new OGNLAttributeEvaluator();
        }
        catch (OgnlException e) {
            throw new TilesContainerFactoryException("Cannot initialize OGNL evaluator", (Throwable)e);
        }
    }
}

