/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;

public class StructureSearchManager {
    public List findMatches(String pattern, IProgramElement.Kind kind) {
        ArrayList matches = new ArrayList();
        IHierarchy model = AsmManager.lastActiveStructureModel.getHierarchy();
        if (model.getRoot().equals(IHierarchy.NO_STRUCTURE)) {
            return null;
        }
        return this.findMatchesHelper(model.getRoot(), pattern, kind, matches);
    }

    private List findMatchesHelper(IProgramElement node, String pattern, IProgramElement.Kind kind, List matches) {
        if (node != null && node.getName().indexOf(pattern) != -1 && (kind == null || node.getKind().equals(kind))) {
            matches.add(node);
        }
        if (node != null && node.getChildren() != null) {
            for (IProgramElement nextNode : node.getChildren()) {
                if (nextNode == null) continue;
                this.findMatchesHelper(nextNode, pattern, kind, matches);
            }
        }
        return matches;
    }
}

