/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.ASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.Annotation;
import org.aspectj.org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.ArrayAccess;
import org.aspectj.org.eclipse.jdt.core.dom.ArrayCreation;
import org.aspectj.org.eclipse.jdt.core.dom.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.core.dom.ArrayType;
import org.aspectj.org.eclipse.jdt.core.dom.AssertStatement;
import org.aspectj.org.eclipse.jdt.core.dom.Assignment;
import org.aspectj.org.eclipse.jdt.core.dom.Block;
import org.aspectj.org.eclipse.jdt.core.dom.CastExpression;
import org.aspectj.org.eclipse.jdt.core.dom.CatchClause;
import org.aspectj.org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.aspectj.org.eclipse.jdt.core.dom.ConditionalExpression;
import org.aspectj.org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.aspectj.org.eclipse.jdt.core.dom.CreationReference;
import org.aspectj.org.eclipse.jdt.core.dom.Dimension;
import org.aspectj.org.eclipse.jdt.core.dom.DoStatement;
import org.aspectj.org.eclipse.jdt.core.dom.EmptyStatement;
import org.aspectj.org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.aspectj.org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.EnumDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.ExportsDirective;
import org.aspectj.org.eclipse.jdt.core.dom.Expression;
import org.aspectj.org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.aspectj.org.eclipse.jdt.core.dom.ExpressionStatement;
import org.aspectj.org.eclipse.jdt.core.dom.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.ForStatement;
import org.aspectj.org.eclipse.jdt.core.dom.IfStatement;
import org.aspectj.org.eclipse.jdt.core.dom.ImportDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.InfixExpression;
import org.aspectj.org.eclipse.jdt.core.dom.InstanceofExpression;
import org.aspectj.org.eclipse.jdt.core.dom.IntersectionType;
import org.aspectj.org.eclipse.jdt.core.dom.LabeledStatement;
import org.aspectj.org.eclipse.jdt.core.dom.LambdaExpression;
import org.aspectj.org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.aspectj.org.eclipse.jdt.core.dom.MemberValuePair;
import org.aspectj.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.MethodInvocation;
import org.aspectj.org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.Name;
import org.aspectj.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.aspectj.org.eclipse.jdt.core.dom.OpensDirective;
import org.aspectj.org.eclipse.jdt.core.dom.PackageDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.ParameterizedType;
import org.aspectj.org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.aspectj.org.eclipse.jdt.core.dom.PostfixExpression;
import org.aspectj.org.eclipse.jdt.core.dom.PrefixExpression;
import org.aspectj.org.eclipse.jdt.core.dom.ProvidesDirective;
import org.aspectj.org.eclipse.jdt.core.dom.ReturnStatement;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleName;
import org.aspectj.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.aspectj.org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.Statement;
import org.aspectj.org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.aspectj.org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.aspectj.org.eclipse.jdt.core.dom.SuperMethodReference;
import org.aspectj.org.eclipse.jdt.core.dom.SwitchCase;
import org.aspectj.org.eclipse.jdt.core.dom.SwitchExpression;
import org.aspectj.org.eclipse.jdt.core.dom.SwitchStatement;
import org.aspectj.org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.aspectj.org.eclipse.jdt.core.dom.ThrowStatement;
import org.aspectj.org.eclipse.jdt.core.dom.TryStatement;
import org.aspectj.org.eclipse.jdt.core.dom.Type;
import org.aspectj.org.eclipse.jdt.core.dom.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.TypeMethodReference;
import org.aspectj.org.eclipse.jdt.core.dom.TypeParameter;
import org.aspectj.org.eclipse.jdt.core.dom.UnionType;
import org.aspectj.org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.aspectj.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.aspectj.org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.aspectj.org.eclipse.jdt.core.dom.WhileStatement;
import org.aspectj.org.eclipse.jdt.core.dom.WildcardType;
import org.aspectj.org.eclipse.jdt.core.dom.YieldStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.aspectj.org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.aspectj.org.eclipse.jdt.internal.formatter.Token;
import org.aspectj.org.eclipse.jdt.internal.formatter.TokenManager;
import org.aspectj.org.eclipse.jdt.internal.formatter.TokenTraverser;

public class SpacePreparator
extends ASTVisitor {
    private static final Map<InfixExpression.Operator, Predicate<DefaultCodeFormatterOptions>> SPACE_BEFORE_OPERATOR;
    private static final Map<InfixExpression.Operator, Predicate<DefaultCodeFormatterOptions>> SPACE_AFTER_OPERATOR;
    TokenManager tm;
    private DefaultCodeFormatterOptions options;

    static {
        HashMap<InfixExpression.Operator, Predicate<DefaultCodeFormatterOptions>> spaceBeforeOperator = new HashMap<InfixExpression.Operator, Predicate<DefaultCodeFormatterOptions>>();
        HashMap<InfixExpression.Operator, Predicate<DefaultCodeFormatterOptions>> spaceAfterOperator = new HashMap<InfixExpression.Operator, Predicate<DefaultCodeFormatterOptions>>();
        for (InfixExpression.Operator op : Arrays.asList(InfixExpression.Operator.TIMES, InfixExpression.Operator.DIVIDE, InfixExpression.Operator.REMAINDER)) {
            spaceBeforeOperator.put(op, o -> o.insert_space_before_multiplicative_operator);
            spaceAfterOperator.put(op, o -> o.insert_space_after_multiplicative_operator);
        }
        for (InfixExpression.Operator op : Arrays.asList(InfixExpression.Operator.PLUS, InfixExpression.Operator.MINUS)) {
            spaceBeforeOperator.put(op, o -> o.insert_space_before_additive_operator);
            spaceAfterOperator.put(op, o -> o.insert_space_after_additive_operator);
        }
        for (InfixExpression.Operator op : Arrays.asList(InfixExpression.Operator.LEFT_SHIFT, InfixExpression.Operator.RIGHT_SHIFT_SIGNED, InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED)) {
            spaceBeforeOperator.put(op, o -> o.insert_space_before_shift_operator);
            spaceAfterOperator.put(op, o -> o.insert_space_after_shift_operator);
        }
        for (InfixExpression.Operator op : Arrays.asList(InfixExpression.Operator.LESS, InfixExpression.Operator.GREATER, InfixExpression.Operator.LESS_EQUALS, InfixExpression.Operator.GREATER_EQUALS, InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS)) {
            spaceBeforeOperator.put(op, o -> o.insert_space_before_relational_operator);
            spaceAfterOperator.put(op, o -> o.insert_space_after_relational_operator);
        }
        for (InfixExpression.Operator op : Arrays.asList(InfixExpression.Operator.AND, InfixExpression.Operator.XOR, InfixExpression.Operator.OR)) {
            spaceBeforeOperator.put(op, o -> o.insert_space_before_bitwise_operator);
            spaceAfterOperator.put(op, o -> o.insert_space_after_bitwise_operator);
        }
        for (InfixExpression.Operator op : Arrays.asList(InfixExpression.Operator.CONDITIONAL_AND, InfixExpression.Operator.CONDITIONAL_OR)) {
            spaceBeforeOperator.put(op, o -> o.insert_space_before_logical_operator);
            spaceAfterOperator.put(op, o -> o.insert_space_after_logical_operator);
        }
        SPACE_BEFORE_OPERATOR = Collections.unmodifiableMap(spaceBeforeOperator);
        SPACE_AFTER_OPERATOR = Collections.unmodifiableMap(spaceAfterOperator);
    }

    public SpacePreparator(TokenManager tokenManager, DefaultCodeFormatterOptions options) {
        this.tm = tokenManager;
        this.options = options;
    }

    @Override
    public boolean preVisit2(ASTNode node) {
        boolean isMalformed = (node.getFlags() & 1) != 0;
        return !isMalformed;
    }

    @Override
    public boolean visit(PackageDeclaration node) {
        this.handleSemicolon(node);
        return true;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        this.handleSemicolon(node);
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        if (node.getName().getStartPosition() == -1) {
            return true;
        }
        this.handleToken(node.getName(), 14, true, false);
        List typeParameters = node.typeParameters();
        this.handleTypeParameters(typeParameters);
        if (!node.isInterface() && !node.superInterfaceTypes().isEmpty()) {
            this.handleToken(node.getName(), 103, true, false);
        }
        this.handleToken(node.getName(), 66, this.options.insert_space_before_opening_brace_in_type_declaration, false);
        this.handleCommas(node.superInterfaceTypes(), this.options.insert_space_before_comma_in_superinterfaces, this.options.insert_space_after_comma_in_superinterfaces);
        return true;
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        this.handleToken(node.getName(), 66, this.options.insert_space_before_opening_brace_in_enum_declaration, false);
        this.handleCommas(node.superInterfaceTypes(), this.options.insert_space_before_comma_in_superinterfaces, this.options.insert_space_after_comma_in_superinterfaces);
        this.handleCommas(node.enumConstants(), this.options.insert_space_before_comma_in_enum_declarations, this.options.insert_space_after_comma_in_enum_declarations);
        return true;
    }

    @Override
    public boolean visit(EnumConstantDeclaration node) {
        List arguments = node.arguments();
        Token openingParen = null;
        if (!arguments.isEmpty()) {
            openingParen = this.tm.firstTokenIn(node, 17);
            if (this.options.insert_space_after_opening_paren_in_enum_constant) {
                openingParen.spaceAfter();
            }
            this.handleTokenAfter((ASTNode)arguments.get(arguments.size() - 1), 25, this.options.insert_space_before_closing_paren_in_enum_constant, false);
        } else {
            int from = this.tm.firstIndexIn(node.getName(), 14) + 1;
            AnonymousClassDeclaration classDeclaration = node.getAnonymousClassDeclaration();
            int to = classDeclaration != null ? this.tm.firstIndexBefore(classDeclaration, -1) : this.tm.lastIndexIn(node, -1);
            int i = from;
            while (i <= to) {
                if (this.tm.get((int)i).tokenType == 17) {
                    openingParen = this.tm.get(i);
                    if (!this.options.insert_space_between_empty_parens_in_enum_constant) break;
                    openingParen.spaceAfter();
                    break;
                }
                ++i;
            }
        }
        if (openingParen != null && this.options.insert_space_before_opening_paren_in_enum_constant) {
            openingParen.spaceBefore();
        }
        this.handleCommas(arguments, this.options.insert_space_before_comma_in_enum_constant_arguments, this.options.insert_space_after_comma_in_enum_constant_arguments);
        return true;
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        boolean spaceBeforeOpenBrace = this.options.insert_space_before_opening_brace_in_anonymous_type_declaration;
        if (node.getParent() instanceof EnumConstantDeclaration) {
            spaceBeforeOpenBrace = this.options.insert_space_before_opening_brace_in_enum_constant;
        }
        this.handleToken(node, 66, spaceBeforeOpenBrace, false);
        return true;
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        List typeParameters;
        boolean spaceBetweenEmptyParens;
        this.handleToken(node.getName(), 14, true, false);
        boolean spaceBeforeOpenParen = node.isConstructor() ? this.options.insert_space_before_opening_paren_in_constructor_declaration : this.options.insert_space_before_opening_paren_in_method_declaration;
        boolean spaceAfterOpenParen = node.isConstructor() ? this.options.insert_space_after_opening_paren_in_constructor_declaration : this.options.insert_space_after_opening_paren_in_method_declaration;
        boolean bl = spaceBetweenEmptyParens = node.isConstructor() ? this.options.insert_space_between_empty_parens_in_constructor_declaration : this.options.insert_space_between_empty_parens_in_method_declaration;
        if (this.handleEmptyParens(node.getName(), spaceBetweenEmptyParens)) {
            this.handleToken(node.getName(), 17, spaceBeforeOpenParen, false);
        } else {
            boolean spaceBeforeCloseParen;
            this.handleToken(node.getName(), 17, spaceBeforeOpenParen, spaceAfterOpenParen);
            boolean bl2 = spaceBeforeCloseParen = node.isConstructor() ? this.options.insert_space_before_closing_paren_in_constructor_declaration : this.options.insert_space_before_closing_paren_in_method_declaration;
            if (spaceBeforeCloseParen) {
                List params = node.parameters();
                SimpleName beforeBrace = params.isEmpty() ? node.getName() : (ASTNode)params.get(params.size() - 1);
                this.handleTokenAfter(beforeBrace, 25, true, false);
            }
        }
        if ((node.isConstructor() ? this.options.insert_space_before_opening_brace_in_constructor_declaration : this.options.insert_space_before_opening_brace_in_method_declaration) && node.getBody() != null) {
            this.tm.firstTokenIn(node.getBody(), 66).spaceBefore();
        }
        if (node.getReceiverType() != null) {
            this.tm.lastTokenIn(node.getReceiverType(), -1).spaceAfter();
        }
        boolean beforeComma = node.isConstructor() ? this.options.insert_space_before_comma_in_constructor_declaration_parameters : this.options.insert_space_before_comma_in_method_declaration_parameters;
        boolean afterComma = node.isConstructor() ? this.options.insert_space_after_comma_in_constructor_declaration_parameters : this.options.insert_space_after_comma_in_method_declaration_parameters;
        ArrayList<Object> params = node.parameters();
        if (node.getReceiverType() != null) {
            params = new ArrayList<Object>(params);
            params.add(0, null);
        }
        this.handleCommas(params, beforeComma, afterComma);
        List thrownExceptionTypes = node.thrownExceptionTypes();
        if (!thrownExceptionTypes.isEmpty()) {
            this.tm.firstTokenBefore((ASTNode)thrownExceptionTypes.get(0), 100).spaceBefore();
            beforeComma = node.isConstructor() ? this.options.insert_space_before_comma_in_constructor_declaration_throws : this.options.insert_space_before_comma_in_method_declaration_throws;
            afterComma = node.isConstructor() ? this.options.insert_space_after_comma_in_constructor_declaration_throws : this.options.insert_space_after_comma_in_method_declaration_throws;
            this.handleCommas(thrownExceptionTypes, beforeComma, afterComma);
        }
        if (!(typeParameters = node.typeParameters()).isEmpty()) {
            this.handleTypeParameters(typeParameters);
            this.handleTokenBefore((ASTNode)typeParameters.get(0), 7, true, false);
            this.handleTokenAfter((ASTNode)typeParameters.get(typeParameters.size() - 1), 13, false, true);
        }
        this.handleSemicolon(node);
        return true;
    }

    private void handleTypeParameters(List<TypeParameter> typeParameters) {
        if (!typeParameters.isEmpty()) {
            this.handleTokenBefore(typeParameters.get(0), 7, this.options.insert_space_before_opening_angle_bracket_in_type_parameters, this.options.insert_space_after_opening_angle_bracket_in_type_parameters);
            this.handleTokenAfter(typeParameters.get(typeParameters.size() - 1), 13, this.options.insert_space_before_closing_angle_bracket_in_type_parameters, this.options.insert_space_after_closing_angle_bracket_in_type_parameters);
            this.handleCommas(typeParameters, this.options.insert_space_before_comma_in_type_parameters, this.options.insert_space_after_comma_in_type_parameters);
        }
    }

    @Override
    public boolean visit(FieldDeclaration node) {
        this.handleToken((ASTNode)node.fragments().get(0), 14, true, false);
        this.handleCommas(node.fragments(), this.options.insert_space_before_comma_in_multiple_field_declarations, this.options.insert_space_after_comma_in_multiple_field_declarations);
        this.handleSemicolon(node);
        return true;
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        this.handleToken((ASTNode)node.fragments().get(0), 14, true, false);
        this.handleCommas(node.fragments(), this.options.insert_space_before_comma_in_multiple_local_declarations, this.options.insert_space_after_comma_in_multiple_local_declarations);
        return true;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        if (node.getInitializer() != null) {
            this.handleToken(node.getName(), 76, this.options.insert_space_before_assignment_operator, this.options.insert_space_after_assignment_operator);
        }
        return true;
    }

    @Override
    public void endVisit(SingleVariableDeclaration node) {
        if (node.isVarargs()) {
            this.handleTokenBefore(node.getName(), 101, this.options.insert_space_before_ellipsis, this.options.insert_space_after_ellipsis);
            List varargsAnnotations = node.varargsAnnotations();
            if (!varargsAnnotations.isEmpty()) {
                this.tm.firstTokenIn((ASTNode)varargsAnnotations.get(0), 42).spaceBefore();
                this.tm.lastTokenIn((ASTNode)varargsAnnotations.get(varargsAnnotations.size() - 1), -1).clearSpaceAfter();
            }
        } else {
            this.handleToken(node.getName(), 14, true, false);
        }
    }

    @Override
    public boolean visit(SwitchStatement node) {
        this.handleToken(node, 17, this.options.insert_space_before_opening_paren_in_switch, this.options.insert_space_after_opening_paren_in_switch);
        this.handleTokenAfter(node.getExpression(), 25, this.options.insert_space_before_closing_paren_in_switch, false);
        this.handleTokenAfter(node.getExpression(), 66, this.options.insert_space_before_opening_brace_in_switch, false);
        this.handleSemicolon(node.statements());
        return true;
    }

    @Override
    public boolean visit(SwitchExpression node) {
        this.handleToken(node, 17, this.options.insert_space_before_opening_paren_in_switch, this.options.insert_space_after_opening_paren_in_switch);
        this.handleTokenAfter(node.getExpression(), 25, this.options.insert_space_before_closing_paren_in_switch, false);
        this.handleTokenAfter(node.getExpression(), 66, this.options.insert_space_before_opening_brace_in_switch, false);
        this.handleSemicolon(node.statements());
        return true;
    }

    @Override
    public boolean visit(SwitchCase node) {
        if (node.getAST().apiLevel() == 13 && node.isSwitchLabeledRule()) {
            this.handleToken(this.tm.lastTokenIn(node, 115), node.isDefault() ? this.options.insert_space_before_arrow_in_switch_default : this.options.insert_space_before_arrow_in_switch_case, node.isDefault() ? this.options.insert_space_after_arrow_in_switch_default : this.options.insert_space_after_arrow_in_switch_case);
        } else {
            this.handleToken(this.tm.lastTokenIn(node, 67), node.isDefault() ? this.options.insert_space_before_colon_in_default : this.options.insert_space_before_colon_in_case, false);
        }
        if (!node.isDefault()) {
            this.handleToken(node, 93, false, true);
            if (node.getAST().apiLevel() == 13) {
                this.handleCommas(node.expressions(), this.options.insert_space_before_comma_in_switch_case_expressions, this.options.insert_space_after_comma_in_switch_case_expressions);
            }
        }
        return true;
    }

    @Override
    public boolean visit(YieldStatement node) {
        if (node.getExpression() != null && !node.isImplicit()) {
            this.tm.firstTokenIn(node, -1).spaceAfter();
        }
        return true;
    }

    @Override
    public boolean visit(DoStatement node) {
        this.handleTokenBefore(node.getExpression(), 17, this.options.insert_space_before_opening_paren_in_while, this.options.insert_space_after_opening_paren_in_while);
        this.handleTokenBefore(node.getExpression(), 81, !(node.getBody() instanceof Block) || this.options.insert_space_after_closing_brace_in_block, false);
        this.handleTokenAfter(node.getExpression(), 25, this.options.insert_space_before_closing_paren_in_while, false);
        return true;
    }

    @Override
    public boolean visit(WhileStatement node) {
        this.handleToken(node, 17, this.options.insert_space_before_opening_paren_in_while, this.options.insert_space_after_opening_paren_in_while);
        this.handleTokenBefore(node.getBody(), 25, this.options.insert_space_before_closing_paren_in_while, false);
        this.handleLoopBody(node.getBody());
        return true;
    }

    @Override
    public boolean visit(SynchronizedStatement node) {
        this.handleToken(node, 17, this.options.insert_space_before_opening_paren_in_synchronized, this.options.insert_space_after_opening_paren_in_synchronized);
        this.handleTokenBefore(node.getBody(), 25, this.options.insert_space_before_closing_paren_in_synchronized, false);
        return true;
    }

    @Override
    public boolean visit(TryStatement node) {
        List resources = node.resources();
        if (!resources.isEmpty()) {
            this.handleToken(node, 17, this.options.insert_space_before_opening_paren_in_try, this.options.insert_space_after_opening_paren_in_try);
            this.handleTokenBefore(node.getBody(), 25, this.options.insert_space_before_closing_paren_in_try, false);
            int i = 1;
            while (i < resources.size()) {
                this.handleTokenBefore((ASTNode)resources.get(i), 26, this.options.insert_space_before_semicolon_in_try_resources, this.options.insert_space_after_semicolon_in_try_resources);
                ++i;
            }
            int index = this.tm.firstIndexAfter((ASTNode)resources.get(resources.size() - 1), -1);
            while (index < this.tm.size()) {
                Token token = this.tm.get(index++);
                if (token.tokenType == 26) {
                    this.handleToken(token, this.options.insert_space_before_semicolon_in_try_resources, false);
                    continue;
                }
                if (token.tokenType == 25) break;
            }
        }
        return true;
    }

    @Override
    public boolean visit(CatchClause node) {
        this.handleToken(node, 17, this.options.insert_space_before_opening_paren_in_catch, this.options.insert_space_after_opening_paren_in_catch);
        this.handleTokenBefore(node.getBody(), 25, this.options.insert_space_before_closing_paren_in_catch, false);
        return true;
    }

    @Override
    public boolean visit(AssertStatement node) {
        this.tm.firstTokenIn(node, 82).spaceAfter();
        if (node.getMessage() != null) {
            this.handleTokenBefore(node.getMessage(), 67, this.options.insert_space_before_colon_in_assert, this.options.insert_space_after_colon_in_assert);
        }
        return true;
    }

    @Override
    public boolean visit(ReturnStatement node) {
        if (node.getExpression() != null) {
            int returnTokenIndex = this.tm.firstIndexIn(node, 89);
            if (!(node.getExpression() instanceof ParenthesizedExpression) || this.options.insert_space_before_parenthesized_expression_in_return) {
                this.tm.get(returnTokenIndex).spaceAfter();
            }
        }
        return true;
    }

    @Override
    public boolean visit(ThrowStatement node) {
        int returnTokenIndex = this.tm.firstIndexIn(node, 80);
        if (this.tm.get((int)(returnTokenIndex + 1)).tokenType != 17 || this.options.insert_space_before_parenthesized_expression_in_throw) {
            this.tm.get(returnTokenIndex).spaceAfter();
        }
        return true;
    }

    @Override
    public boolean visit(LabeledStatement node) {
        this.handleToken(node, 67, this.options.insert_space_before_colon_in_labeled_statement, this.options.insert_space_after_colon_in_labeled_statement);
        return true;
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        this.handleToken(node, 42, this.options.insert_space_before_at_in_annotation_type_declaration, this.options.insert_space_after_at_in_annotation_type_declaration);
        this.handleToken(node.getName(), 66, this.options.insert_space_before_opening_brace_in_annotation_type_declaration, false);
        return true;
    }

    @Override
    public boolean visit(AnnotationTypeMemberDeclaration node) {
        this.handleToken(node.getName(), 14, true, false);
        this.handleToken(node.getName(), 17, this.options.insert_space_before_opening_paren_in_annotation_type_member_declaration, false);
        this.handleEmptyParens(node.getName(), this.options.insert_space_between_empty_parens_in_annotation_type_member_declaration);
        if (node.getDefault() != null) {
            this.handleTokenBefore(node.getDefault(), 99, true, true);
        }
        return true;
    }

    @Override
    public boolean visit(NormalAnnotation node) {
        this.handleAnnotation(node, true);
        this.handleCommas(node.values(), this.options.insert_space_before_comma_in_annotation, this.options.insert_space_after_comma_in_annotation);
        return true;
    }

    @Override
    public boolean visit(MemberValuePair node) {
        this.handleToken(node, 76, this.options.insert_space_before_assignment_operator, this.options.insert_space_after_assignment_operator);
        return true;
    }

    @Override
    public boolean visit(SingleMemberAnnotation node) {
        this.handleAnnotation(node, true);
        return true;
    }

    @Override
    public boolean visit(MarkerAnnotation node) {
        this.handleAnnotation(node, false);
        return true;
    }

    private void handleAnnotation(Annotation node, boolean handleParenthesis) {
        ASTNode parent;
        boolean skipSpaceAfter;
        this.handleToken(node, 42, false, this.options.insert_space_after_at_in_annotation);
        if (handleParenthesis) {
            this.handleToken(node, 17, this.options.insert_space_before_opening_paren_in_annotation, this.options.insert_space_after_opening_paren_in_annotation);
            if (this.options.insert_space_before_closing_paren_in_annotation) {
                this.tm.lastTokenIn(node, 25).spaceBefore();
            }
        }
        boolean bl = skipSpaceAfter = (parent = node.getParent()) instanceof Annotation || parent instanceof MemberValuePair || parent instanceof AnnotationTypeMemberDeclaration && ((AnnotationTypeMemberDeclaration)parent).getDefault() == node || parent instanceof ArrayInitializer;
        if (!skipSpaceAfter) {
            this.tm.lastTokenIn(node, -1).spaceAfter();
        }
    }

    @Override
    public boolean visit(LambdaExpression node) {
        this.handleToken(node, 115, this.options.insert_space_before_lambda_arrow, this.options.insert_space_after_lambda_arrow);
        List parameters = node.parameters();
        if (node.hasParentheses()) {
            if (this.handleEmptyParens(node, this.options.insert_space_between_empty_parens_in_method_declaration)) {
                this.handleToken(node, 17, this.options.insert_space_before_opening_paren_in_method_declaration, false);
            } else {
                this.handleToken(node, 17, this.options.insert_space_before_opening_paren_in_method_declaration, this.options.insert_space_after_opening_paren_in_method_declaration);
                this.handleTokenBefore(node.getBody(), 25, this.options.insert_space_before_closing_paren_in_method_declaration, false);
            }
            this.handleCommas(parameters, this.options.insert_space_before_comma_in_method_declaration_parameters, this.options.insert_space_after_comma_in_method_declaration_parameters);
        }
        return true;
    }

    @Override
    public boolean visit(Block node) {
        this.handleSemicolon(node.statements());
        ASTNode parent = node.getParent();
        if (parent.getLength() == 0) {
            return true;
        }
        if (parent instanceof MethodDeclaration) {
            return true;
        }
        this.handleToken(node, 66, this.options.insert_space_before_opening_brace_in_block, false);
        if (this.options.insert_space_after_closing_brace_in_block && (parent instanceof Statement || parent instanceof CatchClause)) {
            int closeBraceIndex = this.tm.lastIndexIn(node, 40);
            this.tm.get(closeBraceIndex).spaceAfter();
        }
        return true;
    }

    @Override
    public boolean visit(IfStatement node) {
        this.handleToken(node, 17, this.options.insert_space_before_opening_paren_in_if, this.options.insert_space_after_opening_paren_in_if);
        Statement thenStatement = node.getThenStatement();
        this.handleTokenBefore(thenStatement, 25, this.options.insert_space_before_closing_paren_in_if, false);
        this.handleLoopBody(thenStatement);
        this.handleSemicolon(thenStatement);
        return true;
    }

    @Override
    public boolean visit(ForStatement node) {
        this.handleToken(node, 17, this.options.insert_space_before_opening_paren_in_for, this.options.insert_space_after_opening_paren_in_for);
        this.handleTokenBefore(node.getBody(), 25, this.options.insert_space_before_closing_paren_in_for, false);
        this.handleCommas(node.initializers(), this.options.insert_space_before_comma_in_for_inits, this.options.insert_space_after_comma_in_for_inits);
        this.handleCommas(node.updaters(), this.options.insert_space_before_comma_in_for_increments, this.options.insert_space_after_comma_in_for_increments);
        boolean part1Empty = node.initializers().isEmpty();
        boolean part2Empty = node.getExpression() == null;
        boolean part3Empty = node.updaters().isEmpty();
        this.handleToken(node, 26, this.options.insert_space_before_semicolon_in_for && !part1Empty, this.options.insert_space_after_semicolon_in_for && !part2Empty);
        this.handleTokenBefore(node.getBody(), 26, this.options.insert_space_before_semicolon_in_for && !part2Empty, this.options.insert_space_after_semicolon_in_for && !part3Empty);
        this.handleLoopBody(node.getBody());
        return true;
    }

    @Override
    public boolean visit(VariableDeclarationExpression node) {
        ASTNode parent = node.getParent();
        if (parent instanceof ForStatement) {
            this.handleCommas(node.fragments(), this.options.insert_space_before_comma_in_for_inits, this.options.insert_space_after_comma_in_for_inits);
        } else if (parent instanceof ExpressionStatement) {
            this.handleCommas(node.fragments(), this.options.insert_space_before_comma_in_multiple_local_declarations, this.options.insert_space_after_comma_in_multiple_local_declarations);
        }
        this.tm.firstTokenAfter(node.getType(), -1).spaceBefore();
        return true;
    }

    @Override
    public boolean visit(EnhancedForStatement node) {
        this.handleToken(node, 17, this.options.insert_space_before_opening_paren_in_for, this.options.insert_space_after_opening_paren_in_for);
        this.handleTokenBefore(node.getBody(), 25, this.options.insert_space_before_closing_paren_in_for, false);
        this.handleTokenAfter(node.getParameter(), 67, this.options.insert_space_before_colon_in_for, this.options.insert_space_after_colon_in_for);
        this.handleLoopBody(node.getBody());
        return true;
    }

    @Override
    public boolean visit(MethodInvocation node) {
        this.handleTypeArguments(node.typeArguments());
        this.handleInvocation(node, node.getName());
        this.handleCommas(node.arguments(), this.options.insert_space_before_comma_in_method_invocation_arguments, this.options.insert_space_after_comma_in_method_invocation_arguments);
        return true;
    }

    @Override
    public boolean visit(SuperMethodInvocation node) {
        this.handleTypeArguments(node.typeArguments());
        this.handleInvocation(node, node.getName());
        this.handleCommas(node.arguments(), this.options.insert_space_before_comma_in_method_invocation_arguments, this.options.insert_space_after_comma_in_method_invocation_arguments);
        return true;
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        List typeArguments = node.typeArguments();
        this.handleTypeArguments(typeArguments);
        this.handleInvocation(node, node.getType(), node.getAnonymousClassDeclaration());
        if (!typeArguments.isEmpty()) {
            this.handleTokenBefore((ASTNode)typeArguments.get(0), 41, false, true);
        }
        this.handleCommas(node.arguments(), this.options.insert_space_before_comma_in_allocation_expression, this.options.insert_space_after_comma_in_allocation_expression);
        return true;
    }

    @Override
    public boolean visit(ConstructorInvocation node) {
        this.handleTypeArguments(node.typeArguments());
        this.handleInvocation(node, node);
        this.handleCommas(node.arguments(), this.options.insert_space_before_comma_in_explicit_constructor_call_arguments, this.options.insert_space_after_comma_in_explicit_constructor_call_arguments);
        return true;
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        this.handleTypeArguments(node.typeArguments());
        this.handleInvocation(node, node);
        this.handleCommas(node.arguments(), this.options.insert_space_before_comma_in_explicit_constructor_call_arguments, this.options.insert_space_after_comma_in_explicit_constructor_call_arguments);
        return true;
    }

    private void handleInvocation(ASTNode invocationNode, ASTNode nodeBeforeOpeningParen) {
        this.handleInvocation(invocationNode, nodeBeforeOpeningParen, null);
    }

    private void handleInvocation(ASTNode invocationNode, ASTNode nodeBeforeOpeningParen, ASTNode nodeAfterClosingParen) {
        if (this.handleEmptyParens(nodeBeforeOpeningParen, this.options.insert_space_between_empty_parens_in_method_invocation)) {
            this.handleToken(nodeBeforeOpeningParen, 17, this.options.insert_space_before_opening_paren_in_method_invocation, false);
        } else {
            this.handleToken(nodeBeforeOpeningParen, 17, this.options.insert_space_before_opening_paren_in_method_invocation, this.options.insert_space_after_opening_paren_in_method_invocation);
            if (this.options.insert_space_before_closing_paren_in_method_invocation) {
                Token closingParen = nodeAfterClosingParen == null ? this.tm.lastTokenIn(invocationNode, 25) : this.tm.firstTokenBefore(nodeAfterClosingParen, 25);
                closingParen.spaceBefore();
            }
        }
    }

    @Override
    public boolean visit(Assignment node) {
        this.handleOperator(node.getOperator().toString(), node.getRightHandSide(), this.options.insert_space_before_assignment_operator, this.options.insert_space_after_assignment_operator);
        return true;
    }

    @Override
    public boolean visit(InfixExpression node) {
        InfixExpression.Operator operator = node.getOperator();
        boolean spaceBefore = SPACE_BEFORE_OPERATOR.get(operator).test(this.options);
        boolean spaceAfter = SPACE_AFTER_OPERATOR.get(operator).test(this.options);
        if (this.tm.isStringConcatenation(node)) {
            spaceBefore = this.options.insert_space_before_string_concatenation;
            spaceAfter = this.options.insert_space_after_string_concatenation;
        }
        this.handleOperator(operator.toString(), node.getRightOperand(), spaceBefore, spaceAfter);
        List extendedOperands = node.extendedOperands();
        for (Expression operand : extendedOperands) {
            this.handleOperator(operator.toString(), operand, spaceBefore, spaceAfter);
        }
        return true;
    }

    @Override
    public boolean visit(PrefixExpression node) {
        PrefixExpression.Operator operator = node.getOperator();
        if (operator.equals(PrefixExpression.Operator.INCREMENT) || operator.equals(PrefixExpression.Operator.DECREMENT)) {
            this.handleOperator(operator.toString(), node.getOperand(), this.options.insert_space_before_prefix_operator, this.options.insert_space_after_prefix_operator);
        } else {
            this.handleOperator(operator.toString(), node.getOperand(), this.options.insert_space_before_unary_operator, this.options.insert_space_after_unary_operator);
        }
        return true;
    }

    @Override
    public boolean visit(PostfixExpression node) {
        if (this.options.insert_space_before_postfix_operator || this.options.insert_space_after_postfix_operator) {
            String operator = node.getOperator().toString();
            int i = this.tm.firstIndexAfter(node.getOperand(), -1);
            while (!operator.equals(this.tm.toString(i))) {
                ++i;
            }
            this.handleToken(this.tm.get(i), this.options.insert_space_before_postfix_operator, this.options.insert_space_after_postfix_operator);
        }
        return true;
    }

    private void handleOperator(String operator, ASTNode nodeAfter, boolean spaceBefore, boolean spaceAfter) {
        if (spaceBefore || spaceAfter) {
            int i = this.tm.firstIndexBefore(nodeAfter, -1);
            while (!operator.equals(this.tm.toString(i))) {
                --i;
            }
            this.handleToken(this.tm.get(i), spaceBefore, spaceAfter);
        }
    }

    @Override
    public boolean visit(ParenthesizedExpression node) {
        this.handleToken(node, 17, this.options.insert_space_before_opening_paren_in_parenthesized_expression, this.options.insert_space_after_opening_paren_in_parenthesized_expression);
        this.handleTokenAfter(node.getExpression(), 25, this.options.insert_space_before_closing_paren_in_parenthesized_expression, false);
        return true;
    }

    @Override
    public boolean visit(CastExpression node) {
        this.handleToken(node, 17, false, this.options.insert_space_after_opening_paren_in_cast);
        this.handleTokenBefore(node.getExpression(), 25, this.options.insert_space_before_closing_paren_in_cast, this.options.insert_space_after_closing_paren_in_cast);
        return true;
    }

    @Override
    public boolean visit(IntersectionType node) {
        List types = node.types();
        int i = 1;
        while (i < types.size()) {
            this.handleTokenBefore((ASTNode)types.get(i), 22, this.options.insert_space_before_bitwise_operator, this.options.insert_space_after_bitwise_operator);
            ++i;
        }
        return true;
    }

    @Override
    public boolean visit(ConditionalExpression node) {
        this.handleTokenBefore(node.getThenExpression(), 35, this.options.insert_space_before_question_in_conditional, this.options.insert_space_after_question_in_conditional);
        this.handleTokenBefore(node.getElseExpression(), 67, this.options.insert_space_before_colon_in_conditional, this.options.insert_space_after_colon_in_conditional);
        return true;
    }

    @Override
    public boolean visit(ArrayType node) {
        boolean spaceBetween;
        boolean spaceBeofreOpening;
        ASTNode parent = node.getParent();
        if (parent instanceof ArrayCreation) {
            spaceBeofreOpening = this.options.insert_space_before_opening_bracket_in_array_allocation_expression;
            spaceBetween = this.options.insert_space_between_empty_brackets_in_array_allocation_expression;
        } else {
            spaceBeofreOpening = this.options.insert_space_before_opening_bracket_in_array_type_reference;
            spaceBetween = this.options.insert_space_between_brackets_in_array_type_reference;
        }
        List dimensions = node.dimensions();
        for (Dimension dimension : dimensions) {
            this.handleToken(dimension, 5, spaceBeofreOpening, false);
            this.handleEmptyBrackets(dimension, spaceBetween);
        }
        return true;
    }

    @Override
    public boolean visit(ArrayAccess node) {
        this.handleTokenBefore(node.getIndex(), 5, this.options.insert_space_before_opening_bracket_in_array_reference, this.options.insert_space_after_opening_bracket_in_array_reference);
        this.handleTokenAfter(node.getIndex(), 71, this.options.insert_space_before_closing_bracket_in_array_reference, false);
        return true;
    }

    @Override
    public boolean visit(ArrayCreation node) {
        List dimensions = node.dimensions();
        for (Expression dimension : dimensions) {
            this.handleTokenBefore(dimension, 5, false, this.options.insert_space_after_opening_bracket_in_array_allocation_expression);
            this.handleTokenAfter(dimension, 71, this.options.insert_space_before_closing_bracket_in_array_allocation_expression, false);
        }
        return true;
    }

    @Override
    public boolean visit(ArrayInitializer node) {
        int openingBraceIndex = this.tm.firstIndexIn(node, 66);
        int closingBraceIndex = this.tm.lastIndexIn(node, 40);
        Token lastToken = this.tm.get(closingBraceIndex - 1);
        if (lastToken.tokenType == 66) {
            this.handleToken(this.tm.get(openingBraceIndex), this.options.insert_space_before_opening_brace_in_array_initializer && !(node.getParent() instanceof ArrayInitializer) && !(node.getParent() instanceof SingleMemberAnnotation), this.options.insert_space_between_empty_braces_in_array_initializer);
        } else {
            boolean endsWithComma = lastToken.tokenType == 39;
            this.handleToken(this.tm.get(openingBraceIndex), this.options.insert_space_before_opening_brace_in_array_initializer && !(node.getParent() instanceof ArrayInitializer) && !(node.getParent() instanceof SingleMemberAnnotation), this.options.insert_space_after_opening_brace_in_array_initializer && (!endsWithComma || !node.expressions().isEmpty()));
            this.handleCommas(node.expressions(), this.options.insert_space_before_comma_in_array_initializer, this.options.insert_space_after_comma_in_array_initializer);
            if (endsWithComma) {
                this.handleToken(lastToken, this.options.insert_space_before_comma_in_array_initializer, false);
            }
            this.handleToken(this.tm.get(closingBraceIndex), this.options.insert_space_before_closing_brace_in_array_initializer && (!endsWithComma || !node.expressions().isEmpty()), false);
        }
        return true;
    }

    @Override
    public boolean visit(ParameterizedType node) {
        List typeArguments = node.typeArguments();
        boolean hasArguments = !typeArguments.isEmpty();
        this.handleTokenAfter(node.getType(), 7, this.options.insert_space_before_opening_angle_bracket_in_parameterized_type_reference, hasArguments && this.options.insert_space_after_opening_angle_bracket_in_parameterized_type_reference);
        if (hasArguments) {
            this.handleTokenAfter((ASTNode)typeArguments.get(typeArguments.size() - 1), 13, this.options.insert_space_before_closing_angle_bracket_in_parameterized_type_reference, false);
            this.handleCommas(node.typeArguments(), this.options.insert_space_before_comma_in_parameterized_type_reference, this.options.insert_space_after_comma_in_parameterized_type_reference);
        }
        return true;
    }

    @Override
    public boolean visit(TypeParameter node) {
        List typeBounds = node.typeBounds();
        int i = 1;
        while (i < typeBounds.size()) {
            this.handleTokenBefore((ASTNode)typeBounds.get(i), 22, this.options.insert_space_before_and_in_type_parameter, this.options.insert_space_after_and_in_type_parameter);
            ++i;
        }
        return true;
    }

    @Override
    public boolean visit(WildcardType node) {
        this.handleToken(node, 35, this.options.insert_space_before_question_in_wilcard, this.options.insert_space_after_question_in_wilcard || node.getBound() != null);
        return true;
    }

    @Override
    public boolean visit(UnionType node) {
        List types = node.types();
        int i = 1;
        while (i < types.size()) {
            this.handleTokenBefore((ASTNode)types.get(i), 36, this.options.insert_space_before_bitwise_operator, this.options.insert_space_after_bitwise_operator);
            ++i;
        }
        return true;
    }

    @Override
    public boolean visit(Dimension node) {
        List annotations = node.annotations();
        if (!annotations.isEmpty()) {
            this.handleToken((ASTNode)annotations.get(0), 42, true, false);
        }
        return true;
    }

    @Override
    public boolean visit(TypeMethodReference node) {
        this.handleTypeArguments(node.typeArguments());
        return true;
    }

    @Override
    public boolean visit(ExpressionMethodReference node) {
        this.handleTypeArguments(node.typeArguments());
        return true;
    }

    @Override
    public boolean visit(SuperMethodReference node) {
        this.handleTypeArguments(node.typeArguments());
        return true;
    }

    @Override
    public boolean visit(CreationReference node) {
        this.handleTypeArguments(node.typeArguments());
        return true;
    }

    private void handleTypeArguments(List<Type> typeArguments) {
        if (typeArguments.isEmpty()) {
            return;
        }
        this.handleTokenBefore(typeArguments.get(0), 7, this.options.insert_space_before_opening_angle_bracket_in_type_arguments, this.options.insert_space_after_opening_angle_bracket_in_type_arguments);
        this.handleTokenAfter(typeArguments.get(typeArguments.size() - 1), 13, this.options.insert_space_before_closing_angle_bracket_in_type_arguments, this.options.insert_space_after_closing_angle_bracket_in_type_arguments);
        this.handleCommas(typeArguments, this.options.insert_space_before_comma_in_type_arguments, this.options.insert_space_after_comma_in_type_arguments);
    }

    @Override
    public boolean visit(InstanceofExpression node) {
        this.handleTokenAfter(node.getLeftOperand(), 16, true, true);
        return true;
    }

    @Override
    public boolean visit(ModuleDeclaration node) {
        this.handleToken(node.getName(), 66, this.options.insert_space_before_opening_brace_in_type_declaration, false);
        return true;
    }

    @Override
    public boolean visit(ExportsDirective node) {
        this.handleModuleStatementCommas(node.modules());
        return true;
    }

    @Override
    public boolean visit(OpensDirective node) {
        this.handleModuleStatementCommas(node.modules());
        return true;
    }

    @Override
    public boolean visit(ProvidesDirective node) {
        this.handleModuleStatementCommas(node.implementations());
        return true;
    }

    private void handleModuleStatementCommas(List<Name> names) {
        this.handleCommas(names, this.options.insert_space_before_comma_in_multiple_field_declarations, this.options.insert_space_after_comma_in_multiple_field_declarations);
    }

    private void handleCommas(List<? extends ASTNode> nodes, boolean spaceBefore, boolean spaceAfter) {
        if (spaceBefore || spaceAfter) {
            int i = 1;
            while (i < nodes.size()) {
                this.handleTokenBefore(nodes.get(i), 39, spaceBefore, spaceAfter);
                ++i;
            }
        }
    }

    private void handleToken(ASTNode node, int tokenType, boolean spaceBefore, boolean spaceAfter) {
        if (spaceBefore || spaceAfter) {
            Token token = this.tm.get(this.tm.findIndex(node.getStartPosition(), tokenType, true));
            this.handleToken(token, spaceBefore, spaceAfter);
        }
    }

    private void handleTokenBefore(ASTNode node, int tokenType, boolean spaceBefore, boolean spaceAfter) {
        if (spaceBefore || spaceAfter) {
            Token token = this.tm.firstTokenBefore(node, tokenType);
            this.handleToken(token, spaceBefore, spaceAfter);
        }
    }

    private void handleTokenAfter(ASTNode node, int tokenType, boolean spaceBefore, boolean spaceAfter) {
        if (tokenType == 13) {
            int index;
            int i = index = this.tm.lastIndexIn(node, -1);
            while (i < index + 2) {
                Token token = this.tm.get(i);
                if (token.tokenType == 12 || token.tokenType == 15) {
                    this.tm.remove(i);
                    int j = 0;
                    while (j < (token.tokenType == 12 ? 2 : 3)) {
                        this.tm.insert(i + j, new Token(token.originalStart + j, token.originalStart + j, 13));
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (spaceBefore || spaceAfter) {
            Token token = this.tm.firstTokenAfter(node, tokenType);
            this.handleToken(token, spaceBefore, spaceAfter);
        }
    }

    private void handleToken(Token token, boolean spaceBefore, boolean spaceAfter) {
        if (spaceBefore) {
            token.spaceBefore();
        }
        if (spaceAfter) {
            token.spaceAfter();
        }
    }

    private boolean handleEmptyParens(ASTNode nodeBeforeParens, boolean insertSpace) {
        int openingIndex = this.tm.findIndex(nodeBeforeParens.getStartPosition(), 17, true);
        if (this.tm.get((int)(openingIndex + 1)).tokenType == 25) {
            if (insertSpace) {
                this.tm.get(openingIndex).spaceAfter();
            }
            return true;
        }
        return false;
    }

    private boolean handleEmptyBrackets(ASTNode nodeContainingBrackets, boolean insertSpace) {
        int openingIndex = this.tm.firstIndexIn(nodeContainingBrackets, 5);
        if (this.tm.get((int)(openingIndex + 1)).tokenType == 71) {
            if (insertSpace) {
                this.tm.get(openingIndex).spaceAfter();
            }
            return true;
        }
        return false;
    }

    private void handleSemicolon(ASTNode node) {
        if (this.options.insert_space_before_semicolon) {
            Token lastToken = this.tm.lastTokenIn(node, -1);
            if (lastToken.tokenType == 26) {
                lastToken.spaceBefore();
            }
        }
    }

    private void handleSemicolon(List<ASTNode> nodes) {
        if (this.options.insert_space_before_semicolon) {
            for (ASTNode node : nodes) {
                this.handleSemicolon(node);
            }
        }
    }

    private void handleLoopBody(Statement loopBody) {
        int firstTokenIndex = this.tm.firstIndexIn(loopBody, -1);
        if (!(loopBody instanceof Block || loopBody instanceof EmptyStatement || this.tm.get(firstTokenIndex - 1).isComment())) {
            this.tm.get(firstTokenIndex).spaceBefore();
        }
    }

    public void finishUp() {
        this.tm.traverse(0, new TokenTraverser(){
            boolean isPreviousJIDP = false;

            @Override
            protected boolean token(Token token, int index) {
                char c = SpacePreparator.this.tm.charAt(token.originalStart);
                boolean isJIDP = ScannerHelper.isJavaIdentifierPart(c);
                if ((isJIDP || c == '@') && this.isPreviousJIDP) {
                    this.getPrevious().spaceAfter();
                }
                this.isPreviousJIDP = isJIDP;
                switch (token.tokenType) {
                    case 2: {
                        if (this.getNext().tokenType != 2 && this.getNext().tokenType != 3) break;
                        token.spaceAfter();
                        break;
                    }
                    case 6: {
                        if (this.getNext().tokenType != 6 && this.getNext().tokenType != 4) break;
                        token.spaceAfter();
                    }
                }
                return true;
            }
        });
    }
}

