/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cockpit.plugin.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.logging.LogFactory;
import org.camunda.bpm.cockpit.Cockpit;
import org.camunda.bpm.cockpit.db.CommandExecutor;
import org.camunda.bpm.cockpit.db.QueryService;
import org.camunda.bpm.cockpit.impl.DefaultCockpitRuntimeDelegate;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.util.LogUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;

public abstract class AbstractCockpitPluginTest {
    private static TestCockpitRuntimeDelegate RUNTIME_DELEGATE = new TestCockpitRuntimeDelegate();
    private static final String DEFAULT_BPMN_RESOURCE_NAME = "process.bpmn20.xml";
    @Rule
    public ProcessEngineRule processEngineRule = new ProcessEngineRule();

    @BeforeClass
    public static void beforeClass() {
        Cockpit.setCockpitRuntimeDelegate(RUNTIME_DELEGATE);
    }

    @AfterClass
    public static void afterClass() {
        Cockpit.setCockpitRuntimeDelegate(null);
    }

    @Before
    public void before() {
        AbstractCockpitPluginTest.RUNTIME_DELEGATE.ENGINE = this.getProcessEngine();
    }

    @After
    public void after() {
        AbstractCockpitPluginTest.RUNTIME_DELEGATE.ENGINE = null;
        this.getProcessEngine().getIdentityService().clearAuthentication();
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngineRule.getProcessEngine();
    }

    protected CommandExecutor getCommandExecutor() {
        return Cockpit.getCommandExecutor("default");
    }

    protected QueryService getQueryService() {
        return Cockpit.getQueryService("default");
    }

    public void executeAvailableJobs() {
        ManagementService managementService = this.getProcessEngine().getManagementService();
        List jobs = managementService.createJobQuery().withRetriesLeft().list();
        if (jobs.isEmpty()) {
            return;
        }
        for (Job job : jobs) {
            try {
                managementService.executeJob(job.getId());
            }
            catch (Exception e) {}
        }
        this.executeAvailableJobs();
    }

    public Deployment deploy(String ... resources) {
        return this.deploy(this.createDeploymentBuilder(), Collections.<BpmnModelInstance>emptyList(), Arrays.asList(resources));
    }

    public Deployment deployForTenant(String tenantId, String ... resources) {
        return this.deploy(this.createDeploymentBuilder().tenantId(tenantId), Collections.<BpmnModelInstance>emptyList(), Arrays.asList(resources));
    }

    protected Deployment deploy(DeploymentBuilder deploymentBuilder, List<BpmnModelInstance> bpmnModelInstances, List<String> resources) {
        int i = 0;
        for (BpmnModelInstance bpmnModelInstance : bpmnModelInstances) {
            deploymentBuilder.addModelInstance(i + "_" + DEFAULT_BPMN_RESOURCE_NAME, bpmnModelInstance);
            ++i;
        }
        for (String resource : resources) {
            deploymentBuilder.addClasspathResource(resource);
        }
        Deployment deployment = deploymentBuilder.deploy();
        this.processEngineRule.manageDeployment(deployment);
        return deployment;
    }

    protected DeploymentBuilder createDeploymentBuilder() {
        return this.getProcessEngine().getRepositoryService().createDeployment();
    }

    static {
        LogUtil.readJavaUtilLoggingConfigFromClasspath();
        LogFactory.useJdkLogging();
    }

    private static class TestCockpitRuntimeDelegate
    extends DefaultCockpitRuntimeDelegate {
        public ProcessEngine ENGINE;

        private TestCockpitRuntimeDelegate() {
        }

        @Override
        public ProcessEngine getProcessEngine(String processEngineName) {
            return this.ENGINE;
        }
    }
}

