/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.engine;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.camunda.bpm.admin.Admin;
import org.camunda.bpm.admin.AdminRuntimeDelegate;
import org.camunda.bpm.cockpit.Cockpit;
import org.camunda.bpm.cockpit.CockpitRuntimeDelegate;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.tasklist.Tasklist;
import org.camunda.bpm.tasklist.TasklistRuntimeDelegate;
import org.camunda.bpm.webapp.impl.IllegalWebAppConfigurationException;
import org.camunda.bpm.webapp.impl.filter.AbstractTemplateFilter;
import org.camunda.bpm.webapp.impl.security.SecurityActions;
import org.camunda.bpm.webapp.plugin.spi.AppPlugin;
import org.camunda.bpm.welcome.Welcome;
import org.camunda.bpm.welcome.WelcomeRuntimeDelegate;

public class ProcessEnginesFilter
extends AbstractTemplateFilter {
    protected static final String COCKPIT_APP_NAME = "cockpit";
    protected static final String ADMIN_APP_NAME = "admin";
    protected static final String TASKLIST_APP_NAME = "tasklist";
    protected static final String WELCOME_APP_NAME = "welcome";
    protected static final String DEFAULT_APP = "welcome";
    protected static final String INDEX_PAGE = "index.html";
    protected static final String SETUP_PAGE = "setup/";
    public static final String APP_ROOT_PLACEHOLDER = "$APP_ROOT";
    public static final String BASE_PLACEHOLDER = "$BASE";
    public static final String PLUGIN_DEPENDENCIES_PLACEHOLDER = "$PLUGIN_DEPENDENCIES";
    public static final String PLUGIN_PACKAGES_PLACEHOLDER = "$PLUGIN_PACKAGES";
    public static Pattern APP_PREFIX_PATTERN = Pattern.compile("/app/(?:([\\w-]+?)/(?:(index\\.html|[\\w-]+)?/?([^?]*)?)?)?");
    protected final CockpitRuntimeDelegate cockpitRuntimeDelegate = Cockpit.getRuntimeDelegate();
    protected final AdminRuntimeDelegate adminRuntimeDelegate = Admin.getRuntimeDelegate();
    protected final TasklistRuntimeDelegate tasklistRuntimeDelegate = Tasklist.getRuntimeDelegate();
    protected final WelcomeRuntimeDelegate welcomeRuntimeDelegate = Welcome.getRuntimeDelegate();
    protected final String pluginPackageFormat;
    protected final String pluginDependencyFormat;

    public ProcessEnginesFilter() {
        this.pluginPackageFormat = "{ name: '%s-plugin-%s', location: '%s/api/%s/plugin/%s/static/app', main: 'plugin.js' }";
        this.pluginDependencyFormat = "{ ngModuleName: '%s.plugin.%s', requirePackageName: '%s-plugin-%s' }";
    }

    @Override
    protected void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String contextPath = request.getContextPath();
        String requestUri = request.getRequestURI().substring(contextPath.length());
        Matcher uriMatcher = APP_PREFIX_PATTERN.matcher(requestUri);
        if (uriMatcher.matches()) {
            String appName = uriMatcher.group(1);
            String engineName = uriMatcher.group(2);
            String pageUri = uriMatcher.group(3);
            if (INDEX_PAGE.equals(engineName)) {
                engineName = null;
            }
            if (pageUri == null || pageUri.isEmpty() || SETUP_PAGE.equals(pageUri)) {
                this.serveIndexPage(appName, engineName, pageUri, contextPath, request, response, chain);
                return;
            }
            if (INDEX_PAGE.equals(pageUri)) {
                response.sendRedirect(String.format("%s/app/%s/%s/", contextPath, appName, engineName));
                return;
            }
            if (pageUri.endsWith(".html")) {
                this.serveTemplate(requestUri, appName, pageUri, request, response, chain);
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void serveIndexPage(String appName, String engineName, String pageUri, String contextPath, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException {
        if (appName == null) {
            response.sendRedirect(String.format("%s/app/%s/%s/", contextPath, "welcome", this.getDefaultEngineName()));
        } else if (engineName == null) {
            response.sendRedirect(String.format("%s/app/%s/%s/", contextPath, appName, this.getDefaultEngineName()));
        } else {
            boolean setupPage = SETUP_PAGE.equals(pageUri);
            if (this.needsInitialUser(engineName)) {
                if (!setupPage) {
                    response.sendRedirect(String.format("%s/app/admin/%s/setup/#/setup", contextPath, engineName));
                } else {
                    this.serveIndexPage(appName, engineName, contextPath, request, response);
                }
            } else if (!setupPage) {
                this.serveIndexPage(appName, engineName, contextPath, request, response);
            } else {
                response.sendRedirect(String.format("%s/app/%s/%s/", contextPath, appName, engineName));
            }
        }
    }

    protected String getDefaultEngineName() {
        CockpitRuntimeDelegate runtimeDelegate = Cockpit.getRuntimeDelegate();
        Set<String> processEngineNames = runtimeDelegate.getProcessEngineNames();
        if (processEngineNames.isEmpty()) {
            throw new IllegalWebAppConfigurationException("No process engine found. camunda Webapp cannot work without a process engine. ");
        }
        ProcessEngine defaultProcessEngine = runtimeDelegate.getDefaultProcessEngine();
        if (defaultProcessEngine != null) {
            return defaultProcessEngine.getName();
        }
        return processEngineNames.iterator().next();
    }

    protected void serveTemplate(String requestUri, String appName, String pageUri, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.hasWebResource(requestUri)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            String cleanAppUri = String.format("/app/%s/%s", appName, pageUri);
            if (this.hasWebResource(cleanAppUri)) {
                request.getRequestDispatcher(cleanAppUri).forward((ServletRequest)request, (ServletResponse)response);
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    protected boolean needsInitialUser(String engineName) {
        final ProcessEngine processEngine = Cockpit.getProcessEngine(engineName);
        if (processEngine == null) {
            return false;
        }
        if (processEngine.getIdentityService().isReadOnly()) {
            return false;
        }
        return SecurityActions.runWithoutAuthentication(new SecurityActions.SecurityAction<Boolean>(){

            @Override
            public Boolean execute() {
                return processEngine.getIdentityService().createUserQuery().memberOfGroup("camunda-admin").count() == 0L;
            }
        }, processEngine);
    }

    protected void serveIndexPage(String appName, String engineName, String contextPath, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String data = this.getWebResourceContents("/app/" + appName + "/index.html");
        data = this.replacePlaceholder(data, appName, engineName, contextPath, request, response);
        response.setContentLength(data.getBytes("UTF-8").length);
        response.setContentType("text/html");
        response.getWriter().append(data);
    }

    protected String replacePlaceholder(String data, String appName, String engineName, String contextPath, HttpServletRequest request, HttpServletResponse response) {
        return data.replace(APP_ROOT_PLACEHOLDER, contextPath).replace(BASE_PLACEHOLDER, String.format("%s/app/%s/%s/", contextPath, appName, engineName)).replace(PLUGIN_PACKAGES_PLACEHOLDER, this.createPluginPackagesStr(appName, contextPath)).replace(PLUGIN_DEPENDENCIES_PLACEHOLDER, this.createPluginDependenciesStr(appName));
    }

    protected <T extends AppPlugin> CharSequence createPluginPackagesStr(String appName, String contextPath) {
        List<T> plugins = this.getPlugins(appName);
        StringBuilder builder = new StringBuilder();
        for (AppPlugin plugin : plugins) {
            if (builder.length() > 0) {
                builder.append(", ").append("\n");
            }
            String pluginId = plugin.getId();
            String definition = String.format(this.pluginPackageFormat, appName, pluginId, contextPath, appName, pluginId);
            builder.append(definition);
        }
        return "[" + builder.toString() + "]";
    }

    protected <T extends AppPlugin> CharSequence createPluginDependenciesStr(String appName) {
        List<T> plugins = this.getPlugins(appName);
        StringBuilder builder = new StringBuilder();
        for (AppPlugin plugin : plugins) {
            if (builder.length() > 0) {
                builder.append(", ").append("\n");
            }
            String pluginId = plugin.getId();
            String definition = String.format(this.pluginDependencyFormat, appName, pluginId, appName, pluginId);
            builder.append(definition);
        }
        return "[" + builder.toString() + "]";
    }

    protected <T extends AppPlugin> List<T> getPlugins(String appName) {
        if (COCKPIT_APP_NAME.equals(appName)) {
            return this.cockpitRuntimeDelegate.getAppPluginRegistry().getPlugins();
        }
        if (ADMIN_APP_NAME.equals(appName)) {
            return this.adminRuntimeDelegate.getAppPluginRegistry().getPlugins();
        }
        if (TASKLIST_APP_NAME.equals(appName)) {
            return this.tasklistRuntimeDelegate.getAppPluginRegistry().getPlugins();
        }
        if ("welcome".equals(appName)) {
            return this.welcomeRuntimeDelegate.getAppPluginRegistry().getPlugins();
        }
        return Collections.emptyList();
    }
}

