/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.security.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.spi.ProcessEngineProvider;
import org.camunda.bpm.webapp.impl.security.auth.Authentication;
import org.camunda.bpm.webapp.impl.security.auth.AuthenticationDto;
import org.camunda.bpm.webapp.impl.security.auth.Authentications;
import org.camunda.bpm.webapp.impl.security.auth.UserAuthentication;

@Path(value="/auth/user")
public class UserAuthenticationResource {
    public static final String PATH = "/auth/user";
    private static final String[] APPS = new String[]{"cockpit", "tasklist", "admin"};
    @Context
    protected HttpServletRequest request;

    @GET
    @Path(value="/{processEngineName}")
    public Response getAuthenticatedUser(@PathParam(value="processEngineName") String engineName) {
        Authentications allAuthentications = Authentications.getCurrent();
        if (allAuthentications == null) {
            return this.notFound();
        }
        Authentication engineAuth = allAuthentications.getAuthenticationForProcessEngine(engineName);
        if (engineAuth == null) {
            return this.notFound();
        }
        return Response.ok((Object)AuthenticationDto.fromAuthentication(engineAuth)).build();
    }

    @POST
    @Path(value="/{processEngineName}/login/{appName}")
    public Response doLogin(@PathParam(value="processEngineName") String engineName, @PathParam(value="appName") String appName, @FormParam(value="username") String username, @FormParam(value="password") String password) {
        ProcessEngine processEngine = this.lookupProcessEngine(engineName);
        if (processEngine == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Process engine with name " + engineName + " does not exist");
        }
        processEngine.getIdentityService().clearAuthentication();
        boolean isPasswordValid = processEngine.getIdentityService().checkPassword(username, password);
        if (!isPasswordValid) {
            return this.unauthorized();
        }
        List<String> groupIds = this.getGroupsOfUser(processEngine, username);
        List<String> tenantIds = this.getTenantsOfUser(processEngine, username);
        AuthorizationService authorizationService = processEngine.getAuthorizationService();
        HashSet<String> authorizedApps = new HashSet<String>();
        authorizedApps.add("welcome");
        if (processEngine.getProcessEngineConfiguration().isAuthorizationEnabled()) {
            for (String application : APPS) {
                if (!this.isAuthorizedForApp(authorizationService, username, groupIds, application)) continue;
                authorizedApps.add(application);
            }
        } else {
            Collections.addAll(authorizedApps, APPS);
        }
        if (!authorizedApps.contains(appName)) {
            return this.forbidden();
        }
        Authentications authentications = Authentications.getCurrent();
        UserAuthentication newAuthentication = new UserAuthentication(username, engineName);
        newAuthentication.setGroupIds(groupIds);
        newAuthentication.setTenantIds(tenantIds);
        newAuthentication.setAuthorizedApps(authorizedApps);
        authentications.addAuthentication(newAuthentication);
        return Response.ok((Object)AuthenticationDto.fromAuthentication(newAuthentication)).build();
    }

    protected List<String> getGroupsOfUser(ProcessEngine engine, String userId) {
        List groups = engine.getIdentityService().createGroupQuery().groupMember(userId).list();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    protected List<String> getTenantsOfUser(ProcessEngine engine, String userId) {
        List tenants = engine.getIdentityService().createTenantQuery().userMember(userId).includingGroupsOfUser(true).list();
        ArrayList<String> tenantIds = new ArrayList<String>();
        for (Tenant tenant : tenants) {
            tenantIds.add(tenant.getId());
        }
        return tenantIds;
    }

    @POST
    @Path(value="/{processEngineName}/logout")
    public Response doLogout(@PathParam(value="processEngineName") String engineName) {
        Authentications authentications = Authentications.getCurrent();
        authentications.removeAuthenticationForProcessEngine(engineName);
        return Response.ok().build();
    }

    protected ProcessEngine lookupProcessEngine(String engineName) {
        ServiceLoader<ProcessEngineProvider> serviceLoader = ServiceLoader.load(ProcessEngineProvider.class);
        Iterator<ProcessEngineProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            ProcessEngineProvider provider = iterator.next();
            return provider.getProcessEngine(engineName);
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "Could not find an implementation of the " + ProcessEngineProvider.class + "- SPI");
    }

    private Response unauthorized() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    private Response forbidden() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    protected boolean isAuthorizedForApp(AuthorizationService authorizationService, String username, List<String> groupIds, String application) {
        return authorizationService.isUserAuthorized(username, groupIds, (Permission)Permissions.ACCESS, (Resource)Resources.APPLICATION, application);
    }

    private Response notFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

