/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import javax.inject.Inject;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.license.AbstractLicenseNameMojo;
import org.codehaus.mojo.license.model.License;
import org.codehaus.mojo.license.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="update-project-license", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class UpdateProjectLicenseMojo
extends AbstractLicenseNameMojo {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateProjectLicenseMojo.class);
    @Parameter(property="license.licenceFile", defaultValue="${basedir}/LICENSE.txt")
    protected File licenseFile;
    @Parameter(property="license.outputDirectory", defaultValue="target/generated-sources/license")
    protected File outputDirectory;
    @Parameter(property="license.generateBundle", defaultValue="false")
    protected boolean generateBundle;
    @Parameter(property="license.bundleLicensePath", defaultValue="META-INF/${project.artifactId}-LICENSE.txt")
    protected String bundleLicensePath;
    @Parameter(property="license.force", defaultValue="false")
    protected boolean force;
    @Parameter(property="license.skipUpdateProjectLicense", defaultValue="false")
    protected boolean skipUpdateProjectLicense;
    private boolean doGenerate;

    @Inject
    public UpdateProjectLicenseMojo(MavenProjectHelper projectHelper) {
        super(projectHelper);
    }

    @Override
    public boolean isSkip() {
        return this.skipUpdateProjectLicense;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.licenseFile != null) {
            File pomFile = this.getProject().getFile();
            this.doGenerate = this.force || !this.licenseFile.exists() || this.licenseFile.lastModified() <= pomFile.lastModified();
        }
    }

    @Override
    protected void doAction() throws Exception {
        License license = this.getLicense();
        if (this.doGenerate) {
            LOG.info("Will create or update license file [{}] to {}", (Object)license.getName(), (Object)this.licenseFile);
            if (this.isVerbose()) {
                LOG.info("detail of license :\n{}", (Object)license);
            }
            if (this.licenseFile.exists() && this.isKeepBackup()) {
                if (this.isVerbose()) {
                    LOG.info("backup {}", (Object)this.licenseFile);
                }
                FileUtil.backupFile(this.licenseFile);
            }
        }
        String licenseContent = license.getLicenseContent(this.getEncoding());
        if (license.isLicenseContentTemplateAware()) {
            licenseContent = this.processLicenseContext(licenseContent);
        }
        if (this.doGenerate) {
            FileUtil.printString(this.licenseFile, licenseContent, this.getEncoding());
        }
        if (this.hasClassPath()) {
            File resourceTarget = new File(this.outputDirectory, this.licenseFile.getName());
            FileUtil.copyFile(this.licenseFile, resourceTarget);
            this.addResourceDir(this.outputDirectory, "**/" + resourceTarget.getName());
            if (this.generateBundle) {
                File bundleTarget = new File(this.outputDirectory, this.bundleLicensePath);
                FileUtil.copyFile(this.licenseFile, bundleTarget);
                if (!resourceTarget.getName().equals(bundleTarget.getName())) {
                    this.addResourceDir(this.outputDirectory, "**/" + bundleTarget.getName());
                }
            }
        }
    }
}

