/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Lock;
import org.compass.core.CompassTransaction;
import org.compass.core.Property;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.util.ClassUtils;

public class LuceneSettings {
    private static final Log log = LogFactory.getLog(LuceneSettings.class);
    private CompassSettings settings;
    private String connection;
    private String subContext;
    private String defaultSearchPropery;
    private String allProperty;
    private Property.TermVector allPropertyTermVector;
    private boolean allPropertyBoostSupport;
    private String aliasProperty;
    private String extendedAliasProperty;
    private CompassTransaction.TransactionIsolation transactionIsolation;
    private Class transactionIsolationClass;
    private int maxMergeDocs;
    private int mergeFactor;
    private int maxFieldLength;
    private int maxBufferedDocs;
    private int maxBufferedDeletedTerms;
    private int termIndexInterval;
    private double ramBufferSize;
    private long transactionLockTimout;
    private long cacheInvalidationInterval;
    private boolean waitForCacheInvalidationOnIndexOperation;
    private String lockDir;
    private boolean clearCacheOnCommit;

    public void configure(CompassSettings settings) throws SearchEngineException {
        String transIsolationSetting;
        this.settings = settings;
        this.connection = settings.getSetting("compass.engine.connection");
        if (this.connection == null) {
            throw new SearchEngineException("Lucene connection must be set in the settings. Please set [compass.engine.connection]");
        }
        this.subContext = settings.getSetting("compass.engine.connection.subContext");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using connection [" + this.connection + "][" + this.subContext + "]"));
        }
        this.aliasProperty = settings.getSetting("compass.property.alias", "alias");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using alias property [" + this.aliasProperty + "]"));
        }
        this.extendedAliasProperty = settings.getSetting("compass.property.extendedAlias", "extendedAlias");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using extended alias property [" + this.extendedAliasProperty + "]"));
        }
        this.allProperty = settings.getSetting("compass.property.all", "zzz-all");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using default all property [" + this.allProperty + "]"));
        }
        String allPropertyTermVectorSettings = settings.getSetting("compass.property.all.termVector", "no");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using all property term vector [" + allPropertyTermVectorSettings + "]"));
        }
        this.allPropertyBoostSupport = settings.getSettingAsBoolean("compass.property.all.boostSupport", true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("All property boost support is [" + this.allPropertyBoostSupport + "]"));
        }
        if ("no".equals(allPropertyTermVectorSettings)) {
            this.allPropertyTermVector = Property.TermVector.NO;
        } else if ("yes".equals(allPropertyTermVectorSettings)) {
            this.allPropertyTermVector = Property.TermVector.YES;
        } else if ("positions".equals(allPropertyTermVectorSettings)) {
            this.allPropertyTermVector = Property.TermVector.WITH_POSITIONS;
        } else if ("offsets".equals(allPropertyTermVectorSettings)) {
            this.allPropertyTermVector = Property.TermVector.WITH_OFFSETS;
        } else if ("positions_offsets".equals(allPropertyTermVectorSettings)) {
            this.allPropertyTermVector = Property.TermVector.WITH_POSITIONS_OFFSETS;
        } else {
            throw new SearchEngineException("Unrecognized term vector setting for the all property [" + allPropertyTermVectorSettings + "]");
        }
        this.defaultSearchPropery = settings.getSetting("compass.engine.defaultsearch", this.allProperty);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using default search property [" + this.defaultSearchPropery + "]"));
        }
        if ((transIsolationSetting = settings.getSetting("compass.transaction.isolation", "read_committed")).equalsIgnoreCase("none")) {
            this.transactionIsolation = CompassTransaction.TransactionIsolation.READ_COMMITTED;
        } else if (transIsolationSetting.equalsIgnoreCase("read_uncommitted")) {
            this.transactionIsolation = CompassTransaction.TransactionIsolation.READ_COMMITTED;
        } else if (transIsolationSetting.equalsIgnoreCase("read_committed")) {
            this.transactionIsolation = CompassTransaction.TransactionIsolation.READ_COMMITTED;
        } else if (transIsolationSetting.equalsIgnoreCase("repeatable_read")) {
            this.transactionIsolation = CompassTransaction.TransactionIsolation.READ_COMMITTED;
        } else if (transIsolationSetting.equalsIgnoreCase("serializable")) {
            this.transactionIsolation = CompassTransaction.TransactionIsolation.SERIALIZABLE;
        } else if (transIsolationSetting.equalsIgnoreCase("batch_insert")) {
            this.transactionIsolation = CompassTransaction.TransactionIsolation.BATCH_INSERT;
        } else if (transIsolationSetting.equalsIgnoreCase("lucene")) {
            this.transactionIsolation = CompassTransaction.TransactionIsolation.LUCENE;
        }
        String transIsolationClassSetting = settings.getSetting("compass.transaction.isolation.class", null);
        if (transIsolationClassSetting != null) {
            try {
                this.transactionIsolationClass = ClassUtils.forName(transIsolationClassSetting, settings.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new SearchEngineException("Can't find transaction class [" + transIsolationClassSetting + "]", e);
            }
        }
        this.transactionLockTimout = settings.getSettingAsLong("compass.transaction.lockTimeout", 10L) * 1000L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using transaction lock timeout [" + this.transactionLockTimout + "ms]"));
        }
        IndexWriter.setDefaultWriteLockTimeout((long)this.transactionLockTimout);
        Lock.LOCK_POLL_INTERVAL = settings.getSettingAsLong("compass.transaction.lockPollInterval", 100L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using lock poll interval [" + Lock.LOCK_POLL_INTERVAL + "ms]"));
        }
        this.lockDir = settings.getSetting("compass.transaction.lockDir");
        if (this.lockDir != null) {
            throw new IllegalArgumentException("compass.transaction.lockDir setting is no longer supported. The lock by default is stored in the index directory now, and can be conrolled by using LockFactory");
        }
        this.maxMergeDocs = settings.getSettingAsInt("compass.engine.maxMergeDocs", Integer.MAX_VALUE);
        this.clearCacheOnCommit = settings.getSettingAsBoolean("compass.transaction.clearCacheOnCommit", true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using clear cache on commit [" + this.clearCacheOnCommit + "]"));
        }
        this.mergeFactor = settings.getSettingAsInt("compass.engine.mergeFactor", 10);
        this.maxBufferedDocs = settings.getSettingAsInt("compass.engine.maxBufferedDocs", -1);
        this.maxBufferedDeletedTerms = settings.getSettingAsInt("compass.engine.maxBufferedDeletedTerms", -1);
        this.termIndexInterval = settings.getSettingAsInt("compass.engine.termIndexInterval", 128);
        this.maxFieldLength = settings.getSettingAsInt("compass.engine.maxFieldLength", 10000);
        this.ramBufferSize = settings.getSettingAsDouble("compass.engine.ramBufferSize", 16.0);
        this.cacheInvalidationInterval = settings.getSettingAsLong("compass.engine.cacheIntervalInvalidation", 5000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using cache invalidation interval [" + this.cacheInvalidationInterval + "ms]"));
        }
        this.waitForCacheInvalidationOnIndexOperation = settings.getSettingAsBoolean("compass.engine.waitForCacheInvalidationOnIndexOperation", false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wait for cahce invalidation on index operatrion is set to [" + this.waitForCacheInvalidationOnIndexOperation + "]"));
        }
    }

    public CompassSettings getSettings() {
        return this.settings;
    }

    public String getAllProperty() {
        return this.allProperty;
    }

    public String getAliasProperty() {
        return this.aliasProperty;
    }

    public String getExtendedAliasProperty() {
        return this.extendedAliasProperty;
    }

    public CompassTransaction.TransactionIsolation getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public Class getTransactionIsolationClass() {
        return this.transactionIsolationClass;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public int getMaxBufferedDocs() {
        return this.maxBufferedDocs;
    }

    public int getMaxBufferedDeletedTerms() {
        return this.maxBufferedDeletedTerms;
    }

    public int getTermIndexInterval() {
        return this.termIndexInterval;
    }

    public double getRamBufferSize() {
        return this.ramBufferSize;
    }

    public String getDefaultSearchPropery() {
        return this.defaultSearchPropery;
    }

    public String getConnection() {
        return this.connection;
    }

    public Property.TermVector getAllPropertyTermVector() {
        return this.allPropertyTermVector;
    }

    public boolean isAllPropertyBoostSupport() {
        return this.allPropertyBoostSupport;
    }

    public long getTransactionLockTimout() {
        return this.transactionLockTimout;
    }

    public long getCacheInvalidationInterval() {
        return this.cacheInvalidationInterval;
    }

    public String getLockDir() {
        return this.lockDir;
    }

    public boolean isWaitForCacheInvalidationOnIndexOperation() {
        return this.waitForCacheInvalidationOnIndexOperation;
    }

    public boolean isClearCacheOnCommit() {
        return this.clearCacheOnCommit;
    }

    public String getSubContext() {
        return this.subContext;
    }
}

