/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.all;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Payload;
import org.compass.core.Property;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.all.AllBoostUtils;
import org.compass.core.mapping.AllMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.spi.InternalProperty;
import org.compass.core.spi.InternalResource;

public class AllAnalyzer
extends Analyzer {
    private Analyzer analyzer;
    private InternalResource resource;
    private ResourceMapping resourceMapping;
    private AllMapping allMapping;
    private LuceneSearchEngine searchEngine;
    private ArrayList<Token> tokens = new ArrayList();
    private AllTokenStreamCollector allTokenStreamCollector = new AllTokenStreamCollector();
    private boolean boostSupport;

    public AllAnalyzer(Analyzer analyzer, InternalResource resource, LuceneSearchEngine searchEngine) {
        this.analyzer = analyzer;
        this.resource = resource;
        this.resourceMapping = resource.resourceKey().getResourceMapping();
        this.searchEngine = searchEngine;
        this.allMapping = this.resourceMapping.getAllMapping();
        this.boostSupport = searchEngine.getSearchEngineFactory().getLuceneSettings().isAllPropertyBoostSupport();
        if (!this.allMapping.isSupported().booleanValue()) {
            return;
        }
        if (!this.allMapping.isExcludeAlias().booleanValue()) {
            this.tokens.add(new Token(resource.getAlias().toLowerCase(), 0, resource.getAlias().length()));
            Property[] properties = resource.getProperties(searchEngine.getSearchEngineFactory().getExtendedAliasProperty());
            if (properties != null) {
                for (Property property : properties) {
                    this.tokens.add(new Token(property.getStringValue().toLowerCase(), 0, property.getStringValue().length()));
                }
            }
        }
        for (Property property : resource.getProperties()) {
            Token t;
            String value;
            Payload payload;
            ResourcePropertyMapping resourcePropertyMapping = ((InternalProperty)property).getPropertyMapping();
            if (resourcePropertyMapping == null) {
                resourcePropertyMapping = this.resourceMapping.getResourcePropertyMapping(property.getName());
            }
            if (resourcePropertyMapping == null) {
                if (!this.allMapping.isIncludePropertiesWithNoMappings().booleanValue() || !property.isIndexed() || property.isTokenized() || searchEngine.getSearchEngineFactory().getPropertyNamingStrategy().isInternal(property.getName()) || property.getName().equals(searchEngine.getSearchEngineFactory().getAliasProperty()) || property.getName().equals(searchEngine.getSearchEngineFactory().getExtendedAliasProperty())) continue;
                payload = null;
                if (this.boostSupport) {
                    if (property.getBoost() != 1.0f) {
                        payload = AllBoostUtils.writeFloat(property.getBoost());
                    } else if (resource.getBoost() != 1.0f) {
                        payload = AllBoostUtils.writeFloat(resource.getBoost());
                    }
                }
                if ((value = property.getStringValue()) == null) continue;
                t = new Token(value, 0, value.length());
                t.setPayload(payload);
                this.tokens.add(t);
                continue;
            }
            if (resourcePropertyMapping.isInternal() || resourcePropertyMapping.getExcludeFromAll() == ResourcePropertyMapping.ExcludeFromAllType.YES || resourcePropertyMapping.getIndex() != Property.Index.UN_TOKENIZED) continue;
            payload = null;
            if (this.boostSupport) {
                if (resourcePropertyMapping.getBoost() != 1.0f) {
                    payload = AllBoostUtils.writeFloat(resourcePropertyMapping.getBoost());
                } else if (resource.getBoost() != 1.0f) {
                    payload = AllBoostUtils.writeFloat(resource.getBoost());
                }
            }
            if ((value = property.getStringValue()) == null) continue;
            if (resourcePropertyMapping.getExcludeFromAll() == ResourcePropertyMapping.ExcludeFromAllType.NO) {
                t = new Token(value, 0, value.length());
                t.setPayload(payload);
                this.tokens.add(t);
                continue;
            }
            if (resourcePropertyMapping.getExcludeFromAll() != ResourcePropertyMapping.ExcludeFromAllType.NO_ANALYZED) continue;
            Analyzer propAnalyzer = resourcePropertyMapping.getAnalyzer() != null ? searchEngine.getSearchEngineFactory().getAnalyzerManager().getAnalyzerMustExist(resourcePropertyMapping.getAnalyzer()) : searchEngine.getSearchEngineFactory().getAnalyzerManager().getAnalyzerByResource(resource);
            TokenStream ts = propAnalyzer.tokenStream(property.getName(), (Reader)new StringReader(value));
            try {
                Token token = ts.next();
                while (token != null) {
                    token.setPayload(payload);
                    this.tokens.add(token);
                    token = ts.next();
                }
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to analyzer " + property, e);
            }
        }
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream retVal = this.analyzer.tokenStream(fieldName, reader);
        return this.wrapTokenStreamIfNeeded(fieldName, retVal);
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        TokenStream retVal = this.analyzer.reusableTokenStream(fieldName, reader);
        return this.wrapTokenStreamIfNeeded(fieldName, retVal);
    }

    public int getPositionIncrementGap(String fieldName) {
        return this.analyzer.getPositionIncrementGap(fieldName);
    }

    public TokenStream createAllTokenStream() {
        return new AllTokenStream();
    }

    private TokenStream wrapTokenStreamIfNeeded(String fieldName, TokenStream retVal) {
        if (!this.allMapping.isSupported().booleanValue()) {
            return retVal;
        }
        ResourcePropertyMapping resourcePropertyMapping = this.resourceMapping.getResourcePropertyMapping(fieldName);
        if (resourcePropertyMapping == null) {
            if (!this.searchEngine.getSearchEngineFactory().getPropertyNamingStrategy().isInternal(fieldName) && this.allMapping.isIncludePropertiesWithNoMappings().booleanValue()) {
                this.allTokenStreamCollector.setTokenStream(retVal);
                this.allTokenStreamCollector.updateMapping(this.resource, resourcePropertyMapping);
                retVal = this.allTokenStreamCollector;
            }
        } else if (resourcePropertyMapping.getExcludeFromAll() != ResourcePropertyMapping.ExcludeFromAllType.YES && !resourcePropertyMapping.isInternal()) {
            this.allTokenStreamCollector.setTokenStream(retVal);
            this.allTokenStreamCollector.updateMapping(this.resource, resourcePropertyMapping);
            retVal = this.allTokenStreamCollector;
        }
        return retVal;
    }

    private class AllTokenStreamCollector
    extends TokenStream {
        private TokenStream tokenStream;
        private Payload payload;
        private Token lastToken;

        public void updateMapping(InternalResource resource, ResourcePropertyMapping resourcePropertyMapping) {
            if (this.lastToken != null && this.payload != null) {
                this.lastToken.setPayload(this.payload);
                this.lastToken = null;
            }
            if (AllAnalyzer.this.boostSupport) {
                this.payload = resourcePropertyMapping != null && resourcePropertyMapping.getBoost() != 1.0f ? AllBoostUtils.writeFloat(resourcePropertyMapping.getBoost()) : (resource.getBoost() != 1.0f ? AllBoostUtils.writeFloat(resource.getBoost()) : null);
            }
        }

        public void setTokenStream(TokenStream tokenStream) {
            this.tokenStream = tokenStream;
        }

        public Token next() throws IOException {
            if (this.lastToken != null && this.payload != null) {
                this.lastToken.setPayload(this.payload);
            }
            this.lastToken = this.tokenStream.next();
            if (this.lastToken != null) {
                AllAnalyzer.this.tokens.add(this.lastToken);
            }
            return this.lastToken;
        }

        public void reset() throws IOException {
            this.tokenStream.reset();
        }

        public void close() throws IOException {
            if (this.lastToken != null && this.payload != null) {
                this.lastToken.setPayload(this.payload);
            }
            this.tokenStream.close();
        }
    }

    private class AllTokenStream
    extends TokenStream {
        private Iterator<Token> tokenIt;
        private int offset = 0;

        private AllTokenStream() {
        }

        public Token next(Token result) throws IOException {
            if (this.tokenIt == null) {
                this.tokenIt = AllAnalyzer.this.tokens.iterator();
            }
            if (this.tokenIt.hasNext()) {
                Token token = this.tokenIt.next();
                int delta = token.endOffset() - token.startOffset();
                token.setStartOffset(this.offset);
                this.offset += delta;
                token.setEndOffset(this.offset);
                return token;
            }
            AllAnalyzer.this.tokens.clear();
            return null;
        }

        public String toString() {
            return "all-stream";
        }
    }
}

