/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.all;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.search.spans.TermSpans;
import org.compass.core.lucene.engine.all.AllBoostUtils;

public class AllBoostingTermQuery
extends SpanTermQuery {
    public AllBoostingTermQuery(Term term) {
        super(term);
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        return new AllBoostingTermWeight(this, searcher);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AllBoostingTermQuery)) {
            return false;
        }
        AllBoostingTermQuery other = (AllBoostingTermQuery)((Object)o);
        return this.getBoost() == other.getBoost() && this.term.equals((Object)other.term);
    }

    protected class AllBoostingTermWeight
    extends SpanWeight
    implements Weight {
        public AllBoostingTermWeight(AllBoostingTermQuery query, Searcher searcher) throws IOException {
            super((SpanQuery)query, searcher);
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            return new BoostingSpanScorer((TermSpans)this.query.getSpans(reader), this, this.similarity, reader.norms(this.query.getField()));
        }

        class BoostingSpanScorer
        extends SpanScorer {
            byte[] payload;
            private TermPositions positions;
            protected float payloadScore;
            private int payloadsSeen;

            public BoostingSpanScorer(TermSpans spans, Weight weight, Similarity similarity, byte[] norms) throws IOException {
                super((Spans)spans, weight, similarity, norms);
                this.payload = new byte[4];
                this.positions = spans.getPositions();
            }

            protected boolean setFreqCurrentDoc() throws IOException {
                if (!this.more) {
                    return false;
                }
                this.doc = this.spans.doc();
                this.freq = 0.0f;
                this.payloadScore = 0.0f;
                this.payloadsSeen = 0;
                Similarity similarity1 = this.getSimilarity();
                while (this.more && this.doc == this.spans.doc()) {
                    int matchLength = this.spans.end() - this.spans.start();
                    this.freq += similarity1.sloppyFreq(matchLength);
                    this.processPayload(similarity1);
                    this.more = this.spans.next();
                }
                return this.more || this.freq != 0.0f;
            }

            protected void processPayload(Similarity similarity) throws IOException {
                if (this.positions.isPayloadAvailable()) {
                    this.payload = this.positions.getPayload(this.payload, 0);
                    this.payloadScore += AllBoostUtils.readFloat(this.payload);
                    ++this.payloadsSeen;
                }
            }

            public float score() throws IOException {
                return super.score() * (this.payloadsSeen > 0 ? this.payloadScore / (float)this.payloadsSeen : 1.0f);
            }

            public Explanation explain(int doc) throws IOException {
                Explanation result = new Explanation();
                Explanation nonPayloadExpl = super.explain(doc);
                result.addDetail(nonPayloadExpl);
                Explanation payloadBoost = new Explanation();
                result.addDetail(payloadBoost);
                float avgPayloadScore = this.payloadsSeen > 0 ? this.payloadScore / (float)this.payloadsSeen : 1.0f;
                payloadBoost.setValue(avgPayloadScore);
                payloadBoost.setDescription("scorePayload(...)");
                result.setValue(nonPayloadExpl.getValue() * avgPayloadScore);
                result.setDescription("btq, product of:");
                return result;
            }
        }
    }
}

