/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.util;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.compass.core.Compass;
import org.compass.core.CompassHits;
import org.compass.core.CompassQuery;
import org.compass.core.CompassQueryFilter;
import org.compass.core.CompassSession;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.impl.DefaultCompassHits;
import org.compass.core.impl.DefaultCompassQuery;
import org.compass.core.impl.DefaultCompassQueryFilter;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.LuceneSearchEngineQueryFilter;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerManager;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.spi.InternalCompass;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.spi.InternalResource;

public abstract class LuceneHelper {
    public static CompassQuery createCompassQuery(CompassSession session, Query query) {
        InternalCompassSession internalCompassSession = (InternalCompassSession)session;
        LuceneSearchEngineQuery searchEngineQuery = new LuceneSearchEngineQuery((LuceneSearchEngine)internalCompassSession.getSearchEngine(), query);
        return new DefaultCompassQuery(searchEngineQuery, internalCompassSession);
    }

    public static LuceneSearchEngineQuery getLuceneSearchEngineQuery(CompassQuery query) {
        return (LuceneSearchEngineQuery)((DefaultCompassQuery)query).getSearchEngineQuery();
    }

    public static CompassQueryFilter createCompassQueryFilter(CompassSession session, Filter filter) {
        LuceneSearchEngineQueryFilter searchEngineQueryFilter = new LuceneSearchEngineQueryFilter(filter);
        return new DefaultCompassQueryFilter(searchEngineQueryFilter);
    }

    public static LuceneSearchEngineQueryFilter getLuceneSearchEngineQueryFilter(CompassQueryFilter filter) {
        return (LuceneSearchEngineQueryFilter)((DefaultCompassQueryFilter)filter).getFilter();
    }

    public static LuceneSearchEngineHits getLuceneSearchEngineHits(CompassHits hits) {
        return (LuceneSearchEngineHits)((DefaultCompassHits)hits).getSearchEngineHits();
    }

    public static LuceneAnalyzerManager getLuceneAnalyzerManager(Compass compass) {
        return ((LuceneSearchEngineFactory)((InternalCompass)compass).getSearchEngineFactory()).getAnalyzerManager();
    }

    public static LuceneSearchEngineInternalSearch getLuceneInternalSearch(CompassSession session) {
        return (LuceneSearchEngineInternalSearch)((InternalCompassSession)session).getSearchEngine().internalSearch(null, null);
    }

    public static LuceneSearchEngineInternalSearch getLuceneInternalSearch(CompassSession session, String[] subIndexes, String[] aliases) {
        return (LuceneSearchEngineInternalSearch)((InternalCompassSession)session).getSearchEngine().internalSearch(subIndexes, aliases);
    }

    public static Document getDocument(Resource resource) {
        return ((LuceneResource)resource).getDocument();
    }

    public static TermFreqVector[] getTermFreqVectors(CompassSession session, Resource resource) throws SearchEngineException {
        resource = ((InternalCompassSession)session).getResourceByIdResource(resource);
        String subIndex = ((InternalResource)resource).getSubIndex();
        LuceneSearchEngineInternalSearch internalSearch = LuceneHelper.getLuceneInternalSearch(session, new String[]{subIndex}, null);
        try {
            return internalSearch.getReader().getTermFreqVectors(((LuceneResource)resource).getDocNum());
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to fetch term info for resource [" + resource + "]", e);
        }
    }

    public static TermFreqVector getTermFreqVector(CompassSession session, Resource resource, String propertyName) throws SearchEngineException {
        resource = ((InternalCompassSession)session).getResourceByIdResource(resource);
        String subIndex = ((InternalResource)resource).getSubIndex();
        LuceneSearchEngineInternalSearch internalSearch = LuceneHelper.getLuceneInternalSearch(session, new String[]{subIndex}, null);
        try {
            return internalSearch.getReader().getTermFreqVector(((LuceneResource)resource).getDocNum(), propertyName);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to fetch term info for resource [" + resource + "]", e);
        }
    }

    public static Directory getDirectory(Compass compass, String subIndex) {
        return ((LuceneSearchEngineIndexManager)((InternalCompass)compass).getSearchEngineIndexManager()).getStore().openDirectory(subIndex);
    }
}

