/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.coherence;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.filter.AndFilter;
import com.tangosol.util.filter.EqualsFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.compass.needle.coherence.CoherenceDirectory;
import org.compass.needle.coherence.CoherenceIndexInput;
import org.compass.needle.coherence.CoherenceMemIndexOutput;
import org.compass.needle.coherence.DefaultCoherenceLockFactory;
import org.compass.needle.coherence.FileBucketKey;
import org.compass.needle.coherence.FileBucketValue;
import org.compass.needle.coherence.FileHeaderKey;
import org.compass.needle.coherence.FileHeaderValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataGridCoherenceDirectory
extends CoherenceDirectory {
    public static final int DEFAULT_BUCKET_SIZE = 20480;
    public static final int DEFAULT_FLUSH_RATE = 50;
    private String indexName;
    private NamedCache cache;
    private int bucketSize = 20480;
    private int flushRate = 50;
    private boolean closeCache = false;
    private ValueExtractor indexNameKeyExtractor = new KeyExtractor("getIndexName");
    private ValueExtractor fileNameKeyExtractor = new KeyExtractor("getFileName");
    private ValueExtractor typeKeyExtractor = new KeyExtractor("getType");
    private Filter indexNameEqualsFilter;
    private Filter listFilter;
    private transient Map<String, IndexOutput> onGoingIndexOutputs = new ConcurrentHashMap<String, IndexOutput>();

    public DataGridCoherenceDirectory(String cacheName) {
        this(cacheName, cacheName, 20480);
    }

    public DataGridCoherenceDirectory(String cacheName, String indexName) {
        this(cacheName, indexName, 20480);
    }

    public DataGridCoherenceDirectory(String cacheName, String indexName, int bucketSize) {
        this(CacheFactory.getCache((String)cacheName), indexName, bucketSize);
        this.closeCache = true;
    }

    public DataGridCoherenceDirectory(NamedCache cache, String indexName) {
        this(cache, indexName, 20480);
    }

    public DataGridCoherenceDirectory(NamedCache cache, String indexName, int bucketSize) {
        this(cache, indexName, bucketSize, 50);
    }

    public DataGridCoherenceDirectory(NamedCache cache, String indexName, int bucketSize, int flushRate) {
        this.indexName = indexName;
        this.cache = cache;
        this.bucketSize = bucketSize;
        this.flushRate = flushRate;
        this.closeCache = false;
        cache.addIndex(this.indexNameKeyExtractor, false, null);
        cache.addIndex(this.typeKeyExtractor, false, null);
        cache.addIndex(this.fileNameKeyExtractor, false, null);
        this.indexNameEqualsFilter = new EqualsFilter(this.getIndexNameKeyExtractor(), (Object)this.getIndexName());
        this.listFilter = new AndFilter(this.indexNameEqualsFilter, (Filter)new EqualsFilter(this.getTypeKeyExtractor(), (Object)0));
        this.setLockFactory(new DefaultCoherenceLockFactory(this.getCache(), this.getIndexName()));
        this.doInit();
    }

    protected void doInit() {
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public NamedCache getCache() {
        return this.cache;
    }

    @Override
    public int getBucketSize() {
        return this.bucketSize;
    }

    @Override
    public int getFlushRate() {
        return this.flushRate;
    }

    @Override
    public Map<String, IndexOutput> getOnGoingIndexOutputs() {
        return this.onGoingIndexOutputs;
    }

    public ValueExtractor getIndexNameKeyExtractor() {
        return this.indexNameKeyExtractor;
    }

    public ValueExtractor getTypeKeyExtractor() {
        return this.typeKeyExtractor;
    }

    public ValueExtractor getFileNameKeyExtractor() {
        return this.fileNameKeyExtractor;
    }

    public Filter getIndexNameEqualsFilter() {
        return this.indexNameEqualsFilter;
    }

    public boolean fileExists(String name) throws IOException {
        if (this.onGoingIndexOutputs.containsKey(name)) {
            return true;
        }
        return this.cache.containsKey((Object)new FileHeaderKey(this.indexName, name));
    }

    public long fileModified(String name) throws IOException {
        FileHeaderValue fileHeaderValue = (FileHeaderValue)this.cache.get((Object)new FileHeaderKey(this.indexName, name));
        if (fileHeaderValue != null) {
            return fileHeaderValue.getLastModified();
        }
        return 0L;
    }

    public void touchFile(String name) throws IOException {
        FileHeaderKey fileHeaderKey = new FileHeaderKey(this.indexName, name);
        FileHeaderValue fileHeaderValue = (FileHeaderValue)this.cache.get((Object)fileHeaderKey);
        if (fileHeaderValue != null) {
            fileHeaderValue.touch();
        } else {
            fileHeaderValue = new FileHeaderValue(System.currentTimeMillis(), 0L);
        }
        this.cache.put((Object)fileHeaderKey, (Object)fileHeaderValue);
    }

    public void deleteFile(String name) throws IOException {
        FileBucketValue fileBucketValue;
        this.cache.remove((Object)new FileHeaderKey(this.indexName, name));
        int bucketIndex = 0;
        while ((fileBucketValue = (FileBucketValue)this.cache.remove((Object)new FileBucketKey(this.indexName, name, bucketIndex++))) != null) {
        }
    }

    public void renameFile(String from, String to) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long fileLength(String name) throws IOException {
        FileHeaderValue fileHeaderValue = (FileHeaderValue)this.cache.get((Object)new FileHeaderKey(this.indexName, name));
        if (fileHeaderValue != null) {
            return fileHeaderValue.getSize();
        }
        return 0L;
    }

    public String[] list() throws IOException {
        Set fileHeaders = this.getCache().keySet(this.listFilter);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (Object key : fileHeaders) {
            fileNames.add(((FileHeaderKey)key).getFileName());
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    @Override
    public void deleteContent() {
        Set keys = this.getCache().keySet(this.indexNameEqualsFilter);
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            this.getCache().remove(it.next());
        }
    }

    public IndexOutput createOutput(String name) throws IOException {
        CoherenceMemIndexOutput indexOutput = new CoherenceMemIndexOutput(this, name);
        this.onGoingIndexOutputs.put(name, indexOutput);
        return indexOutput;
    }

    public IndexInput openInput(String name) throws IOException {
        FileHeaderKey fileHeaderKey = new FileHeaderKey(this.indexName, name);
        FileHeaderValue fileHeaderValue = (FileHeaderValue)this.cache.get((Object)fileHeaderKey);
        if (fileHeaderValue == null) {
            throw new IOException("Failed to find file " + fileHeaderKey);
        }
        return new CoherenceIndexInput(this, fileHeaderKey, fileHeaderValue);
    }

    public void close() throws IOException {
        if (this.closeCache) {
            this.cache.release();
        }
    }
}

