/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.terracotta;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.compass.needle.terracotta.TerracottaFile;
import org.compass.needle.terracotta.TerracottaIndexInput;
import org.compass.needle.terracotta.TerracottaIndexOutput;
import org.compass.needle.terracotta.TerracottaLockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerracottaDirectory
extends Directory {
    public static final transient int DEFAULT_BUFFER_SIZE = 4096;
    public static final transient int DEFAULT_FLUSH_RATE = 10;
    private static final transient Log log = LogFactory.getLog(TerracottaDirectory.class);
    private Map<String, TerracottaFile> fileMap = new ConcurrentHashMap<String, TerracottaFile>();
    private final int bufferSize;
    private final int flushRate;
    private transient Map<String, Boolean> onGoingIndexOutputs = new ConcurrentHashMap<String, Boolean>();

    public TerracottaDirectory() {
        this(4096, 10);
    }

    public TerracottaDirectory(int bufferSize, int flushRate) {
        this.bufferSize = bufferSize;
        this.flushRate = flushRate;
        try {
            Class.forName("com.tc.object.bytecode.ManagerUtil", true, Thread.currentThread().getContextClassLoader());
            this.setLockFactory(new TerracottaLockFactory());
        }
        catch (ClassNotFoundException e) {
            this.setLockFactory(new TerracottaLockFactory());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using Terracota lock factory [" + this.getLockFactory() + "]"));
        }
    }

    public TerracottaDirectory(Directory dir) throws IOException {
        this(dir, false);
    }

    private TerracottaDirectory(Directory dir, boolean closeDir) throws IOException {
        this(4096, 10);
        Directory.copy((Directory)dir, (Directory)this, (boolean)closeDir);
    }

    public TerracottaDirectory(File dir) throws IOException {
        this((Directory)FSDirectory.getDirectory((File)dir), true);
    }

    public TerracottaDirectory(String dir) throws IOException {
        this((Directory)FSDirectory.getDirectory((String)dir), true);
    }

    public final String[] list() {
        Set<String> fileNames = this.fileMap.keySet();
        return fileNames.toArray(new String[0]);
    }

    public final boolean fileExists(String name) {
        if (this.onGoingIndexOutputs.containsKey(name)) {
            return true;
        }
        return this.fileMap.containsKey(name);
    }

    public final long fileModified(String name) throws IOException {
        TerracottaFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLastModified();
    }

    public void touchFile(String name) throws IOException {
        long ts2;
        TerracottaFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        long ts1 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (ts1 == (ts2 = System.currentTimeMillis()));
        file.setLastModified(ts2);
    }

    public final long fileLength(String name) throws IOException {
        TerracottaFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLength();
    }

    public void deleteFile(String name) throws IOException {
        TerracottaFile file = this.fileMap.remove(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
    }

    public final void renameFile(String from, String to) throws IOException {
        TerracottaFile fromFile = this.fileMap.get(from);
        if (fromFile == null) {
            throw new FileNotFoundException(from);
        }
        this.fileMap.remove(from);
        this.fileMap.put(to, fromFile);
    }

    public IndexOutput createOutput(String name) throws IOException {
        TerracottaIndexOutput indexOutput = new TerracottaIndexOutput(this, name);
        this.onGoingIndexOutputs.put(name, Boolean.TRUE);
        return indexOutput;
    }

    public IndexInput openInput(String name) throws IOException {
        TerracottaFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return new TerracottaIndexInput(file, this.bufferSize);
    }

    void addFile(String name, TerracottaFile file) {
        this.fileMap.put(name, file);
    }

    int getBufferSize() {
        return this.bufferSize;
    }

    int getFlushRate() {
        return this.flushRate;
    }

    Map<String, Boolean> getOnGoingIndexOutputs() {
        return this.onGoingIndexOutputs;
    }

    public void close() {
    }
}

