/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.spring;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.crsh.plugin.Embedded;
import org.crsh.plugin.PluginDiscovery;
import org.crsh.spring.SpringMap;
import org.crsh.spring.SpringPluginDiscovery;
import org.crsh.util.Utils;
import org.crsh.vfs.spi.FSMountFactory;
import org.crsh.vfs.spi.file.FileMountFactory;
import org.crsh.vfs.spi.url.ClassPathMountFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;

public class SpringBootstrap
extends Embedded
implements BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean,
DisposableBean {
    private ClassLoader loader;
    private BeanFactory factory;
    protected final HashMap<String, FSMountFactory<?>> drivers = new HashMap();
    private String cmdMountPointConfig;
    private String confMountPointConfig;

    public String getCmdMountPointConfig() {
        return this.cmdMountPointConfig;
    }

    public void setCmdMountPointConfig(String cmdMountPointConfig) {
        this.cmdMountPointConfig = cmdMountPointConfig;
    }

    public String getConfMountPointConfig() {
        return this.confMountPointConfig;
    }

    public void setConfMountPointConfig(String confMountPointConfig) {
        this.confMountPointConfig = confMountPointConfig;
    }

    public void setBeanClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        this.factory = factory;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.drivers.put("classpath", (FSMountFactory<?>)new ClassPathMountFactory(this.loader));
            this.drivers.put("file", (FSMountFactory<?>)new FileMountFactory(Utils.getCurrentDirectory()));
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Coult not initialize classpath driver", e);
            return;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("factory", this.factory);
        if (this.factory instanceof ListableBeanFactory) {
            ListableBeanFactory listable = (ListableBeanFactory)this.factory;
            attributes.put("beans", (Object)new SpringMap(listable));
        }
        SpringPluginDiscovery discovery = new SpringPluginDiscovery(this.loader, this.factory);
        this.start(Collections.unmodifiableMap(attributes), (PluginDiscovery)discovery, this.loader);
    }

    protected Map<String, FSMountFactory<?>> getMountFactories() {
        return this.drivers;
    }

    protected String resolveConfMountPointConfig() {
        return this.confMountPointConfig != null ? this.confMountPointConfig : this.getDefaultConfMountPointConfig();
    }

    protected String resolveCmdMountPointConfig() {
        return this.cmdMountPointConfig != null ? this.cmdMountPointConfig : this.getDefaultCmdMountPointConfig();
    }

    protected String getDefaultCmdMountPointConfig() {
        return "classpath:/crash/commands/";
    }

    protected String getDefaultConfMountPointConfig() {
        return "classpath:/crash/";
    }

    public void destroy() throws Exception {
        this.stop();
    }
}

