/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.complexscripts.fonts;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.fonts.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphClassTable;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphCoverageTable;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphMappingTable;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphPositioningTable;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphSubtable;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphTable;
import org.docx4j.fonts.fop.complexscripts.scripts.ScriptProcessor;
import org.docx4j.fonts.fop.fonts.truetype.FontFileReader;
import org.docx4j.fonts.fop.fonts.truetype.OFDirTabEntry;
import org.docx4j.fonts.fop.fonts.truetype.OFTableName;
import org.docx4j.fonts.fop.fonts.truetype.OpenFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OTFAdvancedTypographicTableReader {
    private static Logger log = LoggerFactory.getLogger(OTFAdvancedTypographicTableReader.class);
    private OpenFont otf;
    private FontFileReader in;
    private GlyphDefinitionTable gdef;
    private GlyphSubstitutionTable gsub;
    private GlyphPositioningTable gpos;
    private transient Map<String, Object> seScripts;
    private transient Map<String, Object> seLanguages;
    private transient Map<String, Object> seFeatures;
    private transient GlyphMappingTable seMapping;
    private transient List seEntries;
    private transient List seSubtables;
    private Map<String, ScriptProcessor> processors = new HashMap<String, ScriptProcessor>();
    private static String defaultTag = "dflt";

    public OTFAdvancedTypographicTableReader(OpenFont otf, FontFileReader in) {
        assert (otf != null);
        assert (in != null);
        this.otf = otf;
        this.in = in;
    }

    public void readAll() throws AdvancedTypographicTableFormatException {
        try {
            this.readGDEF();
            this.readGSUB();
            this.readGPOS();
        }
        catch (AdvancedTypographicTableFormatException e) {
            this.resetATStateAll();
            throw e;
        }
        catch (IOException e) {
            this.resetATStateAll();
            throw new AdvancedTypographicTableFormatException(e.getMessage(), e);
        }
        finally {
            this.resetATState();
        }
    }

    public boolean hasAdvancedTable() {
        return this.gdef != null || this.gsub != null || this.gpos != null;
    }

    public GlyphDefinitionTable getGDEF() {
        return this.gdef;
    }

    public GlyphSubstitutionTable getGSUB() {
        return this.gsub;
    }

    public GlyphPositioningTable getGPOS() {
        return this.gpos;
    }

    private void readLangSysTable(OFTableName tableTag, long langSysTable, String langSysTag) throws IOException {
        this.in.seekSet(langSysTable);
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " lang sys table: " + langSysTag);
        }
        int lo = this.in.readTTFUShort();
        int rf = this.in.readTTFUShort();
        String rfi = rf != 65535 ? "f" + rf : null;
        int nf = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " lang sys table reorder table: " + lo);
            log.debug(tableTag + " lang sys table required feature index: " + rf);
            log.debug(tableTag + " lang sys table non-required feature count: " + nf);
        }
        ArrayList<CallSite> fl = new ArrayList<CallSite>();
        for (int i = 0; i < nf; ++i) {
            int fi = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug(tableTag + " lang sys table non-required feature index: " + fi);
            }
            fl.add((CallSite)((Object)("f" + fi)));
        }
        if (this.seLanguages == null) {
            this.seLanguages = new LinkedHashMap<String, Object>();
        }
        this.seLanguages.put(langSysTag, new Object[]{rfi, fl});
    }

    private void readScriptTable(OFTableName tableTag, long scriptTable, String scriptTag) throws IOException {
        this.in.seekSet(scriptTable);
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " script table: " + scriptTag);
        }
        int dl = this.in.readTTFUShort();
        String dt = defaultTag;
        if (dl > 0 && log.isDebugEnabled()) {
            log.debug(tableTag + " default lang sys tag: " + dt);
            log.debug(tableTag + " default lang sys table offset: " + dl);
        }
        int nl = this.in.readTTFUShort();
        ArrayList<String> ll = new ArrayList<String>();
        if (nl > 0) {
            int i;
            String[] lta = new String[nl];
            int[] loa = new int[nl];
            int n = nl;
            for (i = 0; i < n; ++i) {
                String lt = this.in.readTTFString(4);
                int lo = this.in.readTTFUShort();
                if (log.isDebugEnabled()) {
                    log.debug(tableTag + " lang sys tag: " + lt);
                    log.debug(tableTag + " lang sys table offset: " + lo);
                }
                lta[i] = lt;
                loa[i] = lo;
                if (dl == lo) {
                    dl = 0;
                    dt = lt;
                }
                ll.add(lt);
            }
            n = nl;
            for (i = 0; i < n; ++i) {
                this.readLangSysTable(tableTag, scriptTable + (long)loa[i], lta[i]);
            }
        }
        if (dl > 0) {
            this.readLangSysTable(tableTag, scriptTable + (long)dl, dt);
        } else if (dt != null && log.isDebugEnabled()) {
            log.debug(tableTag + " lang sys default: " + dt);
        }
        this.seScripts.put(scriptTag, new Object[]{dt, ll, this.seLanguages});
        this.seLanguages = null;
    }

    private void readScriptList(OFTableName tableTag, long scriptList) throws IOException {
        this.in.seekSet(scriptList);
        int ns = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " script list record count: " + ns);
        }
        if (ns > 0) {
            int i;
            String[] sta = new String[ns];
            int[] soa = new int[ns];
            int n = ns;
            for (i = 0; i < n; ++i) {
                String st = this.in.readTTFString(4);
                int so = this.in.readTTFUShort();
                if (log.isDebugEnabled()) {
                    log.debug(tableTag + " script tag: " + st);
                    log.debug(tableTag + " script table offset: " + so);
                }
                sta[i] = st;
                soa[i] = so;
            }
            n = ns;
            for (i = 0; i < n; ++i) {
                this.seLanguages = null;
                this.readScriptTable(tableTag, scriptList + (long)soa[i], sta[i]);
            }
        }
    }

    private void readFeatureTable(OFTableName tableTag, long featureTable, String featureTag, int featureIndex) throws IOException {
        this.in.seekSet(featureTable);
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " feature table: " + featureTag);
        }
        int po = this.in.readTTFUShort();
        int nl = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " feature table parameters offset: " + po);
            log.debug(tableTag + " feature table lookup list index count: " + nl);
        }
        ArrayList<CallSite> lul = new ArrayList<CallSite>();
        for (int i = 0; i < nl; ++i) {
            int li = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug(tableTag + " feature table lookup index: " + li);
            }
            lul.add((CallSite)((Object)("lu" + li)));
        }
        this.seFeatures.put("f" + featureIndex, new Object[]{featureTag, lul});
    }

    private void readFeatureList(OFTableName tableTag, long featureList) throws IOException {
        this.in.seekSet(featureList);
        int nf = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " feature list record count: " + nf);
        }
        if (nf > 0) {
            int i;
            String[] fta = new String[nf];
            int[] foa = new int[nf];
            int n = nf;
            for (i = 0; i < n; ++i) {
                String ft = this.in.readTTFString(4);
                int fo = this.in.readTTFUShort();
                if (log.isDebugEnabled()) {
                    log.debug(tableTag + " feature tag: " + ft);
                    log.debug(tableTag + " feature table offset: " + fo);
                }
                fta[i] = ft;
                foa[i] = fo;
            }
            n = nf;
            for (i = 0; i < n; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug(tableTag + " feature index: " + i);
                }
                this.readFeatureTable(tableTag, featureList + (long)foa[i], fta[i], i);
            }
        }
    }

    private GlyphCoverageTable readCoverageTableFormat1(String label, long tableOffset, int coverageFormat) throws IOException {
        ArrayList<Integer> entries = new ArrayList<Integer>();
        this.in.seekSet(tableOffset);
        this.in.skip(2L);
        int ng = this.in.readTTFUShort();
        int[] ga = new int[ng];
        int n = ng;
        for (int i = 0; i < n; ++i) {
            int g;
            ga[i] = g = this.in.readTTFUShort();
            entries.add(g);
        }
        if (log.isDebugEnabled()) {
            log.debug(label + " glyphs: " + this.toString(ga));
        }
        return GlyphCoverageTable.createCoverageTable(entries);
    }

    private GlyphCoverageTable readCoverageTableFormat2(String label, long tableOffset, int coverageFormat) throws IOException {
        ArrayList<GlyphMappingTable.MappingRange> entries = new ArrayList<GlyphMappingTable.MappingRange>();
        this.in.seekSet(tableOffset);
        this.in.skip(2L);
        int nr = this.in.readTTFUShort();
        int n = nr;
        for (int i = 0; i < n; ++i) {
            int s = this.in.readTTFUShort();
            int e = this.in.readTTFUShort();
            int m = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug(label + " range[" + i + "]: [" + s + "," + e + "]: " + m);
            }
            entries.add(new GlyphMappingTable.MappingRange(s, e, m));
        }
        return GlyphCoverageTable.createCoverageTable(entries);
    }

    private GlyphCoverageTable readCoverageTable(String label, long tableOffset) throws IOException {
        GlyphCoverageTable gct;
        long cp = this.in.getCurrentPos();
        this.in.seekSet(tableOffset);
        int cf = this.in.readTTFUShort();
        if (cf == 1) {
            gct = this.readCoverageTableFormat1(label, tableOffset, cf);
        } else if (cf == 2) {
            gct = this.readCoverageTableFormat2(label, tableOffset, cf);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported coverage table format: " + cf);
        }
        this.in.seekSet(cp);
        return gct;
    }

    private GlyphClassTable readClassDefTableFormat1(String label, long tableOffset, int classFormat) throws IOException {
        ArrayList<Integer> entries = new ArrayList<Integer>();
        this.in.seekSet(tableOffset);
        this.in.skip(2L);
        int sg = this.in.readTTFUShort();
        entries.add(sg);
        int ng = this.in.readTTFUShort();
        int[] ca = new int[ng];
        int n = ng;
        for (int i = 0; i < n; ++i) {
            int gc;
            ca[i] = gc = this.in.readTTFUShort();
            entries.add(gc);
        }
        if (log.isDebugEnabled()) {
            log.debug(label + " glyph classes: " + this.toString(ca));
        }
        return GlyphClassTable.createClassTable(entries);
    }

    private GlyphClassTable readClassDefTableFormat2(String label, long tableOffset, int classFormat) throws IOException {
        ArrayList<GlyphMappingTable.MappingRange> entries = new ArrayList<GlyphMappingTable.MappingRange>();
        this.in.seekSet(tableOffset);
        this.in.skip(2L);
        int nr = this.in.readTTFUShort();
        int n = nr;
        for (int i = 0; i < n; ++i) {
            int s = this.in.readTTFUShort();
            int e = this.in.readTTFUShort();
            int m = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug(label + " range[" + i + "]: [" + s + "," + e + "]: " + m);
            }
            entries.add(new GlyphMappingTable.MappingRange(s, e, m));
        }
        return GlyphClassTable.createClassTable(entries);
    }

    private GlyphClassTable readClassDefTable(String label, long tableOffset) throws IOException {
        GlyphClassTable gct;
        long cp = this.in.getCurrentPos();
        this.in.seekSet(tableOffset);
        int cf = this.in.readTTFUShort();
        if (cf == 1) {
            gct = this.readClassDefTableFormat1(label, tableOffset, cf);
        } else if (cf == 2) {
            gct = this.readClassDefTableFormat2(label, tableOffset, cf);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported class definition table format: " + cf);
        }
        this.in.seekSet(cp);
        return gct;
    }

    private void readSingleSubTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GSUB";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        short dg = this.in.readTTFShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " single substitution subtable format: " + subtableFormat + " (delta)");
            log.debug(tableTag + " single substitution coverage table offset: " + co);
            log.debug(tableTag + " single substitution delta: " + dg);
        }
        this.seMapping = this.readCoverageTable(tableTag + " single substitution coverage", subtableOffset + (long)co);
        this.seEntries.add(Integer.valueOf(dg));
    }

    private void readSingleSubTableFormat2(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GSUB";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int ng = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " single substitution subtable format: " + subtableFormat + " (mapped)");
            log.debug(tableTag + " single substitution coverage table offset: " + co);
            log.debug(tableTag + " single substitution glyph count: " + ng);
        }
        this.seMapping = this.readCoverageTable(tableTag + " single substitution coverage", subtableOffset + (long)co);
        int n = ng;
        for (int i = 0; i < n; ++i) {
            int gs = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug(tableTag + " single substitution glyph[" + i + "]: " + gs);
            }
            this.seEntries.add(gs);
        }
    }

    private int readSingleSubTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf == 1) {
            this.readSingleSubTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        } else if (sf == 2) {
            this.readSingleSubTableFormat2(lookupType, lookupFlags, subtableOffset, sf);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported single substitution subtable format: " + sf);
        }
        return sf;
    }

    private void readMultipleSubTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GSUB";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int ns = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " multiple substitution subtable format: " + subtableFormat + " (mapped)");
            log.debug(tableTag + " multiple substitution coverage table offset: " + co);
            log.debug(tableTag + " multiple substitution sequence count: " + ns);
        }
        this.seMapping = this.readCoverageTable(tableTag + " multiple substitution coverage", subtableOffset + (long)co);
        int[] soa = new int[ns];
        int n = ns;
        for (int i = 0; i < n; ++i) {
            soa[i] = this.in.readTTFUShort();
        }
        int[][] gsa = new int[ns][];
        int n2 = ns;
        for (int i = 0; i < n2; ++i) {
            int[] ga;
            int so = soa[i];
            if (so > 0) {
                this.in.seekSet(subtableOffset + (long)so);
                int ng = this.in.readTTFUShort();
                ga = new int[ng];
                for (int j = 0; j < ng; ++j) {
                    ga[j] = this.in.readTTFUShort();
                }
            } else {
                ga = null;
            }
            if (log.isDebugEnabled()) {
                log.debug(tableTag + " multiple substitution sequence[" + i + "]: " + this.toString(ga));
            }
            gsa[i] = ga;
        }
        this.seEntries.add(gsa);
    }

    private int readMultipleSubTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported multiple substitution subtable format: " + sf);
        }
        this.readMultipleSubTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        return sf;
    }

    private void readAlternateSubTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        int i;
        String tableTag = "GSUB";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int ns = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " alternate substitution subtable format: " + subtableFormat + " (mapped)");
            log.debug(tableTag + " alternate substitution coverage table offset: " + co);
            log.debug(tableTag + " alternate substitution alternate set count: " + ns);
        }
        this.seMapping = this.readCoverageTable(tableTag + " alternate substitution coverage", subtableOffset + (long)co);
        int[] soa = new int[ns];
        int n = ns;
        for (i = 0; i < n; ++i) {
            soa[i] = this.in.readTTFUShort();
        }
        n = ns;
        for (i = 0; i < n; ++i) {
            int so = soa[i];
            this.in.seekSet(subtableOffset + (long)so);
            int ng = this.in.readTTFUShort();
            int[] ga = new int[ng];
            for (int j = 0; j < ng; ++j) {
                int gs;
                ga[j] = gs = this.in.readTTFUShort();
            }
            if (log.isDebugEnabled()) {
                log.debug(tableTag + " alternate substitution alternate set[" + i + "]: " + this.toString(ga));
            }
            this.seEntries.add(ga);
        }
    }

    private int readAlternateSubTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported alternate substitution subtable format: " + sf);
        }
        this.readAlternateSubTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        return sf;
    }

    private void readLigatureSubTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        int i;
        String tableTag = "GSUB";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int ns = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " ligature substitution subtable format: " + subtableFormat + " (mapped)");
            log.debug(tableTag + " ligature substitution coverage table offset: " + co);
            log.debug(tableTag + " ligature substitution ligature set count: " + ns);
        }
        this.seMapping = this.readCoverageTable(tableTag + " ligature substitution coverage", subtableOffset + (long)co);
        int[] soa = new int[ns];
        int n = ns;
        for (i = 0; i < n; ++i) {
            soa[i] = this.in.readTTFUShort();
        }
        n = ns;
        for (i = 0; i < n; ++i) {
            int so = soa[i];
            this.in.seekSet(subtableOffset + (long)so);
            int nl = this.in.readTTFUShort();
            int[] loa = new int[nl];
            for (int j = 0; j < nl; ++j) {
                loa[j] = this.in.readTTFUShort();
            }
            ArrayList<GlyphSubstitutionTable.Ligature> ligs = new ArrayList<GlyphSubstitutionTable.Ligature>();
            for (int j = 0; j < nl; ++j) {
                int lo = loa[j];
                this.in.seekSet(subtableOffset + (long)so + (long)lo);
                int lg = this.in.readTTFUShort();
                int nc = this.in.readTTFUShort();
                int[] ca = new int[nc - 1];
                for (int k = 0; k < nc - 1; ++k) {
                    ca[k] = this.in.readTTFUShort();
                }
                if (log.isDebugEnabled()) {
                    log.debug(tableTag + " ligature substitution ligature set[" + i + "]: ligature(" + lg + "), components: " + this.toString(ca));
                }
                ligs.add(new GlyphSubstitutionTable.Ligature(lg, ca));
            }
            this.seEntries.add(new GlyphSubstitutionTable.LigatureSet(ligs));
        }
    }

    private int readLigatureSubTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported ligature substitution subtable format: " + sf);
        }
        this.readLigatureSubTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        return sf;
    }

    private GlyphTable.RuleLookup[] readRuleLookups(int numLookups, String header) throws IOException {
        GlyphTable.RuleLookup[] la = new GlyphTable.RuleLookup[numLookups];
        int n = numLookups;
        for (int i = 0; i < n; ++i) {
            int sequenceIndex = this.in.readTTFUShort();
            int lookupIndex = this.in.readTTFUShort();
            la[i] = new GlyphTable.RuleLookup(sequenceIndex, lookupIndex);
            if (!log.isDebugEnabled() || header == null) continue;
            log.debug(header + "lookup[" + i + "]: " + la[i]);
        }
        return la;
    }

    private void readContextualSubTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        int i;
        String tableTag = "GSUB";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int nrs = this.in.readTTFUShort();
        int[] rsoa = new int[nrs];
        for (i = 0; i < nrs; ++i) {
            rsoa[i] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " contextual substitution format: " + subtableFormat + " (glyphs)");
            log.debug(tableTag + " contextual substitution coverage table offset: " + co);
            log.debug(tableTag + " contextual substitution rule set count: " + nrs);
            for (i = 0; i < nrs; ++i) {
                log.debug(tableTag + " contextual substitution rule set offset[" + i + "]: " + rsoa[i]);
            }
        }
        GlyphCoverageTable ct = co > 0 ? this.readCoverageTable(tableTag + " contextual substitution coverage", subtableOffset + (long)co) : null;
        GlyphTable.RuleSet[] rsa = new GlyphTable.RuleSet[nrs];
        String header = null;
        for (int i2 = 0; i2 < nrs; ++i2) {
            GlyphTable.HomogeneousRuleSet rs;
            int rso = rsoa[i2];
            if (rso > 0) {
                int j;
                this.in.seekSet(subtableOffset + (long)rso);
                int nr = this.in.readTTFUShort();
                int[] roa = new int[nr];
                GlyphTable.Rule[] ra = new GlyphTable.Rule[nr];
                for (j = 0; j < nr; ++j) {
                    roa[j] = this.in.readTTFUShort();
                }
                for (j = 0; j < nr; ++j) {
                    GlyphTable.GlyphSequenceRule r;
                    int ro = roa[j];
                    if (ro > 0) {
                        this.in.seekSet(subtableOffset + (long)rso + (long)ro);
                        int ng = this.in.readTTFUShort();
                        int nl = this.in.readTTFUShort();
                        int[] glyphs = new int[ng - 1];
                        int nk = glyphs.length;
                        for (int k = 0; k < nk; ++k) {
                            glyphs[k] = this.in.readTTFUShort();
                        }
                        if (log.isDebugEnabled()) {
                            header = tableTag + " contextual substitution lookups @rule[" + i2 + "][" + j + "]: ";
                        }
                        GlyphTable.RuleLookup[] lookups = this.readRuleLookups(nl, header);
                        r = new GlyphTable.GlyphSequenceRule(lookups, ng, glyphs);
                    } else {
                        r = null;
                    }
                    ra[j] = r;
                }
                rs = new GlyphTable.HomogeneousRuleSet(ra);
            } else {
                rs = null;
            }
            rsa[i2] = rs;
        }
        this.seMapping = ct;
        this.seEntries.add(rsa);
    }

    private void readContextualSubTableFormat2(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        int i;
        String tableTag = "GSUB";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int cdo = this.in.readTTFUShort();
        int ngc = this.in.readTTFUShort();
        int[] csoa = new int[ngc];
        for (i = 0; i < ngc; ++i) {
            csoa[i] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " contextual substitution format: " + subtableFormat + " (glyph classes)");
            log.debug(tableTag + " contextual substitution coverage table offset: " + co);
            log.debug(tableTag + " contextual substitution class set count: " + ngc);
            for (i = 0; i < ngc; ++i) {
                log.debug(tableTag + " contextual substitution class set offset[" + i + "]: " + csoa[i]);
            }
        }
        GlyphCoverageTable ct = co > 0 ? this.readCoverageTable(tableTag + " contextual substitution coverage", subtableOffset + (long)co) : null;
        GlyphClassTable cdt = cdo > 0 ? this.readClassDefTable(tableTag + " contextual substitution class definition", subtableOffset + (long)cdo) : null;
        GlyphTable.RuleSet[] rsa = new GlyphTable.RuleSet[ngc];
        String header = null;
        for (int i2 = 0; i2 < ngc; ++i2) {
            GlyphTable.HomogeneousRuleSet rs;
            int cso = csoa[i2];
            if (cso > 0) {
                int j;
                this.in.seekSet(subtableOffset + (long)cso);
                int nr = this.in.readTTFUShort();
                int[] roa = new int[nr];
                GlyphTable.Rule[] ra = new GlyphTable.Rule[nr];
                for (j = 0; j < nr; ++j) {
                    roa[j] = this.in.readTTFUShort();
                }
                for (j = 0; j < nr; ++j) {
                    GlyphTable.ClassSequenceRule r;
                    int ro = roa[j];
                    if (ro > 0) {
                        this.in.seekSet(subtableOffset + (long)cso + (long)ro);
                        int ng = this.in.readTTFUShort();
                        int nl = this.in.readTTFUShort();
                        int[] classes = new int[ng - 1];
                        int nk = classes.length;
                        for (int k = 0; k < nk; ++k) {
                            classes[k] = this.in.readTTFUShort();
                        }
                        if (log.isDebugEnabled()) {
                            header = tableTag + " contextual substitution lookups @rule[" + i2 + "][" + j + "]: ";
                        }
                        GlyphTable.RuleLookup[] lookups = this.readRuleLookups(nl, header);
                        r = new GlyphTable.ClassSequenceRule(lookups, ng, classes);
                    } else {
                        assert (ro > 0) : "unexpected null subclass rule offset";
                        r = null;
                    }
                    ra[j] = r;
                }
                rs = new GlyphTable.HomogeneousRuleSet(ra);
            } else {
                rs = null;
            }
            rsa[i2] = rs;
        }
        this.seMapping = ct;
        this.seEntries.add(cdt);
        this.seEntries.add(ngc);
        this.seEntries.add(rsa);
    }

    private void readContextualSubTableFormat3(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        int i;
        String tableTag = "GSUB";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int ng = this.in.readTTFUShort();
        int nl = this.in.readTTFUShort();
        int[] gcoa = new int[ng];
        for (i = 0; i < ng; ++i) {
            gcoa[i] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " contextual substitution format: " + subtableFormat + " (glyph sets)");
            log.debug(tableTag + " contextual substitution glyph input sequence length count: " + ng);
            log.debug(tableTag + " contextual substitution lookup count: " + nl);
            for (i = 0; i < ng; ++i) {
                log.debug(tableTag + " contextual substitution coverage table offset[" + i + "]: " + gcoa[i]);
            }
        }
        GlyphCoverageTable[] gca = new GlyphCoverageTable[ng];
        for (int i2 = 0; i2 < ng; ++i2) {
            int gco = gcoa[i2];
            GlyphCoverageTable gct = gco > 0 ? this.readCoverageTable(tableTag + " contextual substitution coverage[" + i2 + "]", subtableOffset + (long)gco) : null;
            gca[i2] = gct;
        }
        String header = null;
        if (log.isDebugEnabled()) {
            header = tableTag + " contextual substitution lookups: ";
        }
        GlyphTable.RuleLookup[] lookups = this.readRuleLookups(nl, header);
        GlyphTable.CoverageSequenceRule r = new GlyphTable.CoverageSequenceRule(lookups, ng, gca);
        GlyphTable.HomogeneousRuleSet rs = new GlyphTable.HomogeneousRuleSet(new GlyphTable.Rule[]{r});
        GlyphTable.RuleSet[] rsa = new GlyphTable.RuleSet[]{rs};
        assert (gca != null && gca.length > 0);
        this.seMapping = gca[0];
        this.seEntries.add(rsa);
    }

    private int readContextualSubTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf == 1) {
            this.readContextualSubTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        } else if (sf == 2) {
            this.readContextualSubTableFormat2(lookupType, lookupFlags, subtableOffset, sf);
        } else if (sf == 3) {
            this.readContextualSubTableFormat3(lookupType, lookupFlags, subtableOffset, sf);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported contextual substitution subtable format: " + sf);
        }
        return sf;
    }

    private void readChainedContextualSubTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        int i;
        String tableTag = "GSUB";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int nrs = this.in.readTTFUShort();
        int[] rsoa = new int[nrs];
        for (i = 0; i < nrs; ++i) {
            rsoa[i] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " chained contextual substitution format: " + subtableFormat + " (glyphs)");
            log.debug(tableTag + " chained contextual substitution coverage table offset: " + co);
            log.debug(tableTag + " chained contextual substitution rule set count: " + nrs);
            for (i = 0; i < nrs; ++i) {
                log.debug(tableTag + " chained contextual substitution rule set offset[" + i + "]: " + rsoa[i]);
            }
        }
        GlyphCoverageTable ct = co > 0 ? this.readCoverageTable(tableTag + " chained contextual substitution coverage", subtableOffset + (long)co) : null;
        GlyphTable.RuleSet[] rsa = new GlyphTable.RuleSet[nrs];
        String header = null;
        for (int i2 = 0; i2 < nrs; ++i2) {
            GlyphTable.HomogeneousRuleSet rs;
            int rso = rsoa[i2];
            if (rso > 0) {
                int j;
                this.in.seekSet(subtableOffset + (long)rso);
                int nr = this.in.readTTFUShort();
                int[] roa = new int[nr];
                GlyphTable.Rule[] ra = new GlyphTable.Rule[nr];
                for (j = 0; j < nr; ++j) {
                    roa[j] = this.in.readTTFUShort();
                }
                for (j = 0; j < nr; ++j) {
                    GlyphTable.ChainedGlyphSequenceRule r;
                    int ro = roa[j];
                    if (ro > 0) {
                        this.in.seekSet(subtableOffset + (long)rso + (long)ro);
                        int nbg = this.in.readTTFUShort();
                        int[] backtrackGlyphs = new int[nbg];
                        int nk = backtrackGlyphs.length;
                        for (int k = 0; k < nk; ++k) {
                            backtrackGlyphs[k] = this.in.readTTFUShort();
                        }
                        int nig = this.in.readTTFUShort();
                        int[] glyphs = new int[nig - 1];
                        int nk2 = glyphs.length;
                        for (int k = 0; k < nk2; ++k) {
                            glyphs[k] = this.in.readTTFUShort();
                        }
                        int nlg = this.in.readTTFUShort();
                        int[] lookaheadGlyphs = new int[nlg];
                        int nk3 = lookaheadGlyphs.length;
                        for (int k = 0; k < nk3; ++k) {
                            lookaheadGlyphs[k] = this.in.readTTFUShort();
                        }
                        int nl = this.in.readTTFUShort();
                        if (log.isDebugEnabled()) {
                            header = tableTag + " contextual substitution lookups @rule[" + i2 + "][" + j + "]: ";
                        }
                        GlyphTable.RuleLookup[] lookups = this.readRuleLookups(nl, header);
                        r = new GlyphTable.ChainedGlyphSequenceRule(lookups, nig, glyphs, backtrackGlyphs, lookaheadGlyphs);
                    } else {
                        r = null;
                    }
                    ra[j] = r;
                }
                rs = new GlyphTable.HomogeneousRuleSet(ra);
            } else {
                rs = null;
            }
            rsa[i2] = rs;
        }
        this.seMapping = ct;
        this.seEntries.add(rsa);
    }

    private void readChainedContextualSubTableFormat2(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        int i;
        String tableTag = "GSUB";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int bcdo = this.in.readTTFUShort();
        int icdo = this.in.readTTFUShort();
        int lcdo = this.in.readTTFUShort();
        int ngc = this.in.readTTFUShort();
        int[] csoa = new int[ngc];
        for (i = 0; i < ngc; ++i) {
            csoa[i] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " chained contextual substitution format: " + subtableFormat + " (glyph classes)");
            log.debug(tableTag + " chained contextual substitution coverage table offset: " + co);
            log.debug(tableTag + " chained contextual substitution class set count: " + ngc);
            for (i = 0; i < ngc; ++i) {
                log.debug(tableTag + " chained contextual substitution class set offset[" + i + "]: " + csoa[i]);
            }
        }
        GlyphCoverageTable ct = co > 0 ? this.readCoverageTable(tableTag + " chained contextual substitution coverage", subtableOffset + (long)co) : null;
        GlyphClassTable bcdt = bcdo > 0 ? this.readClassDefTable(tableTag + " contextual substitution backtrack class definition", subtableOffset + (long)bcdo) : null;
        GlyphClassTable icdt = icdo > 0 ? this.readClassDefTable(tableTag + " contextual substitution input class definition", subtableOffset + (long)icdo) : null;
        GlyphClassTable lcdt = lcdo > 0 ? this.readClassDefTable(tableTag + " contextual substitution lookahead class definition", subtableOffset + (long)lcdo) : null;
        GlyphTable.RuleSet[] rsa = new GlyphTable.RuleSet[ngc];
        String header = null;
        for (int i2 = 0; i2 < ngc; ++i2) {
            GlyphTable.HomogeneousRuleSet rs;
            int cso = csoa[i2];
            if (cso > 0) {
                int j;
                this.in.seekSet(subtableOffset + (long)cso);
                int nr = this.in.readTTFUShort();
                int[] roa = new int[nr];
                GlyphTable.Rule[] ra = new GlyphTable.Rule[nr];
                for (j = 0; j < nr; ++j) {
                    roa[j] = this.in.readTTFUShort();
                }
                for (j = 0; j < nr; ++j) {
                    GlyphTable.ChainedClassSequenceRule r;
                    int ro = roa[j];
                    if (ro > 0) {
                        this.in.seekSet(subtableOffset + (long)cso + (long)ro);
                        int nbc = this.in.readTTFUShort();
                        int[] backtrackClasses = new int[nbc];
                        int nk = backtrackClasses.length;
                        for (int k = 0; k < nk; ++k) {
                            backtrackClasses[k] = this.in.readTTFUShort();
                        }
                        int nic = this.in.readTTFUShort();
                        int[] classes = new int[nic - 1];
                        int nk2 = classes.length;
                        for (int k = 0; k < nk2; ++k) {
                            classes[k] = this.in.readTTFUShort();
                        }
                        int nlc = this.in.readTTFUShort();
                        int[] lookaheadClasses = new int[nlc];
                        int nk3 = lookaheadClasses.length;
                        for (int k = 0; k < nk3; ++k) {
                            lookaheadClasses[k] = this.in.readTTFUShort();
                        }
                        int nl = this.in.readTTFUShort();
                        if (log.isDebugEnabled()) {
                            header = tableTag + " contextual substitution lookups @rule[" + i2 + "][" + j + "]: ";
                        }
                        GlyphTable.RuleLookup[] lookups = this.readRuleLookups(nl, header);
                        r = new GlyphTable.ChainedClassSequenceRule(lookups, nic, classes, backtrackClasses, lookaheadClasses);
                    } else {
                        r = null;
                    }
                    ra[j] = r;
                }
                rs = new GlyphTable.HomogeneousRuleSet(ra);
            } else {
                rs = null;
            }
            rsa[i2] = rs;
        }
        this.seMapping = ct;
        this.seEntries.add(icdt);
        this.seEntries.add(bcdt);
        this.seEntries.add(lcdt);
        this.seEntries.add(ngc);
        this.seEntries.add(rsa);
    }

    private void readChainedContextualSubTableFormat3(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GSUB";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int nbg = this.in.readTTFUShort();
        int[] bgcoa = new int[nbg];
        for (int i = 0; i < nbg; ++i) {
            bgcoa[i] = this.in.readTTFUShort();
        }
        int nig = this.in.readTTFUShort();
        int[] igcoa = new int[nig];
        for (int i = 0; i < nig; ++i) {
            igcoa[i] = this.in.readTTFUShort();
        }
        int nlg = this.in.readTTFUShort();
        int[] lgcoa = new int[nlg];
        for (int i = 0; i < nlg; ++i) {
            lgcoa[i] = this.in.readTTFUShort();
        }
        int nl = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            int i;
            log.debug(tableTag + " chained contextual substitution format: " + subtableFormat + " (glyph sets)");
            log.debug(tableTag + " chained contextual substitution backtrack glyph count: " + nbg);
            for (i = 0; i < nbg; ++i) {
                log.debug(tableTag + " chained contextual substitution backtrack coverage table offset[" + i + "]: " + bgcoa[i]);
            }
            log.debug(tableTag + " chained contextual substitution input glyph count: " + nig);
            for (i = 0; i < nig; ++i) {
                log.debug(tableTag + " chained contextual substitution input coverage table offset[" + i + "]: " + igcoa[i]);
            }
            log.debug(tableTag + " chained contextual substitution lookahead glyph count: " + nlg);
            for (i = 0; i < nlg; ++i) {
                log.debug(tableTag + " chained contextual substitution lookahead coverage table offset[" + i + "]: " + lgcoa[i]);
            }
            log.debug(tableTag + " chained contextual substitution lookup count: " + nl);
        }
        GlyphCoverageTable[] bgca = new GlyphCoverageTable[nbg];
        for (int i = 0; i < nbg; ++i) {
            int bgco = bgcoa[i];
            GlyphCoverageTable bgct = bgco > 0 ? this.readCoverageTable(tableTag + " chained contextual substitution backtrack coverage[" + i + "]", subtableOffset + (long)bgco) : null;
            bgca[i] = bgct;
        }
        GlyphCoverageTable[] igca = new GlyphCoverageTable[nig];
        for (int i = 0; i < nig; ++i) {
            int igco = igcoa[i];
            GlyphCoverageTable igct = igco > 0 ? this.readCoverageTable(tableTag + " chained contextual substitution input coverage[" + i + "]", subtableOffset + (long)igco) : null;
            igca[i] = igct;
        }
        GlyphCoverageTable[] lgca = new GlyphCoverageTable[nlg];
        for (int i = 0; i < nlg; ++i) {
            int lgco = lgcoa[i];
            GlyphCoverageTable lgct = lgco > 0 ? this.readCoverageTable(tableTag + " chained contextual substitution lookahead coverage[" + i + "]", subtableOffset + (long)lgco) : null;
            lgca[i] = lgct;
        }
        String header = null;
        if (log.isDebugEnabled()) {
            header = tableTag + " chained contextual substitution lookups: ";
        }
        GlyphTable.RuleLookup[] lookups = this.readRuleLookups(nl, header);
        GlyphTable.ChainedCoverageSequenceRule r = new GlyphTable.ChainedCoverageSequenceRule(lookups, nig, igca, bgca, lgca);
        GlyphTable.HomogeneousRuleSet rs = new GlyphTable.HomogeneousRuleSet(new GlyphTable.Rule[]{r});
        GlyphTable.RuleSet[] rsa = new GlyphTable.RuleSet[]{rs};
        assert (igca != null && igca.length > 0);
        this.seMapping = igca[0];
        this.seEntries.add(rsa);
    }

    private int readChainedContextualSubTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf == 1) {
            this.readChainedContextualSubTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        } else if (sf == 2) {
            this.readChainedContextualSubTableFormat2(lookupType, lookupFlags, subtableOffset, sf);
        } else if (sf == 3) {
            this.readChainedContextualSubTableFormat3(lookupType, lookupFlags, subtableOffset, sf);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported chained contextual substitution subtable format: " + sf);
        }
        return sf;
    }

    private void readExtensionSubTableFormat1(int lookupType, int lookupFlags, int lookupSequence, int subtableSequence, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GSUB";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int lt = this.in.readTTFUShort();
        long eo = this.in.readTTFULong();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " extension substitution subtable format: " + subtableFormat);
            log.debug(tableTag + " extension substitution lookup type: " + lt);
            log.debug(tableTag + " extension substitution lookup table offset: " + eo);
        }
        this.readGSUBSubtable(lt, lookupFlags, lookupSequence, subtableSequence, subtableOffset + eo);
    }

    private int readExtensionSubTable(int lookupType, int lookupFlags, int lookupSequence, int subtableSequence, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported extension substitution subtable format: " + sf);
        }
        this.readExtensionSubTableFormat1(lookupType, lookupFlags, lookupSequence, subtableSequence, subtableOffset, sf);
        return sf;
    }

    private void readReverseChainedSingleSubTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        int i;
        String tableTag = "GSUB";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int nbg = this.in.readTTFUShort();
        int[] bgcoa = new int[nbg];
        for (int i2 = 0; i2 < nbg; ++i2) {
            bgcoa[i2] = this.in.readTTFUShort();
        }
        int nlg = this.in.readTTFUShort();
        int[] lgcoa = new int[nlg];
        for (int i3 = 0; i3 < nlg; ++i3) {
            lgcoa[i3] = this.in.readTTFUShort();
        }
        int ng = this.in.readTTFUShort();
        int[] glyphs = new int[ng];
        int n = ng;
        for (i = 0; i < n; ++i) {
            glyphs[i] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " reverse chained contextual substitution format: " + subtableFormat);
            log.debug(tableTag + " reverse chained contextual substitution coverage table offset: " + co);
            log.debug(tableTag + " reverse chained contextual substitution backtrack glyph count: " + nbg);
            for (i = 0; i < nbg; ++i) {
                log.debug(tableTag + " reverse chained contextual substitution backtrack coverage table offset[" + i + "]: " + bgcoa[i]);
            }
            log.debug(tableTag + " reverse chained contextual substitution lookahead glyph count: " + nlg);
            for (i = 0; i < nlg; ++i) {
                log.debug(tableTag + " reverse chained contextual substitution lookahead coverage table offset[" + i + "]: " + lgcoa[i]);
            }
            log.debug(tableTag + " reverse chained contextual substitution glyphs: " + this.toString(glyphs));
        }
        GlyphCoverageTable ct = this.readCoverageTable(tableTag + " reverse chained contextual substitution coverage", subtableOffset + (long)co);
        GlyphCoverageTable[] bgca = new GlyphCoverageTable[nbg];
        for (int i4 = 0; i4 < nbg; ++i4) {
            int bgco = bgcoa[i4];
            GlyphCoverageTable bgct = bgco > 0 ? this.readCoverageTable(tableTag + " reverse chained contextual substitution backtrack coverage[" + i4 + "]", subtableOffset + (long)bgco) : null;
            bgca[i4] = bgct;
        }
        GlyphCoverageTable[] lgca = new GlyphCoverageTable[nlg];
        for (int i5 = 0; i5 < nlg; ++i5) {
            int lgco = lgcoa[i5];
            GlyphCoverageTable lgct = lgco > 0 ? this.readCoverageTable(tableTag + " reverse chained contextual substitution lookahead coverage[" + i5 + "]", subtableOffset + (long)lgco) : null;
            lgca[i5] = lgct;
        }
        this.seMapping = ct;
        this.seEntries.add(bgca);
        this.seEntries.add(lgca);
        this.seEntries.add(glyphs);
    }

    private int readReverseChainedSingleSubTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported reverse chained single substitution subtable format: " + sf);
        }
        this.readReverseChainedSingleSubTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        return sf;
    }

    private void readGSUBSubtable(int lookupType, int lookupFlags, int lookupSequence, int subtableSequence, long subtableOffset) throws IOException {
        this.initATSubState();
        int subtableFormat = -1;
        switch (lookupType) {
            case 1: {
                subtableFormat = this.readSingleSubTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 2: {
                subtableFormat = this.readMultipleSubTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 3: {
                subtableFormat = this.readAlternateSubTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 4: {
                subtableFormat = this.readLigatureSubTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 5: {
                subtableFormat = this.readContextualSubTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 6: {
                subtableFormat = this.readChainedContextualSubTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 8: {
                subtableFormat = this.readReverseChainedSingleSubTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 7: {
                subtableFormat = this.readExtensionSubTable(lookupType, lookupFlags, lookupSequence, subtableSequence, subtableOffset);
                break;
            }
        }
        this.extractSESubState(1, lookupType, lookupFlags, lookupSequence, subtableSequence, subtableFormat);
        this.resetATSubState();
    }

    private GlyphPositioningTable.DeviceTable readPosDeviceTable(long subtableOffset, long deviceTableOffset) throws IOException {
        int s2;
        int dd;
        int dm;
        int m1;
        int s1;
        long cp = this.in.getCurrentPos();
        this.in.seekSet(subtableOffset + deviceTableOffset);
        int ss = this.in.readTTFUShort();
        int es = this.in.readTTFUShort();
        int df = this.in.readTTFUShort();
        if (df == 1) {
            s1 = 14;
            m1 = 3;
            dm = 1;
            dd = 4;
            s2 = 2;
        } else if (df == 2) {
            s1 = 12;
            m1 = 15;
            dm = 7;
            dd = 16;
            s2 = 4;
        } else if (df == 3) {
            s1 = 8;
            m1 = 255;
            dm = 127;
            dd = 256;
            s2 = 8;
        } else {
            log.debug("unsupported device table delta format: " + df + ", ignoring device table");
            return null;
        }
        int n = es - ss + 1;
        if (n < 0) {
            log.debug("invalid device table delta count: " + n + ", ignoring device table");
            return null;
        }
        int[] da = new int[n];
        int i = 0;
        block0: while (i < n && s2 > 0) {
            int p = this.in.readTTFUShort();
            int k = 16 / s2;
            for (int j = 0; j < k; ++j) {
                int d = p >> s1 & m1;
                if (d > dm) {
                    d -= dd;
                }
                if (i >= n) continue block0;
                da[i++] = d;
                p <<= s2;
            }
        }
        this.in.seekSet(cp);
        return new GlyphPositioningTable.DeviceTable(ss, es, da);
    }

    private GlyphPositioningTable.Value readPosValue(long subtableOffset, int valueFormat) throws IOException {
        GlyphPositioningTable.DeviceTable yad;
        GlyphPositioningTable.DeviceTable xad;
        GlyphPositioningTable.DeviceTable ypd;
        GlyphPositioningTable.DeviceTable xpd;
        int xp = (valueFormat & 1) != 0 ? this.otf.convertTTFUnit2PDFUnit(this.in.readTTFShort()) : 0;
        int yp = (valueFormat & 2) != 0 ? this.otf.convertTTFUnit2PDFUnit(this.in.readTTFShort()) : 0;
        int xa = (valueFormat & 4) != 0 ? this.otf.convertTTFUnit2PDFUnit(this.in.readTTFShort()) : 0;
        int ya = (valueFormat & 8) != 0 ? this.otf.convertTTFUnit2PDFUnit(this.in.readTTFShort()) : 0;
        if ((valueFormat & 0x10) != 0) {
            int xpdo = this.in.readTTFUShort();
            xpd = this.readPosDeviceTable(subtableOffset, xpdo);
        } else {
            xpd = null;
        }
        if ((valueFormat & 0x20) != 0) {
            int ypdo = this.in.readTTFUShort();
            ypd = this.readPosDeviceTable(subtableOffset, ypdo);
        } else {
            ypd = null;
        }
        if ((valueFormat & 0x40) != 0) {
            int xado = this.in.readTTFUShort();
            xad = this.readPosDeviceTable(subtableOffset, xado);
        } else {
            xad = null;
        }
        if ((valueFormat & 0x80) != 0) {
            int yado = this.in.readTTFUShort();
            yad = this.readPosDeviceTable(subtableOffset, yado);
        } else {
            yad = null;
        }
        return new GlyphPositioningTable.Value(xp, yp, xa, ya, xpd, ypd, xad, yad);
    }

    private void readSinglePosTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int vf = this.in.readTTFUShort();
        GlyphPositioningTable.Value v = this.readPosValue(subtableOffset, vf);
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " single positioning subtable format: " + subtableFormat + " (delta)");
            log.debug(tableTag + " single positioning coverage table offset: " + co);
            log.debug(tableTag + " single positioning value: " + v);
        }
        GlyphCoverageTable ct = this.readCoverageTable(tableTag + " single positioning coverage", subtableOffset + (long)co);
        this.seMapping = ct;
        this.seEntries.add(v);
    }

    private void readSinglePosTableFormat2(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int vf = this.in.readTTFUShort();
        int nv = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " single positioning subtable format: " + subtableFormat + " (mapped)");
            log.debug(tableTag + " single positioning coverage table offset: " + co);
            log.debug(tableTag + " single positioning value count: " + nv);
        }
        GlyphCoverageTable ct = this.readCoverageTable(tableTag + " single positioning coverage", subtableOffset + (long)co);
        GlyphPositioningTable.Value[] pva = new GlyphPositioningTable.Value[nv];
        int n = nv;
        for (int i = 0; i < n; ++i) {
            GlyphPositioningTable.Value pv = this.readPosValue(subtableOffset, vf);
            if (log.isDebugEnabled()) {
                log.debug(tableTag + " single positioning value[" + i + "]: " + pv);
            }
            pva[i] = pv;
        }
        this.seMapping = ct;
        this.seEntries.add(pva);
    }

    private int readSinglePosTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf == 1) {
            this.readSinglePosTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        } else if (sf == 2) {
            this.readSinglePosTableFormat2(lookupType, lookupFlags, subtableOffset, sf);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported single positioning subtable format: " + sf);
        }
        return sf;
    }

    private GlyphPositioningTable.PairValues readPosPairValues(long subtableOffset, boolean hasGlyph, int vf1, int vf2) throws IOException {
        int glyph = hasGlyph ? this.in.readTTFUShort() : 0;
        GlyphPositioningTable.Value v1 = vf1 != 0 ? this.readPosValue(subtableOffset, vf1) : null;
        GlyphPositioningTable.Value v2 = vf2 != 0 ? this.readPosValue(subtableOffset, vf2) : null;
        return new GlyphPositioningTable.PairValues(glyph, v1, v2);
    }

    private GlyphPositioningTable.PairValues[] readPosPairSetTable(long subtableOffset, int pairSetTableOffset, int vf1, int vf2) throws IOException {
        String tableTag = "GPOS";
        long cp = this.in.getCurrentPos();
        this.in.seekSet(subtableOffset + (long)pairSetTableOffset);
        int npv = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " pair set table offset: " + pairSetTableOffset);
            log.debug(tableTag + " pair set table values count: " + npv);
        }
        GlyphPositioningTable.PairValues[] pva = new GlyphPositioningTable.PairValues[npv];
        int n = npv;
        for (int i = 0; i < n; ++i) {
            GlyphPositioningTable.PairValues pv;
            pva[i] = pv = this.readPosPairValues(subtableOffset, true, vf1, vf2);
            if (!log.isDebugEnabled()) continue;
            log.debug(tableTag + " pair set table value[" + i + "]: " + pv);
        }
        this.in.seekSet(cp);
        return pva;
    }

    private void readPairPosTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int vf1 = this.in.readTTFUShort();
        int vf2 = this.in.readTTFUShort();
        int nps = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " pair positioning subtable format: " + subtableFormat + " (glyphs)");
            log.debug(tableTag + " pair positioning coverage table offset: " + co);
            log.debug(tableTag + " pair positioning value format #1: " + vf1);
            log.debug(tableTag + " pair positioning value format #2: " + vf2);
        }
        GlyphCoverageTable ct = this.readCoverageTable(tableTag + " pair positioning coverage", subtableOffset + (long)co);
        GlyphPositioningTable.PairValues[][] pvm = new GlyphPositioningTable.PairValues[nps][];
        int n = nps;
        for (int i = 0; i < n; ++i) {
            int pso = this.in.readTTFUShort();
            pvm[i] = this.readPosPairSetTable(subtableOffset, pso, vf1, vf2);
        }
        this.seMapping = ct;
        this.seEntries.add(pvm);
    }

    private void readPairPosTableFormat2(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int vf1 = this.in.readTTFUShort();
        int vf2 = this.in.readTTFUShort();
        int cd1o = this.in.readTTFUShort();
        int cd2o = this.in.readTTFUShort();
        int nc1 = this.in.readTTFUShort();
        int nc2 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " pair positioning subtable format: " + subtableFormat + " (glyph classes)");
            log.debug(tableTag + " pair positioning coverage table offset: " + co);
            log.debug(tableTag + " pair positioning value format #1: " + vf1);
            log.debug(tableTag + " pair positioning value format #2: " + vf2);
            log.debug(tableTag + " pair positioning class def table #1 offset: " + cd1o);
            log.debug(tableTag + " pair positioning class def table #2 offset: " + cd2o);
            log.debug(tableTag + " pair positioning class #1 count: " + nc1);
            log.debug(tableTag + " pair positioning class #2 count: " + nc2);
        }
        GlyphCoverageTable ct = this.readCoverageTable(tableTag + " pair positioning coverage", subtableOffset + (long)co);
        GlyphClassTable cdt1 = this.readClassDefTable(tableTag + " pair positioning class definition #1", subtableOffset + (long)cd1o);
        GlyphClassTable cdt2 = this.readClassDefTable(tableTag + " pair positioning class definition #2", subtableOffset + (long)cd2o);
        GlyphPositioningTable.PairValues[][] pvm = new GlyphPositioningTable.PairValues[nc1][nc2];
        for (int i = 0; i < nc1; ++i) {
            for (int j = 0; j < nc2; ++j) {
                GlyphPositioningTable.PairValues pv;
                pvm[i][j] = pv = this.readPosPairValues(subtableOffset, false, vf1, vf2);
                if (!log.isDebugEnabled()) continue;
                log.debug(tableTag + " pair set table value[" + i + "][" + j + "]: " + pv);
            }
        }
        this.seMapping = ct;
        this.seEntries.add(cdt1);
        this.seEntries.add(cdt2);
        this.seEntries.add(nc1);
        this.seEntries.add(nc2);
        this.seEntries.add(pvm);
    }

    private int readPairPosTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf == 1) {
            this.readPairPosTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        } else if (sf == 2) {
            this.readPairPosTableFormat2(lookupType, lookupFlags, subtableOffset, sf);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported pair positioning subtable format: " + sf);
        }
        return sf;
    }

    private GlyphPositioningTable.Anchor readPosAnchor(long anchorTableOffset) throws IOException {
        GlyphPositioningTable.Anchor a;
        long cp = this.in.getCurrentPos();
        this.in.seekSet(anchorTableOffset);
        int af = this.in.readTTFUShort();
        if (af == 1) {
            int x = this.otf.convertTTFUnit2PDFUnit(this.in.readTTFShort());
            int y = this.otf.convertTTFUnit2PDFUnit(this.in.readTTFShort());
            a = new GlyphPositioningTable.Anchor(x, y);
        } else if (af == 2) {
            int x = this.otf.convertTTFUnit2PDFUnit(this.in.readTTFShort());
            int y = this.otf.convertTTFUnit2PDFUnit(this.in.readTTFShort());
            int ap = this.in.readTTFUShort();
            a = new GlyphPositioningTable.Anchor(x, y, ap);
        } else if (af == 3) {
            int x = this.otf.convertTTFUnit2PDFUnit(this.in.readTTFShort());
            int y = this.otf.convertTTFUnit2PDFUnit(this.in.readTTFShort());
            int xdo = this.in.readTTFUShort();
            int ydo = this.in.readTTFUShort();
            GlyphPositioningTable.DeviceTable xd = xdo != 0 ? this.readPosDeviceTable(cp, xdo) : null;
            GlyphPositioningTable.DeviceTable yd = ydo != 0 ? this.readPosDeviceTable(cp, ydo) : null;
            a = new GlyphPositioningTable.Anchor(x, y, xd, yd);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported positioning anchor format: " + af);
        }
        this.in.seekSet(cp);
        return a;
    }

    private void readCursivePosTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int ec = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " cursive positioning subtable format: " + subtableFormat);
            log.debug(tableTag + " cursive positioning coverage table offset: " + co);
            log.debug(tableTag + " cursive positioning entry/exit count: " + ec);
        }
        GlyphCoverageTable ct = this.readCoverageTable(tableTag + " cursive positioning coverage", subtableOffset + (long)co);
        GlyphPositioningTable.Anchor[] aa = new GlyphPositioningTable.Anchor[ec * 2];
        int n = ec;
        for (int i = 0; i < n; ++i) {
            int eno = this.in.readTTFUShort();
            int exo = this.in.readTTFUShort();
            GlyphPositioningTable.Anchor ena = eno > 0 ? this.readPosAnchor(subtableOffset + (long)eno) : null;
            GlyphPositioningTable.Anchor exa = exo > 0 ? this.readPosAnchor(subtableOffset + (long)exo) : null;
            aa[i * 2 + 0] = ena;
            aa[i * 2 + 1] = exa;
            if (!log.isDebugEnabled()) continue;
            if (ena != null) {
                log.debug(tableTag + " cursive entry anchor [" + i + "]: " + ena);
            }
            if (exa == null) continue;
            log.debug(tableTag + " cursive exit anchor  [" + i + "]: " + exa);
        }
        this.seMapping = ct;
        this.seEntries.add(aa);
    }

    private int readCursivePosTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported cursive positioning subtable format: " + sf);
        }
        this.readCursivePosTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        return sf;
    }

    private void readMarkToBasePosTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int mco = this.in.readTTFUShort();
        int bco = this.in.readTTFUShort();
        int nmc = this.in.readTTFUShort();
        int mao = this.in.readTTFUShort();
        int bao = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " mark-to-base positioning subtable format: " + subtableFormat);
            log.debug(tableTag + " mark-to-base positioning mark coverage table offset: " + mco);
            log.debug(tableTag + " mark-to-base positioning base coverage table offset: " + bco);
            log.debug(tableTag + " mark-to-base positioning mark class count: " + nmc);
            log.debug(tableTag + " mark-to-base positioning mark array offset: " + mao);
            log.debug(tableTag + " mark-to-base positioning base array offset: " + bao);
        }
        GlyphCoverageTable mct = this.readCoverageTable(tableTag + " mark-to-base positioning mark coverage", subtableOffset + (long)mco);
        GlyphCoverageTable bct = this.readCoverageTable(tableTag + " mark-to-base positioning base coverage", subtableOffset + (long)bco);
        this.in.seekSet(subtableOffset + (long)mao);
        int nm = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " mark-to-base positioning mark count: " + nm);
        }
        GlyphPositioningTable.MarkAnchor[] maa = new GlyphPositioningTable.MarkAnchor[nm];
        for (int i = 0; i < nm; ++i) {
            int mc = this.in.readTTFUShort();
            int ao = this.in.readTTFUShort();
            GlyphPositioningTable.Anchor a = ao > 0 ? this.readPosAnchor(subtableOffset + (long)mao + (long)ao) : null;
            GlyphPositioningTable.MarkAnchor ma = a != null ? new GlyphPositioningTable.MarkAnchor(mc, a) : null;
            maa[i] = ma;
            if (!log.isDebugEnabled()) continue;
            log.debug(tableTag + " mark-to-base positioning mark anchor[" + i + "]: " + ma);
        }
        this.in.seekSet(subtableOffset + (long)bao);
        int nb = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " mark-to-base positioning base count: " + nb);
        }
        GlyphPositioningTable.Anchor[][] bam = new GlyphPositioningTable.Anchor[nb][nmc];
        for (int i = 0; i < nb; ++i) {
            for (int j = 0; j < nmc; ++j) {
                int ao = this.in.readTTFUShort();
                GlyphPositioningTable.Anchor a = ao > 0 ? this.readPosAnchor(subtableOffset + (long)bao + (long)ao) : null;
                bam[i][j] = a;
                if (!log.isDebugEnabled()) continue;
                log.debug(tableTag + " mark-to-base positioning base anchor[" + i + "][" + j + "]: " + a);
            }
        }
        this.seMapping = mct;
        this.seEntries.add(bct);
        this.seEntries.add(nmc);
        this.seEntries.add(maa);
        this.seEntries.add(bam);
    }

    private int readMarkToBasePosTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported mark-to-base positioning subtable format: " + sf);
        }
        this.readMarkToBasePosTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        return sf;
    }

    private void readMarkToLigaturePosTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int mco = this.in.readTTFUShort();
        int lco = this.in.readTTFUShort();
        int nmc = this.in.readTTFUShort();
        int mao = this.in.readTTFUShort();
        int lao = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " mark-to-ligature positioning subtable format: " + subtableFormat);
            log.debug(tableTag + " mark-to-ligature positioning mark coverage table offset: " + mco);
            log.debug(tableTag + " mark-to-ligature positioning ligature coverage table offset: " + lco);
            log.debug(tableTag + " mark-to-ligature positioning mark class count: " + nmc);
            log.debug(tableTag + " mark-to-ligature positioning mark array offset: " + mao);
            log.debug(tableTag + " mark-to-ligature positioning ligature array offset: " + lao);
        }
        GlyphCoverageTable mct = this.readCoverageTable(tableTag + " mark-to-ligature positioning mark coverage", subtableOffset + (long)mco);
        GlyphCoverageTable lct = this.readCoverageTable(tableTag + " mark-to-ligature positioning ligature coverage", subtableOffset + (long)lco);
        this.in.seekSet(subtableOffset + (long)mao);
        int nm = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " mark-to-ligature positioning mark count: " + nm);
        }
        GlyphPositioningTable.MarkAnchor[] maa = new GlyphPositioningTable.MarkAnchor[nm];
        for (int i = 0; i < nm; ++i) {
            int mc = this.in.readTTFUShort();
            int ao = this.in.readTTFUShort();
            GlyphPositioningTable.Anchor a = ao > 0 ? this.readPosAnchor(subtableOffset + (long)mao + (long)ao) : null;
            GlyphPositioningTable.MarkAnchor ma = a != null ? new GlyphPositioningTable.MarkAnchor(mc, a) : null;
            maa[i] = ma;
            if (!log.isDebugEnabled()) continue;
            log.debug(tableTag + " mark-to-ligature positioning mark anchor[" + i + "]: " + ma);
        }
        this.in.seekSet(subtableOffset + (long)lao);
        int nl = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " mark-to-ligature positioning ligature count: " + nl);
        }
        int[] laoa = new int[nl];
        for (int i = 0; i < nl; ++i) {
            laoa[i] = this.in.readTTFUShort();
        }
        int mxc = 0;
        for (int i = 0; i < nl; ++i) {
            int lato = laoa[i];
            this.in.seekSet(subtableOffset + (long)lao + (long)lato);
            int cc = this.in.readTTFUShort();
            if (cc <= mxc) continue;
            mxc = cc;
        }
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " mark-to-ligature positioning maximum component count: " + mxc);
        }
        GlyphPositioningTable.Anchor[][][] lam = new GlyphPositioningTable.Anchor[nl][][];
        for (int i = 0; i < nl; ++i) {
            int lato = laoa[i];
            this.in.seekSet(subtableOffset + (long)lao + (long)lato);
            int cc = this.in.readTTFUShort();
            GlyphPositioningTable.Anchor[][] lcm = new GlyphPositioningTable.Anchor[cc][nmc];
            for (int j = 0; j < cc; ++j) {
                for (int k = 0; k < nmc; ++k) {
                    int ao = this.in.readTTFUShort();
                    GlyphPositioningTable.Anchor a = ao > 0 ? this.readPosAnchor(subtableOffset + (long)lao + (long)lato + (long)ao) : null;
                    lcm[j][k] = a;
                    if (!log.isDebugEnabled()) continue;
                    log.debug(tableTag + " mark-to-ligature positioning ligature anchor[" + i + "][" + j + "][" + k + "]: " + a);
                }
            }
            lam[i] = lcm;
        }
        this.seMapping = mct;
        this.seEntries.add(lct);
        this.seEntries.add(nmc);
        this.seEntries.add(mxc);
        this.seEntries.add(maa);
        this.seEntries.add(lam);
    }

    private int readMarkToLigaturePosTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported mark-to-ligature positioning subtable format: " + sf);
        }
        this.readMarkToLigaturePosTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        return sf;
    }

    private void readMarkToMarkPosTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int m1co = this.in.readTTFUShort();
        int m2co = this.in.readTTFUShort();
        int nmc = this.in.readTTFUShort();
        int m1ao = this.in.readTTFUShort();
        int m2ao = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " mark-to-mark positioning subtable format: " + subtableFormat);
            log.debug(tableTag + " mark-to-mark positioning mark #1 coverage table offset: " + m1co);
            log.debug(tableTag + " mark-to-mark positioning mark #2 coverage table offset: " + m2co);
            log.debug(tableTag + " mark-to-mark positioning mark class count: " + nmc);
            log.debug(tableTag + " mark-to-mark positioning mark #1 array offset: " + m1ao);
            log.debug(tableTag + " mark-to-mark positioning mark #2 array offset: " + m2ao);
        }
        GlyphCoverageTable mct1 = this.readCoverageTable(tableTag + " mark-to-mark positioning mark #1 coverage", subtableOffset + (long)m1co);
        GlyphCoverageTable mct2 = this.readCoverageTable(tableTag + " mark-to-mark positioning mark #2 coverage", subtableOffset + (long)m2co);
        this.in.seekSet(subtableOffset + (long)m1ao);
        int nm1 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " mark-to-mark positioning mark #1 count: " + nm1);
        }
        GlyphPositioningTable.MarkAnchor[] maa = new GlyphPositioningTable.MarkAnchor[nm1];
        for (int i = 0; i < nm1; ++i) {
            int mc = this.in.readTTFUShort();
            int ao = this.in.readTTFUShort();
            GlyphPositioningTable.Anchor a = ao > 0 ? this.readPosAnchor(subtableOffset + (long)m1ao + (long)ao) : null;
            GlyphPositioningTable.MarkAnchor ma = a != null ? new GlyphPositioningTable.MarkAnchor(mc, a) : null;
            maa[i] = ma;
            if (!log.isDebugEnabled()) continue;
            log.debug(tableTag + " mark-to-mark positioning mark #1 anchor[" + i + "]: " + ma);
        }
        this.in.seekSet(subtableOffset + (long)m2ao);
        int nm2 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " mark-to-mark positioning mark #2 count: " + nm2);
        }
        GlyphPositioningTable.Anchor[][] mam = new GlyphPositioningTable.Anchor[nm2][nmc];
        for (int i = 0; i < nm2; ++i) {
            for (int j = 0; j < nmc; ++j) {
                int ao = this.in.readTTFUShort();
                GlyphPositioningTable.Anchor a = ao > 0 ? this.readPosAnchor(subtableOffset + (long)m2ao + (long)ao) : null;
                mam[i][j] = a;
                if (!log.isDebugEnabled()) continue;
                log.debug(tableTag + " mark-to-mark positioning mark #2 anchor[" + i + "][" + j + "]: " + a);
            }
        }
        this.seMapping = mct1;
        this.seEntries.add(mct2);
        this.seEntries.add(nmc);
        this.seEntries.add(maa);
        this.seEntries.add(mam);
    }

    private int readMarkToMarkPosTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported mark-to-mark positioning subtable format: " + sf);
        }
        this.readMarkToMarkPosTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        return sf;
    }

    private void readContextualPosTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        int i;
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int nrs = this.in.readTTFUShort();
        int[] rsoa = new int[nrs];
        for (i = 0; i < nrs; ++i) {
            rsoa[i] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " contextual positioning subtable format: " + subtableFormat + " (glyphs)");
            log.debug(tableTag + " contextual positioning coverage table offset: " + co);
            log.debug(tableTag + " contextual positioning rule set count: " + nrs);
            for (i = 0; i < nrs; ++i) {
                log.debug(tableTag + " contextual positioning rule set offset[" + i + "]: " + rsoa[i]);
            }
        }
        GlyphCoverageTable ct = co > 0 ? this.readCoverageTable(tableTag + " contextual positioning coverage", subtableOffset + (long)co) : null;
        GlyphTable.RuleSet[] rsa = new GlyphTable.RuleSet[nrs];
        String header = null;
        for (int i2 = 0; i2 < nrs; ++i2) {
            GlyphTable.HomogeneousRuleSet rs;
            int rso = rsoa[i2];
            if (rso > 0) {
                int j;
                this.in.seekSet(subtableOffset + (long)rso);
                int nr = this.in.readTTFUShort();
                int[] roa = new int[nr];
                GlyphTable.Rule[] ra = new GlyphTable.Rule[nr];
                for (j = 0; j < nr; ++j) {
                    roa[j] = this.in.readTTFUShort();
                }
                for (j = 0; j < nr; ++j) {
                    GlyphTable.GlyphSequenceRule r;
                    int ro = roa[j];
                    if (ro > 0) {
                        this.in.seekSet(subtableOffset + (long)rso + (long)ro);
                        int ng = this.in.readTTFUShort();
                        int nl = this.in.readTTFUShort();
                        int[] glyphs = new int[ng - 1];
                        int nk = glyphs.length;
                        for (int k = 0; k < nk; ++k) {
                            glyphs[k] = this.in.readTTFUShort();
                        }
                        if (log.isDebugEnabled()) {
                            header = tableTag + " contextual positioning lookups @rule[" + i2 + "][" + j + "]: ";
                        }
                        GlyphTable.RuleLookup[] lookups = this.readRuleLookups(nl, header);
                        r = new GlyphTable.GlyphSequenceRule(lookups, ng, glyphs);
                    } else {
                        r = null;
                    }
                    ra[j] = r;
                }
                rs = new GlyphTable.HomogeneousRuleSet(ra);
            } else {
                rs = null;
            }
            rsa[i2] = rs;
        }
        this.seMapping = ct;
        this.seEntries.add(rsa);
    }

    private void readContextualPosTableFormat2(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        int i;
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int cdo = this.in.readTTFUShort();
        int ngc = this.in.readTTFUShort();
        int[] csoa = new int[ngc];
        for (i = 0; i < ngc; ++i) {
            csoa[i] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " contextual positioning subtable format: " + subtableFormat + " (glyph classes)");
            log.debug(tableTag + " contextual positioning coverage table offset: " + co);
            log.debug(tableTag + " contextual positioning class set count: " + ngc);
            for (i = 0; i < ngc; ++i) {
                log.debug(tableTag + " contextual positioning class set offset[" + i + "]: " + csoa[i]);
            }
        }
        GlyphCoverageTable ct = co > 0 ? this.readCoverageTable(tableTag + " contextual positioning coverage", subtableOffset + (long)co) : null;
        GlyphClassTable cdt = cdo > 0 ? this.readClassDefTable(tableTag + " contextual positioning class definition", subtableOffset + (long)cdo) : null;
        GlyphTable.RuleSet[] rsa = new GlyphTable.RuleSet[ngc];
        String header = null;
        for (int i2 = 0; i2 < ngc; ++i2) {
            GlyphTable.HomogeneousRuleSet rs;
            int cso = csoa[i2];
            if (cso > 0) {
                int j;
                this.in.seekSet(subtableOffset + (long)cso);
                int nr = this.in.readTTFUShort();
                int[] roa = new int[nr];
                GlyphTable.Rule[] ra = new GlyphTable.Rule[nr];
                for (j = 0; j < nr; ++j) {
                    roa[j] = this.in.readTTFUShort();
                }
                for (j = 0; j < nr; ++j) {
                    GlyphTable.ClassSequenceRule r;
                    int ro = roa[j];
                    if (ro > 0) {
                        this.in.seekSet(subtableOffset + (long)cso + (long)ro);
                        int ng = this.in.readTTFUShort();
                        int nl = this.in.readTTFUShort();
                        int[] classes = new int[ng - 1];
                        int nk = classes.length;
                        for (int k = 0; k < nk; ++k) {
                            classes[k] = this.in.readTTFUShort();
                        }
                        if (log.isDebugEnabled()) {
                            header = tableTag + " contextual positioning lookups @rule[" + i2 + "][" + j + "]: ";
                        }
                        GlyphTable.RuleLookup[] lookups = this.readRuleLookups(nl, header);
                        r = new GlyphTable.ClassSequenceRule(lookups, ng, classes);
                    } else {
                        r = null;
                    }
                    ra[j] = r;
                }
                rs = new GlyphTable.HomogeneousRuleSet(ra);
            } else {
                rs = null;
            }
            rsa[i2] = rs;
        }
        this.seMapping = ct;
        this.seEntries.add(cdt);
        this.seEntries.add(ngc);
        this.seEntries.add(rsa);
    }

    private void readContextualPosTableFormat3(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        int i;
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int ng = this.in.readTTFUShort();
        int nl = this.in.readTTFUShort();
        int[] gcoa = new int[ng];
        for (i = 0; i < ng; ++i) {
            gcoa[i] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " contextual positioning subtable format: " + subtableFormat + " (glyph sets)");
            log.debug(tableTag + " contextual positioning glyph input sequence length count: " + ng);
            log.debug(tableTag + " contextual positioning lookup count: " + nl);
            for (i = 0; i < ng; ++i) {
                log.debug(tableTag + " contextual positioning coverage table offset[" + i + "]: " + gcoa[i]);
            }
        }
        GlyphCoverageTable[] gca = new GlyphCoverageTable[ng];
        for (int i2 = 0; i2 < ng; ++i2) {
            int gco = gcoa[i2];
            GlyphCoverageTable gct = gco > 0 ? this.readCoverageTable(tableTag + " contextual positioning coverage[" + i2 + "]", subtableOffset + (long)gcoa[i2]) : null;
            gca[i2] = gct;
        }
        String header = null;
        if (log.isDebugEnabled()) {
            header = tableTag + " contextual positioning lookups: ";
        }
        GlyphTable.RuleLookup[] lookups = this.readRuleLookups(nl, header);
        GlyphTable.CoverageSequenceRule r = new GlyphTable.CoverageSequenceRule(lookups, ng, gca);
        GlyphTable.HomogeneousRuleSet rs = new GlyphTable.HomogeneousRuleSet(new GlyphTable.Rule[]{r});
        GlyphTable.RuleSet[] rsa = new GlyphTable.RuleSet[]{rs};
        assert (gca != null && gca.length > 0);
        this.seMapping = gca[0];
        this.seEntries.add(rsa);
    }

    private int readContextualPosTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf == 1) {
            this.readContextualPosTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        } else if (sf == 2) {
            this.readContextualPosTableFormat2(lookupType, lookupFlags, subtableOffset, sf);
        } else if (sf == 3) {
            this.readContextualPosTableFormat3(lookupType, lookupFlags, subtableOffset, sf);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported contextual positioning subtable format: " + sf);
        }
        return sf;
    }

    private void readChainedContextualPosTableFormat1(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        int i;
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int nrs = this.in.readTTFUShort();
        int[] rsoa = new int[nrs];
        for (i = 0; i < nrs; ++i) {
            rsoa[i] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " chained contextual positioning subtable format: " + subtableFormat + " (glyphs)");
            log.debug(tableTag + " chained contextual positioning coverage table offset: " + co);
            log.debug(tableTag + " chained contextual positioning rule set count: " + nrs);
            for (i = 0; i < nrs; ++i) {
                log.debug(tableTag + " chained contextual positioning rule set offset[" + i + "]: " + rsoa[i]);
            }
        }
        GlyphCoverageTable ct = co > 0 ? this.readCoverageTable(tableTag + " chained contextual positioning coverage", subtableOffset + (long)co) : null;
        GlyphTable.RuleSet[] rsa = new GlyphTable.RuleSet[nrs];
        String header = null;
        for (int i2 = 0; i2 < nrs; ++i2) {
            GlyphTable.HomogeneousRuleSet rs;
            int rso = rsoa[i2];
            if (rso > 0) {
                int j;
                this.in.seekSet(subtableOffset + (long)rso);
                int nr = this.in.readTTFUShort();
                int[] roa = new int[nr];
                GlyphTable.Rule[] ra = new GlyphTable.Rule[nr];
                for (j = 0; j < nr; ++j) {
                    roa[j] = this.in.readTTFUShort();
                }
                for (j = 0; j < nr; ++j) {
                    GlyphTable.ChainedGlyphSequenceRule r;
                    int ro = roa[j];
                    if (ro > 0) {
                        this.in.seekSet(subtableOffset + (long)rso + (long)ro);
                        int nbg = this.in.readTTFUShort();
                        int[] backtrackGlyphs = new int[nbg];
                        int nk = backtrackGlyphs.length;
                        for (int k = 0; k < nk; ++k) {
                            backtrackGlyphs[k] = this.in.readTTFUShort();
                        }
                        int nig = this.in.readTTFUShort();
                        int[] glyphs = new int[nig - 1];
                        int nk2 = glyphs.length;
                        for (int k = 0; k < nk2; ++k) {
                            glyphs[k] = this.in.readTTFUShort();
                        }
                        int nlg = this.in.readTTFUShort();
                        int[] lookaheadGlyphs = new int[nlg];
                        int nk3 = lookaheadGlyphs.length;
                        for (int k = 0; k < nk3; ++k) {
                            lookaheadGlyphs[k] = this.in.readTTFUShort();
                        }
                        int nl = this.in.readTTFUShort();
                        if (log.isDebugEnabled()) {
                            header = tableTag + " contextual positioning lookups @rule[" + i2 + "][" + j + "]: ";
                        }
                        GlyphTable.RuleLookup[] lookups = this.readRuleLookups(nl, header);
                        r = new GlyphTable.ChainedGlyphSequenceRule(lookups, nig, glyphs, backtrackGlyphs, lookaheadGlyphs);
                    } else {
                        r = null;
                    }
                    ra[j] = r;
                }
                rs = new GlyphTable.HomogeneousRuleSet(ra);
            } else {
                rs = null;
            }
            rsa[i2] = rs;
        }
        this.seMapping = ct;
        this.seEntries.add(rsa);
    }

    private void readChainedContextualPosTableFormat2(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        int i;
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int co = this.in.readTTFUShort();
        int bcdo = this.in.readTTFUShort();
        int icdo = this.in.readTTFUShort();
        int lcdo = this.in.readTTFUShort();
        int ngc = this.in.readTTFUShort();
        int[] csoa = new int[ngc];
        for (i = 0; i < ngc; ++i) {
            csoa[i] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " chained contextual positioning subtable format: " + subtableFormat + " (glyph classes)");
            log.debug(tableTag + " chained contextual positioning coverage table offset: " + co);
            log.debug(tableTag + " chained contextual positioning class set count: " + ngc);
            for (i = 0; i < ngc; ++i) {
                log.debug(tableTag + " chained contextual positioning class set offset[" + i + "]: " + csoa[i]);
            }
        }
        GlyphCoverageTable ct = co > 0 ? this.readCoverageTable(tableTag + " chained contextual positioning coverage", subtableOffset + (long)co) : null;
        GlyphClassTable bcdt = bcdo > 0 ? this.readClassDefTable(tableTag + " contextual positioning backtrack class definition", subtableOffset + (long)bcdo) : null;
        GlyphClassTable icdt = icdo > 0 ? this.readClassDefTable(tableTag + " contextual positioning input class definition", subtableOffset + (long)icdo) : null;
        GlyphClassTable lcdt = lcdo > 0 ? this.readClassDefTable(tableTag + " contextual positioning lookahead class definition", subtableOffset + (long)lcdo) : null;
        GlyphTable.RuleSet[] rsa = new GlyphTable.RuleSet[ngc];
        String header = null;
        for (int i2 = 0; i2 < ngc; ++i2) {
            GlyphTable.HomogeneousRuleSet rs;
            int cso = csoa[i2];
            if (cso > 0) {
                int j;
                this.in.seekSet(subtableOffset + (long)cso);
                int nr = this.in.readTTFUShort();
                int[] roa = new int[nr];
                GlyphTable.Rule[] ra = new GlyphTable.Rule[nr];
                for (j = 0; j < nr; ++j) {
                    roa[j] = this.in.readTTFUShort();
                }
                for (j = 0; j < nr; ++j) {
                    GlyphTable.ChainedClassSequenceRule r;
                    int ro = roa[j];
                    if (ro > 0) {
                        this.in.seekSet(subtableOffset + (long)cso + (long)ro);
                        int nbc = this.in.readTTFUShort();
                        int[] backtrackClasses = new int[nbc];
                        int nk = backtrackClasses.length;
                        for (int k = 0; k < nk; ++k) {
                            backtrackClasses[k] = this.in.readTTFUShort();
                        }
                        int nic = this.in.readTTFUShort();
                        int[] classes = new int[nic - 1];
                        int nk2 = classes.length;
                        for (int k = 0; k < nk2; ++k) {
                            classes[k] = this.in.readTTFUShort();
                        }
                        int nlc = this.in.readTTFUShort();
                        int[] lookaheadClasses = new int[nlc];
                        int nk3 = lookaheadClasses.length;
                        for (int k = 0; k < nk3; ++k) {
                            lookaheadClasses[k] = this.in.readTTFUShort();
                        }
                        int nl = this.in.readTTFUShort();
                        if (log.isDebugEnabled()) {
                            header = tableTag + " contextual positioning lookups @rule[" + i2 + "][" + j + "]: ";
                        }
                        GlyphTable.RuleLookup[] lookups = this.readRuleLookups(nl, header);
                        r = new GlyphTable.ChainedClassSequenceRule(lookups, nic, classes, backtrackClasses, lookaheadClasses);
                    } else {
                        r = null;
                    }
                    ra[j] = r;
                }
                rs = new GlyphTable.HomogeneousRuleSet(ra);
            } else {
                rs = null;
            }
            rsa[i2] = rs;
        }
        this.seMapping = ct;
        this.seEntries.add(icdt);
        this.seEntries.add(bcdt);
        this.seEntries.add(lcdt);
        this.seEntries.add(ngc);
        this.seEntries.add(rsa);
    }

    private void readChainedContextualPosTableFormat3(int lookupType, int lookupFlags, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int nbg = this.in.readTTFUShort();
        int[] bgcoa = new int[nbg];
        for (int i = 0; i < nbg; ++i) {
            bgcoa[i] = this.in.readTTFUShort();
        }
        int nig = this.in.readTTFUShort();
        int[] igcoa = new int[nig];
        for (int i = 0; i < nig; ++i) {
            igcoa[i] = this.in.readTTFUShort();
        }
        int nlg = this.in.readTTFUShort();
        int[] lgcoa = new int[nlg];
        for (int i = 0; i < nlg; ++i) {
            lgcoa[i] = this.in.readTTFUShort();
        }
        int nl = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            int i;
            log.debug(tableTag + " chained contextual positioning subtable format: " + subtableFormat + " (glyph sets)");
            log.debug(tableTag + " chained contextual positioning backtrack glyph count: " + nbg);
            for (i = 0; i < nbg; ++i) {
                log.debug(tableTag + " chained contextual positioning backtrack coverage table offset[" + i + "]: " + bgcoa[i]);
            }
            log.debug(tableTag + " chained contextual positioning input glyph count: " + nig);
            for (i = 0; i < nig; ++i) {
                log.debug(tableTag + " chained contextual positioning input coverage table offset[" + i + "]: " + igcoa[i]);
            }
            log.debug(tableTag + " chained contextual positioning lookahead glyph count: " + nlg);
            for (i = 0; i < nlg; ++i) {
                log.debug(tableTag + " chained contextual positioning lookahead coverage table offset[" + i + "]: " + lgcoa[i]);
            }
            log.debug(tableTag + " chained contextual positioning lookup count: " + nl);
        }
        GlyphCoverageTable[] bgca = new GlyphCoverageTable[nbg];
        for (int i = 0; i < nbg; ++i) {
            int bgco = bgcoa[i];
            GlyphCoverageTable bgct = bgco > 0 ? this.readCoverageTable(tableTag + " chained contextual positioning backtrack coverage[" + i + "]", subtableOffset + (long)bgco) : null;
            bgca[i] = bgct;
        }
        GlyphCoverageTable[] igca = new GlyphCoverageTable[nig];
        for (int i = 0; i < nig; ++i) {
            int igco = igcoa[i];
            GlyphCoverageTable igct = igco > 0 ? this.readCoverageTable(tableTag + " chained contextual positioning input coverage[" + i + "]", subtableOffset + (long)igco) : null;
            igca[i] = igct;
        }
        GlyphCoverageTable[] lgca = new GlyphCoverageTable[nlg];
        for (int i = 0; i < nlg; ++i) {
            int lgco = lgcoa[i];
            GlyphCoverageTable lgct = lgco > 0 ? this.readCoverageTable(tableTag + " chained contextual positioning lookahead coverage[" + i + "]", subtableOffset + (long)lgco) : null;
            lgca[i] = lgct;
        }
        String header = null;
        if (log.isDebugEnabled()) {
            header = tableTag + " chained contextual positioning lookups: ";
        }
        GlyphTable.RuleLookup[] lookups = this.readRuleLookups(nl, header);
        GlyphTable.ChainedCoverageSequenceRule r = new GlyphTable.ChainedCoverageSequenceRule(lookups, nig, igca, bgca, lgca);
        GlyphTable.HomogeneousRuleSet rs = new GlyphTable.HomogeneousRuleSet(new GlyphTable.Rule[]{r});
        GlyphTable.RuleSet[] rsa = new GlyphTable.RuleSet[]{rs};
        assert (igca != null && igca.length > 0);
        this.seMapping = igca[0];
        this.seEntries.add(rsa);
    }

    private int readChainedContextualPosTable(int lookupType, int lookupFlags, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf == 1) {
            this.readChainedContextualPosTableFormat1(lookupType, lookupFlags, subtableOffset, sf);
        } else if (sf == 2) {
            this.readChainedContextualPosTableFormat2(lookupType, lookupFlags, subtableOffset, sf);
        } else if (sf == 3) {
            this.readChainedContextualPosTableFormat3(lookupType, lookupFlags, subtableOffset, sf);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported chained contextual positioning subtable format: " + sf);
        }
        return sf;
    }

    private void readExtensionPosTableFormat1(int lookupType, int lookupFlags, int lookupSequence, int subtableSequence, long subtableOffset, int subtableFormat) throws IOException {
        String tableTag = "GPOS";
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int lt = this.in.readTTFUShort();
        long eo = this.in.readTTFULong();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " extension positioning subtable format: " + subtableFormat);
            log.debug(tableTag + " extension positioning lookup type: " + lt);
            log.debug(tableTag + " extension positioning lookup table offset: " + eo);
        }
        this.readGPOSSubtable(lt, lookupFlags, lookupSequence, subtableSequence, subtableOffset + eo);
    }

    private int readExtensionPosTable(int lookupType, int lookupFlags, int lookupSequence, int subtableSequence, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported extension positioning subtable format: " + sf);
        }
        this.readExtensionPosTableFormat1(lookupType, lookupFlags, lookupSequence, subtableSequence, subtableOffset, sf);
        return sf;
    }

    private void readGPOSSubtable(int lookupType, int lookupFlags, int lookupSequence, int subtableSequence, long subtableOffset) throws IOException {
        this.initATSubState();
        int subtableFormat = -1;
        switch (lookupType) {
            case 1: {
                subtableFormat = this.readSinglePosTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 2: {
                subtableFormat = this.readPairPosTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 3: {
                subtableFormat = this.readCursivePosTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 4: {
                subtableFormat = this.readMarkToBasePosTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 5: {
                subtableFormat = this.readMarkToLigaturePosTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 6: {
                subtableFormat = this.readMarkToMarkPosTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 7: {
                subtableFormat = this.readContextualPosTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 8: {
                subtableFormat = this.readChainedContextualPosTable(lookupType, lookupFlags, subtableOffset);
                break;
            }
            case 9: {
                subtableFormat = this.readExtensionPosTable(lookupType, lookupFlags, lookupSequence, subtableSequence, subtableOffset);
                break;
            }
        }
        this.extractSESubState(2, lookupType, lookupFlags, lookupSequence, subtableSequence, subtableFormat);
        this.resetATSubState();
    }

    private void readLookupTable(OFTableName tableTag, int lookupSequence, long lookupTable) throws IOException {
        int so;
        int i;
        boolean isGSUB = tableTag.equals(OFTableName.GSUB);
        boolean isGPOS = tableTag.equals(OFTableName.GPOS);
        this.in.seekSet(lookupTable);
        int lt = this.in.readTTFUShort();
        int lf = this.in.readTTFUShort();
        int ns = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            String lts = isGSUB ? GSUBLookupType.toString(lt) : (isGPOS ? GPOSLookupType.toString(lt) : "?");
            log.debug(tableTag + " lookup table type: " + lt + " (" + lts + ")");
            log.debug(tableTag + " lookup table flags: " + lf + " (" + LookupFlag.toString(lf) + ")");
            log.debug(tableTag + " lookup table subtable count: " + ns);
        }
        int[] soa = new int[ns];
        for (i = 0; i < ns; ++i) {
            so = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug(tableTag + " lookup table subtable offset: " + so);
            }
            soa[i] = so;
        }
        if ((lf & 0x10) != 0) {
            int fs = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug(tableTag + " lookup table mark filter set: " + fs);
            }
        }
        for (i = 0; i < ns; ++i) {
            so = soa[i];
            if (isGSUB) {
                this.readGSUBSubtable(lt, lf, lookupSequence, i, lookupTable + (long)so);
                continue;
            }
            if (!isGPOS) continue;
            this.readGPOSSubtable(lt, lf, lookupSequence, i, lookupTable + (long)so);
        }
    }

    private void readLookupList(OFTableName tableTag, long lookupList) throws IOException {
        this.in.seekSet(lookupList);
        int nl = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " lookup list record count: " + nl);
        }
        if (nl > 0) {
            int i;
            int[] loa = new int[nl];
            int n = nl;
            for (i = 0; i < n; ++i) {
                int lo = this.in.readTTFUShort();
                if (log.isDebugEnabled()) {
                    log.debug(tableTag + " lookup table offset: " + lo);
                }
                loa[i] = lo;
            }
            n = nl;
            for (i = 0; i < n; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug(tableTag + " lookup index: " + i);
                }
                this.readLookupTable(tableTag, i, lookupList + (long)loa[i]);
            }
        }
    }

    private void readCommonLayoutTables(OFTableName tableTag, long scriptList, long featureList, long lookupList) throws IOException {
        if (scriptList > 0L) {
            this.readScriptList(tableTag, scriptList);
        }
        if (featureList > 0L) {
            this.readFeatureList(tableTag, featureList);
        }
        if (lookupList > 0L) {
            this.readLookupList(tableTag, lookupList);
        }
    }

    private void readGDEFClassDefTable(OFTableName tableTag, int lookupSequence, long subtableOffset) throws IOException {
        this.initATSubState();
        this.in.seekSet(subtableOffset);
        GlyphClassTable ct = this.readClassDefTable(tableTag + " glyph class definition table", subtableOffset);
        this.seMapping = ct;
        this.extractSESubState(5, 1, 0, lookupSequence, 0, 1);
        this.resetATSubState();
    }

    private void readGDEFAttachmentTable(OFTableName tableTag, int lookupSequence, long subtableOffset) throws IOException {
        this.initATSubState();
        this.in.seekSet(subtableOffset);
        int co = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " attachment point coverage table offset: " + co);
        }
        GlyphCoverageTable ct = this.readCoverageTable(tableTag + " attachment point coverage", subtableOffset + (long)co);
        this.seMapping = ct;
        this.extractSESubState(5, 2, 0, lookupSequence, 0, 1);
        this.resetATSubState();
    }

    private void readGDEFLigatureCaretTable(OFTableName tableTag, int lookupSequence, long subtableOffset) throws IOException {
        int i;
        this.initATSubState();
        this.in.seekSet(subtableOffset);
        int co = this.in.readTTFUShort();
        int nl = this.in.readTTFUShort();
        int[] lgto = new int[nl];
        for (i = 0; i < nl; ++i) {
            lgto[i] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " ligature caret coverage table offset: " + co);
            log.debug(tableTag + " ligature caret ligature glyph count: " + nl);
            for (i = 0; i < nl; ++i) {
                log.debug(tableTag + " ligature glyph table offset[" + i + "]: " + lgto[i]);
            }
        }
        GlyphCoverageTable ct = this.readCoverageTable(tableTag + " ligature caret coverage", subtableOffset + (long)co);
        this.seMapping = ct;
        this.extractSESubState(5, 3, 0, lookupSequence, 0, 1);
        this.resetATSubState();
    }

    private void readGDEFMarkAttachmentTable(OFTableName tableTag, int lookupSequence, long subtableOffset) throws IOException {
        this.initATSubState();
        this.in.seekSet(subtableOffset);
        GlyphClassTable ct = this.readClassDefTable(tableTag + " glyph class definition table", subtableOffset);
        this.seMapping = ct;
        this.extractSESubState(5, 4, 0, lookupSequence, 0, 1);
        this.resetATSubState();
    }

    private void readGDEFMarkGlyphsTableFormat1(OFTableName tableTag, int lookupSequence, long subtableOffset, int subtableFormat) throws IOException {
        int i;
        this.initATSubState();
        this.in.seekSet(subtableOffset);
        this.in.skip(2L);
        int nmc = this.in.readTTFUShort();
        long[] mso = new long[nmc];
        for (i = 0; i < nmc; ++i) {
            mso[i] = this.in.readTTFULong();
        }
        if (log.isDebugEnabled()) {
            log.debug(tableTag + " mark set subtable format: " + subtableFormat + " (glyph sets)");
            log.debug(tableTag + " mark set class count: " + nmc);
            for (i = 0; i < nmc; ++i) {
                log.debug(tableTag + " mark set coverage table offset[" + i + "]: " + mso[i]);
            }
        }
        GlyphCoverageTable[] msca = new GlyphCoverageTable[nmc];
        for (int i2 = 0; i2 < nmc; ++i2) {
            msca[i2] = this.readCoverageTable(tableTag + " mark set coverage[" + i2 + "]", subtableOffset + mso[i2]);
        }
        GlyphClassTable ct = GlyphClassTable.createClassTable(Arrays.asList(msca));
        this.seMapping = ct;
        this.extractSESubState(5, 4, 0, lookupSequence, 0, 1);
        this.resetATSubState();
    }

    private void readGDEFMarkGlyphsTable(OFTableName tableTag, int lookupSequence, long subtableOffset) throws IOException {
        this.in.seekSet(subtableOffset);
        int sf = this.in.readTTFUShort();
        if (sf != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported mark glyph sets subtable format: " + sf);
        }
        this.readGDEFMarkGlyphsTableFormat1(tableTag, lookupSequence, subtableOffset, sf);
    }

    private void readGDEF() throws IOException {
        OFTableName tableTag = OFTableName.GDEF;
        this.initATState();
        OFDirTabEntry dirTab = this.otf.getDirectoryEntry(tableTag);
        if (this.gdef != null) {
            if (log.isDebugEnabled()) {
                log.debug(tableTag + ": ignoring duplicate table");
            }
        } else if (dirTab != null) {
            GlyphDefinitionTable gdef;
            this.otf.seekTab(this.in, tableTag, 0L);
            long version = this.in.readTTFULong();
            if (log.isDebugEnabled()) {
                log.debug(tableTag + " version: " + version / 65536L + "." + version % 65536L);
            }
            int cdo = this.in.readTTFUShort();
            int apo = this.in.readTTFUShort();
            int lco = this.in.readTTFUShort();
            int mao = this.in.readTTFUShort();
            int mgo = version >= 65538L ? this.in.readTTFUShort() : 0;
            if (log.isDebugEnabled()) {
                log.debug(tableTag + " glyph class definition table offset: " + cdo);
                log.debug(tableTag + " attachment point list offset: " + apo);
                log.debug(tableTag + " ligature caret list offset: " + lco);
                log.debug(tableTag + " mark attachment class definition table offset: " + mao);
                log.debug(tableTag + " mark glyph set definitions table offset: " + mgo);
            }
            int seqno = 0;
            long to = dirTab.getOffset();
            if (cdo != 0) {
                this.readGDEFClassDefTable(tableTag, seqno++, to + (long)cdo);
            }
            if (apo != 0) {
                this.readGDEFAttachmentTable(tableTag, seqno++, to + (long)apo);
            }
            if (lco != 0) {
                this.readGDEFLigatureCaretTable(tableTag, seqno++, to + (long)lco);
            }
            if (mao != 0) {
                this.readGDEFMarkAttachmentTable(tableTag, seqno++, to + (long)mao);
            }
            if (mgo != 0) {
                this.readGDEFMarkGlyphsTable(tableTag, seqno++, to + (long)mgo);
            }
            if ((gdef = this.constructGDEF()) != null) {
                this.gdef = gdef;
            }
        }
    }

    private void readGSUB() throws IOException {
        OFTableName tableTag = OFTableName.GSUB;
        this.initATState();
        OFDirTabEntry dirTab = this.otf.getDirectoryEntry(tableTag);
        if (this.gpos != null) {
            if (log.isDebugEnabled()) {
                log.debug(tableTag + ": ignoring duplicate table");
            }
        } else if (dirTab != null) {
            this.otf.seekTab(this.in, tableTag, 0L);
            int version = this.in.readTTFLong();
            if (log.isDebugEnabled()) {
                log.debug(tableTag + " version: " + version / 65536 + "." + version % 65536);
            }
            int slo = this.in.readTTFUShort();
            int flo = this.in.readTTFUShort();
            int llo = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug(tableTag + " script list offset: " + slo);
                log.debug(tableTag + " feature list offset: " + flo);
                log.debug(tableTag + " lookup list offset: " + llo);
            }
            long to = dirTab.getOffset();
            this.readCommonLayoutTables(tableTag, to + (long)slo, to + (long)flo, to + (long)llo);
            GlyphSubstitutionTable gsub = this.constructGSUB();
            if (gsub != null) {
                this.gsub = gsub;
            }
        }
    }

    private void readGPOS() throws IOException {
        OFTableName tableTag = OFTableName.GPOS;
        this.initATState();
        OFDirTabEntry dirTab = this.otf.getDirectoryEntry(tableTag);
        if (this.gpos != null) {
            if (log.isDebugEnabled()) {
                log.debug(tableTag + ": ignoring duplicate table");
            }
        } else if (dirTab != null) {
            this.otf.seekTab(this.in, tableTag, 0L);
            int version = this.in.readTTFLong();
            if (log.isDebugEnabled()) {
                log.debug(tableTag + " version: " + version / 65536 + "." + version % 65536);
            }
            int slo = this.in.readTTFUShort();
            int flo = this.in.readTTFUShort();
            int llo = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug(tableTag + " script list offset: " + slo);
                log.debug(tableTag + " feature list offset: " + flo);
                log.debug(tableTag + " lookup list offset: " + llo);
            }
            long to = dirTab.getOffset();
            this.readCommonLayoutTables(tableTag, to + (long)slo, to + (long)flo, to + (long)llo);
            GlyphPositioningTable gpos = this.constructGPOS();
            if (gpos != null) {
                this.gpos = gpos;
            }
        }
    }

    private GlyphDefinitionTable constructGDEF() {
        GlyphDefinitionTable gdef = null;
        List subtables = this.constructGDEFSubtables();
        if (subtables != null && subtables.size() > 0) {
            gdef = new GlyphDefinitionTable(subtables, this.processors);
        }
        this.resetATState();
        return gdef;
    }

    private GlyphSubstitutionTable constructGSUB() {
        List subtables;
        GlyphSubstitutionTable gsub = null;
        Map lookups = this.constructLookups();
        if (lookups != null && (subtables = this.constructGSUBSubtables()) != null && lookups.size() > 0 && subtables.size() > 0) {
            gsub = new GlyphSubstitutionTable(this.gdef, lookups, subtables, this.processors);
        }
        this.resetATState();
        return gsub;
    }

    private GlyphPositioningTable constructGPOS() {
        List subtables;
        GlyphPositioningTable gpos = null;
        Map lookups = this.constructLookups();
        if (lookups != null && (subtables = this.constructGPOSSubtables()) != null && lookups.size() > 0 && subtables.size() > 0) {
            gpos = new GlyphPositioningTable(this.gdef, lookups, subtables, this.processors);
        }
        this.resetATState();
        return gpos;
    }

    private void constructLookupsFeature(Map lookups, String st, String lt, String fid) {
        Object[] fp = (Object[])this.seFeatures.get(fid);
        if (fp != null) {
            assert (fp.length == 2);
            String ft = (String)fp[0];
            List lul = (List)fp[1];
            if (ft != null && lul != null && lul.size() > 0) {
                GlyphTable.LookupSpec ls = new GlyphTable.LookupSpec(st, lt, ft);
                lookups.put(ls, lul);
            }
        }
    }

    private void constructLookupsFeatures(Map lookups, String st, String lt, List<String> fids) {
        Iterator<String> iterator = fids.iterator();
        while (iterator.hasNext()) {
            String fid1;
            String fid = fid1 = iterator.next();
            this.constructLookupsFeature(lookups, st, lt, fid);
        }
    }

    private void constructLookupsLanguage(Map lookups, String st, String lt, Map<String, Object> languages) {
        Object[] lp = (Object[])languages.get(lt);
        if (lp != null) {
            assert (lp.length == 2);
            if (lp[0] != null) {
                this.constructLookupsFeature(lookups, st, lt, (String)lp[0]);
            }
            if (lp[1] != null) {
                this.constructLookupsFeatures(lookups, st, lt, (List)lp[1]);
            }
        }
    }

    private void constructLookupsLanguages(Map lookups, String st, List<String> ll, Map<String, Object> languages) {
        Iterator<String> iterator = ll.iterator();
        while (iterator.hasNext()) {
            String aLl;
            String lt = aLl = iterator.next();
            this.constructLookupsLanguage(lookups, st, lt, languages);
        }
    }

    private Map constructLookups() {
        LinkedHashMap lookups = new LinkedHashMap();
        for (String o : this.seScripts.keySet()) {
            String st = o;
            Object[] sp = (Object[])this.seScripts.get(st);
            if (sp == null) continue;
            assert (sp.length == 3);
            Map languages = (Map)sp[2];
            if (sp[0] != null) {
                this.constructLookupsLanguage(lookups, st, (String)sp[0], languages);
            }
            if (sp[1] == null) continue;
            this.constructLookupsLanguages(lookups, st, (List)sp[1], languages);
        }
        return lookups;
    }

    private List constructGDEFSubtables() {
        ArrayList<GlyphSubtable> subtables = new ArrayList<GlyphSubtable>();
        if (this.seSubtables != null) {
            for (Object seSubtable : this.seSubtables) {
                Object[] stp = (Object[])seSubtable;
                GlyphSubtable st = this.constructGDEFSubtable(stp);
                if (st == null) continue;
                subtables.add(st);
            }
        }
        return subtables;
    }

    private GlyphSubtable constructGDEFSubtable(Object[] stp) {
        GlyphSubtable st = null;
        assert (stp != null && stp.length == 8);
        Integer tt = (Integer)stp[0];
        Integer lt = (Integer)stp[1];
        Integer ln = (Integer)stp[2];
        Integer lf = (Integer)stp[3];
        Integer sn = (Integer)stp[4];
        Integer sf = (Integer)stp[5];
        GlyphMappingTable mapping = (GlyphMappingTable)stp[6];
        List entries = (List)stp[7];
        if (tt == 5) {
            int type = GDEFLookupType.getSubtableType(lt);
            String lid = "lu" + ln;
            int sequence = sn;
            int flags = lf;
            int format = sf;
            st = GlyphDefinitionTable.createSubtable(type, lid, sequence, flags, format, mapping, entries);
        }
        return st;
    }

    private List constructGSUBSubtables() {
        ArrayList<GlyphSubtable> subtables = new ArrayList<GlyphSubtable>();
        if (this.seSubtables != null) {
            for (Object seSubtable : this.seSubtables) {
                Object[] stp = (Object[])seSubtable;
                GlyphSubtable st = this.constructGSUBSubtable(stp);
                if (st == null) continue;
                subtables.add(st);
            }
        }
        return subtables;
    }

    private GlyphSubtable constructGSUBSubtable(Object[] stp) {
        GlyphSubtable st = null;
        assert (stp != null && stp.length == 8);
        Integer tt = (Integer)stp[0];
        Integer lt = (Integer)stp[1];
        Integer ln = (Integer)stp[2];
        Integer lf = (Integer)stp[3];
        Integer sn = (Integer)stp[4];
        Integer sf = (Integer)stp[5];
        GlyphCoverageTable coverage = (GlyphCoverageTable)stp[6];
        List entries = (List)stp[7];
        if (tt == 1) {
            int type = GSUBLookupType.getSubtableType(lt);
            String lid = "lu" + ln;
            int sequence = sn;
            int flags = lf;
            int format = sf;
            st = GlyphSubstitutionTable.createSubtable(type, lid, sequence, flags, format, coverage, entries);
        }
        return st;
    }

    private List constructGPOSSubtables() {
        ArrayList<GlyphSubtable> subtables = new ArrayList<GlyphSubtable>();
        if (this.seSubtables != null) {
            for (Object seSubtable : this.seSubtables) {
                Object[] stp = (Object[])seSubtable;
                GlyphSubtable st = this.constructGPOSSubtable(stp);
                if (st == null) continue;
                subtables.add(st);
            }
        }
        return subtables;
    }

    private GlyphSubtable constructGPOSSubtable(Object[] stp) {
        GlyphSubtable st = null;
        assert (stp != null && stp.length == 8);
        Integer tt = (Integer)stp[0];
        Integer lt = (Integer)stp[1];
        Integer ln = (Integer)stp[2];
        Integer lf = (Integer)stp[3];
        Integer sn = (Integer)stp[4];
        Integer sf = (Integer)stp[5];
        GlyphCoverageTable coverage = (GlyphCoverageTable)stp[6];
        List entries = (List)stp[7];
        if (tt == 2) {
            int type = GSUBLookupType.getSubtableType(lt);
            String lid = "lu" + ln;
            int sequence = sn;
            int flags = lf;
            int format = sf;
            st = GlyphPositioningTable.createSubtable(type, lid, sequence, flags, format, coverage, entries);
        }
        return st;
    }

    private void initATState() {
        this.seScripts = new LinkedHashMap<String, Object>();
        this.seLanguages = new LinkedHashMap<String, Object>();
        this.seFeatures = new LinkedHashMap<String, Object>();
        this.seSubtables = new ArrayList();
        this.resetATSubState();
    }

    private void resetATState() {
        this.seScripts = null;
        this.seLanguages = null;
        this.seFeatures = null;
        this.seSubtables = null;
        this.resetATSubState();
    }

    private void initATSubState() {
        this.seMapping = null;
        this.seEntries = new ArrayList();
    }

    private void extractSESubState(int tableType, int lookupType, int lookupFlags, int lookupSequence, int subtableSequence, int subtableFormat) {
        if (this.seEntries != null && (tableType == 5 || this.seEntries.size() > 0) && this.seSubtables != null) {
            Integer tt = tableType;
            Integer lt = lookupType;
            Integer ln = lookupSequence;
            Integer lf = lookupFlags;
            Integer sn = subtableSequence;
            Integer sf = subtableFormat;
            this.seSubtables.add(new Object[]{tt, lt, ln, lf, sn, sf, this.seMapping, this.seEntries});
        }
    }

    private void resetATSubState() {
        this.seMapping = null;
        this.seEntries = null;
    }

    private void resetATStateAll() {
        this.resetATState();
        this.gdef = null;
        this.gsub = null;
        this.gpos = null;
    }

    private String toString(int[] ia) {
        StringBuffer sb = new StringBuffer();
        if (ia == null || ia.length == 0) {
            sb.append('-');
        } else {
            boolean first = true;
            for (int anIa : ia) {
                if (!first) {
                    sb.append(' ');
                } else {
                    first = false;
                }
                sb.append(anIa);
            }
        }
        return sb.toString();
    }

    static final class GSUBLookupType {
        static final int SINGLE = 1;
        static final int MULTIPLE = 2;
        static final int ALTERNATE = 3;
        static final int LIGATURE = 4;
        static final int CONTEXTUAL = 5;
        static final int CHAINED_CONTEXTUAL = 6;
        static final int EXTENSION = 7;
        static final int REVERSE_CHAINED_SINGLE = 8;

        private GSUBLookupType() {
        }

        public static int getSubtableType(int lt) {
            int st;
            switch (lt) {
                case 1: {
                    st = 1;
                    break;
                }
                case 2: {
                    st = 2;
                    break;
                }
                case 3: {
                    st = 3;
                    break;
                }
                case 4: {
                    st = 4;
                    break;
                }
                case 5: {
                    st = 5;
                    break;
                }
                case 6: {
                    st = 6;
                    break;
                }
                case 7: {
                    st = 7;
                    break;
                }
                case 8: {
                    st = 8;
                    break;
                }
                default: {
                    st = -1;
                }
            }
            return st;
        }

        public static String toString(int type) {
            String s;
            switch (type) {
                case 1: {
                    s = "Single";
                    break;
                }
                case 2: {
                    s = "Multiple";
                    break;
                }
                case 3: {
                    s = "Alternate";
                    break;
                }
                case 4: {
                    s = "Ligature";
                    break;
                }
                case 5: {
                    s = "Contextual";
                    break;
                }
                case 6: {
                    s = "ChainedContextual";
                    break;
                }
                case 7: {
                    s = "Extension";
                    break;
                }
                case 8: {
                    s = "ReverseChainedSingle";
                    break;
                }
                default: {
                    s = "?";
                }
            }
            return s;
        }
    }

    static final class GPOSLookupType {
        static final int SINGLE = 1;
        static final int PAIR = 2;
        static final int CURSIVE = 3;
        static final int MARK_TO_BASE = 4;
        static final int MARK_TO_LIGATURE = 5;
        static final int MARK_TO_MARK = 6;
        static final int CONTEXTUAL = 7;
        static final int CHAINED_CONTEXTUAL = 8;
        static final int EXTENSION = 9;

        private GPOSLookupType() {
        }

        public static String toString(int type) {
            String s;
            switch (type) {
                case 1: {
                    s = "Single";
                    break;
                }
                case 2: {
                    s = "Pair";
                    break;
                }
                case 3: {
                    s = "Cursive";
                    break;
                }
                case 4: {
                    s = "MarkToBase";
                    break;
                }
                case 5: {
                    s = "MarkToLigature";
                    break;
                }
                case 6: {
                    s = "MarkToMark";
                    break;
                }
                case 7: {
                    s = "Contextual";
                    break;
                }
                case 8: {
                    s = "ChainedContextual";
                    break;
                }
                case 9: {
                    s = "Extension";
                    break;
                }
                default: {
                    s = "?";
                }
            }
            return s;
        }
    }

    static final class LookupFlag {
        static final int RIGHT_TO_LEFT = 1;
        static final int IGNORE_BASE_GLYPHS = 2;
        static final int IGNORE_LIGATURE = 4;
        static final int IGNORE_MARKS = 8;
        static final int USE_MARK_FILTERING_SET = 16;
        static final int MARK_ATTACHMENT_TYPE = 65280;

        private LookupFlag() {
        }

        public static String toString(int flags) {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            if ((flags & 1) != 0) {
                if (first) {
                    first = false;
                } else {
                    sb.append('|');
                }
                sb.append("RightToLeft");
            }
            if ((flags & 2) != 0) {
                if (first) {
                    first = false;
                } else {
                    sb.append('|');
                }
                sb.append("IgnoreBaseGlyphs");
            }
            if ((flags & 4) != 0) {
                if (first) {
                    first = false;
                } else {
                    sb.append('|');
                }
                sb.append("IgnoreLigature");
            }
            if ((flags & 8) != 0) {
                if (first) {
                    first = false;
                } else {
                    sb.append('|');
                }
                sb.append("IgnoreMarks");
            }
            if ((flags & 0x10) != 0) {
                if (first) {
                    first = false;
                } else {
                    sb.append('|');
                }
                sb.append("UseMarkFilteringSet");
            }
            if (sb.length() == 0) {
                sb.append('-');
            }
            return sb.toString();
        }
    }

    static final class GDEFLookupType {
        static final int GLYPH_CLASS = 1;
        static final int ATTACHMENT_POINT = 2;
        static final int LIGATURE_CARET = 3;
        static final int MARK_ATTACHMENT = 4;

        private GDEFLookupType() {
        }

        public static int getSubtableType(int lt) {
            int st;
            switch (lt) {
                case 1: {
                    st = 1;
                    break;
                }
                case 2: {
                    st = 2;
                    break;
                }
                case 3: {
                    st = 3;
                    break;
                }
                case 4: {
                    st = 4;
                    break;
                }
                default: {
                    st = -1;
                }
            }
            return st;
        }

        public static String toString(int type) {
            String s;
            switch (type) {
                case 1: {
                    s = "GlyphClass";
                    break;
                }
                case 2: {
                    s = "AttachmentPoint";
                    break;
                }
                case 3: {
                    s = "LigatureCaret";
                    break;
                }
                case 4: {
                    s = "MarkAttachment";
                    break;
                }
                default: {
                    s = "?";
                }
            }
            return s;
        }
    }
}

