/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.docx4j.fonts.fop.apps.io.InternalResourceResolver;
import org.docx4j.fonts.fop.fonts.EmbedFontInfo;
import org.docx4j.fonts.fop.fonts.FontCache;
import org.docx4j.fonts.fop.fonts.FontEventListener;
import org.docx4j.fonts.fop.fonts.FontManager;
import org.docx4j.fonts.fop.fonts.autodetect.FontInfoFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontAdder {
    protected static Logger log = LoggerFactory.getLogger(FontAdder.class);
    private final FontEventListener listener;
    private final InternalResourceResolver resourceResolver;
    private final FontManager manager;

    public FontAdder(FontManager manager, InternalResourceResolver resourceResolver, FontEventListener listener) {
        this.manager = manager;
        this.resourceResolver = resourceResolver;
        this.listener = listener;
    }

    public void add(List<URL> fontURLList, List<EmbedFontInfo> fontInfoList) throws URISyntaxException {
        FontCache cache = this.manager.getFontCache();
        FontInfoFinder finder = new FontInfoFinder();
        finder.setEventListener(this.listener);
        for (URL fontURL : fontURLList) {
            EmbedFontInfo[] embedFontInfos = finder.find(fontURL.toURI(), this.resourceResolver, cache);
            if (embedFontInfos == null) {
                if (finder.log.isDebugEnabled()) {
                    log.warn("Aborting: " + fontURL.toString());
                    continue;
                }
                log.warn("Aborting: " + fontURL.toString() + " (to investigate, set org.docx4j.fonts.fop.fonts.autodetect.FontInfoFinder to DEBUG)");
                continue;
            }
            for (EmbedFontInfo fontInfo : embedFontInfos) {
                if (fontInfo == null) continue;
                fontInfoList.add(fontInfo);
            }
        }
    }
}

