/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.fields;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.docx4j.XmlUtils;
import org.docx4j.wml.CTSimpleField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class FldSimpleModel {
    private static Logger log = LoggerFactory.getLogger(FldSimpleModel.class);
    protected CTSimpleField fldSimple = null;
    protected Node content = null;
    protected String fldName = null;
    protected String fldParameterString = null;
    protected List<String> fldParameters = null;

    public void build(CTSimpleField fldSimple, Node content) throws TransformerException {
        this.fldSimple = fldSimple;
        if (log.isDebugEnabled()) {
            log.debug("\n" + XmlUtils.marshaltoString((Object)fldSimple, true, true));
        }
        this.content = content;
        this.setupNameParameterString(fldSimple.getInstr());
    }

    public void build(String inStr) throws TransformerException {
        this.reset();
        this.setupNameParameterString(inStr);
    }

    protected void setupNameParameterString(String text) {
        int nameEnd = 0;
        if (text != null && text.length() > 0) {
            int nameStart;
            for (nameStart = 0; nameStart < text.length() && text.charAt(nameStart) == ' '; ++nameStart) {
            }
            if (nameStart < text.length()) {
                if (text.charAt(nameStart) != '=') {
                    for (nameEnd = nameStart + 1; nameEnd < text.length() && text.charAt(nameEnd) != ' '; ++nameEnd) {
                    }
                }
            }
            if (nameStart < nameEnd) {
                this.fldName = text.substring(nameStart, nameEnd);
                log.debug("fldName: " + this.fldName);
                if (nameEnd < text.length()) {
                    this.fldParameterString = text.substring(nameEnd).trim();
                    log.debug("fldParameterString: " + this.fldParameterString);
                }
            }
        }
        if (this.fldName != null) {
            this.fldName = this.fldName.toUpperCase();
        }
    }

    public static List<String> splitParameters(String text) {
        log.debug("splitParameters: " + text);
        ArrayList<String> ret = Collections.EMPTY_LIST;
        int valStart = -1;
        boolean inLiteral = false;
        char ch = '\u0000';
        if (text != null && text.length() > 0) {
            ret = new ArrayList<String>(4);
            for (int chidx = 0; chidx < text.length(); ++chidx) {
                ch = text.charAt(chidx);
                if (ch == '\"') {
                    if (inLiteral) {
                        FldSimpleModel.appendParameter(ret, text.substring(valStart, chidx + 1));
                        inLiteral = false;
                        valStart = -1;
                        continue;
                    }
                    valStart = chidx;
                    inLiteral = true;
                    continue;
                }
                if (ch == ' ') {
                    if (valStart <= -1 || inLiteral) continue;
                    FldSimpleModel.appendParameter(ret, text.substring(valStart, chidx));
                    valStart = -1;
                    continue;
                }
                if (valStart != -1) continue;
                valStart = chidx;
            }
            if (valStart > -1) {
                FldSimpleModel.appendParameter(ret, text.substring(valStart));
                valStart = -1;
            }
        }
        return ret;
    }

    public static void appendParameter(List<String> parameters, String value) {
        log.debug("parameter: " + value);
        parameters.add(value);
    }

    public String getFldName() {
        return this.fldName;
    }

    public String getFldArgument() {
        return this.getFldParameters().get(0);
    }

    public String getFldParameterString() {
        return this.fldParameterString;
    }

    public List<String> getFldParameters() {
        if (this.fldParameters == null) {
            this.fldParameters = FldSimpleModel.splitParameters(this.fldParameterString);
        }
        return this.fldParameters;
    }

    public CTSimpleField getFldSimple() {
        return this.fldSimple;
    }

    public Node getContent() {
        return this.content;
    }

    protected void reset() {
        this.fldSimple = null;
        this.content = null;
        this.fldName = null;
        this.fldParameterString = null;
        this.fldParameters = null;
    }
}

