/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.shapes;

import java.io.InputStream;
import java.util.LinkedHashMap;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTCustomGeometry2D;
import org.docx4j.jaxb.Context;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PresetGeometries
extends LinkedHashMap<String, CTCustomGeometry2D> {
    private static Logger log = LoggerFactory.getLogger(PresetGeometries.class);
    private static PresetGeometries _inst;

    public static PresetGeometries getInstance() {
        if (_inst == null) {
            _inst = new PresetGeometries();
        }
        return _inst;
    }

    private PresetGeometries() {
        try {
            InputStream is = ResourceUtils.getResource("org/docx4j/model/shapes/presetShapeDefinitions.xml");
            this.read(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void read(InputStream is) throws Exception {
        Document domDoc = XmlUtils.getNewDocumentBuilder().parse(is);
        Element presetShapeDefinitons = domDoc.getDocumentElement();
        NodeList nodes = presetShapeDefinitons.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            String name = node.getLocalName();
            CTCustomGeometry2D geom = (CTCustomGeometry2D)XmlUtils.unmarshal(node, Context.jc, CTCustomGeometry2D.class);
            if (this.containsKey(name)) {
                log.warn("Duplicate definition of " + name);
            }
            this.put(name, geom);
            log.debug(name);
        }
    }
}

