/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.dynamictp.common.em.NotifyItemEnum;
import org.dromara.dynamictp.common.util.StringUtil;

public class NotifyItem {
    private List<String> platformIds;
    private boolean enabled = true;
    private String type;
    private int threshold;
    private int interval = 120;
    private int clusterLimit = 1;
    private String receivers;

    public static List<NotifyItem> mergeAllNotifyItems(List<NotifyItem> source) {
        if (CollectionUtils.isEmpty(source)) {
            return NotifyItem.getAllNotifyItems();
        }
        List configuredTypes = source.stream().map(NotifyItem::getType).collect(Collectors.toList());
        List defaultItems = NotifyItem.getAllNotifyItems().stream().filter(t -> !StringUtil.containsIgnoreCase((CharSequence)t.getType(), configuredTypes)).collect(Collectors.toList());
        ArrayList<NotifyItem> notifyItems = new ArrayList<NotifyItem>(6);
        notifyItems.addAll(defaultItems);
        notifyItems.addAll(source);
        return notifyItems;
    }

    public static List<NotifyItem> getAllNotifyItems() {
        NotifyItem rejectNotify = new NotifyItem();
        rejectNotify.setType(NotifyItemEnum.REJECT.getValue());
        rejectNotify.setThreshold(10);
        NotifyItem runTimeoutNotify = new NotifyItem();
        runTimeoutNotify.setType(NotifyItemEnum.RUN_TIMEOUT.getValue());
        runTimeoutNotify.setThreshold(10);
        NotifyItem queueTimeoutNotify = new NotifyItem();
        queueTimeoutNotify.setType(NotifyItemEnum.QUEUE_TIMEOUT.getValue());
        queueTimeoutNotify.setThreshold(10);
        ArrayList<NotifyItem> notifyItems = new ArrayList<NotifyItem>(6);
        notifyItems.addAll(NotifyItem.getSimpleNotifyItems());
        notifyItems.add(rejectNotify);
        notifyItems.add(runTimeoutNotify);
        notifyItems.add(queueTimeoutNotify);
        return notifyItems;
    }

    public static List<NotifyItem> getSimpleNotifyItems() {
        NotifyItem changeNotify = new NotifyItem();
        changeNotify.setType(NotifyItemEnum.CHANGE.getValue());
        changeNotify.setInterval(1);
        NotifyItem livenessNotify = new NotifyItem();
        livenessNotify.setType(NotifyItemEnum.LIVENESS.getValue());
        livenessNotify.setThreshold(70);
        NotifyItem capacityNotify = new NotifyItem();
        capacityNotify.setType(NotifyItemEnum.CAPACITY.getValue());
        capacityNotify.setThreshold(70);
        ArrayList<NotifyItem> notifyItems = new ArrayList<NotifyItem>(3);
        notifyItems.add(livenessNotify);
        notifyItems.add(changeNotify);
        notifyItems.add(capacityNotify);
        return notifyItems;
    }

    public List<String> getPlatformIds() {
        return this.platformIds;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getType() {
        return this.type;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getClusterLimit() {
        return this.clusterLimit;
    }

    public String getReceivers() {
        return this.receivers;
    }

    public void setPlatformIds(List<String> platformIds) {
        this.platformIds = platformIds;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setClusterLimit(int clusterLimit) {
        this.clusterLimit = clusterLimit;
    }

    public void setReceivers(String receivers) {
        this.receivers = receivers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotifyItem)) {
            return false;
        }
        NotifyItem other = (NotifyItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getThreshold() != other.getThreshold()) {
            return false;
        }
        if (this.getInterval() != other.getInterval()) {
            return false;
        }
        if (this.getClusterLimit() != other.getClusterLimit()) {
            return false;
        }
        List<String> this$platformIds = this.getPlatformIds();
        List<String> other$platformIds = other.getPlatformIds();
        if (this$platformIds == null ? other$platformIds != null : !((Object)this$platformIds).equals(other$platformIds)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$receivers = this.getReceivers();
        String other$receivers = other.getReceivers();
        return !(this$receivers == null ? other$receivers != null : !this$receivers.equals(other$receivers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotifyItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getThreshold();
        result = result * 59 + this.getInterval();
        result = result * 59 + this.getClusterLimit();
        List<String> $platformIds = this.getPlatformIds();
        result = result * 59 + ($platformIds == null ? 43 : ((Object)$platformIds).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $receivers = this.getReceivers();
        result = result * 59 + ($receivers == null ? 43 : $receivers.hashCode());
        return result;
    }

    public String toString() {
        return "NotifyItem(platformIds=" + this.getPlatformIds() + ", enabled=" + this.isEnabled() + ", type=" + this.getType() + ", threshold=" + this.getThreshold() + ", interval=" + this.getInterval() + ", clusterLimit=" + this.getClusterLimit() + ", receivers=" + this.getReceivers() + ")";
    }
}

