/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.mail;

import java.nio.charset.Charset;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.extra.mail.MailAccount;

public enum GlobalMailAccount {
    INSTANCE;

    private static final String SPLIT_LONG_PARAMS = "mail.mime.splitlongparameters";
    private static final String CHARSET = "mail.mime.charset";
    private final MailAccount mailAccount = this.createDefaultAccount();

    public MailAccount getAccount() {
        return this.mailAccount;
    }

    public void setSplitLongParams(boolean splitLongParams) {
        System.setProperty(SPLIT_LONG_PARAMS, String.valueOf(splitLongParams));
    }

    public void setCharset(Charset charset) {
        System.setProperty(CHARSET, charset.name());
    }

    private MailAccount createDefaultAccount() {
        for (String mailSettingPath : MailAccount.MAIL_SETTING_PATHS) {
            try {
                return new MailAccount(mailSettingPath);
            }
            catch (IORuntimeException iORuntimeException) {
            }
        }
        return null;
    }

    static {
        System.setProperty(SPLIT_LONG_PARAMS, "false");
        System.setProperty(CHARSET, GlobalMailAccount.INSTANCE.mailAccount.getCharset().name());
    }
}

