/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.stats;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.internal.stats.ClassStats;
import org.eclipse.core.runtime.internal.stats.ResourceBundleStats;
import org.eclipse.core.runtime.internal.stats.StatsManager;

public class ClassloaderStats {
    private String id;
    private long loadingTime;
    private int failureCount = 0;
    private Map classes = Collections.synchronizedMap(new HashMap(20));
    private ArrayList bundles = new ArrayList(2);
    private boolean keepTraces = false;
    private static ArrayList packageFilters = new ArrayList(4);
    private static Set pluginFilters = new HashSet(5);
    private static Stack classStack = new Stack();
    private static Map loaders = Collections.synchronizedMap(new HashMap(20));
    public static File traceFile;

    static {
        if (StatsManager.TRACE_CLASSES || StatsManager.TRACE_BUNDLES) {
            ClassloaderStats.initializeTraceOptions();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initializeTraceOptions() {
        String filename = StatsManager.TRACE_FILENAME;
        traceFile = new File(filename);
        traceFile.delete();
        if (!StatsManager.TRACE_CLASSES) {
            return;
        }
        filename = StatsManager.TRACE_FILTERS;
        if (filename == null) return;
        if (filename.length() == 0) {
            return;
        }
        try {
            File filterFile = new File(filename);
            System.out.print("Runtime tracing elements defined in: " + filterFile.getAbsolutePath() + "...");
            FileInputStream input = new FileInputStream(filterFile);
            System.out.println("  Loaded.");
            Properties filters = new Properties(){
                private static final long serialVersionUID = 3546359543853365296L;

                public Object put(Object key, Object value) {
                    ClassloaderStats.addFilters((String)key, (String)value);
                    return null;
                }
            };
            try {
                filters.load(input);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                ((InputStream)input).close();
                throw throwable;
            }
            {
                Object var4_6 = null;
                ((InputStream)input).close();
                return;
            }
        }
        catch (IOException iOException) {
            System.out.println("  No trace filters loaded.");
        }
    }

    protected static void addFilters(String key, String value) {
        String[] filters = StatsManager.getArrayFromList(value);
        if ("plugins".equals(key)) {
            pluginFilters.addAll(Arrays.asList(filters));
        }
        if ("packages".equals(key)) {
            packageFilters.addAll(Arrays.asList(filters));
        }
    }

    public static void startLoadingClass(String id, String className) {
        ClassloaderStats.findLoader(id).startLoadClass(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassloaderStats findLoader(String id) {
        Map map = loaders;
        synchronized (map) {
            ClassloaderStats result = (ClassloaderStats)loaders.get(id);
            if (result == null) {
                result = new ClassloaderStats(id);
                loaders.put(id, result);
            }
            return result;
        }
    }

    public static Stack getClassStack() {
        return classStack;
    }

    public static ClassloaderStats[] getLoaders() {
        return loaders.values().toArray(new ClassloaderStats[0]);
    }

    public static void endLoadingClass(String id, String className, boolean success) {
        ClassloaderStats.findLoader(id).endLoadClass(className, success);
    }

    public static void loadedBundle(String id, ResourceBundleStats info) {
        ClassloaderStats.findLoader(id).loadedBundle(info);
    }

    public static ClassloaderStats getLoader(String id) {
        return (ClassloaderStats)loaders.get(id);
    }

    public ClassloaderStats(String id) {
        this.id = id;
        this.keepTraces = pluginFilters.contains(id);
    }

    public void addBaseClasses(String[] baseClasses) {
        int i = 0;
        while (i < baseClasses.length) {
            String name = baseClasses[i];
            if (this.classes.get(name) == null) {
                ClassStats value = new ClassStats(name, this);
                value.toBaseClass();
                this.classes.put(name, value);
            }
            ++i;
        }
    }

    private void loadedBundle(ResourceBundleStats bundle) {
        this.bundles.add(bundle);
    }

    public ArrayList getBundles() {
        return this.bundles;
    }

    private synchronized void startLoadClass(String name) {
        classStack.push(this.findClass(name));
    }

    private ClassStats findClass(String name) {
        ClassStats result = (ClassStats)this.classes.get(name);
        return result == null ? new ClassStats(name, this) : result;
    }

    private synchronized void endLoadClass(String name, boolean success) {
        ClassStats current = (ClassStats)classStack.pop();
        if (!success) {
            ++this.failureCount;
            return;
        }
        if (current.getLoadOrder() >= 0) {
            return;
        }
        this.classes.put(name, current);
        current.setLoadOrder(this.classes.size());
        current.loadingDone();
        this.traceLoad(name, current);
        if (classStack.size() != 0) {
            ClassStats previous = (ClassStats)classStack.peek();
            previous.addTimeLoadingOthers(current.getTimeLoading());
            current.setLoadedBy(previous);
            previous.loaded(current);
        } else {
            this.loadingTime += current.getTimeLoading();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void traceLoad(String name, ClassStats target) {
        int i;
        if (!this.keepTraces) {
            boolean found = false;
            i = 0;
            while (true) {
                if (found || i >= packageFilters.size()) {
                    if (found) break;
                    return;
                }
                if (name.startsWith((String)packageFilters.get(i))) {
                    found = true;
                }
                ++i;
            }
        }
        try {
            target.setTraceStart(traceFile.length());
            PrintWriter output = new PrintWriter(new FileOutputStream(traceFile.getAbsolutePath(), true));
            try {
                output.println("Loading class: " + name);
                output.println("Class loading stack:");
                output.println("\t" + name);
                i = classStack.size() - 1;
                while (true) {
                    block10: {
                        if (i >= 0) break block10;
                        output.println("Stack trace:");
                        new Throwable().printStackTrace(output);
                        break;
                    }
                    output.println("\t" + ((ClassStats)classStack.get(i)).getClassName());
                    --i;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                output.close();
                throw throwable;
            }
            {
                Object var5_9 = null;
                output.close();
                target.setTraceEnd(traceFile.length());
                return;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public int getClassLoadCount() {
        return this.classes.size();
    }

    public long getClassLoadTime() {
        return this.loadingTime;
    }

    public ClassStats[] getClasses() {
        return this.classes.values().toArray(new ClassStats[0]);
    }

    public String getId() {
        return this.id;
    }
}

