/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.File;
import java.io.IOException;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.resolver.ReadOnlyState;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateObjectFactoryImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class StateManager
implements PlatformAdmin,
Runnable {
    public static boolean DEBUG = false;
    public static boolean DEBUG_READER = false;
    public static boolean DEBUG_PLATFORM_ADMIN = false;
    public static boolean DEBUG_PLATFORM_ADMIN_RESOLVER = false;
    public static boolean MONITOR_PLATFORM_ADMIN = false;
    public static String PROP_NO_LAZY_LOADING = "osgi.noLazyStateLoading";
    public static String PROP_LAZY_UNLOADING_TIME = "osgi.lazyStateUnloadingTime";
    private long expireTime = 300000L;
    private long readStartupTime;
    private StateImpl systemState;
    private StateObjectFactoryImpl factory;
    private long lastTimeStamp;
    private boolean cachedState = false;
    private File stateFile;
    private File lazyFile;
    private long expectedTimeStamp;
    private BundleContext context;
    private Thread dataManagerThread;

    public StateManager(File stateFile, File lazyFile, BundleContext context) {
        this(stateFile, lazyFile, context, -1L);
    }

    public StateManager(File stateFile, File lazyFile, BundleContext context, long expectedTimeStamp) {
        this.stateFile = stateFile;
        this.lazyFile = lazyFile;
        this.context = context;
        this.expectedTimeStamp = expectedTimeStamp;
        this.factory = new StateObjectFactoryImpl();
    }

    public void shutdown(File stateFile, File lazyFile) throws IOException {
        BundleDescription[] removalPendings = this.systemState.getRemovalPendings();
        if (removalPendings.length > 0) {
            this.systemState.resolve(removalPendings);
        }
        this.writeState(this.systemState, stateFile, lazyFile);
        this.stopDataManager();
    }

    public void update(File stateFile, File lazyFile) throws IOException {
        BundleDescription[] removalPendings = this.systemState.getRemovalPendings();
        StateImpl state = this.systemState;
        if (removalPendings.length > 0) {
            state = (StateImpl)state.getFactory().createState(this.systemState);
            state.setResolver(this.getResolver(System.getSecurityManager() != null));
            state.setPlatformProperties(FrameworkProperties.getProperties());
            state.resolve(false);
        }
        this.writeState(state, stateFile, lazyFile);
        this.lastTimeStamp = state.getTimeStamp();
    }

    /*
     * Exception decompiling
     */
    private void readSystemState(File stateFile, File lazyFile, long expectedTimeStamp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 198->202)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void startDataManager() {
        if (this.dataManagerThread != null) {
            return;
        }
        this.dataManagerThread = new Thread((Runnable)this, "State Data Manager");
        this.dataManagerThread.setDaemon(true);
        this.dataManagerThread.start();
    }

    public synchronized void stopDataManager() {
        if (this.dataManagerThread == null) {
            return;
        }
        this.dataManagerThread.interrupt();
        this.dataManagerThread = null;
    }

    private void writeState(StateImpl state, File stateFile, File lazyFile) throws IOException {
        if (state == null) {
            return;
        }
        if (this.cachedState && !this.saveNeeded()) {
            return;
        }
        state.fullyLoad();
        this.factory.writeState(state, stateFile, lazyFile);
    }

    private boolean initializeSystemState() {
        this.systemState.setResolver(this.getResolver(System.getSecurityManager() != null));
        this.lastTimeStamp = this.systemState.getTimeStamp();
        return !this.systemState.setPlatformProperties(FrameworkProperties.getProperties());
    }

    public synchronized State createSystemState() {
        if (this.systemState == null) {
            this.systemState = this.factory.createSystemState();
            this.initializeSystemState();
        }
        return this.systemState;
    }

    public synchronized State readSystemState() {
        if (this.systemState == null) {
            this.readSystemState(this.stateFile, this.lazyFile, this.expectedTimeStamp);
        }
        return this.systemState;
    }

    public State getSystemState() {
        return this.systemState;
    }

    public long getCachedTimeStamp() {
        return this.lastTimeStamp;
    }

    public boolean saveNeeded() {
        return this.systemState.getTimeStamp() != this.lastTimeStamp || this.systemState.dynamicCacheChanged();
    }

    public State getState(boolean mutable) {
        return mutable ? this.factory.createState(this.systemState) : new ReadOnlyState(this.systemState);
    }

    public State getState() {
        return this.getState(true);
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    public synchronized void commit(State state) throws BundleException {
        throw new IllegalArgumentException("PlatformAdmin.commit() not supported");
    }

    public Resolver getResolver() {
        return this.getResolver(false);
    }

    private Resolver getResolver(boolean checkPermissions) {
        return new ResolverImpl(this.context, checkPermissions);
    }

    public StateHelper getStateHelper() {
        return StateHelperImpl.getInstance();
    }

    public void run() {
        long timeStamp = this.lastTimeStamp;
        while (true) {
            try {
                Thread.sleep(this.expireTime);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (this.systemState == null || timeStamp != this.systemState.getTimeStamp() || this.systemState.dynamicCacheChanged()) continue;
            this.systemState.unloadLazyData(this.expireTime);
        }
    }
}

