/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.SequenceFlow;

public class SequenceFlowXMLConverter
extends BaseBpmnXMLConverter {
    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return SequenceFlow.class;
    }

    @Override
    protected String getXMLElementName() {
        return "sequenceFlow";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        SequenceFlow sequenceFlow = new SequenceFlow();
        BpmnXMLUtil.addXMLLocation((BaseElement)sequenceFlow, xtr);
        sequenceFlow.setSourceRef(xtr.getAttributeValue(null, "sourceRef"));
        sequenceFlow.setTargetRef(xtr.getAttributeValue(null, "targetRef"));
        sequenceFlow.setName(xtr.getAttributeValue(null, "name"));
        sequenceFlow.setSkipExpression(xtr.getAttributeValue(null, "skipExpression"));
        this.parseChildElements(this.getXMLElementName(), (BaseElement)sequenceFlow, model, xtr);
        return sequenceFlow;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        SequenceFlow sequenceFlow = (SequenceFlow)element;
        this.writeDefaultAttribute("sourceRef", sequenceFlow.getSourceRef(), xtw);
        this.writeDefaultAttribute("targetRef", sequenceFlow.getTargetRef(), xtw);
        if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getSkipExpression())) {
            this.writeDefaultAttribute("skipExpression", sequenceFlow.getSkipExpression(), xtw);
        }
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        SequenceFlow sequenceFlow = (SequenceFlow)element;
        if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getConditionExpression())) {
            xtw.writeStartElement("conditionExpression");
            xtw.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "tFormalExpression");
            String conditionExpression = sequenceFlow.getConditionExpression();
            if (StringUtils.isNotEmpty((CharSequence)conditionExpression)) {
                conditionExpression = conditionExpression.replace("<![CDATA[", "").replace("]]>", "");
            }
            xtw.writeCData(conditionExpression);
            xtw.writeEndElement();
        }
    }
}

