/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.camel;

import org.apache.camel.CamelContext;
import org.apache.commons.lang3.StringUtils;
import org.flowable.camel.CamelBehavior;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.spring.SpringProcessEngineConfiguration;

public abstract class SpringCamelBehavior
extends CamelBehavior {
    private static final long serialVersionUID = 1L;

    @Override
    protected void setAppropriateCamelContext(DelegateExecution execution) {
        String camelContextValue = this.getStringFromField(this.camelContext, execution);
        if (!StringUtils.isEmpty((CharSequence)camelContextValue) || this.camelContextObj == null) {
            ProcessEngineConfigurationImpl engineConfiguration = org.flowable.engine.impl.context.Context.getProcessEngineConfiguration();
            if (Context.getCommandContext() != null && Flowable5Util.isFlowable5ProcessDefinitionId((CommandContext)Context.getCommandContext(), (String)execution.getProcessDefinitionId()) || Context.getCommandContext() == null && Flowable5Util.getFlowable5CompatibilityHandler() != null) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                this.camelContextObj = (CamelContext)compatibilityHandler.getCamelContextObject(camelContextValue);
            } else {
                try {
                    Object ctx;
                    SpringProcessEngineConfiguration springConfiguration = (SpringProcessEngineConfiguration)engineConfiguration;
                    if (StringUtils.isEmpty((CharSequence)camelContextValue) && this.camelContextObj == null) {
                        camelContextValue = springConfiguration.getDefaultCamelContext();
                    }
                    if (!((ctx = springConfiguration.getApplicationContext().getBean(camelContextValue)) instanceof CamelContext)) {
                        throw new FlowableException("Could not find CamelContext named " + camelContextValue + ".");
                    }
                    this.camelContextObj = (CamelContext)ctx;
                }
                catch (Exception e) {
                    throw new FlowableException("Expecting a SpringProcessEngineConfiguration for the Camel module.", (Throwable)e);
                }
            }
        }
    }
}

