/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.process.restart;

import com.pangubpm.process.restart.BadUserRequestException;
import com.pangubpm.process.restart.EnsureUtil;
import com.pangubpm.process.restart.InstructionsVO;
import com.pangubpm.process.restart.PanguProcessInstanceHelper;
import com.pangubpm.process.restart.RestartProcessInstanceModelLogDao;
import com.pangubpm.process.restart.RestartProcessInstanceModelLogEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.HistoryService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricDetail;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricVariableUpdate;
import org.flowable.engine.impl.HistoricDetailQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.AbstractCustomSqlExecution;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;

public class RestartProcessInstancesCmd
implements Command<List<ProcessInstance>> {
    protected Collection<String> processInstanceIds;
    protected boolean writeUserOperationLog;
    protected String processDefinitionId = "";
    protected String bizKey = "";
    private List<String> users;
    protected List<InstructionsVO> instructionsVOS;

    public RestartProcessInstancesCmd(Collection<String> processInstanceIds, String processDefinitionId, List<InstructionsVO> instructionsVOS, List<String> users, String bizKey) {
        this.processInstanceIds = processInstanceIds;
        this.processDefinitionId = processDefinitionId;
        this.instructionsVOS = instructionsVOS;
        this.users = users;
        this.bizKey = bizKey;
    }

    public List<ProcessInstance> execute(CommandContext commandContext) {
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot be empty", "Process instance ids", this.processInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Process instance ids cannot be null", "Process instance ids", this.processInstanceIds);
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(this.processDefinitionId, false);
        EnsureUtil.ensureNotNull("Process definition cannot be found", "processDefinition", (Object)processDefinition);
        Object[] objects = this.processInstanceIds.toArray();
        ArrayList<ProcessInstance> result = new ArrayList<ProcessInstance>();
        for (int i = 0; i < this.processInstanceIds.size(); ++i) {
            String startFlowElementId = "";
            String processInstanceId = objects[i].toString();
            String operateType = "";
            if (this.instructionsVOS.size() == this.processInstanceIds.size()) {
                startFlowElementId = this.instructionsVOS.get(i).getActivityId();
                operateType = this.instructionsVOS.get(i).getType();
            } else {
                startFlowElementId = this.instructionsVOS.get(0).getActivityId();
                operateType = this.instructionsVOS.get(0).getType();
            }
            HistoricProcessInstance historicProcessInstance = this.getHistoricProcessInstance(commandContext, processInstanceId);
            EnsureUtil.ensureNotNull(BadUserRequestException.class, "Historic process instance cannot be found", "historicProcessInstanceId", (Object)historicProcessInstance);
            this.ensureHistoricProcessInstanceNotActive(historicProcessInstance);
            this.ensureSameProcessDefinition(historicProcessInstance, this.processDefinitionId);
            Map<String, Object> variables = new HashMap();
            try {
                variables = this.collectVariables(commandContext, historicProcessInstance);
            }
            catch (Exception e) {
                variables = new HashMap();
            }
            variables.put("restart", true);
            variables.put("users", this.users);
            variables.put("restart_processInstanceId", processInstanceId);
            PanguProcessInstanceHelper panguProcessInstanceHelper = new PanguProcessInstanceHelper();
            ProcessInstance processInstance = panguProcessInstanceHelper.createAndStartProcessInstance(processDefinition, this.bizKey, historicProcessInstance.getName(), variables, null, startFlowElementId, operateType);
            RestartProcessInstanceModelLogEntity a1RestartProcessInstanceModelLogEntity = new RestartProcessInstanceModelLogEntity();
            a1RestartProcessInstanceModelLogEntity.setActivityId(startFlowElementId);
            a1RestartProcessInstanceModelLogEntity.setDeadProcId(processInstanceId);
            a1RestartProcessInstanceModelLogEntity.setProcId(processInstance.getId());
            a1RestartProcessInstanceModelLogEntity.setProcDefId(this.processDefinitionId);
            a1RestartProcessInstanceModelLogEntity.setOperateType(operateType);
            a1RestartProcessInstanceModelLogEntity.setStatus("0");
            RestartProcessInstancesCmd.insertLog(CommandContextUtil.getProcessEngineConfiguration(), a1RestartProcessInstanceModelLogEntity);
            result.add(processInstance);
        }
        return result;
    }

    public static void insertLog(ProcessEngineConfigurationImpl processEngineConfiguration, final RestartProcessInstanceModelLogEntity a1RestartProcessInstanceModelLogEntity) {
        ManagementService managementService = processEngineConfiguration.getManagementService();
        AbstractCustomSqlExecution<RestartProcessInstanceModelLogDao, Integer> customSqlExecution = new AbstractCustomSqlExecution<RestartProcessInstanceModelLogDao, Integer>(RestartProcessInstanceModelLogDao.class){

            public Integer execute(RestartProcessInstanceModelLogDao a1ProcessInstanceLogDao) {
                return a1ProcessInstanceLogDao.insert(a1RestartProcessInstanceModelLogEntity);
            }
        };
        managementService.executeCustomSql(customSqlExecution);
    }

    protected HistoricProcessInstance getHistoricProcessInstance(CommandContext commandContext, String processInstanceId) {
        HistoryService historyService = CommandContextUtil.getProcessEngineConfiguration().getHistoryService();
        return (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
    }

    protected ProcessEngineConfigurationImpl getProcessEngineConfigurationImpl() {
        ProcessEngineConfigurationImpl processEngineConfigurationImpl = CommandContextUtil.getProcessEngineConfiguration();
        return processEngineConfigurationImpl;
    }

    protected void ensureSameProcessDefinition(HistoricProcessInstance instance, String processDefinitionId) {
        if (!processDefinitionId.equals(instance.getProcessDefinitionId())) {
            // empty if block
        }
    }

    protected void ensureHistoricProcessInstanceNotActive(HistoricProcessInstance instance) {
        if (instance.getEndTime() == null) {
            // empty if block
        }
    }

    protected Map collectVariables(CommandContext commandContext, HistoricProcessInstance processInstance) {
        Map variables = null;
        variables = this.collectInitialVariables(commandContext, processInstance);
        return variables;
    }

    protected Map collectInitialVariables(CommandContext commandContext, HistoricProcessInstance processInstance) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HistoryService historyService = CommandContextUtil.getProcessEngineConfiguration().getHistoryService();
        HistoricActivityInstance startActivityInstance = this.resolveStartActivityInstance(processInstance);
        HistoricDetailQueryImpl query = (HistoricDetailQueryImpl)historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId());
        List historicDetails = query.list();
        for (HistoricDetail detail : historicDetails) {
            HistoricVariableUpdate variableUpdate = (HistoricVariableUpdate)detail;
            result.put(variableUpdate.getVariableName(), variableUpdate.getValue());
        }
        return result;
    }

    protected Map collectLastVariables(CommandContext commandContext, HistoricProcessInstance processInstance) {
        HistoryService historyService = CommandContextUtil.getProcessEngineConfiguration().getHistoryService();
        List historicVariables = historyService.createHistoricVariableInstanceQuery().list();
        return null;
    }

    protected HistoricActivityInstance resolveStartActivityInstance(HistoricProcessInstance processInstance) {
        HistoryService historyService = CommandContextUtil.getProcessEngineConfiguration().getHistoryService();
        String processInstanceId = processInstance.getId();
        String startActivityId = processInstance.getStartActivityId();
        EnsureUtil.ensureNotNull("startActivityId", (Object)startActivityId);
        List historicActivityInstances = historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityId(startActivityId).list();
        EnsureUtil.ensureNotEmpty("historicActivityInstances", historicActivityInstances);
        HistoricActivityInstance startActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
        return startActivityInstance;
    }
}

