/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.addnode;

import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.engine.addnode.CallActivityInfo;
import org.flowable.engine.addnode.NodeModel;
import org.flowable.engine.addnode.SignNodeInfo;
import org.flowable.engine.impl.bpmn.behavior.CallActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.flowable.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.flowable.engine.impl.bpmn.behavior.ServiceTaskDelegateExpressionActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.flowable.engine.impl.bpmn.parser.factory.ActivityBehaviorFactory;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.delegate.ActivityBehavior;

public class NodeElementModel {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected FlowNode addNodeInfo;
    protected String preNodeId;
    protected String nextNodeId;
    private NodeType nodeType;
    protected Object behavior;
    protected SignNodeInfo signNodeInfo;
    protected CallActivityInfo callActivityInfo;

    public SignNodeInfo getSignNodeInfo() {
        return this.signNodeInfo;
    }

    public void setSignNodeInfo(SignNodeInfo signNodeInfo) {
        this.signNodeInfo = signNodeInfo;
    }

    public FlowElement getAddNodeInfo() {
        return this.addNodeInfo;
    }

    public void setAddNodeInfo(FlowNode addNodeInfo) {
        this.addNodeInfo = addNodeInfo;
    }

    public String getPreNodeId() {
        return this.preNodeId;
    }

    public void setPreNodeId(String preNodeId) {
        this.preNodeId = preNodeId;
    }

    public String getNextNodeId() {
        return this.nextNodeId;
    }

    public void setNextNodeId(String nextNodeId) {
        this.nextNodeId = nextNodeId;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeType nodeType) {
        this.init(nodeType);
    }

    public NodeElementModel(ProcessEngineConfigurationImpl processEngineConfiguration, NodeModel nodeModel) {
        this.processEngineConfiguration = processEngineConfiguration;
        this.callActivityInfo = nodeModel.getCallActivityInfo();
        this.addNodeInfo = this.converModelToExcute(nodeModel);
        this.signNodeInfo = nodeModel.getSignNodeInfo();
    }

    private FlowNode converModelToExcute(NodeModel nodeModel) {
        ActivityBehaviorFactory activityBehaviorFactory = this.processEngineConfiguration.getProcessEngineConfiguration().getActivityBehaviorFactory();
        UserTask result = null;
        switch (nodeModel.getNodeType()) {
            case USERTASK: {
                UserTask userTask = new UserTask();
                userTask.setId(nodeModel.getId());
                userTask.setName(nodeModel.getName());
                userTask.setAssignee(nodeModel.getDoUserId());
                this.addNodeInfo = userTask;
                UserTaskActivityBehavior userTaskActivityBehavior1 = activityBehaviorFactory.createUserTaskActivityBehavior((UserTask)this.addNodeInfo);
                this.fillPostProperty((FlowNode)userTask, nodeModel, userTaskActivityBehavior1, NodeType.USERTASK);
                result = userTask;
                break;
            }
            case SERVICETASK: {
                ServiceTask serviceTask = new ServiceTask();
                serviceTask.setId(nodeModel.getId());
                serviceTask.setName(nodeModel.getName());
                serviceTask.setImplementation("#{serviceTaskInAddOperate}");
                serviceTask.setTriggerable(false);
                this.addNodeInfo = serviceTask;
                ServiceTaskDelegateExpressionActivityBehavior serviceTaskDelegateExpressionActivityBehavior = activityBehaviorFactory.createServiceTaskDelegateExpressionActivityBehavior((ServiceTask)this.addNodeInfo);
                this.fillPostProperty((FlowNode)serviceTask, nodeModel, serviceTaskDelegateExpressionActivityBehavior, NodeType.SERVICETASK);
                result = serviceTask;
                break;
            }
            case SEQUENTIAL: {
                UserTask userTask1 = new UserTask();
                userTask1.setId(nodeModel.getId());
                userTask1.setName(nodeModel.getName());
                userTask1.setAssignee(nodeModel.getDoUserId());
                MultiInstanceLoopCharacteristics loopCharacteristics = new MultiInstanceLoopCharacteristics();
                loopCharacteristics.setSequential(true);
                loopCharacteristics.setElementVariable("PANGUELEMENTASSIGNEE");
                loopCharacteristics.setInputDataItem("PANGUASSIGNEES");
                userTask1.setLoopCharacteristics(loopCharacteristics);
                this.addNodeInfo = userTask1;
                UserTaskActivityBehavior userTaskActivityBehavior = activityBehaviorFactory.createUserTaskActivityBehavior((UserTask)this.addNodeInfo);
                SequentialMultiInstanceBehavior sequentialMultiInstanceBehavior = activityBehaviorFactory.createSequentialMultiInstanceBehavior((Activity)userTask1, userTaskActivityBehavior);
                this.fillPostProperty((FlowNode)userTask1, nodeModel, sequentialMultiInstanceBehavior, NodeType.SEQUENTIAL);
                sequentialMultiInstanceBehavior.setCollectionElementVariable(loopCharacteristics.getElementVariable());
                sequentialMultiInstanceBehavior.setCollectionElementVariable(loopCharacteristics.getInputDataItem());
                result = userTask1;
                break;
            }
            case PARALLEL: {
                UserTask userTask2 = new UserTask();
                userTask2.setId(nodeModel.getId());
                userTask2.setName(nodeModel.getName());
                userTask2.setAssignee(nodeModel.getDoUserId());
                MultiInstanceLoopCharacteristics loopCharacteristics2 = new MultiInstanceLoopCharacteristics();
                loopCharacteristics2.setSequential(false);
                loopCharacteristics2.setElementVariable("PANGUELEMENTASSIGNEE");
                loopCharacteristics2.setInputDataItem("PANGUASSIGNEES");
                userTask2.setLoopCharacteristics(loopCharacteristics2);
                this.addNodeInfo = userTask2;
                UserTaskActivityBehavior userTaskActivityBehavior2 = activityBehaviorFactory.createUserTaskActivityBehavior((UserTask)this.addNodeInfo);
                ParallelMultiInstanceBehavior parallelMultiInstanceBehavior = activityBehaviorFactory.createParallelMultiInstanceBehavior((Activity)userTask2, userTaskActivityBehavior2);
                this.fillPostProperty((FlowNode)userTask2, nodeModel, parallelMultiInstanceBehavior, NodeType.PARALLEL);
                parallelMultiInstanceBehavior.setCollectionElementVariable(loopCharacteristics2.getElementVariable());
                parallelMultiInstanceBehavior.setCollectionElementVariable(loopCharacteristics2.getInputDataItem());
                result = userTask2;
                break;
            }
            case CALLACTIVITY: {
                if (this.callActivityInfo == null) {
                    throw new FlowableIllegalArgumentException("\u5f15\u7528\u6d3b\u52a8\u4fe1\u606f\u6ca1\u6709\u4f20\u9012");
                }
                CallActivity callActivity = new CallActivity();
                callActivity.setId(nodeModel.getId());
                callActivity.setCalledElementType("key");
                callActivity.setCalledElement(this.callActivityInfo.getCalledElement());
                CallActivityBehavior callActivityBehavior = activityBehaviorFactory.createCallActivityBehavior(callActivity);
                this.addNodeInfo = callActivity;
                this.fillPostProperty((FlowNode)callActivity, nodeModel, callActivityBehavior, NodeType.CALLACTIVITY);
                result = callActivity;
            }
        }
        return result;
    }

    public void fillPostProperty(FlowNode flowNode, NodeModel nodeModel, ActivityBehavior activityBehavior, NodeType nodeType) {
        this.addNodeInfo = flowNode;
        this.addNodeInfo.setBehavior((Object)activityBehavior);
        this.preNodeId = nodeModel.getPreNodeId();
        this.nextNodeId = nodeModel.getNextNodeId();
        this.behavior = activityBehavior;
        this.nodeType = nodeType;
    }

    public NodeElementModel(ProcessEngineConfigurationImpl processEngineConfiguration, FlowNode addNodeInfo, String preNodeId, String nextNodeId, NodeType nodeType) {
        this.processEngineConfiguration = processEngineConfiguration;
        this.addNodeInfo = addNodeInfo;
        this.preNodeId = preNodeId;
        this.nextNodeId = nextNodeId;
        this.nodeType = nodeType;
        this.init(nodeType);
    }

    public Object getBehavior() {
        return this.behavior;
    }

    public void setBehavior(Object behavior) {
        this.behavior = behavior;
    }

    private void init(NodeType nodeType) {
        ActivityBehaviorFactory activityBehaviorFactory = this.processEngineConfiguration.getProcessEngineConfiguration().getActivityBehaviorFactory();
        switch (nodeType) {
            case USERTASK: {
                this.behavior = activityBehaviorFactory.createUserTaskActivityBehavior((UserTask)this.addNodeInfo);
                this.addNodeInfo.setBehavior(this.behavior);
                break;
            }
            case SERVICETASK: {
                this.behavior = activityBehaviorFactory.createServiceTaskExpressionActivityBehavior((ServiceTask)this.addNodeInfo);
            }
        }
    }

    public void setCallActivityInfo(CallActivityInfo callActivityInfo) {
        this.callActivityInfo = callActivityInfo;
    }

    public CallActivityInfo getCallActivityInfo() {
        return this.callActivityInfo;
    }

    public static enum NodeType {
        USERTASK("userTask"),
        SERVICETASK("serviceTask"),
        SEQUENTIAL("sequential"),
        PARALLEL("Parallel"),
        CALLACTIVITY("CallActivity"),
        SUBPROCESS("Subprocess");

        private String name;

        private NodeType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class GenerateActivity {
        public static SequenceFlow generateSequenceFlow(String id, String source, String target) {
            SequenceFlow sequenceFlow = new SequenceFlow();
            sequenceFlow.setId(id);
            sequenceFlow.setSourceRef(source);
            sequenceFlow.setTargetRef(target);
            return sequenceFlow;
        }

        public static UserTask generateUserTask(String id, String name, String assignee) {
            UserTask userTask = new UserTask();
            userTask.setId(id);
            userTask.setAssignee(assignee);
            userTask.setName(name);
            return userTask;
        }
    }
}

