/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.batch.task;

import java.util.List;
import java.util.stream.Collectors;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.calendar.CycleBusinessCalendar;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.batch.task.BatchCompleteTaskResult;
import org.flowable.engine.batch.task.BatchTaskManager;
import org.flowable.engine.batch.task.TaskDataEntity;
import org.flowable.engine.batch.task.TaskEntityDocument;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.jobexecutor.ProcessInstanceMigrationJobHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.JobService;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.service.TaskService;

public class BatchTaskManagerImpl
implements BatchTaskManager {
    @Override
    public Batch batchComplete(String source, String target, TaskEntityDocument document, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        TaskService taskService = CommandContextUtil.getTaskService(commandContext);
        BatchService batchService = CommandContextUtil.getBatchService(commandContext);
        List<TaskDataEntity> taskDataEntities = document.getTaskId();
        List taskIds = taskDataEntities.stream().map(TaskDataEntity::getId).collect(Collectors.toList());
        taskService.updateTaskHided(taskIds);
        Batch batch = batchService.createBatchBuilder().batchType("taskCompleteType").searchKey(source).searchKey2(target).status(BatchCompleteTaskResult.STATUS_IN_PROGRESS).batchDocumentJson(document.asJsonString()).create();
        JobService jobService = CommandContextUtil.getJobService(commandContext);
        for (TaskDataEntity taskDataEntity : taskDataEntities) {
            BatchPart batchPart = batchService.createBatchPart(batch, BatchCompleteTaskResult.STATUS_WAITING, taskDataEntity.getId(), null, "bpmn");
            Task task = (Task)((TaskQuery)taskService.createTaskQuery().taskId(taskDataEntity.getId())).singleResult();
            JobEntity job = jobService.createJob();
            job.setJobHandlerType("process-task-batch-complete-status");
            job.setProcessInstanceId(task.getProcessInstanceId());
            job.setJobHandlerConfiguration(ProcessInstanceMigrationJobHandler.getHandlerCfgForBatchPartId(batchPart.getId()));
            jobService.createAsyncJob(job, false);
            jobService.scheduleAsyncJob(job);
        }
        if (taskIds.size() > 0) {
            TimerJobService timerJobService = CommandContextUtil.getTimerJobService(commandContext);
            TimerJobEntity timerJob = timerJobService.createTimerJob();
            timerJob.setJobType("timer");
            timerJob.setRevision(1);
            timerJob.setJobHandlerType("process-task-batch-complete-status");
            timerJob.setJobHandlerConfiguration(ProcessInstanceMigrationJobHandler.getHandlerCfgForBatchId(batch.getId()));
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
            BusinessCalendar businessCalendar = processEngineConfiguration.getBusinessCalendarManager().getBusinessCalendar(CycleBusinessCalendar.NAME);
            timerJob.setDuedate(businessCalendar.resolveDuedate(processEngineConfiguration.getBatchStatusTimeCycleConfig()));
            timerJob.setRepeat(processEngineConfiguration.getBatchStatusTimeCycleConfig());
            timerJobService.scheduleTimerJob(timerJob);
        }
        return batch;
    }
}

