/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.debug.ExecutionTree;
import org.flowable.engine.debug.ExecutionTreeNode;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;

public class ExecutionTreeUtil {
    public static ExecutionEntity getMultiInstanceRootExecution(ExecutionEntity execution) {
        ExecutionEntity currentExecution;
        for (currentExecution = execution; currentExecution != null && currentExecution.getParent() != null; currentExecution = currentExecution.getParent()) {
        }
        return currentExecution;
    }

    public static ExecutionTree buildExecutionTree(DelegateExecution executionEntity) {
        ExecutionEntity parentExecution = (ExecutionEntity)executionEntity;
        while (parentExecution.getParentId() != null || parentExecution.getSuperExecutionId() != null) {
            if (parentExecution.getParentId() != null) {
                parentExecution = parentExecution.getParent();
                continue;
            }
            parentExecution = parentExecution.getSuperExecution();
        }
        ArrayList<ExecutionEntity> allExecutions = new ArrayList<ExecutionEntity>();
        allExecutions.add(parentExecution);
        ExecutionTreeUtil.collectChildExecutions(parentExecution, allExecutions);
        return ExecutionTreeUtil.buildExecutionTree(allExecutions);
    }

    public static void collectChildExecutions(ExecutionEntity rootExecutionEntity, List<ExecutionEntity> allExecutions) {
        for (ExecutionEntity executionEntity : rootExecutionEntity.getExecutions()) {
            allExecutions.add(executionEntity);
            ExecutionTreeUtil.collectChildExecutions(executionEntity, allExecutions);
        }
        if (rootExecutionEntity.getSubProcessInstance() != null) {
            allExecutions.add(rootExecutionEntity.getSubProcessInstance());
            ExecutionTreeUtil.collectChildExecutions(rootExecutionEntity.getSubProcessInstance(), allExecutions);
        }
    }

    public static ExecutionTree buildExecutionTree(Collection<ExecutionEntity> executions) {
        ExecutionTree executionTree = new ExecutionTree();
        HashMap<String, List<ExecutionEntity>> parentMapping = new HashMap<String, List<ExecutionEntity>>();
        for (ExecutionEntity executionEntity : executions) {
            String parentId = executionEntity.getParentId();
            if (parentId == null) {
                parentId = executionEntity.getSuperExecutionId();
            }
            if (parentId != null) {
                if (!parentMapping.containsKey(parentId)) {
                    parentMapping.put(parentId, new ArrayList());
                }
                ((List)parentMapping.get(parentId)).add(executionEntity);
                continue;
            }
            if (executionEntity.getSuperExecutionId() != null) continue;
            executionTree.setRoot(new ExecutionTreeNode(executionEntity));
        }
        ExecutionTreeUtil.fillExecutionTree(executionTree, parentMapping);
        return executionTree;
    }

    public static ExecutionTree buildExecutionTreeForProcessInstance(Collection<ExecutionEntity> executions) {
        ExecutionTree executionTree = new ExecutionTree();
        if (executions.size() == 0) {
            return executionTree;
        }
        HashMap<String, List<ExecutionEntity>> parentMapping = new HashMap<String, List<ExecutionEntity>>();
        for (ExecutionEntity executionEntity : executions) {
            String parentId = executionEntity.getParentId();
            if (parentId != null) {
                if (!parentMapping.containsKey(parentId)) {
                    parentMapping.put(parentId, new ArrayList());
                }
                ((List)parentMapping.get(parentId)).add(executionEntity);
                continue;
            }
            executionTree.setRoot(new ExecutionTreeNode(executionEntity));
        }
        ExecutionTreeUtil.fillExecutionTree(executionTree, parentMapping);
        return executionTree;
    }

    protected static void fillExecutionTree(ExecutionTree executionTree, Map<String, List<ExecutionEntity>> parentMapping) {
        if (executionTree.getRoot() == null) {
            throw new FlowableException("Programmatic error: the list of passed executions in the argument of the method should contain the process instance execution");
        }
        LinkedList<ExecutionTreeNode> executionsToHandle = new LinkedList<ExecutionTreeNode>();
        executionsToHandle.add(executionTree.getRoot());
        while (!executionsToHandle.isEmpty()) {
            ExecutionTreeNode parentNode = (ExecutionTreeNode)executionsToHandle.pop();
            String parentId = parentNode.getExecutionEntity().getId();
            if (!parentMapping.containsKey(parentId)) continue;
            List<ExecutionEntity> childExecutions = parentMapping.get(parentId);
            ArrayList<ExecutionTreeNode> childNodes = new ArrayList<ExecutionTreeNode>(childExecutions.size());
            for (ExecutionEntity childExecutionEntity : childExecutions) {
                ExecutionTreeNode childNode = new ExecutionTreeNode(childExecutionEntity);
                childNode.setParent(parentNode);
                childNodes.add(childNode);
                executionsToHandle.add(childNode);
            }
            parentNode.setChildren(childNodes);
        }
    }
}

