/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.delegate.event.ext;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.flowable.common.engine.impl.persistence.deploy.DefaultDeploymentCache;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerDeploymentCache<T>
implements DeploymentCache<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDeploymentCache.class);
    protected Map<String, T> cache;
    protected Map<String, T> processInstanceCache;

    public CustomerDeploymentCache() {
        this.cache = Collections.synchronizedMap(new HashMap());
        this.processInstanceCache = Collections.synchronizedMap(new HashMap());
    }

    public CustomerDeploymentCache(final int limit) {
        this.cache = Collections.synchronizedMap(new LinkedHashMap<String, T>(limit + 1, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, T> eldest) {
                boolean removeEldest;
                boolean bl = removeEldest = this.size() > limit;
                if (removeEldest && LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Cache limit is reached, {} will be evicted", (Object)eldest.getKey());
                }
                return removeEldest;
            }
        });
        this.processInstanceCache = Collections.synchronizedMap(new LinkedHashMap<String, T>(limit + 1, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, T> eldest) {
                boolean removeEldest;
                boolean bl = removeEldest = this.size() > limit;
                if (removeEldest && LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Cache limit is reached, {} will be evicted", (Object)eldest.getKey());
                }
                return removeEldest;
            }
        });
    }

    public T get(String id) {
        return this.cache.get(id);
    }

    public void add(String id, T obj) {
        this.cache.put(id, obj);
    }

    public void addProcessInstanceId(String id, T object) {
        this.processInstanceCache.put(id, object);
    }

    public void remove(String id) {
        this.cache.remove(id);
    }

    public void removeProcessInstance(String processInstanceId) {
        this.processInstanceCache.remove(processInstanceId);
    }

    public boolean contains(String id) {
        return this.cache.containsKey(id);
    }

    public boolean containsProcessInstance(String processInstanceId) {
        return this.processInstanceCache.containsKey(processInstanceId);
    }

    public void clear() {
        this.cache.clear();
        this.processInstanceCache.clear();
    }

    public void clearProcessInstance() {
    }

    public T get(String processDefinitionId, String processInstanceId) {
        if (this.processInstanceCache.containsKey(processInstanceId)) {
            return this.processInstanceCache.get(processInstanceId);
        }
        return null;
    }

    public Collection<T> getAll() {
        return this.cache.values();
    }

    public int size() {
        return this.cache.size();
    }
}

