/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.delegate.event.ext;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.identity.UserInfoAuthentication;
import org.flowable.common.engine.impl.innermapper.A1FlowTaskTrajectoryEntry;
import org.flowable.common.engine.impl.innermapper.PanguFlowInstanceEntity;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.ext.NotifyContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.UpdateA1FlowTaskTrajectory;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.jms.MsgTemplateEnum;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class NotifyContextBuilder {
    public NotifyContext fill(NotifyContext notifyContext, TaskEntity taskEntity) {
        if (taskEntity != null) {
            notifyContext.setTaskId(taskEntity.getId());
            notifyContext.setExecutionId(taskEntity.getExecutionId());
            notifyContext.setProcId(taskEntity.getProcessInstanceId());
            notifyContext.setNodeName(taskEntity.getName());
            String processDefinitionId = taskEntity.getProcessDefinitionId();
            notifyContext.setProcessDefinitionId(processDefinitionId);
            String taskDefinitionKey = taskEntity.getTaskDefinitionKey();
            notifyContext.setTaskDefinitionKey(taskDefinitionKey);
            notifyContext.setTaskEntity(taskEntity);
            this.builderPi(notifyContext, taskEntity);
            this.builderTask(taskEntity, notifyContext);
        }
        return notifyContext;
    }

    public static NotifyContext buildCommon(List<String> userIds, List<String> userNames, String option, String userId, String realname, MsgTemplateEnum msgTemplateEnum) {
        NotifyContext notifyContext = new NotifyContext();
        notifyContext.setReceiver(userNames);
        notifyContext.setReceiverUserId(userIds);
        notifyContext.setCreateUserId(userId);
        notifyContext.setCreateUserName(realname);
        notifyContext.setMsgTemplateEnum(msgTemplateEnum);
        notifyContext.setCause(option);
        return notifyContext;
    }

    private void builderPi(NotifyContext notifyContext, TaskEntity taskEntity) {
        PanguFlowInstanceEntity panguFlowInstanceEntity = UpdateA1FlowTaskTrajectory.listByProcId(this.currentEngineConfiguration(), taskEntity.getProcessInstanceId());
        String subject = "";
        if (panguFlowInstanceEntity == null) {
            Map jmsMap = UserInfoAuthentication.getAuthenticatedUserId();
            if (jmsMap != null) {
                subject = jmsMap.get("instSubject") == null ? "" : (String)jmsMap.get("instSubject");
            }
        } else {
            subject = panguFlowInstanceEntity.getSubject();
        }
        notifyContext.setInstSubject(subject);
    }

    private void builderTask(TaskEntity taskEntity, NotifyContext notifyContext) {
        List<A1FlowTaskTrajectoryEntry> a1FlowTaskTrajectoryEntries = UpdateA1FlowTaskTrajectory.listA1FlowTaskTrajectoryEntryByNodeIds(this.currentEngineConfiguration(), Arrays.asList(taskEntity.getId()));
        if (a1FlowTaskTrajectoryEntries != null && a1FlowTaskTrajectoryEntries.size() > 0) {
            A1FlowTaskTrajectoryEntry a1FlowTaskTrajectoryEntry = a1FlowTaskTrajectoryEntries.get(0);
            notifyContext.setTaskSubject(a1FlowTaskTrajectoryEntry.getTitle());
        }
        if (StringUtils.isEmpty((CharSequence)notifyContext.getTaskSubject())) {
            notifyContext.setTaskSubject(notifyContext.getInstSubject());
        }
    }

    public ProcessEngineConfigurationImpl currentEngineConfiguration() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfigurationImpl currentEngineConfiguration = (ProcessEngineConfigurationImpl)commandContext.getCurrentEngineConfiguration();
        return currentEngineConfiguration;
    }
}

