/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import java.util.Map;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.impl.cfg.TransactionContextFactory;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.interceptor.SessionFactory;
import org.flowable.engine.DynamicBpmnService;
import org.flowable.engine.FormService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngines;
import org.flowable.engine.ProcessMigrationService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessEngineImpl
implements ProcessEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessEngineImpl.class);
    protected String name;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected HistoryService historicDataService;
    protected IdentityService identityService;
    protected TaskService taskService;
    protected FormService formService;
    protected ManagementService managementService;
    protected DynamicBpmnService dynamicBpmnService;
    protected ProcessMigrationService processInstanceMigrationService;
    protected AsyncExecutor asyncExecutor;
    protected AsyncExecutor asyncHistoryExecutor;
    protected CommandExecutor commandExecutor;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected TransactionContextFactory transactionContextFactory;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public ProcessEngineImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
        this.name = processEngineConfiguration.getEngineName();
        this.repositoryService = processEngineConfiguration.getRepositoryService();
        this.runtimeService = processEngineConfiguration.getRuntimeService();
        this.historicDataService = processEngineConfiguration.getHistoryService();
        this.identityService = processEngineConfiguration.getIdentityService();
        this.taskService = processEngineConfiguration.getTaskService();
        this.formService = processEngineConfiguration.getFormService();
        this.managementService = processEngineConfiguration.getManagementService();
        this.dynamicBpmnService = processEngineConfiguration.getDynamicBpmnService();
        this.processInstanceMigrationService = processEngineConfiguration.getProcessMigrationService();
        this.asyncExecutor = processEngineConfiguration.getAsyncExecutor();
        this.asyncHistoryExecutor = processEngineConfiguration.getAsyncHistoryExecutor();
        this.commandExecutor = processEngineConfiguration.getCommandExecutor();
        this.sessionFactories = processEngineConfiguration.getSessionFactories();
        this.transactionContextFactory = processEngineConfiguration.getTransactionContextFactory();
        if (processEngineConfiguration.getSchemaManagementCmd() != null) {
            this.commandExecutor.execute(processEngineConfiguration.getSchemaCommandConfig(), processEngineConfiguration.getSchemaManagementCmd());
        }
        if (this.name == null) {
            LOGGER.info("default ProcessEngine created");
        } else {
            LOGGER.info("ProcessEngine {} created", (Object)this.name);
        }
        ProcessEngines.registerProcessEngine(this);
        if (processEngineConfiguration.getProcessEngineLifecycleListener() != null) {
            processEngineConfiguration.getProcessEngineLifecycleListener().onProcessEngineBuilt(this);
        }
        processEngineConfiguration.getEventDispatcher().dispatchEvent(FlowableEventBuilder.createGlobalEvent(FlowableEngineEventType.ENGINE_CREATED));
        if (this.asyncExecutor != null && this.asyncExecutor.isAutoActivate()) {
            this.asyncExecutor.start();
        }
        if (this.asyncHistoryExecutor != null && this.asyncHistoryExecutor.isAutoActivate()) {
            this.asyncHistoryExecutor.start();
        }
        if (processEngineConfiguration.isEnableHistoryCleaning()) {
            this.managementService.handleHistoryCleanupTimerJob();
        }
        if (processEngineConfiguration.isEnableAddNode()) {
            this.initModel(this.managementService);
        }
    }

    private void initModel(ManagementService managementService) {
        managementService.executeCommand(new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                ProcessDefinitionUtil.updateBpmnModel(ProcessEngineImpl.this.processEngineConfiguration);
                return null;
            }
        });
    }

    @Override
    public void close() {
        Runnable closeRunnable;
        ProcessEngines.unregister(this);
        if (this.asyncExecutor != null && this.asyncExecutor.isActive()) {
            this.asyncExecutor.shutdown();
        }
        if (this.asyncHistoryExecutor != null && this.asyncHistoryExecutor.isActive()) {
            this.asyncHistoryExecutor.shutdown();
        }
        if ((closeRunnable = this.processEngineConfiguration.getProcessEngineCloseRunnable()) != null) {
            closeRunnable.run();
        }
        this.processEngineConfiguration.close();
        if (this.processEngineConfiguration.getProcessEngineLifecycleListener() != null) {
            this.processEngineConfiguration.getProcessEngineLifecycleListener().onProcessEngineClosed(this);
        }
        this.processEngineConfiguration.getEventDispatcher().dispatchEvent(FlowableEventBuilder.createGlobalEvent(FlowableEngineEventType.ENGINE_CLOSED));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IdentityService getIdentityService() {
        return this.identityService;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public TaskService getTaskService() {
        return this.taskService;
    }

    @Override
    public HistoryService getHistoryService() {
        return this.historicDataService;
    }

    @Override
    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    @Override
    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    @Override
    public FormService getFormService() {
        return this.formService;
    }

    @Override
    public DynamicBpmnService getDynamicBpmnService() {
        return this.dynamicBpmnService;
    }

    @Override
    public ProcessMigrationService getProcessMigrationService() {
        return this.processInstanceMigrationService;
    }

    @Override
    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }
}

