/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.FlowableEngineAgenda;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;

public abstract class AbstractOperation
implements Runnable {
    protected CommandContext commandContext;
    protected FlowableEngineAgenda agenda;
    protected ExecutionEntity execution;

    public AbstractOperation() {
    }

    public AbstractOperation(CommandContext commandContext, ExecutionEntity execution) {
        this.commandContext = commandContext;
        this.execution = execution;
        this.agenda = CommandContextUtil.getAgenda(commandContext);
    }

    protected FlowElement getCurrentFlowElement(ExecutionEntity execution) {
        Activity activity;
        FlowElement currentFlowElement = null;
        if (execution.getCurrentFlowElement() != null) {
            currentFlowElement = execution.getCurrentFlowElement();
        } else if (execution.getCurrentActivityId() != null) {
            String processDefinitionId = execution.getProcessDefinitionId();
            Process process = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, execution.getProcessInstanceId()).getMainProcess();
            String activityId = execution.getCurrentActivityId();
            currentFlowElement = process.getFlowElement(activityId, true);
        }
        if (currentFlowElement instanceof Activity && (activity = (Activity)currentFlowElement).getBehavior() == null) {
            String processDefinitionId = execution.getProcessDefinitionId();
            Process process = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, execution.getProcessInstanceId()).getMainProcess();
            String activityId = execution.getCurrentActivityId();
            currentFlowElement = process.getFlowElement(activityId, true);
        }
        return currentFlowElement;
    }

    protected void executeExecutionListeners(HasExecutionListeners elementWithExecutionListeners, String eventType) {
        this.executeExecutionListeners(elementWithExecutionListeners, this.execution, eventType);
    }

    protected void executeExecutionListeners(HasExecutionListeners elementWithExecutionListeners, ExecutionEntity executionEntity, String eventType) {
        CommandContextUtil.getProcessEngineConfiguration(this.commandContext).getListenerNotificationHelper().executeExecutionListeners(elementWithExecutionListeners, executionEntity, eventType);
    }

    protected ExecutionEntity findFirstParentScopeExecution(ExecutionEntity executionEntity) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(this.commandContext);
        ExecutionEntity parentScopeExecution = null;
        ExecutionEntity currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(executionEntity.getParentId());
        while (currentlyExaminedExecution != null && parentScopeExecution == null) {
            if (currentlyExaminedExecution.isScope()) {
                parentScopeExecution = currentlyExaminedExecution;
                continue;
            }
            currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(currentlyExaminedExecution.getParentId());
        }
        return parentScopeExecution;
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public void setCommandContext(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public FlowableEngineAgenda getAgenda() {
        return this.agenda;
    }

    public void setAgenda(FlowableEngineAgenda agenda) {
        this.agenda = agenda;
    }

    public ExecutionEntity getExecution() {
        return this.execution;
    }

    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
    }
}

