/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import com.a1bpm.model.ExtA1SignNode;
import com.a1bpm.model.ExtA1UserRule;
import com.pangu.entity.NodeLoop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.addnode.SignNodeInfo;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.common.UserOperateUtils;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.logging.LogMDC;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinueMultiInstanceOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContinueMultiInstanceOperation.class);
    protected ExecutionEntity multiInstanceRootExecution;
    protected int loopCounter;

    protected ExtA1SignNode getCurrentSignNode(DelegateExecution multiInstanceRootExecution, String nodeId) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(multiInstanceRootExecution.getProcessDefinitionId(), multiInstanceRootExecution.getProcessInstanceId());
        List extA1SignNodes = bpmnModel.getExtA1SignNodes();
        if (extA1SignNodes.isEmpty()) {
            BpmnModel bpmnModelOld = ProcessDefinitionUtil.getBpmnModel(multiInstanceRootExecution.getProcessDefinitionId());
            extA1SignNodes = bpmnModelOld.getExtA1SignNodes();
        }
        if (extA1SignNodes.size() > 0) {
            String id = nodeId;
            for (ExtA1SignNode es : extA1SignNodes) {
                if (!es.getNodeId().equals(id)) continue;
                return es;
            }
        }
        return null;
    }

    protected List<String> getCurrentExtA1SignNode(DelegateExecution multiInstanceRootExecution, String nodeId) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(multiInstanceRootExecution.getProcessDefinitionId(), multiInstanceRootExecution.getProcessInstanceId());
        List<String> list = new ArrayList<String>();
        List extA1UserPropertys = bpmnModel.getExtA1UserRule();
        for (ExtA1UserRule extA1UserProperty1 : extA1UserPropertys) {
            if (!extA1UserProperty1.getNodeId().equals(nodeId) || !extA1UserProperty1.getRuleId().equals("spec")) continue;
            String specId = extA1UserProperty1.getSpecId();
            String[] split = specId.split(",");
            for (int i = 0; i < split.length; ++i) {
                if (list.contains(split[i])) continue;
                list.add(split[i]);
            }
        }
        if (list.size() == 0) {
            List extA1SignNodes = bpmnModel.getExtA1SignNodes();
            for (ExtA1SignNode eas : extA1SignNodes) {
                if (!eas.getNodeId().equals(nodeId)) continue;
                String doUserId = eas.getDoUserId();
                list = Arrays.asList(doUserId.split(","));
                break;
            }
        }
        return list;
    }

    public ContinueMultiInstanceOperation(CommandContext commandContext, ExecutionEntity execution, ExecutionEntity multiInstanceRootExecution, int loopCounter) {
        super(commandContext, execution);
        this.multiInstanceRootExecution = multiInstanceRootExecution;
        this.loopCounter = loopCounter;
    }

    public ExecutionEntity getMultiInstanceRootExecution(ExecutionEntity execution) {
        ExecutionEntity currentExecution;
        for (currentExecution = execution; currentExecution != null && currentExecution.getParent() != null; currentExecution = currentExecution.getParent()) {
        }
        return currentExecution;
    }

    @Override
    public void run() {
        FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
        ExecutionEntity rootExecution = this.getMultiInstanceRootExecution(this.execution);
        List<Object> sequentialMultiInstanceResult = new ArrayList();
        List<Object> list = new ArrayList<String>();
        String sequentialMultiInstanceUsers = (String)rootExecution.getVariable("SequentialMultiInstanceUsers", String.class);
        if (StringUtils.isNotEmpty((CharSequence)sequentialMultiInstanceUsers)) {
            sequentialMultiInstanceResult = Arrays.asList(sequentialMultiInstanceUsers.split(","));
        }
        if (sequentialMultiInstanceResult.size() > 0) {
            FlowElement currentFlowElement1 = this.execution.getCurrentFlowElement();
            String user = "";
            if (this.loopCounter < sequentialMultiInstanceResult.size()) {
                user = (String)sequentialMultiInstanceResult.get(this.loopCounter);
            }
            if (currentFlowElement1 instanceof UserTask) {
                UserTask userTask = (UserTask)currentFlowElement1;
                userTask.setAssignee(user);
                currentFlowElement = userTask;
            }
        } else {
            UserTask userTask;
            FlowElement currentFlowElement1;
            SignNodeInfo signNodeInfo = (SignNodeInfo)rootExecution.getVariable("addSignVarInfo", SignNodeInfo.class);
            if (signNodeInfo != null) {
                String doUserId = signNodeInfo.getDoUserId();
                String[] split = doUserId.split(",");
                for (int i = 0; i < split.length; ++i) {
                    if (list.contains(split[i])) continue;
                    list.add(split[i]);
                }
                if (this.loopCounter < list.size()) {
                    String s = (String)list.get(this.loopCounter);
                    FlowElement currentFlowElement12 = this.execution.getCurrentFlowElement();
                    if (currentFlowElement12 instanceof UserTask) {
                        UserTask userTask2 = (UserTask)currentFlowElement12;
                        userTask2.setAssignee(s);
                        currentFlowElement = userTask2;
                    }
                }
            }
            List handlerInfoList = null;
            Object nodeLoopObject = this.execution.getTransientVariables().get("nodeLoop");
            if (nodeLoopObject != null && nodeLoopObject instanceof NodeLoop) {
                NodeLoop nodeLoop = (NodeLoop)nodeLoopObject;
                int count = nodeLoop.getCount();
                handlerInfoList = nodeLoop.getHandlerInfoList();
            }
            Object chooseNodeUser = this.execution.getTransientVariables().get("chooseNodeUser");
            Object chooseNodeObj = this.execution.getTransientVariables().get("chooseNode");
            if (chooseNodeUser != null && StringUtils.isNotEmpty((CharSequence)chooseNodeUser.toString()) && !"_".equals(chooseNodeUser.toString())) {
                String chooseNodeUserStr = (String)chooseNodeUser;
                String chooseNode = (String)chooseNodeObj;
                String[] chooseNodeSplit = chooseNode.split(",");
                int nodeIndex = 0;
                for (int i = 0; i < chooseNodeSplit.length; ++i) {
                    if (!currentFlowElement.getId().equals(chooseNodeSplit[i])) continue;
                    nodeIndex = i;
                    break;
                }
                if (chooseNode.split(",").length > 1) {
                    String[] allNode = chooseNodeUserStr.split("_");
                    String currentActivityUsers = allNode[nodeIndex];
                    list = Arrays.asList(currentActivityUsers.split(","));
                } else {
                    list = Arrays.asList(chooseNodeUserStr.split(","));
                }
            } else {
                Object panguassignees = rootExecution.getVariable("PANGUASSIGNEES", true);
                if (panguassignees != null) {
                    list = (List)panguassignees;
                } else {
                    BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.multiInstanceRootExecution.getProcessDefinitionId(), this.multiInstanceRootExecution.getProcessInstanceId());
                    List extA1UserPropertys = bpmnModel.getExtA1UserRule();
                    UserOperateUtils userOperateUtils = new UserOperateUtils();
                    FlowElement finalCurrentFlowElement = currentFlowElement;
                    List<ExtA1UserRule> filterList = extA1UserPropertys.stream().filter(extA1UserRule -> extA1UserRule.getNodeId().equals(finalCurrentFlowElement.getId())).collect(Collectors.toList());
                    list = userOperateUtils.operateUser(filterList, this.execution);
                    ExtA1SignNode currentExtA1SignNode = this.getCurrentSignNode(this.execution, currentFlowElement.getId());
                    if (list.size() == 0 && this.execution.getCurrentFlowElement() instanceof UserTask && StringUtils.isNotEmpty((CharSequence)currentExtA1SignNode.getDoUserId())) {
                        list = Arrays.asList(currentExtA1SignNode.getDoUserId().split(","));
                    }
                }
            }
            if (handlerInfoList != null) {
                if (this.loopCounter < handlerInfoList.size() && nodeLoopObject != null) {
                    NodeLoop.HandlerInfo handlerInfo = (NodeLoop.HandlerInfo)handlerInfoList.get(this.loopCounter);
                    currentFlowElement1 = this.execution.getCurrentFlowElement();
                    this.execution.setVariableLocal("nodeLoopLocal", handlerInfo.getCode());
                    if (currentFlowElement1 instanceof UserTask) {
                        userTask = (UserTask)currentFlowElement1;
                        userTask.setAssignee(handlerInfo.getCode());
                        currentFlowElement = userTask;
                    }
                }
            } else if (this.loopCounter < list.size()) {
                String s = (String)list.get(this.loopCounter);
                currentFlowElement1 = this.execution.getCurrentFlowElement();
                this.execution.setVariableLocal("nodeLoopLocal", s);
                if (currentFlowElement1 instanceof UserTask) {
                    userTask = (UserTask)currentFlowElement1;
                    userTask.setAssignee(s);
                    currentFlowElement = userTask;
                }
            }
        }
        if (currentFlowElement instanceof FlowNode) {
            if (currentFlowElement instanceof SubProcess) {
                SubProcess subProcess = (SubProcess)currentFlowElement;
                subProcess.setHandlerIdList(list);
                subProcess.setLoopCounter(this.loopCounter);
                this.continueThroughMultiInstanceFlowNode((FlowNode)subProcess);
            } else {
                this.continueThroughMultiInstanceFlowNode((FlowNode)currentFlowElement);
            }
        } else {
            throw new RuntimeException("Programmatic error: no valid multi instance flow node, type: " + currentFlowElement + ". Halting.");
        }
    }

    protected void continueThroughMultiInstanceFlowNode(FlowNode flowNode) {
        this.setLoopCounterVariable(flowNode);
        if (!flowNode.isAsynchronous()) {
            this.executeSynchronous(flowNode);
        } else {
            this.executeAsynchronous(flowNode);
        }
    }

    protected void executeSynchronous(FlowNode flowNode) {
        CommandContextUtil.getActivityInstanceEntityManager(this.commandContext).recordActivityStart(this.execution);
        if (CollectionUtil.isNotEmpty((Collection)flowNode.getExecutionListeners())) {
            this.executeExecutionListeners((HasExecutionListeners)flowNode, "start");
        }
        ActivityBehavior activityBehavior = (ActivityBehavior)flowNode.getBehavior();
        LOGGER.debug("Executing activityBehavior {} on activity '{}' with execution {}", new Object[]{activityBehavior.getClass(), flowNode.getId(), this.execution.getId()});
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(this.commandContext);
        FlowableEventDispatcher eventDispatcher = null;
        if (processEngineConfiguration != null) {
            eventDispatcher = processEngineConfiguration.getEventDispatcher();
        }
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_STARTED, flowNode.getId(), flowNode.getName(), this.execution.getId(), this.execution.getProcessInstanceId(), this.execution.getProcessDefinitionId(), (FlowElement)flowNode));
        }
        try {
            activityBehavior.execute(this.execution);
        }
        catch (BpmnError error) {
            ErrorPropagation.propagateError(error, (DelegateExecution)this.execution);
        }
        catch (RuntimeException e) {
            if (LogMDC.isMDCEnabled()) {
                LogMDC.putMDCExecution(this.execution);
            }
            throw e;
        }
    }

    protected void executeAsynchronous(FlowNode flowNode) {
        JobService jobService = CommandContextUtil.getJobService(this.commandContext);
        JobEntity job = jobService.createJob();
        job.setExecutionId(this.execution.getId());
        job.setProcessInstanceId(this.execution.getProcessInstanceId());
        job.setProcessDefinitionId(this.execution.getProcessDefinitionId());
        job.setElementId(flowNode.getId());
        job.setElementName(flowNode.getName());
        job.setJobHandlerType("async-continuation");
        if (this.execution.getTenantId() != null) {
            job.setTenantId(this.execution.getTenantId());
        }
        this.execution.getJobs().add(job);
        jobService.createAsyncJob(job, flowNode.isExclusive());
        jobService.scheduleAsyncJob(job);
    }

    protected ActivityBehavior setLoopCounterVariable(FlowNode flowNode) {
        ActivityBehavior activityBehavior = (ActivityBehavior)flowNode.getBehavior();
        if (!(activityBehavior instanceof MultiInstanceActivityBehavior)) {
            throw new FlowableException("Programmatic error: expected multi instance activity behavior, but got " + activityBehavior.getClass());
        }
        MultiInstanceActivityBehavior multiInstanceActivityBehavior = (MultiInstanceActivityBehavior)activityBehavior;
        String elementIndexVariable = multiInstanceActivityBehavior.getCollectionElementIndexVariable();
        if (!flowNode.isAsynchronous()) {
            this.execution.setVariableLocal(elementIndexVariable, this.loopCounter);
        } else {
            this.multiInstanceRootExecution.setVariableLocal(elementIndexVariable, this.loopCounter);
        }
        return activityBehavior;
    }
}

