/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.AdhocSubProcess;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CancelEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.InclusiveGateway;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.common.engine.impl.util.ThreadMapUtil;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.el.UelExpressionCondition;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.VariableUtil;
import org.flowable.engine.impl.util.condition.ConditionUtil;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.service.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakeOutgoingSequenceFlowsOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TakeOutgoingSequenceFlowsOperation.class);
    Object lockObject = new Object();
    protected boolean evaluateConditions;

    public TakeOutgoingSequenceFlowsOperation(CommandContext commandContext, ExecutionEntity executionEntity, boolean evaluateConditions) {
        super(commandContext, executionEntity);
        this.evaluateConditions = evaluateConditions;
    }

    @Override
    public void run() {
        FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
        if (currentFlowElement instanceof Activity && ((Activity)currentFlowElement).isForCompensation()) {
            this.cleanupCompensation();
            return;
        }
        this.cleanupExecutions(currentFlowElement);
        if (currentFlowElement instanceof FlowNode) {
            this.handleFlowNode((FlowNode)currentFlowElement);
        } else if (currentFlowElement instanceof SequenceFlow) {
            this.handleSequenceFlow();
        }
    }

    protected void handleFlowNode(FlowNode flowNode) {
        this.handleActivityEnd(flowNode);
        if (flowNode.getParentContainer() != null && flowNode.getParentContainer() instanceof AdhocSubProcess) {
            this.handleAdhocSubProcess(flowNode);
        } else {
            this.leaveFlowNode(flowNode);
        }
    }

    protected List<SequenceFlow> handlerSelectPath(FlowNode flowNode, BpmnModel bpmnModel) {
        Boolean chooseBoolean;
        Object choose = this.execution.getVariable("choose");
        Object chooseNode = this.execution.getTransientVariable("chooseNode");
        ArrayList<SequenceFlow> resultIncomingFlows = new ArrayList<SequenceFlow>();
        if (choose != null && (chooseBoolean = (Boolean)choose).booleanValue() && chooseNode != null) {
            String[] split;
            List<Object> chooseNodeList = new ArrayList();
            String chooseNodeStr = (String)chooseNode;
            if (StringUtils.isNotEmpty((CharSequence)chooseNodeStr) && (chooseNodeList = Arrays.asList(split = chooseNodeStr.split(","))).size() > 0) {
                for (String string : chooseNodeList) {
                    FlowElement flowElement = bpmnModel.getMainProcess().getFlowElement(string, true);
                    if (!(flowElement instanceof FlowNode)) continue;
                    FlowNode tmpNode = (FlowNode)flowElement;
                    List incomingFlows = tmpNode.getIncomingFlows();
                    resultIncomingFlows.addAll(incomingFlows);
                }
            }
        }
        return resultIncomingFlows;
    }

    protected void handleActivityEnd(FlowNode flowNode) {
        if (!this.execution.isProcessInstanceType()) {
            if (CollectionUtil.isNotEmpty((Collection)flowNode.getExecutionListeners())) {
                this.executeExecutionListeners((HasExecutionListeners)flowNode, "end");
            }
            if (!(!this.execution.isActive() || flowNode.getOutgoingFlows().isEmpty() || flowNode instanceof ParallelGateway || flowNode instanceof InclusiveGateway || flowNode instanceof SubProcess || flowNode instanceof Activity && ((Activity)flowNode).getLoopCharacteristics() != null)) {
                CommandContextUtil.getActivityInstanceEntityManager(this.commandContext).recordActivityEnd(this.execution, null);
            }
            if (!(this.execution.getCurrentFlowElement() instanceof SubProcess || flowNode instanceof Activity && ((Activity)flowNode).hasMultiInstanceLoopCharacteristics())) {
                CommandContextUtil.getEventDispatcher(this.commandContext).dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_COMPLETED, flowNode.getId(), flowNode.getName(), this.execution.getId(), this.execution.getProcessInstanceId(), this.execution.getProcessDefinitionId(), (FlowElement)flowNode));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void leaveFlowNode(FlowNode flowNode) {
        List<SequenceFlow> sequenceFlowPathList;
        FlowElement flowElement2;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.execution.getProcessDefinitionId(), this.execution.getProcessInstanceId());
        FlowElement flowElement = bpmnModel.getMainProcess().getFlowElement(flowNode.getId(), true);
        flowNode = (FlowNode)flowElement;
        String nextId = flowElement.getNextId();
        if (StringUtils.isBlank((CharSequence)nextId)) {
            nextId = (String)ThreadMapUtil.get((String)"nextId");
        }
        LOGGER.info("next Id :{}", (Object)nextId);
        if (StringUtils.isNotEmpty((CharSequence)nextId) && !"null".equalsIgnoreCase(nextId) && !((flowElement2 = bpmnModel.getMainProcess().getFlowElement(nextId, true)) instanceof SubProcess)) {
            ArrayList<ExecutionEntity> outgoingExecutions = new ArrayList<ExecutionEntity>(flowNode.getOutgoingFlows().size());
            Object object = this.lockObject;
            synchronized (object) {
                FlowNode flowElement1 = (FlowNode)bpmnModel.getMainProcess().getFlowElement(nextId, true);
                List incomingFlows = flowElement1.getIncomingFlows();
                if (incomingFlows.size() == 1) {
                    this.execution.setCurrentFlowElement((FlowElement)incomingFlows.get(0));
                } else {
                    this.execution.setCurrentFlowElement((FlowElement)flowElement1);
                }
                this.execution.setActive(false);
                outgoingExecutions.add(this.execution);
                for (ExecutionEntity outgoingExecution : outgoingExecutions) {
                    this.agenda.planContinueProcessOperation(outgoingExecution);
                }
                flowElement.setNextId(null);
                ThreadMapUtil.remove((String)"nextId");
                return;
            }
        }
        LOGGER.debug("Leaving flow node {} with id '{}' by following it's {} outgoing sequenceflow", new Object[]{flowNode.getClass(), flowNode.getId(), flowNode.getOutgoingFlows().size()});
        String defaultSequenceFlowId = null;
        if (flowNode instanceof Activity) {
            defaultSequenceFlowId = ((Activity)flowNode).getDefaultFlow();
        } else if (flowNode instanceof Gateway) {
            defaultSequenceFlowId = ((Gateway)flowNode).getDefaultFlow();
        }
        List<Object> outgoingSequenceFlows = new ArrayList<SequenceFlow>();
        List outgoingFlows = flowNode.getOutgoingFlows();
        for (SequenceFlow sequenceFlow : outgoingFlows) {
            String skipExpressionString = sequenceFlow.getSkipExpression();
            if (!SkipExpressionUtil.isSkipExpressionEnabled(skipExpressionString, sequenceFlow.getId(), this.execution, this.commandContext)) {
                if (this.evaluateConditions && (!this.evaluateConditions || !ConditionUtil.hasTrueCondition(sequenceFlow, this.execution) || defaultSequenceFlowId != null && defaultSequenceFlowId.equals(sequenceFlow.getId()))) continue;
                outgoingSequenceFlows.add(sequenceFlow);
                continue;
            }
            if (flowNode.getOutgoingFlows().size() != 1 && !SkipExpressionUtil.shouldSkipFlowElement(skipExpressionString, sequenceFlow.getId(), this.execution, this.commandContext)) continue;
            outgoingSequenceFlows.add(sequenceFlow);
        }
        if (outgoingSequenceFlows.size() == 0 && this.evaluateConditions && defaultSequenceFlowId != null) {
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                if (!defaultSequenceFlowId.equals(sequenceFlow.getId())) continue;
                outgoingSequenceFlows.add(sequenceFlow);
                break;
            }
        }
        if ((sequenceFlowPathList = this.handlerSelectPath(flowNode, bpmnModel)) != null && sequenceFlowPathList.size() > 0 && outgoingSequenceFlows.size() > 0) {
            List intersection = outgoingSequenceFlows.stream().filter(item -> sequenceFlowPathList.contains(item)).collect(Collectors.toList());
            LOGGER.debug("\u4ea4\u96c6\u5143\u7d20{} ", intersection, (Object)intersection.size());
            if (intersection != null && intersection.size() > 0) {
                outgoingSequenceFlows = intersection;
            }
        }
        if (outgoingSequenceFlows.size() == 0) {
            if (flowNode.getOutgoingFlows() != null && flowNode.getOutgoingFlows().size() != 0) throw new FlowableException("No outgoing sequence flow of element '" + flowNode.getId() + "' could be selected for continuing the process");
            LOGGER.debug("No outgoing sequence flow found for flow node '{}'.", (Object)flowNode.getId());
            this.agenda.planEndExecutionOperation(this.execution);
            return;
        } else {
            ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(this.commandContext);
            ArrayList<ExecutionEntity> outgoingExecutions = new ArrayList<ExecutionEntity>(flowNode.getOutgoingFlows().size());
            SequenceFlow sequenceFlow = (SequenceFlow)outgoingSequenceFlows.get(0);
            this.execution.setCurrentFlowElement((FlowElement)sequenceFlow);
            this.execution.setActive(false);
            outgoingExecutions.add(this.execution);
            if (outgoingSequenceFlows.size() > 1) {
                for (int i = 1; i < outgoingSequenceFlows.size(); ++i) {
                    ExecutionEntity parent = this.execution.getParentId() != null ? this.execution.getParent() : this.execution;
                    ExecutionEntity outgoingExecutionEntity = CommandContextUtil.getExecutionEntityManager(this.commandContext).createChildExecution(parent);
                    SequenceFlow outgoingSequenceFlow = (SequenceFlow)outgoingSequenceFlows.get(i);
                    outgoingExecutionEntity.setActive(false);
                    outgoingExecutionEntity.setCurrentFlowElement((FlowElement)outgoingSequenceFlow);
                    executionEntityManager.insert(outgoingExecutionEntity);
                    outgoingExecutions.add(outgoingExecutionEntity);
                }
            }
            for (ExecutionEntity outgoingExecution : outgoingExecutions) {
                this.agenda.planContinueProcessOperation(outgoingExecution);
            }
        }
    }

    protected void handleAdhocSubProcess(FlowNode flowNode) {
        Boolean isCompleteAdhoc;
        Expression expression;
        UelExpressionCondition uelExpressionCondition;
        Object operate = ThreadMapUtil.get((String)"operate");
        boolean completeAdhocSubProcess = false;
        AdhocSubProcess adhocSubProcess = (AdhocSubProcess)flowNode.getParentContainer();
        if (adhocSubProcess.getCompletionCondition() != null && (uelExpressionCondition = new UelExpressionCondition(expression = CommandContextUtil.getProcessEngineConfiguration(this.commandContext).getExpressionManager().createExpression(adhocSubProcess.getCompletionCondition()))).evaluate(adhocSubProcess.getId(), this.execution)) {
            completeAdhocSubProcess = true;
        }
        boolean lave = false;
        if (flowNode.getOutgoingFlows().size() == 0) {
            List allSubFlowElementInFlowMapOfType = adhocSubProcess.findAllSubFlowElementInFlowMapOfType(UserTask.class);
            List collect = allSubFlowElementInFlowMapOfType.stream().map(BaseElement::getId).collect(Collectors.toList());
            TaskService taskService = CommandContextUtil.getTaskService();
            List list = ((TaskQuery)taskService.createTaskQuery().processInstanceId(this.execution.getProcessInstanceId())).list();
            List ids = list.stream().filter(r -> collect.contains(r.getTaskDefinitionKey())).map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
            if (ids.size() == 0 || ids.size() == 1) {
                lave = true;
            }
        }
        if (flowNode.getOutgoingFlows().size() > 0 || lave) {
            this.leaveFlowNode(flowNode);
        } else {
            CommandContextUtil.getExecutionEntityManager(this.commandContext).deleteExecutionAndRelatedData(this.execution, null, false);
        }
        Object completeAdhoc = VariableUtil.getVariable(this.execution, "completeAdhoc");
        if (completeAdhoc != null && (isCompleteAdhoc = (Boolean)completeAdhoc).booleanValue()) {
            completeAdhocSubProcess = true;
        }
        if (operate != null && StringUtils.isNotEmpty((CharSequence)operate.toString())) {
            this.agenda.planEndExecutionOperation(this.execution.getParent());
        } else if (completeAdhocSubProcess) {
            boolean endAdhocSubProcess = true;
            if (!adhocSubProcess.isCancelRemainingInstances()) {
                List<ExecutionEntity> childExecutions = CommandContextUtil.getExecutionEntityManager(this.commandContext).findChildExecutionsByParentExecutionId(this.execution.getParentId());
                for (ExecutionEntity executionEntity : childExecutions) {
                    if (executionEntity.getId().equals(this.execution.getId())) continue;
                    endAdhocSubProcess = false;
                    break;
                }
            }
            if (endAdhocSubProcess) {
                this.agenda.planEndExecutionOperation(this.execution.getParent());
            }
        }
    }

    protected void handleSequenceFlow() {
        CommandContextUtil.getActivityInstanceEntityManager(this.commandContext).recordActivityEnd(this.execution, null);
        this.agenda.planContinueProcessOperation(this.execution);
    }

    protected void cleanupCompensation() {
        CommandContextUtil.getExecutionEntityManager(this.commandContext).deleteExecutionAndRelatedData(this.execution, null, false);
        ExecutionEntity parentExecutionEntity = this.execution.getParent();
        if (parentExecutionEntity.isScope() && !parentExecutionEntity.isProcessInstanceType() && this.allChildExecutionsEnded(parentExecutionEntity, null)) {
            ExecutionEntity executionEntityToEnd = parentExecutionEntity;
            ExecutionEntity scopeExecutionEntity = this.findNextParentScopeExecutionWithAllEndedChildExecutions(parentExecutionEntity, parentExecutionEntity);
            while (scopeExecutionEntity != null) {
                executionEntityToEnd = scopeExecutionEntity;
                scopeExecutionEntity = this.findNextParentScopeExecutionWithAllEndedChildExecutions(scopeExecutionEntity, parentExecutionEntity);
            }
            if (executionEntityToEnd.isProcessInstanceType()) {
                this.agenda.planEndExecutionOperation(executionEntityToEnd);
            } else {
                this.agenda.planDestroyScopeOperation(executionEntityToEnd);
            }
        }
    }

    protected void cleanupExecutions(FlowElement currentFlowElement) {
        Activity activity;
        if (this.execution.getParentId() != null && this.execution.isScope()) {
            this.agenda.planDestroyScopeOperation(this.execution);
        } else if (currentFlowElement instanceof Activity && CollectionUtil.isNotEmpty((Collection)(activity = (Activity)currentFlowElement).getBoundaryEvents())) {
            ArrayList<String> notToDeleteEvents = new ArrayList<String>();
            for (BoundaryEvent event : activity.getBoundaryEvents()) {
                if (!CollectionUtil.isNotEmpty((Collection)event.getEventDefinitions()) || !(event.getEventDefinitions().get(0) instanceof CancelEventDefinition)) continue;
                notToDeleteEvents.add(event.getId());
            }
            List<ExecutionEntity> childExecutions = CommandContextUtil.getExecutionEntityManager(this.commandContext).findChildExecutionsByParentExecutionId(this.execution.getId());
            for (ExecutionEntity childExecution : childExecutions) {
                if (childExecution.getCurrentFlowElement() != null && notToDeleteEvents.contains(childExecution.getCurrentFlowElement().getId())) continue;
                CommandContextUtil.getExecutionEntityManager(this.commandContext).deleteExecutionAndRelatedData(childExecution, null, false);
            }
        }
    }

    protected ExecutionEntity findNextParentScopeExecutionWithAllEndedChildExecutions(ExecutionEntity executionEntity, ExecutionEntity executionEntityToIgnore) {
        if (executionEntity.getParentId() != null) {
            ExecutionEntity scopeExecutionEntity = executionEntity.getParent();
            while (!scopeExecutionEntity.isScope() || !scopeExecutionEntity.isProcessInstanceType()) {
                scopeExecutionEntity = scopeExecutionEntity.getParent();
            }
            if (this.allChildExecutionsEnded(scopeExecutionEntity, executionEntityToIgnore)) {
                return scopeExecutionEntity;
            }
        }
        return null;
    }

    protected boolean allChildExecutionsEnded(ExecutionEntity parentExecutionEntity, ExecutionEntity executionEntityToIgnore) {
        for (ExecutionEntity executionEntity : parentExecutionEntity.getExecutions()) {
            if (executionEntityToIgnore != null && executionEntityToIgnore.getId().equals(executionEntity.getId())) continue;
            if (!executionEntity.isEnded()) {
                return false;
            }
            if (executionEntity.getExecutions() == null || executionEntity.getExecutions().size() <= 0 || this.allChildExecutionsEnded(executionEntity, executionEntityToIgnore)) continue;
            return false;
        }
        return true;
    }
}

