/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.runtime.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminationExecutionOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminationExecutionOperation.class);
    protected boolean forceSynchronous;

    public TerminationExecutionOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    public TerminationExecutionOperation(CommandContext commandContext, ExecutionEntity execution, boolean forceSynchronous) {
        this(commandContext, execution);
        this.forceSynchronous = forceSynchronous;
    }

    @Override
    public void run() {
        String processInstanceId = this.execution.getProcessInstanceId();
        ExecutionEntity processInstanceEntity = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(this.commandContext).findById(processInstanceId);
        if (processInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No process instance found for id '" + processInstanceId + "'", ProcessInstance.class);
        }
        if (processInstanceEntity.isDeleted()) {
            return;
        }
        if (Flowable5Util.isFlowable5ProcessDefinitionId(this.commandContext, processInstanceEntity.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.deleteProcessInstance(processInstanceId, null);
        } else {
            CommandContextUtil.getExecutionEntityManager(this.commandContext).deleteProcessInstance(processInstanceEntity.getProcessInstanceId(), null, true);
        }
    }
}

