/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.cmd.ExecuteActivityForAdhocSubProcessCmd;
import org.flowable.engine.impl.cmd.ExecuteActivityForAdhocSubProcessUserCmd;
import org.flowable.engine.impl.util.CommandContextUtil;

public class AdhocSubProcessActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(DelegateExecution execution) {
        SubProcess subProcess = this.getSubProcessFromExecution(execution);
        execution.setScope(true);
        String processDefinitionId = execution.getProcessDefinitionId();
        Map<String, Object> dataObjectVars = this.processDataObjects(subProcess.getDataObjects());
        if (dataObjectVars != null) {
            execution.setVariablesLocal(dataObjectVars);
        }
        String executionId = execution.getId();
        Object chooseNode = execution.getTransientVariables().get("chooseNode");
        Object chooseNodeUser = execution.getTransientVariables().get("chooseNodeUser");
        if (chooseNode == null) {
            chooseNode = execution.getVariable("chooseNode");
        }
        if (chooseNodeUser == null) {
            chooseNodeUser = execution.getVariable("chooseNodeUser");
        }
        if (chooseNode != null && StringUtils.isNotEmpty((CharSequence)chooseNode.toString())) {
            String chooseNodeUserStr = (String)chooseNode;
            List<String> result = Arrays.asList(chooseNodeUserStr.split(","));
            String[] chooseNodeUserArray = null;
            if (chooseNodeUser != null && StringUtils.isNotEmpty((CharSequence)chooseNodeUser.toString())) {
                chooseNodeUserArray = chooseNodeUser.toString().split("_");
            }
            for (int i = 0; i < result.size(); ++i) {
                String node = result.get(i);
                if (chooseNodeUserArray == null || !StringUtils.isNotEmpty((CharSequence)node)) continue;
                for (FlowElement flowElement : subProcess.getFlowElements()) {
                    String users;
                    if (!node.equals(flowElement.getId()) || !(flowElement instanceof FlowNode) || !StringUtils.isNotEmpty((CharSequence)(users = chooseNodeUserArray[i]))) continue;
                    List<String> resultUsers = Arrays.asList(users.split(","));
                    for (int j = 0; j < resultUsers.size(); ++j) {
                        String user = resultUsers.get(j);
                        this.managementService().executeCommand(new ExecuteActivityForAdhocSubProcessUserCmd(executionId, node, user));
                    }
                }
            }
        } else {
            RepositoryService repositoryService = this.repositoryService();
            BpmnModel bpmnModel = repositoryService.getBpmnModel(processDefinitionId);
            StartEvent firstSubFlowElementInFlowMapOfType = (StartEvent)subProcess.findFirstSubFlowElementInFlowMapOfType(StartEvent.class);
            if (firstSubFlowElementInFlowMapOfType != null) {
                this.managementService().executeCommand(new ExecuteActivityForAdhocSubProcessCmd(executionId, firstSubFlowElementInFlowMapOfType.getId()));
            }
        }
    }

    public ManagementService managementService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        ManagementService managementService = currentEngineConfiguration.getManagementService();
        return managementService;
    }

    public RepositoryService repositoryService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        RepositoryService repositoryService = currentEngineConfiguration.getRepositoryService();
        return repositoryService;
    }

    protected SubProcess getSubProcessFromExecution(DelegateExecution execution) {
        FlowElement flowElement = execution.getCurrentFlowElement();
        SubProcess subProcess = null;
        if (!(flowElement instanceof SubProcess)) {
            throw new FlowableException("Programmatic error: sub process behaviour can only be applied to a SubProcess instance, but got an instance of " + flowElement);
        }
        subProcess = (SubProcess)flowElement;
        return subProcess;
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }
}

