/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.flowable.bpmn.model.BusinessRuleTask;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.DmnDecisionTableResult;
import org.flowable.dmn.DmnModel;
import org.flowable.dmn.DmnScheduler;
import org.flowable.dmn.HistoricDecisionExecutionEntity;
import org.flowable.engine.delegate.BusinessRuleTaskDelegate;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.HistoricDecisionUtils;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;

public class DmnBusinessRuleTaskActivityBehavior
extends TaskActivityBehavior
implements BusinessRuleTaskDelegate {
    private static final long serialVersionUID = 1L;
    protected Set<Expression> variablesInputExpressions = new HashSet<Expression>();
    protected Set<Expression> rulesExpressions = new HashSet<Expression>();
    protected boolean exclude;
    protected String resultVariable;
    private final BusinessRuleTask businessRuleTask;

    public DmnBusinessRuleTaskActivityBehavior(BusinessRuleTask businessRuleTask) {
        this.businessRuleTask = businessRuleTask;
    }

    public ProcessEngineConfigurationImpl currentEngineConfiguration() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfigurationImpl currentEngineConfiguration = (ProcessEngineConfigurationImpl)commandContext.getCurrentEngineConfiguration();
        return currentEngineConfiguration;
    }

    @Override
    public void execute(DelegateExecution execution) {
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(execution.getProcessDefinitionId());
        String deploymentId = processDefinition.getDeploymentId();
        HistoricDecisionExecutionEntity historicDecisionExecutionEntity = new HistoricDecisionExecutionEntity();
        historicDecisionExecutionEntity.setId(this.currentEngineConfiguration().getIdGenerator().getNextId());
        historicDecisionExecutionEntity.setActivityId(this.businessRuleTask.getId());
        historicDecisionExecutionEntity.setStartTime(new Date());
        historicDecisionExecutionEntity.setEndTime(new Date());
        historicDecisionExecutionEntity.setInstanceId(execution.getProcessInstanceId());
        historicDecisionExecutionEntity.setExecutionId(execution.getId());
        historicDecisionExecutionEntity.setScopeType("DMN");
        try {
            Object result;
            ApplicationContext applicationContext;
            Map sqlListeners;
            Map beansMap = CommandContextUtil.getProcessEngineConfiguration().getBeans();
            SpringBeanFactoryProxyMap springBeanFactoryProxyMap = (SpringBeanFactoryProxyMap)beansMap;
            BeanFactory beanFactory = springBeanFactoryProxyMap.getBeanFactory();
            DmnDecisionTableResult dmnDecisionTableResult = null;
            if (beanFactory instanceof ApplicationContext && (sqlListeners = (applicationContext = (ApplicationContext)beanFactory).getBeansOfType(DmnScheduler.class)) != null) {
                Map stringObjectMap = sqlListeners;
                for (Map.Entry entry : stringObjectMap.entrySet()) {
                    Object value = entry.getValue();
                    if (!(value instanceof DmnScheduler)) continue;
                    DmnScheduler dmnScheduler = (DmnScheduler)value;
                    dmnDecisionTableResult = dmnScheduler.notify(this.businessRuleTask.getBaseCallableElement(), execution.getVariables());
                }
            }
            if (dmnDecisionTableResult != null && (result = dmnDecisionTableResult.getResult()) instanceof List) {
                List resultList = (List)result;
                for (List r : resultList) {
                    for (Map r1 : r) {
                        for (Map.Entry entry : r1.entrySet()) {
                            execution.setVariables(r1);
                        }
                    }
                }
            }
            historicDecisionExecutionEntity.setFailed(false);
            ObjectMapper objectMapper = this.currentEngineConfiguration().getObjectMapper();
            DmnModel dmnModel = dmnDecisionTableResult.getDmnModel();
            if (dmnModel != null) {
                historicDecisionExecutionEntity.setCategory(dmnModel.getCategory());
            }
            String dmnDecisionTableResultStr = objectMapper.writeValueAsString(dmnDecisionTableResult.getResult());
            historicDecisionExecutionEntity.setExecutionJson(dmnDecisionTableResultStr.getBytes("UTF-8"));
            this.leave(execution);
        }
        catch (Exception e) {
            historicDecisionExecutionEntity.setFailed(true);
        }
        HistoricDecisionUtils.insert(this.currentEngineConfiguration(), historicDecisionExecutionEntity);
    }

    @Override
    public void addRuleVariableInputIdExpression(Expression inputId) {
        this.variablesInputExpressions.add(inputId);
    }

    @Override
    public void addRuleIdExpression(Expression inputId) {
        this.rulesExpressions.add(inputId);
    }

    @Override
    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    @Override
    public void setResultVariable(String resultVariableName) {
        this.resultVariable = resultVariableName;
    }
}

