/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.Iterator;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.condition.ConditionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusiveGatewayActivityBehavior
extends GatewayActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExclusiveGatewayActivityBehavior.class);

    @Override
    public void leave(DelegateExecution execution) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Leaving exclusive gateway '{}'", (Object)execution.getCurrentActivityId());
        }
        ExclusiveGateway exclusiveGateway = (ExclusiveGateway)execution.getCurrentFlowElement();
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        FlowableEventDispatcher eventDispatcher = null;
        if (processEngineConfiguration != null) {
            eventDispatcher = processEngineConfiguration.getEventDispatcher();
        }
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_COMPLETED, exclusiveGateway.getId(), exclusiveGateway.getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), (FlowElement)exclusiveGateway));
        }
        SequenceFlow outgoingSequenceFlow = null;
        SequenceFlow defaultSequenceFlow = null;
        String defaultSequenceFlowId = exclusiveGateway.getDefaultFlow();
        Iterator sequenceFlowIterator = exclusiveGateway.getOutgoingFlows().iterator();
        while (outgoingSequenceFlow == null && sequenceFlowIterator.hasNext()) {
            SequenceFlow sequenceFlow = (SequenceFlow)sequenceFlowIterator.next();
            String skipExpressionString = sequenceFlow.getSkipExpression();
            if (!SkipExpressionUtil.isSkipExpressionEnabled(skipExpressionString, sequenceFlow.getId(), execution, commandContext)) {
                boolean conditionEvaluatesToTrue = ConditionUtil.hasTrueCondition(sequenceFlow, execution);
                if (conditionEvaluatesToTrue && (defaultSequenceFlowId == null || !defaultSequenceFlowId.equals(sequenceFlow.getId()))) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Sequence flow '{}' selected as outgoing sequence flow.", (Object)sequenceFlow.getId());
                    }
                    outgoingSequenceFlow = sequenceFlow;
                }
            } else if (SkipExpressionUtil.shouldSkipFlowElement(skipExpressionString, sequenceFlow.getId(), execution, Context.getCommandContext())) {
                outgoingSequenceFlow = sequenceFlow;
            }
            if (defaultSequenceFlowId == null || !defaultSequenceFlowId.equals(sequenceFlow.getId())) continue;
            defaultSequenceFlow = sequenceFlow;
        }
        if (outgoingSequenceFlow != null) {
            execution.setCurrentFlowElement((FlowElement)outgoingSequenceFlow);
        } else if (defaultSequenceFlow != null) {
            execution.setCurrentFlowElement((FlowElement)defaultSequenceFlow);
        } else {
            throw new FlowableException("\u6392\u4ed6\u7f51\u5173\u3010" + exclusiveGateway.getName() + "\u3011\u672a\u627e\u5230\u540e\u7eed\u64cd\u4f5c\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5\u63d0\u4ea4\u5ba1\u6279\u53c2\u6570\u6216\u6d41\u8f6c\u6761\u4ef6\u8868\u8fbe\u5f0f\u662f\u5426\u6b63\u786e\uff01");
        }
        super.leave(execution);
    }
}

