/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.a1bpm.model.ExtA1SignNode;
import com.a1bpm.model.ExtA1UserRule;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.pangu.entity.NodeLoop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CollectionHandler;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.ImplementationType;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.identity.UserInfoAuthentication;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.common.engine.impl.util.ThreadMapUtil;
import org.flowable.engine.FlowableEngineAgenda;
import org.flowable.engine.HistoryService;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.addnode.SignNodeInfo;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.FlowableMultiInstanceActivityCompletedEvent;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.eumns.ChangeActivityEnumType;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.flowable.engine.impl.bpmn.bpmnmodel.BpmModelUtils;
import org.flowable.engine.impl.bpmn.helper.ClassDelegateCollectionHandler;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionCollectionHandler;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.common.UserOperateUtils;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.FlowableCollectionHandler;
import org.flowable.engine.impl.delegate.SubProcessActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.BpmnModelUtils;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiInstanceActivityBehavior
extends FlowNodeActivityBehavior
implements SubProcessActivityBehavior {
    public static final String ONE_VETO = "oneVeto";
    public static final String ONE_VETO_PASS = "oneVetoPass";
    public static final String SKIP_SAME_USER_FLAG = "skipSameUserFlag";
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(MultiInstanceActivityBehavior.class);
    protected static final String DELETE_REASON_END = "MI_END";
    protected final String NUMBER_OF_INSTANCES = "nrOfInstances";
    protected final String NUMBER_OF_ACTIVE_INSTANCES = "nrOfActiveInstances";
    protected final String NUMBER_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";
    protected final String NUMBER_OF_PASS_INSTANCES = "nrOfPassInstances";
    protected final String MULTI_INSTANCE_ACTIVITY_RESULT = "signResult";
    protected Activity activity;
    protected AbstractBpmnActivityBehavior innerActivityBehavior;
    protected Expression loopCardinalityExpression;
    protected String completionCondition;
    protected Expression collectionExpression;
    protected String collectionVariable;
    protected String collectionElementVariable;
    protected String collectionString;
    protected CollectionHandler collectionHandler;
    protected String collectionElementIndexVariable = "loopCounter";
    private static final String CURRENT_USER = "currentUser";
    private static final String CURRENT_USER_NAME = "currentUserName";

    public MultiInstanceActivityBehavior(Activity activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        this.activity = activity;
        this.setInnerActivityBehavior(innerActivityBehavior);
    }

    public HistoryService historyService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        HistoryService historyService = currentEngineConfiguration.getHistoryService();
        return historyService;
    }

    @Override
    public void execute(DelegateExecution delegateExecution) {
        ExecutionEntity execution = (ExecutionEntity)delegateExecution;
        if (this.getLocalLoopVariable(execution, this.getCollectionElementIndexVariable()) == null) {
            int nrOfInstances = 0;
            try {
                nrOfInstances = this.createInstances(delegateExecution);
            }
            catch (BpmnError error) {
                ErrorPropagation.propagateError(error, (DelegateExecution)execution);
            }
            if (nrOfInstances == 0) {
                this.cleanupMiRoot(execution);
            }
        } else {
            if (this.activity.isAsynchronous()) {
                CommandContextUtil.getActivityInstanceEntityManager().recordActivityStart(execution);
            }
            this.innerActivityBehavior.execute(execution);
        }
    }

    protected abstract int createInstances(DelegateExecution var1);

    @Override
    public void leave(DelegateExecution execution) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        RuntimeService runtimeService = currentEngineConfiguration.getRuntimeService();
        runtimeService.removeVariable(execution.getId(), "PANGUASSIGNEES");
        this.cleanupMiRoot(execution);
        ThreadMapUtil.put((String)"multiInstanceActivityLeaveFlag", (Object)true);
    }

    protected void cleanupMiRoot(DelegateExecution execution) {
        ExecutionEntity multiInstanceRootExecution = (ExecutionEntity)this.getMultiInstanceRootExecution(execution);
        FlowElement flowElement = multiInstanceRootExecution.getCurrentFlowElement();
        ExecutionEntity parentExecution = multiInstanceRootExecution.getParent();
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        List<String> executionIdsNotToSendCancelledEventsFor = execution.isMultiInstanceRoot() ? null : Collections.singletonList(execution.getId());
        executionEntityManager.deleteChildExecutions(multiInstanceRootExecution, null, executionIdsNotToSendCancelledEventsFor, DELETE_REASON_END, true, flowElement);
        executionEntityManager.deleteRelatedDataForExecution(multiInstanceRootExecution, DELETE_REASON_END);
        executionEntityManager.delete(multiInstanceRootExecution);
        ExecutionEntity newExecution = executionEntityManager.createChildExecution(parentExecution);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
        Object o = ThreadMapUtil.get((String)"simulation");
        if (o != null && Boolean.parseBoolean(o.toString())) {
            this.setNextNodeId("next", flowElement, bpmnModel);
            newExecution.setCurrentFlowElement(flowElement);
            this.leaveSuper(newExecution);
            return;
        }
        Object operate = ThreadMapUtil.get((String)"operate");
        if (ChangeActivityEnumType.BACKTONODE.getCode().equals(operate) || ChangeActivityEnumType.ADD_PRE_NODE.getCode().equals(operate) || ChangeActivityEnumType.FETCHBACK.getCode().equals(operate) || ChangeActivityEnumType.FETCH_PRE_NODE.getCode().equals(operate)) {
            String chooseNode = (String)execution.getVariable("chooseNode");
            if (StringUtils.isNotBlank((CharSequence)chooseNode)) {
                ThreadMapUtil.put((String)"nextId", (Object)chooseNode);
            } else {
                flowElement.setNextId(flowElement.getNextId());
            }
            newExecution.setCurrentFlowElement(flowElement);
            this.leaveSuper(newExecution);
            return;
        }
        ExtA1SignNode currentExtA1SignNode = this.getCurrentExtA1SignNode(execution);
        Boolean signResult = (Boolean)execution.getTransientVariable("signResult");
        if (!signResult.booleanValue()) {
            String passNode = StringUtils.isEmpty((CharSequence)currentExtA1SignNode.getPass()) ? "next" : currentExtA1SignNode.getPass();
            this.setNextNodeId(passNode, flowElement, bpmnModel);
        } else {
            String unPassNode;
            String string = unPassNode = StringUtils.isEmpty((CharSequence)currentExtA1SignNode.getUnPass()) ? "pre" : currentExtA1SignNode.getUnPass();
            if ("initiator".equals(unPassNode)) {
                FlowableEngineAgenda agenda = CommandContextUtil.getAgenda();
                agenda.planTerminationExecutionOperation(newExecution);
                return;
            }
            this.setNextNodeId(unPassNode, flowElement, bpmnModel);
        }
        if (StringUtils.isNotBlank((CharSequence)flowElement.getNextId())) {
            ThreadMapUtil.put((String)"nextId", (Object)flowElement.getNextId());
        }
        newExecution.setCurrentFlowElement(flowElement);
        this.leaveSuper(newExecution);
    }

    private void setNextNodeId(String signResultHandler, FlowElement flowElement, BpmnModel bpmnModel) {
        if (signResultHandler.equals("next")) {
            String id = flowElement.getId();
            flowElement.setNextId(BpmModelUtils.getNextId(bpmnModel, id));
        } else if (signResultHandler.equals("pre")) {
            List<String> preNodeIds = BpmnModelUtils.getPreNodeId(bpmnModel, flowElement.getId());
            flowElement.setNextId(preNodeIds.get(0));
        } else if (signResultHandler.equals("finished")) {
            String endEventNodeId = BpmnModelUtils.getEndEventNodeId(bpmnModel, flowElement.getId());
            flowElement.setNextId(endEventNodeId);
        }
    }

    public void leaveSuper(DelegateExecution execution) {
        super.leave(execution);
    }

    protected void executeCompensationBoundaryEvents(FlowElement flowElement, DelegateExecution execution) {
        Collection<BoundaryEvent> boundaryEvents = this.findBoundaryEventsForFlowNode(execution.getProcessDefinitionId(), flowElement);
        if (CollectionUtil.isNotEmpty(boundaryEvents)) {
            for (BoundaryEvent boundaryEvent : boundaryEvents) {
                if (CollectionUtil.isEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                ExecutionEntity childExecutionEntity = CommandContextUtil.getExecutionEntityManager().createChildExecution((ExecutionEntity)execution);
                childExecutionEntity.setParentId(execution.getId());
                childExecutionEntity.setCurrentFlowElement((FlowElement)boundaryEvent);
                childExecutionEntity.setScope(false);
                ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
                boundaryEventBehavior.execute(childExecutionEntity);
            }
        }
    }

    protected Collection<BoundaryEvent> findBoundaryEventsForFlowNode(String processDefinitionId, FlowElement flowElement) {
        Process process = this.getProcessDefinition(processDefinitionId);
        ArrayList<BoundaryEvent> results = new ArrayList<BoundaryEvent>(1);
        List boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (boundaryEvent.getAttachedToRefId() == null || !boundaryEvent.getAttachedToRefId().equals(flowElement.getId())) continue;
            results.add(boundaryEvent);
        }
        return results;
    }

    protected Process getProcessDefinition(String processDefinitionId) {
        return ProcessDefinitionUtil.getProcess(processDefinitionId);
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        this.innerActivityBehavior.trigger(execution, signalName, signalData);
    }

    public void lastExecutionEnded(DelegateExecution execution) {
        this.leave(execution);
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
    }

    @Override
    public void completed(DelegateExecution execution) throws Exception {
        this.leave(execution);
    }

    public boolean completionConditionSatisfied(DelegateExecution execution) {
        if (this.completionCondition != null) {
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
            ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
            String activeCompletionCondition = null;
            if (CommandContextUtil.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
                ObjectNode taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(this.activity.getId(), execution.getProcessDefinitionId());
                activeCompletionCondition = this.getActiveValue(this.completionCondition, "multiInstanceCompletionCondition", taskElementProperties);
            } else {
                activeCompletionCondition = this.completionCondition;
            }
            Object value = expressionManager.createExpression(activeCompletionCondition).getValue((VariableContainer)execution);
            if (!(value instanceof Boolean)) {
                throw new FlowableIllegalArgumentException("completionCondition '" + activeCompletionCondition + "' does not evaluate to a boolean value");
            }
            Boolean booleanValue = (Boolean)value;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Completion condition of multi-instance satisfied: {}", (Object)booleanValue);
            }
            return booleanValue;
        }
        return false;
    }

    protected boolean customerCompletionConditionSatisfied(DelegateExecution execution) {
        ExtA1SignNode a1SignNode = this.getCurrentExtA1SignNode(execution);
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances");
        int nrOfCompletedPassInstances = this.getLoopVariable(execution, "nrOfPassInstances");
        int nrOfCompletedUnPassInstances = nrOfCompletedInstances - nrOfCompletedPassInstances;
        return this.customerCompletionConditionSatisfied(execution, a1SignNode, nrOfInstances, nrOfCompletedInstances, nrOfCompletedPassInstances, nrOfCompletedUnPassInstances);
    }

    protected boolean customerCompletionConditionSatisfied(DelegateExecution execution, ExtA1SignNode a1SignNode, int nrOfInstances, int nrOfCompletedInstances, int nrOfCompletedPassInstances, int nrOfCompletedUnPassInstances) {
        String isAll = a1SignNode.getAll();
        if (Boolean.parseBoolean(isAll)) {
            return nrOfCompletedInstances >= nrOfInstances && this.resultJudgment(execution, a1SignNode, nrOfInstances, nrOfCompletedInstances, nrOfCompletedPassInstances, nrOfCompletedUnPassInstances);
        }
        return this.resultJudgment(execution, a1SignNode, nrOfInstances, nrOfCompletedInstances, nrOfCompletedPassInstances, nrOfCompletedUnPassInstances);
    }

    private boolean resultJudgment(DelegateExecution execution, ExtA1SignNode a1SignNode, int nrOfInstances, int nrOfCompletedInstances, int nrOfCompletedPassInstances, int nrOfCompletedUnPassInstances) {
        String signType = StringUtils.isEmpty((CharSequence)a1SignNode.getSignType()) ? "scale" : a1SignNode.getSignType();
        execution.setTransientVariable("signResult", false);
        if (ONE_VETO_PASS.equals(signType)) {
            boolean isCompletionConditionSatisfied;
            boolean bl = isCompletionConditionSatisfied = nrOfCompletedPassInstances > 0;
            if (isCompletionConditionSatisfied) {
                return true;
            }
            if (nrOfCompletedInstances >= nrOfInstances) {
                execution.setTransientVariable("signResult", true);
            }
        } else {
            if (ONE_VETO.equals(signType) && nrOfCompletedUnPassInstances > 0) {
                execution.setTransientVariable("signResult", true);
                return true;
            }
            if ("scale".equals(signType)) {
                boolean isRejectConditionSatisfied;
                boolean isCompletionConditionSatisfied;
                Double signScale = null;
                try {
                    signScale = Double.valueOf(a1SignNode.getSignScale());
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException("\u901a\u8fc7\u6bd4\u4f8b\u503c\u4e3a\u7a7a\uff01");
                }
                double completedPassNumber = Double.valueOf(nrOfCompletedPassInstances) / (double)nrOfInstances * 100.0;
                double completedUnPassNumber = Double.valueOf(nrOfCompletedInstances - nrOfCompletedPassInstances) / (double)nrOfInstances * 100.0;
                boolean bl = isCompletionConditionSatisfied = completedPassNumber >= signScale;
                if (isCompletionConditionSatisfied) {
                    return true;
                }
                boolean bl2 = isRejectConditionSatisfied = signScale >= 100.0 && completedUnPassNumber > 0.0 || completedUnPassNumber >= 100.0 - signScale && signScale < 100.0;
                if (isRejectConditionSatisfied || nrOfCompletedInstances >= nrOfInstances) {
                    execution.setTransientVariable("signResult", true);
                    return true;
                }
            }
        }
        return false;
    }

    public Integer getLoopVariable(DelegateExecution execution, String variableName) {
        Object value = execution.getVariableLocal(variableName);
        for (DelegateExecution parent = execution.getParent(); value == null && parent != null; parent = parent.getParent()) {
            value = parent.getVariableLocal(variableName);
        }
        return (Integer)(value != null ? value : Integer.valueOf(0));
    }

    protected void sendCompletedWithConditionEvent(DelegateExecution execution) {
        CommandContextUtil.getEventDispatcher(CommandContextUtil.getCommandContext()).dispatchEvent((FlowableEvent)this.buildCompletedEvent(execution, FlowableEngineEventType.MULTI_INSTANCE_ACTIVITY_COMPLETED_WITH_CONDITION));
    }

    protected void sendCompletedEvent(DelegateExecution execution) {
        CommandContextUtil.getEventDispatcher(CommandContextUtil.getCommandContext()).dispatchEvent((FlowableEvent)this.buildCompletedEvent(execution, FlowableEngineEventType.MULTI_INSTANCE_ACTIVITY_COMPLETED));
    }

    protected FlowableMultiInstanceActivityCompletedEvent buildCompletedEvent(DelegateExecution execution, FlowableEngineEventType eventType) {
        FlowElement flowNode = execution.getCurrentFlowElement();
        return FlowableEventBuilder.createMultiInstanceActivityCompletedEvent(eventType, (Integer)execution.getVariable("nrOfInstances"), (Integer)execution.getVariable("nrOfActiveInstances"), (Integer)execution.getVariable("nrOfCompletedInstances"), flowNode.getId(), flowNode.getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), flowNode);
    }

    protected int resolveNrOfInstances(DelegateExecution execution) {
        if (this.loopCardinalityExpression != null) {
            return this.resolveLoopCardinality(execution);
        }
        if (this.usesCollection()) {
            Collection collection = this.resolveAndValidateCollection(execution);
            return collection.size();
        }
        throw new FlowableIllegalArgumentException("Couldn't resolve collection expression nor variable reference");
    }

    protected void executeOriginalBehavior(DelegateExecution execution, ExecutionEntity multiInstanceRootExecution, int loopCounter) {
        Collection collection = null;
        try {
            if (this.usesCollection() && this.collectionElementVariable != null) {
                collection = this.resolveAndValidateCollection(execution);
                Object value = null;
                Iterator it = collection.iterator();
                for (int index = 0; index <= loopCounter; ++index) {
                    value = it.next();
                }
                this.setLoopVariable(execution, this.collectionElementVariable, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        execution.setCurrentFlowElement((FlowElement)this.activity);
        CommandContextUtil.getAgenda().planContinueMultiInstanceOperation((ExecutionEntity)execution, multiInstanceRootExecution, loopCounter);
    }

    protected Collection resolveAndValidateCollection(DelegateExecution execution) {
        Object obj = this.resolveCollection(execution);
        List<Object> list = new ArrayList();
        if (this.collectionHandler != null) {
            return this.createFlowableCollectionHandler(this.collectionHandler, execution).resolveCollection(obj, execution);
        }
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj instanceof Iterable) {
            return this.iterableToCollection((Iterable)obj);
        }
        if (obj instanceof String) {
            Object collectionVariable = this.getSubProcess(execution, (String)obj);
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
            if (collectionVariable instanceof Collection) {
                return (Collection)collectionVariable;
            }
            if (collectionVariable instanceof Iterable) {
                return this.iterableToCollection((Iterable)collectionVariable);
            }
            if (collectionVariable == null) {
                boolean skipSameUserFlag;
                String currentActivityId = execution.getCurrentActivityId();
                ExtA1SignNode currentExtA1SignNode = this.getCurrentExtA1SignNode(execution);
                if (currentExtA1SignNode == null) {
                    SignNodeInfo signNodeInfo = (SignNodeInfo)execution.getVariable("addSignVarInfo", SignNodeInfo.class);
                    if (signNodeInfo != null) {
                        String doUserId = signNodeInfo.getDoUserId();
                        List<String> doUserIdResult = Arrays.asList(doUserId.split(","));
                        if (doUserIdResult.size() == 0) {
                            throw new FlowableIllegalArgumentException("Variable '" + obj + "':" + collectionVariable + " is not a Collection");
                        }
                        return doUserIdResult;
                    }
                    throw new FlowableIllegalArgumentException("Variable '" + obj + "' was not found");
                }
                Object nodeLoopObject = execution.getTransientVariables().get("nodeLoop");
                if (nodeLoopObject != null && nodeLoopObject instanceof NodeLoop) {
                    NodeLoop nodeLoop = (NodeLoop)nodeLoopObject;
                    List handlerInfoList = nodeLoop.getHandlerInfoList();
                    return handlerInfoList;
                }
                Object chooseNodeUser = execution.getTransientVariables().get("chooseNodeUser");
                Object chooseNodeObj = execution.getTransientVariables().get("chooseNode");
                Object o = ThreadMapUtil.get((String)SKIP_SAME_USER_FLAG);
                boolean bl = skipSameUserFlag = o == null || StringUtils.isBlank((CharSequence)o.toString()) ? false : (Boolean)o;
                if (!skipSameUserFlag && chooseNodeUser != null && StringUtils.isNotEmpty((CharSequence)chooseNodeUser.toString()) && !"_".equals(chooseNodeUser.toString())) {
                    String chooseNodeUserStr = (String)chooseNodeUser;
                    String chooseNode = (String)chooseNodeObj;
                    String[] chooseNodeSplit = chooseNode.split(",");
                    int nodeIndex = 0;
                    for (int i = 0; i < chooseNodeSplit.length; ++i) {
                        if (!currentActivityId.equals(chooseNodeSplit[i])) continue;
                        nodeIndex = i;
                        break;
                    }
                    if (chooseNode.split(",").length > 1) {
                        String[] allNode = chooseNodeUserStr.split("_");
                        String currentActivityUsers = allNode[nodeIndex];
                        return Arrays.asList(currentActivityUsers.split(","));
                    }
                    return Arrays.asList(chooseNodeUserStr.split(","));
                }
                UserOperateUtils userOperateUtils = new UserOperateUtils();
                List extA1UserPropertys = bpmnModel.getExtA1UserRule();
                if (execution != null && execution.getCurrentFlowElement() != null) {
                    FlowElement currentFlowElement = execution.getCurrentFlowElement();
                    if (currentFlowElement instanceof SubProcess) {
                        SubProcess subProcess = (SubProcess)currentFlowElement;
                        StartEvent firstSubFlowElementInFlowMapOfType = (StartEvent)subProcess.findFirstSubFlowElementInFlowMapOfType(StartEvent.class);
                        List outgoingFlows = firstSubFlowElementInFlowMapOfType.getOutgoingFlows();
                        List<Object> finalList = list;
                        outgoingFlows.forEach(outgoingFlow -> {
                            FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
                            List<ExtA1UserRule> filterList = extA1UserPropertys.stream().filter(extA1UserRule -> extA1UserRule.getNodeId().equals(targetFlowElement.getId())).collect(Collectors.toList());
                            finalList.addAll(userOperateUtils.operateUser(filterList, execution));
                        });
                        if (finalList != null) {
                            execution.setVariable("PANGUASSIGNEES", finalList);
                        }
                        return finalList;
                    }
                    List<ExtA1UserRule> filterList = extA1UserPropertys.stream().filter(extA1UserRule -> extA1UserRule.getNodeId().equals(execution.getCurrentFlowElement().getId())).collect(Collectors.toList());
                    list = userOperateUtils.operateUser(filterList, execution);
                    if (list.size() == 0 && execution.getCurrentFlowElement() instanceof UserTask) {
                        if (StringUtils.isNotEmpty((CharSequence)currentExtA1SignNode.getDoUserId())) {
                            list = Arrays.asList(currentExtA1SignNode.getDoUserId().split(","));
                            if (list.size() == 0) {
                                throw new FlowableIllegalArgumentException("Variable '" + obj + "':" + collectionVariable + " is not a Collection");
                            }
                        } else {
                            Object variable = execution.getParent().getVariable("nrOfInstances");
                            if (variable != null) {
                                Integer nrOfInstances = Integer.valueOf(variable.toString());
                                for (int i = 0; i < nrOfInstances; ++i) {
                                    list.add(String.valueOf(i));
                                }
                            }
                        }
                    }
                    return list;
                }
                List<ExtA1UserRule> filterList = extA1UserPropertys.stream().filter(extA1UserRule -> extA1UserRule.getNodeId().equals(execution.getCurrentFlowElement().getId())).collect(Collectors.toList());
                list = userOperateUtils.operateUser(filterList, execution);
                if (list.size() == 0 && execution.getCurrentFlowElement() instanceof UserTask && StringUtils.isNotEmpty((CharSequence)currentExtA1SignNode.getDoUserId()) && (list = Arrays.asList(currentExtA1SignNode.getDoUserId().split(","))).size() == 0) {
                    throw new FlowableIllegalArgumentException("Variable '" + obj + "':" + collectionVariable + " is not a Collection");
                }
                return list;
            }
            throw new FlowableIllegalArgumentException("Variable '" + obj + "':" + collectionVariable + " is not a Collection");
        }
        throw new FlowableIllegalArgumentException("Couldn't resolve collection expression, variable reference or string");
    }

    protected ExtA1SignNode getCurrentExtA1SignNode(DelegateExecution multiInstanceRootExecution) {
        String id;
        FlowElement currentFlowElement;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(multiInstanceRootExecution.getProcessDefinitionId(), multiInstanceRootExecution.getProcessInstanceId());
        List extA1SignNodes = bpmnModel.getExtA1SignNodes();
        if (extA1SignNodes.isEmpty() && multiInstanceRootExecution.getParent() != null) {
            DelegateExecution parent = multiInstanceRootExecution.getParent();
            bpmnModel = ProcessDefinitionUtil.getBpmnModel(multiInstanceRootExecution.getProcessDefinitionId(), parent.getProcessInstanceId());
            extA1SignNodes = bpmnModel.getExtA1SignNodes();
        }
        if (extA1SignNodes.isEmpty()) {
            BpmnModel bpmnModelOld = ProcessDefinitionUtil.getBpmnModel(multiInstanceRootExecution.getProcessDefinitionId());
            extA1SignNodes = bpmnModelOld.getExtA1SignNodes();
        }
        if ((currentFlowElement = multiInstanceRootExecution.getCurrentFlowElement()) != null) {
            id = currentFlowElement.getId();
            ExtA1SignNode variable = (ExtA1SignNode)multiInstanceRootExecution.getVariable(id + "_nodeHanderUserSignNodes", ExtA1SignNode.class);
            if (variable == null) {
                variable = (ExtA1SignNode)multiInstanceRootExecution.getParent().getVariable(id + "_nodeHanderUserSignNodes", ExtA1SignNode.class);
            }
            if (variable != null) {
                return variable;
            }
        }
        if (extA1SignNodes.size() > 0) {
            id = this.activity.getId();
            for (ExtA1SignNode es : extA1SignNodes) {
                if (!es.getNodeId().equals(id)) continue;
                return es;
            }
        }
        return null;
    }

    protected Collection iterableToCollection(Iterable iterable) {
        ArrayList result = new ArrayList();
        iterable.forEach(element -> result.add(element));
        return result;
    }

    protected Object resolveCollection(DelegateExecution execution) {
        List<String> collection = null;
        if (this.collectionExpression != null) {
            DelegateExecution multiInstanceRootExecution;
            String taskDefinitionKey;
            Object transientVariable;
            DelegateExecution multiInstanceRootExecution2;
            collection = this.collectionExpression.getValue((VariableContainer)execution);
            if (collection.toString().equals("PANGUASSIGNEES") && (collection = (multiInstanceRootExecution2 = this.getMultiInstanceRootExecution(execution)).getVariableLocal("PANGUASSIGNEES")) == null && multiInstanceRootExecution2 != null) {
                DelegateExecution parent = multiInstanceRootExecution2.getParent();
                collection = parent.getVariable("PANGUASSIGNEES");
            }
            if ((transientVariable = execution.getVariable((taskDefinitionKey = execution.getCurrentFlowElement().getId()) + "_nodeHanderUser")) == null && (transientVariable = (multiInstanceRootExecution = this.getMultiInstanceRootExecution(execution)).getVariable(taskDefinitionKey + "_nodeHanderUser")) == null) {
                transientVariable = multiInstanceRootExecution.getParent().getVariable(taskDefinitionKey + "_nodeHanderUser");
            }
            if (transientVariable != null) {
                String[] split = transientVariable.toString().split(",");
                collection = Arrays.asList(split);
                execution.setVariable("PANGUASSIGNEES", collection);
            }
            if (collection == null) {
                multiInstanceRootExecution = this.getMultiInstanceRootExecution(execution);
                collection = this.collectionExpression.getValue((VariableContainer)multiInstanceRootExecution);
            }
        } else if (this.collectionVariable != null) {
            collection = execution.getVariable(this.collectionVariable);
        } else if (this.collectionString != null) {
            collection = this.collectionString;
        }
        return collection;
    }

    protected boolean usesCollection() {
        return this.collectionExpression != null || this.collectionVariable != null || this.collectionString != null;
    }

    protected boolean isExtraScopeNeeded(FlowNode flowNode) {
        return flowNode.getSubProcess() != null;
    }

    protected int resolveLoopCardinality(DelegateExecution execution) {
        Object value = this.loopCardinalityExpression.getValue((VariableContainer)execution);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        throw new FlowableIllegalArgumentException("Could not resolve loopCardinality expression '" + this.loopCardinalityExpression.getExpressionText() + "': not a number nor number String");
    }

    protected void setLoopVariable(DelegateExecution execution, String variableName, Object value) {
        execution.setVariableLocal(variableName, value);
    }

    protected Integer getLocalLoopVariable(DelegateExecution execution, String variableName) {
        Map localVariables = execution.getVariablesLocal();
        if (localVariables.containsKey(variableName)) {
            return (Integer)execution.getVariableLocal(variableName);
        }
        if (!execution.isMultiInstanceRoot()) {
            DelegateExecution parentExecution = execution.getParent();
            localVariables = parentExecution.getVariablesLocal();
            if (localVariables.containsKey(variableName)) {
                return (Integer)parentExecution.getVariableLocal(variableName);
            }
            if (!parentExecution.isMultiInstanceRoot()) {
                DelegateExecution superExecution = parentExecution.getParent();
                return (Integer)superExecution.getVariableLocal(variableName);
            }
            return null;
        }
        return null;
    }

    protected void callActivityEndListeners(DelegateExecution execution) {
        CommandContextUtil.getProcessEngineConfiguration().getListenerNotificationHelper().executeExecutionListeners((HasExecutionListeners)this.activity, execution, "end");
    }

    protected void logLoopDetails(DelegateExecution execution, String custom, int loopCounter, int nrOfCompletedInstances, int nrOfActiveInstances, int nrOfInstances) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Multi-instance '{}' {}. Details: loopCounter={}, nrOrCompletedInstances={},nrOfActiveInstances={},nrOfInstances={}", new Object[]{execution.getCurrentFlowElement() != null ? execution.getCurrentFlowElement().getId() : "", custom, loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances});
        }
    }

    protected DelegateExecution getMultiInstanceRootExecution(DelegateExecution executionEntity) {
        DelegateExecution multiInstanceRootExecution = null;
        DelegateExecution currentExecution = executionEntity;
        while (currentExecution != null && multiInstanceRootExecution == null && currentExecution.getParent() != null) {
            if (currentExecution.isMultiInstanceRoot()) {
                multiInstanceRootExecution = currentExecution;
                continue;
            }
            currentExecution = currentExecution.getParent();
        }
        return multiInstanceRootExecution;
    }

    protected DelegateExecution getMultiInstanceChildExecution(DelegateExecution executionEntity, List<String> ids) {
        DelegateExecution multiInstanceRootExecution = null;
        for (DelegateExecution currentExecution = executionEntity; currentExecution != null && currentExecution.getParent() != null; currentExecution = currentExecution.getParent()) {
            ids.add(currentExecution.getId());
        }
        return multiInstanceRootExecution;
    }

    protected String getActiveValue(String originalValue, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValueNode;
        String activeValue = originalValue;
        if (taskElementProperties != null && (overrideValueNode = taskElementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : overrideValueNode.asText();
        }
        return activeValue;
    }

    protected FlowableCollectionHandler createFlowableCollectionHandler(CollectionHandler handler, DelegateExecution execution) {
        FlowableCollectionHandler collectionHandler = null;
        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(handler.getImplementationType())) {
            collectionHandler = new ClassDelegateCollectionHandler(handler.getImplementation(), null);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(handler.getImplementationType())) {
            Object delegate = DelegateExpressionUtil.resolveDelegateExpression(CommandContextUtil.getProcessEngineConfiguration().getExpressionManager().createExpression(handler.getImplementation()), execution);
            if (delegate instanceof FlowableCollectionHandler) {
                collectionHandler = new DelegateExpressionCollectionHandler(execution, CommandContextUtil.getProcessEngineConfiguration().getExpressionManager().createExpression(handler.getImplementation()));
            } else {
                throw new FlowableIllegalArgumentException("Delegate expression " + handler.getImplementation() + " did not resolve to an implementation of " + FlowableCollectionHandler.class);
            }
        }
        return collectionHandler;
    }

    public Expression getLoopCardinalityExpression() {
        return this.loopCardinalityExpression;
    }

    public void setLoopCardinalityExpression(Expression loopCardinalityExpression) {
        this.loopCardinalityExpression = loopCardinalityExpression;
    }

    public String getCompletionCondition() {
        return this.completionCondition;
    }

    public void setCompletionCondition(String completionCondition) {
        this.completionCondition = completionCondition;
    }

    public Expression getCollectionExpression() {
        return this.collectionExpression;
    }

    public void setCollectionExpression(Expression collectionExpression) {
        this.collectionExpression = collectionExpression;
    }

    public String getCollectionVariable() {
        return this.collectionVariable;
    }

    public void setCollectionVariable(String collectionVariable) {
        this.collectionVariable = collectionVariable;
    }

    public String getCollectionElementVariable() {
        return this.collectionElementVariable;
    }

    public void setCollectionElementVariable(String collectionElementVariable) {
        this.collectionElementVariable = collectionElementVariable;
    }

    public String getCollectionString() {
        return this.collectionString;
    }

    public void setCollectionString(String collectionString) {
        this.collectionString = collectionString;
    }

    public CollectionHandler getHandler() {
        return this.collectionHandler;
    }

    public void setHandler(CollectionHandler collectionHandler) {
        this.collectionHandler = collectionHandler;
    }

    public String getCollectionElementIndexVariable() {
        return this.collectionElementIndexVariable;
    }

    public void setCollectionElementIndexVariable(String collectionElementIndexVariable) {
        this.collectionElementIndexVariable = collectionElementIndexVariable;
    }

    public void setInnerActivityBehavior(AbstractBpmnActivityBehavior innerActivityBehavior) {
        this.innerActivityBehavior = innerActivityBehavior;
        this.innerActivityBehavior.setMultiInstanceActivityBehavior(this);
    }

    public AbstractBpmnActivityBehavior getInnerActivityBehavior() {
        return this.innerActivityBehavior;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public static String getPreUserId() {
        String result = "";
        Map authenticatedUserId = UserInfoAuthentication.getAuthenticatedUserId();
        if (authenticatedUserId != null && authenticatedUserId.containsKey(CURRENT_USER)) {
            result = (String)authenticatedUserId.get(CURRENT_USER);
        }
        return result;
    }

    public static String getPreUserName() {
        String result = "";
        Map authenticatedUserId = UserInfoAuthentication.getAuthenticatedUserId();
        if (authenticatedUserId != null && authenticatedUserId.containsKey(CURRENT_USER_NAME)) {
            String taskId;
            result = taskId = (String)authenticatedUserId.get(CURRENT_USER_NAME);
        }
        return result;
    }

    protected boolean isSubProcess(DelegateExecution execution) {
        return execution.getCurrentFlowElement() instanceof SubProcess;
    }

    protected DelegateExecution getMiRoot(DelegateExecution execution) {
        if (execution.isScope()) {
            return execution;
        }
        execution = execution.getParent();
        return execution;
    }

    protected Object getSubProcess(DelegateExecution execution, String obj) {
        if (execution.getCurrentFlowElement() instanceof SubProcess) {
            String inputDataItem;
            SubProcess subProcess;
            MultiInstanceLoopCharacteristics loopCharacteristics;
            List<String> collectionVariable = execution.getVariable(obj);
            if (collectionVariable == null) {
                DelegateExecution parent = this.getMiRoot(execution);
                collectionVariable = parent.getVariable(obj);
            }
            if ((loopCharacteristics = (subProcess = (SubProcess)execution.getCurrentFlowElement()).getLoopCharacteristics()) != null && (collectionVariable = execution.getVariableLocal(inputDataItem = loopCharacteristics.getInputDataItem())) == null) {
                Object chooseNodeUser = execution.getTransientVariable("chooseNodeUser");
                if (chooseNodeUser == null) {
                    chooseNodeUser = execution.getVariable("chooseNodeUser");
                }
                if (chooseNodeUser != null && StringUtils.isNotEmpty((CharSequence)chooseNodeUser.toString())) {
                    String[] split = chooseNodeUser.toString().split(",");
                    collectionVariable = Arrays.asList(split);
                }
                if (collectionVariable != null) {
                    execution.setVariableLocal("PANGUASSIGNEES", collectionVariable);
                }
            }
        } else {
            return null;
        }
        return this.collectionVariable;
    }
}

