/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.HistoryService;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.BpmnModelUtils;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelGatewayActivityBehavior
extends GatewayActivityBehavior {
    private static final long serialVersionUID = 1840892471343975524L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelGatewayActivityBehavior.class);

    @Override
    public void execute(DelegateExecution execution) {
        Task task;
        List<List<String>> paths;
        execution.inactivate();
        FlowElement flowElement = execution.getCurrentFlowElement();
        ParallelGateway parallelGateway = null;
        if (!(flowElement instanceof ParallelGateway)) {
            throw new FlowableException("Programmatic error: parallel gateway behaviour can only be applied to a ParallelGateway instance, but got an instance of " + flowElement);
        }
        parallelGateway = (ParallelGateway)flowElement;
        this.lockFirstParentScope(execution);
        DelegateExecution multiInstanceExecution = null;
        if (this.hasMultiInstanceParent((FlowNode)parallelGateway)) {
            multiInstanceExecution = this.findMultiInstanceParentExecution(execution);
        }
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        Collection<ExecutionEntity> joinedExecutions = executionEntityManager.findInactiveExecutionsByActivityIdAndProcessInstanceId(execution.getCurrentActivityId(), execution.getProcessInstanceId());
        if (multiInstanceExecution != null) {
            joinedExecutions = this.cleanJoinedExecutions(joinedExecutions, multiInstanceExecution);
        }
        int nbrOfExecutionsToJoin = parallelGateway.getIncomingFlows().size();
        int nbrOfExecutionsCurrentlyJoined = joinedExecutions.size();
        CommandContextUtil.getActivityInstanceEntityManager().recordActivityEnd((ExecutionEntity)execution, null);
        List taskList = ((TaskQuery)this.taskService().createTaskQuery().processInstanceId(execution.getProcessInstanceId())).list();
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
        Map flowElementMap = bpmnModel.getMainProcess().getFlowElementMap();
        boolean isLeave = false;
        Iterator<Object> iterator = taskList.iterator();
        while (iterator.hasNext() && !CollectionUtil.isNotEmpty(paths = BpmnModelUtils.findAllPathsById(flowElementMap, (task = (Task)iterator.next()).getTaskDefinitionKey(), parallelGateway.getId()))) {
        }
        if (nbrOfExecutionsCurrentlyJoined == nbrOfExecutionsToJoin || isLeave) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("parallel gateway '{}' ({}) activates: {} of {} joined", new Object[]{execution.getCurrentActivityId(), execution.getId(), nbrOfExecutionsCurrentlyJoined, nbrOfExecutionsToJoin});
            }
            if (parallelGateway.getIncomingFlows().size() > 1) {
                for (ExecutionEntity joinedExecution : joinedExecutions) {
                    if (joinedExecution.getId().equals(execution.getId())) continue;
                    executionEntityManager.deleteRelatedDataForExecution(joinedExecution, null);
                    executionEntityManager.delete(joinedExecution);
                }
            }
            CommandContextUtil.getAgenda().planTakeOutgoingSequenceFlowsOperation((ExecutionEntity)execution, false);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("parallel gateway '{}' ({}) does not activate: {} of {} joined", new Object[]{execution.getCurrentActivityId(), execution.getId(), nbrOfExecutionsCurrentlyJoined, nbrOfExecutionsToJoin});
        }
    }

    public static HistoryService historyService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        HistoryService historyService = currentEngineConfiguration.getHistoryService();
        return historyService;
    }

    public RuntimeService runtimeService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        RuntimeService runtimeService = currentEngineConfiguration.getRuntimeService();
        return runtimeService;
    }

    public TaskService taskService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        TaskService taskService = currentEngineConfiguration.getTaskService();
        return taskService;
    }

    protected Collection<ExecutionEntity> cleanJoinedExecutions(Collection<ExecutionEntity> joinedExecutions, DelegateExecution multiInstanceExecution) {
        ArrayList<ExecutionEntity> cleanedExecutions = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity executionEntity : joinedExecutions) {
            if (!this.isChildOfMultiInstanceExecution(executionEntity, multiInstanceExecution)) continue;
            cleanedExecutions.add(executionEntity);
        }
        return cleanedExecutions;
    }

    protected boolean isChildOfMultiInstanceExecution(DelegateExecution executionEntity, DelegateExecution multiInstanceExecution) {
        boolean isChild = false;
        DelegateExecution parentExecution = executionEntity.getParent();
        if (parentExecution != null) {
            if (parentExecution.getId().equals(multiInstanceExecution.getId())) {
                isChild = true;
            } else {
                boolean isNestedChild = this.isChildOfMultiInstanceExecution(parentExecution, multiInstanceExecution);
                if (isNestedChild) {
                    isChild = true;
                }
            }
        }
        return isChild;
    }

    protected boolean hasMultiInstanceParent(FlowNode flowNode) {
        boolean hasMultiInstanceParent = false;
        if (flowNode.getSubProcess() != null) {
            if (flowNode.getSubProcess().getLoopCharacteristics() != null) {
                hasMultiInstanceParent = true;
            } else {
                boolean hasNestedMultiInstanceParent = this.hasMultiInstanceParent((FlowNode)flowNode.getSubProcess());
                if (hasNestedMultiInstanceParent) {
                    hasMultiInstanceParent = true;
                }
            }
        }
        return hasMultiInstanceParent;
    }

    protected DelegateExecution findMultiInstanceParentExecution(DelegateExecution execution) {
        DelegateExecution multiInstanceExecution = null;
        DelegateExecution parentExecution = execution.getParent();
        if (parentExecution != null && parentExecution.getCurrentFlowElement() != null) {
            DelegateExecution potentialMultiInstanceExecution;
            Activity activity;
            FlowElement flowElement = parentExecution.getCurrentFlowElement();
            if (flowElement instanceof Activity && (activity = (Activity)flowElement).getLoopCharacteristics() != null) {
                multiInstanceExecution = parentExecution;
            }
            if (multiInstanceExecution == null && (potentialMultiInstanceExecution = this.findMultiInstanceParentExecution(parentExecution)) != null) {
                multiInstanceExecution = potentialMultiInstanceExecution;
            }
        }
        return multiInstanceExecution;
    }
}

