/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.flowable.engine.impl.bpmn.attachedbehavior.CommonScriptCmd;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.bpmn.parser.FieldDeclaration;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.ActivityBehaviorInvocation;
import org.flowable.engine.impl.delegate.TriggerableActivityBehavior;
import org.flowable.engine.impl.delegate.invocation.JavaDelegateInvocation;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ServiceTaskDelegateExpressionActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected String serviceTaskId;
    protected Expression expression;
    protected Expression skipExpression;
    protected List<FieldDeclaration> fieldDeclarations;
    protected List<MapExceptionEntry> mapExceptions;
    protected boolean triggerable;

    public ServiceTaskDelegateExpressionActivityBehavior(String serviceTaskId, Expression expression, Expression skipExpression, List<FieldDeclaration> fieldDeclarations, List<MapExceptionEntry> mapExceptions, boolean triggerable) {
        this.serviceTaskId = serviceTaskId;
        this.expression = expression;
        this.skipExpression = skipExpression;
        this.fieldDeclarations = fieldDeclarations;
        this.mapExceptions = mapExceptions;
        this.triggerable = triggerable;
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, (VariableContainer)execution, this.fieldDeclarations);
        if (this.triggerable && delegate instanceof TriggerableActivityBehavior) {
            ((TriggerableActivityBehavior)delegate).trigger(execution, signalName, signalData);
        }
        this.leave(execution);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(DelegateExecution execution) {
        try {
            void var3_6;
            boolean isSkipExpressionEnabled;
            CommandContext commandContext = CommandContextUtil.getCommandContext();
            Object var3_4 = null;
            if (this.skipExpression != null) {
                String string = this.skipExpression.getExpressionText();
            }
            if (!(isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled((String)var3_6, this.serviceTaskId, execution, commandContext)) || !SkipExpressionUtil.shouldSkipFlowElement((String)var3_6, this.serviceTaskId, execution, commandContext)) {
                Object delegate;
                String overrideExpression;
                ObjectNode taskElementProperties;
                if (CommandContextUtil.getProcessEngineConfiguration(commandContext).isEnableProcessDefinitionInfoCache() && (taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(this.serviceTaskId, execution.getProcessDefinitionId())) != null && taskElementProperties.has("serviceTaskDelegateExpression") && StringUtils.isNotEmpty((CharSequence)(overrideExpression = taskElementProperties.get("serviceTaskDelegateExpression").asText())) && !overrideExpression.equals(this.expression.getExpressionText())) {
                    this.expression = CommandContextUtil.getProcessEngineConfiguration(commandContext).getExpressionManager().createExpression(overrideExpression);
                }
                if ((delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, (VariableContainer)execution, this.fieldDeclarations)) instanceof ActivityBehavior) {
                    if (delegate instanceof AbstractBpmnActivityBehavior) {
                        ((AbstractBpmnActivityBehavior)delegate).setMultiInstanceActivityBehavior(this.getMultiInstanceActivityBehavior());
                    }
                    CommandContextUtil.getProcessEngineConfiguration(commandContext).getDelegateInterceptor().handleInvocation(new ActivityBehaviorInvocation((ActivityBehavior)delegate, execution));
                    return;
                } else {
                    if (!(delegate instanceof JavaDelegate)) throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did neither resolve to an implementation of " + ActivityBehavior.class + " nor " + JavaDelegate.class);
                    CommandContextUtil.getProcessEngineConfiguration(commandContext).getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)delegate, execution));
                    if (this.triggerable) return;
                    CommonScriptCmd.handlerScript(execution, execution.getCurrentFlowElement().getId());
                    this.leave(execution);
                }
                return;
            } else {
                CommonScriptCmd.handlerScript(execution, execution.getCurrentFlowElement().getId());
                this.leave(execution);
            }
            return;
        }
        catch (Exception exc) {
            void var3_8;
            Exception exception = exc;
            BpmnError error = null;
            while (var3_8 != null) {
                if (var3_8 instanceof BpmnError) {
                    error = (BpmnError)var3_8;
                    break;
                }
                if (var3_8 instanceof RuntimeException && ErrorPropagation.mapException((RuntimeException)var3_8, (ExecutionEntity)execution, this.mapExceptions)) {
                    return;
                }
                Throwable throwable = var3_8.getCause();
            }
            if (error != null) {
                ErrorPropagation.propagateError(error, execution);
                return;
            }
            if (!(exc instanceof FlowableException)) throw new FlowableException(exc.getMessage(), (Throwable)exc);
            throw exc;
        }
    }
}

