/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.a1bpm.model.ExtA1UserRule;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtA1Properties;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.DynamicPropertyUtil;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.IdentityLinkUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.engine.interceptor.CreateUserTaskAfterContext;
import org.flowable.engine.interceptor.CreateUserTaskBeforeContext;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.event.impl.FlowableTaskEventBuilder;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTaskActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTaskActivityBehavior.class);
    protected UserTask userTask;
    private static ObjectMapper MAPPER = new ObjectMapper();

    public UserTaskActivityBehavior(UserTask userTask) {
        this.userTask = userTask;
    }

    @Override
    public void execute(DelegateExecution execution) {
        String parameterUserAssign;
        Object priority;
        Object dueDate;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        TaskService taskService = CommandContextUtil.getTaskService(commandContext);
        TaskEntity task = taskService.createTask();
        task.setExecutionId(execution.getId());
        task.setTaskDefinitionKey(this.userTask.getId());
        String activeTaskName = null;
        String activeTaskDescription = null;
        String activeTaskDueDate = null;
        String activeTaskPriority = null;
        String activeTaskCategory = null;
        String activeTaskFormKey = null;
        String activeTaskSkipExpression = null;
        String activeTaskAssignee = null;
        String activeTaskOwner = null;
        List<String> activeTaskCandidateUsers = null;
        List<String> activeTaskCandidateGroups = null;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        if (processEngineConfiguration.isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(this.userTask.getId(), execution.getProcessDefinitionId());
            activeTaskName = DynamicPropertyUtil.getActiveValue(this.userTask.getName(), "userTaskName", taskElementProperties);
            activeTaskDescription = DynamicPropertyUtil.getActiveValue(this.userTask.getDocumentation(), "userTaskDescription", taskElementProperties);
            activeTaskDueDate = DynamicPropertyUtil.getActiveValue(this.userTask.getDueDate(), "userTaskDueDate", taskElementProperties);
            activeTaskPriority = DynamicPropertyUtil.getActiveValue(this.userTask.getPriority(), "userTaskPriority", taskElementProperties);
            activeTaskCategory = DynamicPropertyUtil.getActiveValue(this.userTask.getCategory(), "userTaskCategory", taskElementProperties);
            activeTaskFormKey = DynamicPropertyUtil.getActiveValue(this.userTask.getFormKey(), "userTaskFormKey", taskElementProperties);
            activeTaskSkipExpression = DynamicPropertyUtil.getActiveValue(this.userTask.getSkipExpression(), "taskSkipExpression", taskElementProperties);
            activeTaskAssignee = DynamicPropertyUtil.getActiveValue(this.userTask.getAssignee(), "userTaskAssignee", taskElementProperties);
            activeTaskOwner = DynamicPropertyUtil.getActiveValue(this.userTask.getOwner(), "userTaskOwner", taskElementProperties);
            activeTaskCandidateUsers = this.getActiveValueList(this.userTask.getCandidateUsers(), "userTaskCandidateUsers", taskElementProperties);
            activeTaskCandidateGroups = this.getActiveValueList(this.userTask.getCandidateGroups(), "userTaskCandidateGroups", taskElementProperties);
        } else {
            activeTaskName = this.userTask.getName();
            activeTaskDescription = this.userTask.getDocumentation();
            activeTaskDueDate = this.userTask.getDueDate();
            activeTaskPriority = this.userTask.getPriority();
            activeTaskCategory = this.userTask.getCategory();
            activeTaskFormKey = this.userTask.getFormKey();
            activeTaskSkipExpression = this.userTask.getSkipExpression();
            activeTaskAssignee = this.userTask.getAssignee();
            activeTaskOwner = this.userTask.getOwner();
            activeTaskCandidateUsers = this.userTask.getCandidateUsers();
            activeTaskCandidateGroups = this.userTask.getCandidateGroups();
        }
        CreateUserTaskBeforeContext beforeContext = new CreateUserTaskBeforeContext(this.userTask, execution, activeTaskName, activeTaskDescription, activeTaskDueDate, activeTaskPriority, activeTaskCategory, activeTaskFormKey, activeTaskSkipExpression, activeTaskAssignee, activeTaskOwner, activeTaskCandidateUsers, activeTaskCandidateGroups);
        if (processEngineConfiguration.getCreateUserTaskInterceptor() != null) {
            processEngineConfiguration.getCreateUserTaskInterceptor().beforeCreateUserTask(beforeContext);
        }
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getName())) {
            String name = null;
            try {
                Object nameValue = expressionManager.createExpression(beforeContext.getName()).getValue((VariableContainer)execution);
                if (nameValue != null) {
                    name = nameValue.toString();
                }
            }
            catch (FlowableException e) {
                name = beforeContext.getName();
                LOGGER.warn("property not found in task name expression {}", (Object)e.getMessage());
            }
            task.setName(name);
        }
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getDescription())) {
            String description = null;
            try {
                Object descriptionValue = expressionManager.createExpression(beforeContext.getDescription()).getValue((VariableContainer)execution);
                if (descriptionValue != null) {
                    description = descriptionValue.toString();
                }
            }
            catch (FlowableException e) {
                description = beforeContext.getDescription();
                LOGGER.warn("property not found in task description expression {}", (Object)e.getMessage());
            }
            task.setDescription(description);
        }
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getDueDate()) && (dueDate = expressionManager.createExpression(beforeContext.getDueDate()).getValue((VariableContainer)execution)) != null) {
            if (dueDate instanceof Date) {
                task.setDueDate((Date)dueDate);
            } else if (dueDate instanceof String) {
                String businessCalendarName = null;
                businessCalendarName = StringUtils.isNotEmpty((CharSequence)this.userTask.getBusinessCalendarName()) ? expressionManager.createExpression(this.userTask.getBusinessCalendarName()).getValue((VariableContainer)execution).toString() : "dueDate";
                BusinessCalendar businessCalendar = CommandContextUtil.getProcessEngineConfiguration(commandContext).getBusinessCalendarManager().getBusinessCalendar(businessCalendarName);
                task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
            } else {
                throw new FlowableIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeTaskDueDate);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getPriority()) && (priority = expressionManager.createExpression(beforeContext.getPriority()).getValue((VariableContainer)execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.valueOf((String)priority).intValue());
                }
                catch (NumberFormatException e) {
                    throw new FlowableIllegalArgumentException("Priority does not resolve to a number: " + priority, (Throwable)e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new FlowableIllegalArgumentException("Priority expression does not resolve to a number: " + activeTaskPriority);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getCategory())) {
            String category = null;
            try {
                Object categoryValue = expressionManager.createExpression(beforeContext.getCategory()).getValue((VariableContainer)execution);
                if (categoryValue != null) {
                    category = categoryValue.toString();
                }
            }
            catch (FlowableException e) {
                category = beforeContext.getCategory();
                LOGGER.warn("property not found in task category expression {}", (Object)e.getMessage());
            }
            task.setCategory(category);
        }
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getFormKey())) {
            String formKey = null;
            try {
                Object formKeyValue = expressionManager.createExpression(beforeContext.getFormKey()).getValue((VariableContainer)execution);
                if (formKeyValue != null) {
                    formKey = formKeyValue.toString();
                }
            }
            catch (FlowableException e) {
                formKey = beforeContext.getFormKey();
                LOGGER.warn("property not found in task formKey expression {}", (Object)e.getMessage());
            }
            task.setFormKey(formKey);
        }
        boolean skipUserTask = SkipExpressionUtil.isSkipExpressionEnabled(beforeContext.getSkipExpression(), this.userTask.getId(), execution, commandContext) && SkipExpressionUtil.shouldSkipFlowElement(beforeContext.getSkipExpression(), this.userTask.getId(), execution, commandContext);
        TaskHelper.insertTask(task, (ExecutionEntity)execution, !skipUserTask, !skipUserTask && processEngineConfiguration.isEnableEntityLinks());
        BpmnModel bpmnModel = this.repositoryService().getBpmnModel(task.getProcessDefinitionId());
        ExtA1Properties extA1Properties = bpmnModel.getExtA1Properties();
        if (!(extA1Properties == null || (parameterUserAssign = extA1Properties.getParameterUserAssign()).indexOf("prop_skipFirstNode") == -1 || execution.getVariable("prop_skipFirstNode") != null && Boolean.parseBoolean(execution.getVariable("prop_skipFirstNode").toString()))) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("deleteReason", "\u8df3\u8fc7\u6267\u884c");
            map.put("comment", "\u8df3\u8fc7\u7b2c\u4e00\u4e2a\u4efb\u52a1\u8282\u70b9");
            map.put("startUser", Authentication.getAuthenticatedUserId());
            try {
                String mjson = MAPPER.writeValueAsString(map);
                TaskHelper.deleteTask(task, mjson, false, false, false);
                this.leave(execution);
                ((ExecutionEntity)execution).setVariable("prop_skipFirstNode", true);
                return;
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        if (!skipUserTask) {
            this.handleAssignments(taskService, beforeContext.getAssignee(), beforeContext.getOwner(), beforeContext.getCandidateUsers(), beforeContext.getCandidateGroups(), task, expressionManager, execution);
            processEngineConfiguration.getListenerNotificationHelper().executeTaskListeners(task, "create");
            FlowableEventDispatcher eventDispatcher = CommandContextUtil.getTaskServiceConfiguration(commandContext).getEventDispatcher();
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.TASK_CREATED, (Object)task));
            }
        } else {
            TaskHelper.deleteTask(task, null, false, false, false);
            this.leave(execution);
        }
        if (processEngineConfiguration.getCreateUserTaskInterceptor() != null) {
            CreateUserTaskAfterContext afterContext = new CreateUserTaskAfterContext(this.userTask, task, execution);
            processEngineConfiguration.getCreateUserTaskInterceptor().afterCreateUserTask(afterContext);
        }
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        List taskEntities = CommandContextUtil.getTaskService().findTasksByExecutionId(execution.getId());
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.isDeleted()) continue;
            throw new FlowableException("UserTask should not be signalled before complete");
        }
        this.leave(execution);
    }

    public RepositoryService repositoryService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        RepositoryService repositoryService = currentEngineConfiguration.getRepositoryService();
        return repositoryService;
    }

    public RuntimeService runtimeService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        RuntimeService runtimeService = currentEngineConfiguration.getRuntimeService();
        return runtimeService;
    }

    private List<ExtA1UserRule> getExtA1UserRules(TaskEntity task) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        String processDefinitionId = task.getProcessDefinitionId();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        RepositoryService repositoryService = currentEngineConfiguration.getRepositoryService();
        BpmnModel bpmnModel = repositoryService.getBpmnModel(processDefinitionId);
        List extA1UserRules = bpmnModel.getExtA1UserRule();
        if (extA1UserRules != null && extA1UserRules.size() > 0) {
            List<ExtA1UserRule> list = extA1UserRules.stream().filter(o -> o.getNodeId().equals(task.getTaskDefinitionKey())).collect(Collectors.toList());
            return list;
        }
        return null;
    }

    public List<String> genareateCurnnetUsers(ExtA1UserRule extA1UserRule, List<String> users, TaskEntity task) {
        String logicCal;
        Object innerUser = this.runtimeService().getVariable(task.getExecutionId(), "innerUser");
        String currentUser = "";
        if (innerUser != null) {
            Map valueMap = (Map)innerUser;
            currentUser = (String)valueMap.get("currentUser");
        }
        if ((logicCal = extA1UserRule.getLogicCal()).equals("or") || logicCal.equals("")) {
            users.add(currentUser);
        } else if (logicCal.equals("exclude")) {
            users.remove(currentUser);
        }
        return users;
    }

    public List<String> genareatePreUsers(ExtA1UserRule extA1UserRule, List<String> users, TaskEntity task) {
        return users;
    }

    public List<String> genareateSpecUsers(ExtA1UserRule extA1UserRule, List<String> users) {
        String ruleVal = extA1UserRule.getRuleVal();
        List<String> list = Arrays.asList(ruleVal.split(","));
        String logicCal = extA1UserRule.getLogicCal();
        if (logicCal.equals("or") || logicCal.equals("")) {
            users.addAll(list);
        } else if (logicCal.equals("exclude")) {
            users.removeAll(list);
        }
        users.addAll(list);
        return users;
    }

    private void genareateStartUsers(ExtA1UserRule extA1UserRule, List<String> users, TaskEntity task) {
        Object startUser = this.runtimeService().getVariable(task.getExecutionId(), "startUser");
        if (startUser != null) {
            String startUserStr = (String)startUser;
            String logicCal = extA1UserRule.getLogicCal();
            if (logicCal.equals("or") || logicCal.equals("")) {
                users.add(startUserStr);
            } else if (logicCal.equals("exclude")) {
                users.remove(startUserStr);
            }
            users.add(startUserStr);
        }
    }

    public void operateUsers(ExtA1UserRule extA1UserRule, List<String> users, TaskEntity task) {
        String logicCal = extA1UserRule.getLogicCal();
        if (extA1UserRule.getRuleId().equals("")) {
            users.addAll(this.genareateCurnnetUsers(extA1UserRule, users, task));
        } else if (extA1UserRule.getRuleId().equals("currentUser")) {
            this.genareateCurnnetUsers(extA1UserRule, users, task);
        } else if (extA1UserRule.getRuleId().equals("prev")) {
            this.genareatePreUsers(extA1UserRule, users, task);
        } else if (extA1UserRule.getRuleId().equals("spec")) {
            this.genareateSpecUsers(extA1UserRule, users);
        } else if (extA1UserRule.getRuleId().equals("start")) {
            this.genareateStartUsers(extA1UserRule, users, task);
        }
    }

    protected void handleAssignments(TaskService taskService, String assignee, String owner, List<String> candidateUsers, List<String> candidateGroups, TaskEntity task, ExpressionManager expressionManager, DelegateExecution execution) {
        IdentityLinkEntity identityLinkEntity;
        IdentityLinkEntity identityLinkEntity2;
        Expression idExpression;
        List<String> candidates;
        String strValue;
        List identityLinkEntities;
        Object value;
        List identityLinkEntities2;
        Object value2;
        List<String> users;
        Object nodeHanderUser;
        Map transientVariables;
        Object innerUser = execution.getVariable("innerUser");
        if (innerUser != null) {
            Map innerUserMap = (Map)innerUser;
            String currentUser = (String)innerUserMap.get("currentUser");
            List<ExtA1UserRule> extA1UserRules = this.getExtA1UserRules(task);
            System.out.println(extA1UserRules);
            ArrayList<String> users2 = new ArrayList<String>();
            if (extA1UserRules != null) {
                for (ExtA1UserRule extA1UserRule : extA1UserRules) {
                    this.operateUsers(extA1UserRule, users2, task);
                }
            }
            if (users2.size() > 0) {
                if (users2.size() == 1) {
                    Object assigneeExpressionValue = expressionManager.createExpression((String)users2.get(0)).getValue((VariableContainer)execution);
                    String assigneeValue = null;
                    if (assigneeExpressionValue != null) {
                        assigneeValue = assigneeExpressionValue.toString();
                    }
                    if (StringUtils.isNotEmpty(assigneeValue)) {
                        TaskHelper.changeTaskAssignee(task, assigneeValue);
                    }
                } else {
                    for (String candidateUser : users2) {
                        Expression userIdExpr = expressionManager.createExpression(candidateUser);
                        Object value3 = userIdExpr.getValue((VariableContainer)execution);
                        if (value3 == null) continue;
                        if (value3 instanceof Collection) {
                            List identityLinkEntities3 = CommandContextUtil.getIdentityLinkService().addCandidateUsers(task.getId(), (Collection)value3);
                            IdentityLinkUtil.handleTaskIdentityLinkAdditions(task, identityLinkEntities3);
                            continue;
                        }
                        String strValue2 = value3.toString();
                        if (!StringUtils.isNotEmpty((CharSequence)strValue2)) continue;
                        List<String> candidates2 = this.extractCandidates(strValue2);
                        List identityLinkEntities4 = CommandContextUtil.getIdentityLinkService().addCandidateUsers(task.getId(), candidates2);
                        IdentityLinkUtil.handleTaskIdentityLinkAdditions(task, identityLinkEntities4);
                    }
                }
            }
        }
        if ((transientVariables = execution.getTransientVariables()) != null && (nodeHanderUser = transientVariables.get(task.getTaskDefinitionKey() + "nodeHanderUser")) != null && (users = Arrays.asList(nodeHanderUser.toString().split(","))) != null && !users.isEmpty()) {
            if (users.size() == 1) {
                Object assigneeExpressionValue = expressionManager.createExpression(users.get(0)).getValue((VariableContainer)execution);
                String assigneeValue = null;
                if (assigneeExpressionValue != null) {
                    assigneeValue = assigneeExpressionValue.toString();
                }
                if (StringUtils.isNotEmpty(assigneeValue)) {
                    TaskHelper.changeTaskAssignee(task, assigneeValue);
                }
            } else {
                for (String candidateUser : users) {
                    Expression userIdExpr = expressionManager.createExpression(candidateUser);
                    value2 = userIdExpr.getValue((VariableContainer)execution);
                    if (value2 == null) continue;
                    if (value2 instanceof Collection) {
                        identityLinkEntities2 = CommandContextUtil.getIdentityLinkService().addCandidateUsers(task.getId(), (Collection)value2);
                        IdentityLinkUtil.handleTaskIdentityLinkAdditions(task, identityLinkEntities2);
                        continue;
                    }
                    String strValue3 = value2.toString();
                    if (!StringUtils.isNotEmpty((CharSequence)strValue3)) continue;
                    List<String> candidates3 = this.extractCandidates(strValue3);
                    List identityLinkEntities5 = CommandContextUtil.getIdentityLinkService().addCandidateUsers(task.getId(), candidates3);
                    IdentityLinkUtil.handleTaskIdentityLinkAdditions(task, identityLinkEntities5);
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)assignee)) {
            Object assigneeExpressionValue = expressionManager.createExpression(assignee).getValue((VariableContainer)execution);
            String assigneeValue = null;
            if (assigneeExpressionValue != null) {
                assigneeValue = assigneeExpressionValue.toString();
            }
            if (StringUtils.isNotEmpty(assigneeValue)) {
                TaskHelper.changeTaskAssignee(task, assigneeValue);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)owner)) {
            Object ownerExpressionValue = expressionManager.createExpression(owner).getValue((VariableContainer)execution);
            String ownerValue = null;
            if (ownerExpressionValue != null) {
                ownerValue = ownerExpressionValue.toString();
            }
            if (StringUtils.isNotEmpty(ownerValue)) {
                TaskHelper.changeTaskOwner(task, ownerValue);
            }
        }
        if (candidateGroups != null && !candidateGroups.isEmpty()) {
            for (String candidateGroup : candidateGroups) {
                Expression groupIdExpr = expressionManager.createExpression(candidateGroup);
                value = groupIdExpr.getValue((VariableContainer)execution);
                if (value == null) continue;
                if (value instanceof Collection) {
                    identityLinkEntities = CommandContextUtil.getIdentityLinkService().addCandidateGroups(task.getId(), (Collection)value);
                    IdentityLinkUtil.handleTaskIdentityLinkAdditions(task, identityLinkEntities);
                    continue;
                }
                strValue = value.toString();
                if (!StringUtils.isNotEmpty((CharSequence)strValue)) continue;
                candidates = this.extractCandidates(strValue);
                identityLinkEntities2 = CommandContextUtil.getIdentityLinkService().addCandidateGroups(task.getId(), candidates);
                IdentityLinkUtil.handleTaskIdentityLinkAdditions(task, identityLinkEntities2);
            }
        }
        if (candidateUsers != null && !candidateUsers.isEmpty()) {
            for (String candidateUser : candidateUsers) {
                Expression userIdExpr = expressionManager.createExpression(candidateUser);
                value = userIdExpr.getValue((VariableContainer)execution);
                if (value == null) continue;
                if (value instanceof Collection) {
                    identityLinkEntities = CommandContextUtil.getIdentityLinkService().addCandidateUsers(task.getId(), (Collection)value);
                    IdentityLinkUtil.handleTaskIdentityLinkAdditions(task, identityLinkEntities);
                    continue;
                }
                strValue = value.toString();
                if (!StringUtils.isNotEmpty((CharSequence)strValue)) continue;
                candidates = this.extractCandidates(strValue);
                identityLinkEntities2 = CommandContextUtil.getIdentityLinkService().addCandidateUsers(task.getId(), candidates);
                IdentityLinkUtil.handleTaskIdentityLinkAdditions(task, identityLinkEntities2);
            }
        }
        if (this.userTask.getCustomUserIdentityLinks() != null && !this.userTask.getCustomUserIdentityLinks().isEmpty()) {
            for (String customUserIdentityLinkType : this.userTask.getCustomUserIdentityLinks().keySet()) {
                for (String userIdentityLink : (Set)this.userTask.getCustomUserIdentityLinks().get(customUserIdentityLinkType)) {
                    idExpression = expressionManager.createExpression(userIdentityLink);
                    value2 = idExpression.getValue((VariableContainer)execution);
                    if (value2 instanceof Collection) {
                        Iterator userIdSet = ((Collection)value2).iterator();
                        while (userIdSet.hasNext()) {
                            identityLinkEntity2 = CommandContextUtil.getIdentityLinkService().createTaskIdentityLink(task.getId(), userIdSet.next().toString(), null, customUserIdentityLinkType);
                            IdentityLinkUtil.handleTaskIdentityLinkAddition(task, identityLinkEntity2);
                        }
                        continue;
                    }
                    List<String> userIds = this.extractCandidates(value2.toString());
                    for (String userId : userIds) {
                        identityLinkEntity = CommandContextUtil.getIdentityLinkService().createTaskIdentityLink(task.getId(), userId, null, customUserIdentityLinkType);
                        IdentityLinkUtil.handleTaskIdentityLinkAddition(task, identityLinkEntity);
                    }
                }
            }
        }
        if (this.userTask.getCustomGroupIdentityLinks() != null && !this.userTask.getCustomGroupIdentityLinks().isEmpty()) {
            for (String customGroupIdentityLinkType : this.userTask.getCustomGroupIdentityLinks().keySet()) {
                for (String groupIdentityLink : (Set)this.userTask.getCustomGroupIdentityLinks().get(customGroupIdentityLinkType)) {
                    idExpression = expressionManager.createExpression(groupIdentityLink);
                    value2 = idExpression.getValue((VariableContainer)execution);
                    if (value2 instanceof Collection) {
                        Iterator groupIdSet = ((Collection)value2).iterator();
                        while (groupIdSet.hasNext()) {
                            identityLinkEntity2 = CommandContextUtil.getIdentityLinkService().createTaskIdentityLink(task.getId(), null, groupIdSet.next().toString(), customGroupIdentityLinkType);
                            IdentityLinkUtil.handleTaskIdentityLinkAddition(task, identityLinkEntity2);
                        }
                        continue;
                    }
                    List<String> groupIds = this.extractCandidates(value2.toString());
                    for (String groupId : groupIds) {
                        identityLinkEntity = CommandContextUtil.getIdentityLinkService().createTaskIdentityLink(task.getId(), null, groupId, customGroupIdentityLinkType);
                        IdentityLinkUtil.handleTaskIdentityLinkAddition(task, identityLinkEntity);
                    }
                }
            }
        }
    }

    protected List<String> extractCandidates(String str) {
        return Arrays.asList(str.split("[\\s]*,[\\s]*"));
    }
}

