/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.sql;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.sql.SqlContext;
import org.flowable.sql.SqlListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class LogPersistenceSqlExecutionTimePlugin
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogPersistenceSqlExecutionTimePlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object retVal;
        long startTime = System.currentTimeMillis();
        try {
            retVal = invocation.proceed();
        }
        finally {
            try {
                ApplicationContext applicationContext;
                Map sqlListeners;
                long endTime = System.currentTimeMillis();
                MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
                LOGGER.debug("SQL Statement {} took {}ms", (Object)mappedStatement.getId(), (Object)(endTime - startTime));
                Object parameter = null;
                if (invocation.getArgs().length > 1) {
                    parameter = invocation.getArgs()[1];
                }
                String sqlId = mappedStatement.getId();
                BoundSql boundSql = mappedStatement.getBoundSql(parameter);
                Configuration configuration = mappedStatement.getConfiguration();
                Object returnValue = null;
                String sql = LogPersistenceSqlExecutionTimePlugin.showSql(configuration, boundSql);
                SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
                SqlContext sqlContext = new SqlContext(sql, sqlId, mappedStatement.getResource(), mappedStatement.getId(), endTime - startTime, sqlCommandType.name());
                Map beansMap = CommandContextUtil.getProcessEngineConfiguration().getBeans();
                SpringBeanFactoryProxyMap springBeanFactoryProxyMap = (SpringBeanFactoryProxyMap)beansMap;
                BeanFactory beanFactory = springBeanFactoryProxyMap.getBeanFactory();
                if (beanFactory instanceof ApplicationContext && (sqlListeners = (applicationContext = (ApplicationContext)beanFactory).getBeansOfType(SqlListener.class)) != null) {
                    Map stringObjectMap = sqlListeners;
                    for (Map.Entry entry : stringObjectMap.entrySet()) {
                        Object value = entry.getValue();
                        if (!(value instanceof SqlListener)) continue;
                        SqlListener sqlListener = (SqlListener)value;
                        sqlListener.notify(sqlContext);
                    }
                }
            }
            catch (Exception exception) {}
        }
        return retVal;
    }

    public static String getSql(Configuration configuration, BoundSql boundSql, String sqlId, long time) {
        String sql = LogPersistenceSqlExecutionTimePlugin.showSql(configuration, boundSql);
        StringBuilder str = new StringBuilder(100);
        str.append(sql);
        str.append(":");
        return str.toString();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public static String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", LogPersistenceSqlExecutionTimePlugin.getParameterValue(parameterObject));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", LogPersistenceSqlExecutionTimePlugin.getParameterValue(obj));
                        continue;
                    }
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        obj = boundSql.getAdditionalParameter(propertyName);
                        sql = sql.replaceFirst("\\?", LogPersistenceSqlExecutionTimePlugin.getParameterValue(obj));
                        continue;
                    }
                    Map map = (Map)metaObject;
                    sql = sql.replaceFirst("\\?", LogPersistenceSqlExecutionTimePlugin.getParameterValue(map.get(propertyName)));
                }
            }
        }
        return sql;
    }

    private static String getParameterValue(Object obj) {
        String value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(new Date()) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }
}

