/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.innermapper.transfertask.TransferTaskLogDao;
import org.flowable.common.engine.impl.innermapper.transfertask.TransferTaskLogEntity;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.ext.NotifyContext;
import org.flowable.engine.delegate.event.ext.NotifyContextBuilder;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cmd.AbstractCustomSqlExecution;
import org.flowable.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.IdentityLinkUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class AddIdentityLinkWithTransferTaskLogCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    public static int IDENTITY_USER = 1;
    public static int IDENTITY_GROUP = 2;
    protected String identityId;
    protected int identityIdType;
    protected String identityType;
    protected TransferTaskLogEntity transferTaskLogEntity;
    protected NotifyContext notifyContext;

    public AddIdentityLinkWithTransferTaskLogCmd(String taskId, String identityId, int identityIdType, String identityType, TransferTaskLogEntity transferTaskLogEntity, NotifyContext notifyContext) {
        super(taskId);
        this.validateParams(taskId, identityId, identityIdType, identityType);
        this.taskId = taskId;
        this.identityId = identityId;
        this.identityIdType = identityIdType;
        this.identityType = identityType;
        this.transferTaskLogEntity = transferTaskLogEntity;
        this.notifyContext = notifyContext;
    }

    protected void validateParams(String taskId, String identityId, int identityIdType, String identityType) {
        if (taskId == null) {
            throw new FlowableIllegalArgumentException("taskId is null");
        }
        if (identityType == null) {
            throw new FlowableIllegalArgumentException("type is required when adding a new task identity link");
        }
        if (identityId == null && (identityIdType == IDENTITY_GROUP || !"assignee".equals(identityType) && !"owner".equals(identityType))) {
            throw new FlowableIllegalArgumentException("identityId is null");
        }
        if (identityIdType != IDENTITY_USER && identityIdType != IDENTITY_GROUP) {
            throw new FlowableIllegalArgumentException("identityIdType allowed values are 1 and 2");
        }
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        IdentityLinkEntity identityLinkEntity;
        if (task.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.addIdentityLink(this.taskId, this.identityId, this.identityIdType, this.identityType);
            return null;
        }
        String oldAssigneeId = task.getAssignee();
        String oldOwnerId = task.getOwner();
        boolean assignedToNoOne = false;
        if ("assignee".equals(this.identityType)) {
            if (oldAssigneeId == null && this.identityId == null) {
                return null;
            }
            if (oldAssigneeId != null && oldAssigneeId.equals(this.identityId)) {
                return null;
            }
            TaskHelper.changeTaskAssignee(task, this.identityId);
            assignedToNoOne = this.identityId == null;
        } else if ("owner".equals(this.identityType)) {
            if (oldOwnerId == null && this.identityId == null) {
                return null;
            }
            if (oldOwnerId != null && oldOwnerId.equals(this.identityId)) {
                return null;
            }
            TaskHelper.changeTaskOwner(task, this.identityId);
            assignedToNoOne = this.identityId == null;
        } else if (IDENTITY_USER == this.identityIdType) {
            identityLinkEntity = CommandContextUtil.getIdentityLinkService().createTaskIdentityLink(task.getId(), this.identityId, null, this.identityType);
            IdentityLinkUtil.handleTaskIdentityLinkAddition(task, identityLinkEntity);
        } else if (IDENTITY_GROUP == this.identityIdType) {
            identityLinkEntity = CommandContextUtil.getIdentityLinkService().createTaskIdentityLink(task.getId(), null, this.identityId, this.identityType);
            IdentityLinkUtil.handleTaskIdentityLinkAddition(task, identityLinkEntity);
        }
        boolean forceNullUserId = false;
        if (assignedToNoOne) {
            forceNullUserId = true;
            this.identityId = "assignee".equals(this.identityType) ? oldAssigneeId : oldOwnerId;
        }
        if (IDENTITY_USER == this.identityIdType) {
            CommandContextUtil.getHistoryManager(commandContext).createUserIdentityLinkComment(task, this.identityId, this.identityType, true, forceNullUserId);
        } else {
            CommandContextUtil.getHistoryManager(commandContext).createGroupIdentityLinkComment(task, this.identityId, this.identityType, true);
        }
        AbstractCustomSqlExecution<TransferTaskLogDao, Void> customSqlExecution = new AbstractCustomSqlExecution<TransferTaskLogDao, Void>(TransferTaskLogDao.class){

            public Void execute(TransferTaskLogDao transferTaskLogDao) {
                transferTaskLogDao.insert(AddIdentityLinkWithTransferTaskLogCmd.this.transferTaskLogEntity);
                return null;
            }
        };
        Void obj = AddIdentityLinkWithTransferTaskLogCmd.managementService().executeCustomSql(customSqlExecution);
        this.log(task);
        return null;
    }

    private void log(TaskEntity taskEntity) {
        NotifyContextBuilder notifyContextBuilder = new NotifyContextBuilder();
        notifyContextBuilder.fill(this.notifyContext, taskEntity);
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.BPM_HAND_TO, this.notifyContext));
        }
    }

    public static ManagementService managementService() {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfiguration currentEngineConfiguration = (ProcessEngineConfiguration)commandContext.getCurrentEngineConfiguration();
        ManagementService managementService = currentEngineConfiguration.getManagementService();
        return managementService;
    }
}

