/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.common.engine.impl.de.odysseus.el.tree.Node;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.util.condition.ConditionUtil;

public class ConditionCmd
implements Command<List<NodeVarInfo>>,
Serializable {
    private BpmnModel bpmnModel;

    public ConditionCmd(BpmnModel bpmnModel) {
        this.bpmnModel = bpmnModel;
    }

    public List<NodeVarInfo> execute(CommandContext commandContext) {
        Process mainProcess = this.bpmnModel.getMainProcess();
        ArrayList<NodeVarInfo> result = new ArrayList<NodeVarInfo>();
        if (mainProcess != null) {
            Map flowElementMap = mainProcess.getFlowElementMap();
            for (Map.Entry entry : flowElementMap.entrySet()) {
                String key = (String)entry.getKey();
                FlowElement flowElement = (FlowElement)entry.getValue();
                if (!(flowElement instanceof FlowNode)) continue;
                FlowNode flowNode = (FlowNode)flowElement;
                List outgoingFlows = flowNode.getOutgoingFlows();
                for (SequenceFlow sequenceFlow : outgoingFlows) {
                    List<Node> nodeList = ConditionUtil.searchNode(sequenceFlow, null);
                    if (nodeList == null) continue;
                    NodeVarInfo nodeVarInfo = new NodeVarInfo();
                    nodeVarInfo.setSequenceFlow(sequenceFlow);
                    nodeVarInfo.setNodeList(nodeList);
                    String sourceRef = sequenceFlow.getSourceRef();
                    FlowElement sourceRefFlowElement = mainProcess.getFlowElement(sourceRef, true);
                    nodeVarInfo.setFlowNode(sourceRefFlowElement);
                    result.add(nodeVarInfo);
                }
            }
        }
        return result;
    }

    public static class NodeVarInfo {
        private SequenceFlow sequenceFlow;
        private FlowElement flowNode;
        private List<Node> nodeList;

        public SequenceFlow getSequenceFlow() {
            return this.sequenceFlow;
        }

        public void setSequenceFlow(SequenceFlow sequenceFlow) {
            this.sequenceFlow = sequenceFlow;
        }

        public FlowElement getFlowNode() {
            return this.flowNode;
        }

        public void setFlowNode(FlowElement flowNode) {
            this.flowNode = flowNode;
        }

        public List<Node> getNodeList() {
            return this.nodeList;
        }

        public void setNodeList(List<Node> nodeList) {
            this.nodeList = nodeList;
        }
    }
}

