/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.innermapper.A1FlowTaskTrajectoryEntry;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.UpdateA1FlowTaskTrajectory;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.service.TaskService;

public class DeleteMultiInstanceExecutionCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String NUMBER_OF_INSTANCES = "nrOfInstances";
    protected final String NUMBER_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";
    protected String executionId;
    protected String userId;
    protected boolean executionIsCompleted;

    public DeleteMultiInstanceExecutionCmd(String executionId, boolean executionIsCompleted, String userId) {
        this.executionId = executionId;
        this.executionIsCompleted = executionIsCompleted;
        this.userId = userId;
    }

    public DeleteMultiInstanceExecutionCmd(String executionId, boolean executionIsCompleted) {
        this.executionId = executionId;
        this.executionIsCompleted = executionIsCompleted;
    }

    public Void execute(CommandContext commandContext) {
        Integer currentNumberOfInstances;
        SequentialMultiInstanceBehavior miBehavior;
        this.handlerLog(this.executionId, this.executionIsCompleted);
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        ExecutionEntity execution = (ExecutionEntity)executionEntityManager.findById(this.executionId);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
        Activity miActivityElement = (Activity)bpmnModel.getFlowElement(execution.getActivityId());
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = miActivityElement.getLoopCharacteristics();
        if (miActivityElement.getLoopCharacteristics() == null) {
            throw new FlowableException("No multi instance execution found for execution id " + this.executionId);
        }
        if (!(miActivityElement.getBehavior() instanceof MultiInstanceActivityBehavior)) {
            throw new FlowableException("No multi instance behavior found for execution id " + this.executionId);
        }
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            throw new FlowableException("Flowable 5 process definitions are not supported");
        }
        ExecutionEntity miExecution = this.getMultiInstanceRootExecution(execution);
        if (!multiInstanceLoopCharacteristics.isSequential()) {
            executionEntityManager.deleteChildExecutions(execution, "Delete MI execution", false);
            executionEntityManager.deleteExecutionAndRelatedData(execution, "Delete MI execution", false);
        }
        int loopCounter = 0;
        if (multiInstanceLoopCharacteristics.isSequential()) {
            miBehavior = (SequentialMultiInstanceBehavior)miActivityElement.getBehavior();
            loopCounter = miBehavior.getLoopVariable(execution, miBehavior.getCollectionElementIndexVariable());
        }
        if (multiInstanceLoopCharacteristics.isSequential()) {
            currentNumberOfInstances = (Integer)miExecution.getVariable("nrOfInstances");
            miExecution.setVariableLocal("nrOfInstances", currentNumberOfInstances - 1);
        } else if (this.executionIsCompleted) {
            Integer numberOfCompletedInstances = (Integer)miExecution.getVariable("nrOfCompletedInstances");
            miExecution.setVariableLocal("nrOfCompletedInstances", numberOfCompletedInstances + 1);
            ++loopCounter;
        } else {
            currentNumberOfInstances = (Integer)miExecution.getVariable("nrOfInstances");
            miExecution.setVariableLocal("nrOfInstances", currentNumberOfInstances - 1);
        }
        if (multiInstanceLoopCharacteristics.isSequential()) {
            miBehavior = (SequentialMultiInstanceBehavior)miActivityElement.getBehavior();
            if (miExecution.getParent().getVariable("SequentialMultiInstanceUsers") != null) {
                String sequentialMultiInstanceUsers = (String)miExecution.getParent().getVariable("SequentialMultiInstanceUsers", String.class);
                List<String> result = Arrays.asList(sequentialMultiInstanceUsers.split(","));
                ArrayList<String> result2 = new ArrayList<String>();
                for (String str : result) {
                    if (this.userId.equals(str)) continue;
                    result2.add(str);
                }
                String citiesCommaSeparated = String.join((CharSequence)",", result2);
                miExecution.getParent().setVariable("SequentialMultiInstanceUsers", citiesCommaSeparated);
            }
        } else {
            ExecutionEntity childExecution = executionEntityManager.createChildExecution(miExecution);
            childExecution.setCurrentFlowElement(miExecution.getCurrentFlowElement());
        }
        return null;
    }

    private void handlerLog(String executionId, boolean executionIsCompleted) {
        TaskService taskService = CommandContextUtil.getTaskService();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        Task task = (Task)((TaskQuery)taskService.createTaskQuery().executionId(executionId)).singleResult();
        if (task != null) {
            List<A1FlowTaskTrajectoryEntry> a1FlowTaskTrajectoryEntries = UpdateA1FlowTaskTrajectory.listA1FlowTaskTrajectoryEntry(processEngineConfiguration, task.getProcessInstanceId());
            for (A1FlowTaskTrajectoryEntry att : a1FlowTaskTrajectoryEntries) {
                if (!StringUtils.isNotEmpty((CharSequence)att.getNodeRunId()) || !att.getNodeRunId().equals(task.getId())) continue;
                att.setStatusVal("\u4f1a\u7b7e\u88ab\u7ec8\u6b62");
                att.setEndStatus(Integer.valueOf(0));
                att.setOpinion("\u4f1a\u7b7e\u88ab\u7ec8\u6b62");
                att.setStatus("removeSignUser|" + executionIsCompleted);
                UpdateA1FlowTaskTrajectory.update(processEngineConfiguration, att);
                break;
            }
        }
    }

    protected ExecutionEntity getMultiInstanceRootExecution(ExecutionEntity executionEntity) {
        ExecutionEntity multiInstanceRootExecution = null;
        ExecutionEntity currentExecution = executionEntity;
        while (currentExecution != null && multiInstanceRootExecution == null && currentExecution.getParent() != null) {
            if (currentExecution.isMultiInstanceRoot()) {
                multiInstanceRootExecution = currentExecution;
                continue;
            }
            currentExecution = currentExecution.getParent();
        }
        return multiInstanceRootExecution;
    }
}

