/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import com.a1bpm.model.ExtA1UserRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.AdhocSubProcess;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.Transaction;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.io.StringStreamSource;

public class GetUserTaskCmd
implements Command<List<BaseTask>> {
    private String modelEditorXmlStr;
    private BpmnModel bpmnModel;

    public GetUserTaskCmd(String modelEditorXmlStr, BpmnModel bpmnModel) {
        this.modelEditorXmlStr = modelEditorXmlStr;
        this.bpmnModel = bpmnModel;
    }

    public String getModelEditorXmlStr() {
        return this.modelEditorXmlStr;
    }

    public void setModelEditorXmlStr(String modelEditorXmlStr) {
        this.modelEditorXmlStr = modelEditorXmlStr;
    }

    public List<BaseTask> execute(CommandContext commandContext) {
        ArrayList<BaseTask> baseTasks = new ArrayList<BaseTask>();
        if (this.bpmnModel == null) {
            BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
            StringStreamSource inputStreamProvider = new StringStreamSource(this.modelEditorXmlStr);
            this.bpmnModel = bpmnXMLConverter.convertToBpmnModel((InputStreamProvider)inputStreamProvider, false, false);
        }
        Map flowElementMap = this.bpmnModel.getMainProcess().getFlowElementMap();
        for (Map.Entry entry : flowElementMap.entrySet()) {
            String key = (String)entry.getKey();
            FlowElement flowElement = (FlowElement)entry.getValue();
            if (!(flowElement instanceof UserTask)) continue;
            UserTask userTask = (UserTask)flowElement;
            String id = userTask.getId();
            String name = userTask.getName();
            FlowElementsContainer parentContainer = userTask.getParentContainer();
            BaseTask baseTask = new BaseTask();
            baseTask.setId(id);
            baseTask.setName(name);
            List outgoingFlows = userTask.getOutgoingFlows();
            ArrayList<BaseSequenceFlow> baseSequenceFlowList = new ArrayList<BaseSequenceFlow>();
            outgoingFlows.forEach(sequenceFlow -> {
                BaseSequenceFlow baseSequenceFlow = new BaseSequenceFlow();
                baseSequenceFlow.setId(sequenceFlow.getId());
                baseSequenceFlow.setName(sequenceFlow.getName());
                baseSequenceFlow.setSourceRef(sequenceFlow.getSourceRef());
                baseSequenceFlow.setTargetRef(sequenceFlow.getTargetRef());
                baseSequenceFlowList.add(baseSequenceFlow);
            });
            baseTask.setBaseSequenceFlowList(baseSequenceFlowList);
            baseTask.setParentId(parentContainer.getId());
            if (parentContainer instanceof Process) {
                baseTask.setScope(FlowElementsContainerEnum.PROCESS);
            } else if (parentContainer instanceof AdhocSubProcess) {
                baseTask.setScope(FlowElementsContainerEnum.AD_HOC_SUB_PROCESS);
            } else if (parentContainer instanceof SubProcess) {
                baseTask.setScope(FlowElementsContainerEnum.SUB_PROCESS);
            } else if (parentContainer instanceof Transaction) {
                baseTask.setScope(FlowElementsContainerEnum.TRANSACTION);
            } else if (parentContainer instanceof EventSubProcess) {
                baseTask.setScope(FlowElementsContainerEnum.EVENT_SUB_PROCESS);
            }
            if (baseTasks.contains(baseTask)) continue;
            baseTasks.add(baseTask);
        }
        return baseTasks;
    }

    public static enum FlowElementsContainerEnum {
        AD_HOC_SUB_PROCESS("AdhocSubProcess", "\u4e34\u65f6\u5b50\u6d41\u7a0b"),
        PROCESS("Process", "\u4e3b\u6d41\u7a0b"),
        SUB_PROCESS("SubProcess", "\u5b50\u6d41\u7a0b"),
        TRANSACTION("Transaction", "\u4e8b\u52a1"),
        EVENT_SUB_PROCESS("EventSubProcess", "\u4e8b\u4ef6\u5b50\u6d41\u7a0b");

        private final String status;
        private final String desc;

        private FlowElementsContainerEnum(String status, String desc) {
            this.status = status;
            this.desc = desc;
        }

        public String toString() {
            return "FlowElementsContainerEnum{status='" + this.status + '\'' + ", desc='" + this.desc + '\'' + '}';
        }

        public String getStatus() {
            return this.status;
        }

        public String getDesc() {
            return this.desc;
        }

        public static String getValue(String value) {
            FlowElementsContainerEnum[] businessModeEnums;
            for (FlowElementsContainerEnum businessModeEnum : businessModeEnums = FlowElementsContainerEnum.values()) {
                if (!businessModeEnum.status.equals(value)) continue;
                return businessModeEnum.status;
            }
            return null;
        }

        public static String getDesc(String value) {
            FlowElementsContainerEnum[] businessModeEnums;
            for (FlowElementsContainerEnum businessModeEnum : businessModeEnums = FlowElementsContainerEnum.values()) {
                if (!businessModeEnum.status.equals(value)) continue;
                return businessModeEnum.desc;
            }
            return null;
        }
    }

    public static class BaseTask {
        private String id;
        private String name;
        private FlowElementsContainerEnum scope;
        private boolean enable;
        private List<ExtA1UserRule> extA1UserRuleList;
        private String parentId;
        private List<BaseSequenceFlow> baseSequenceFlowList;

        public List<ExtA1UserRule> getExtA1UserRuleList() {
            return this.extA1UserRuleList;
        }

        public void setExtA1UserRuleList(List<ExtA1UserRule> extA1UserRuleList) {
            this.extA1UserRuleList = extA1UserRuleList;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public List<BaseSequenceFlow> getBaseSequenceFlowList() {
            return this.baseSequenceFlowList;
        }

        public void setBaseSequenceFlowList(List<BaseSequenceFlow> baseSequenceFlowList) {
            this.baseSequenceFlowList = baseSequenceFlowList;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseTask baseTask = (BaseTask)o;
            return Objects.equals(this.id, baseTask.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public FlowElementsContainerEnum getScope() {
            return this.scope;
        }

        public void setScope(FlowElementsContainerEnum scope) {
            this.scope = scope;
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }
    }

    public static class BaseSequenceFlow {
        private String id;
        private String name;
        private String sourceRef;
        private String targetRef;

        public String getSourceRef() {
            return this.sourceRef;
        }

        public void setSourceRef(String sourceRef) {
            this.sourceRef = sourceRef;
        }

        public String getTargetRef() {
            return this.targetRef;
        }

        public void setTargetRef(String targetRef) {
            this.targetRef = targetRef;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

